/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.push.sdk.server.constant;

import java.util.Collection;
import java.util.HashMap;

public class PushResponseCode {
    private String value;
    private String description;
    private static HashMap<String, PushResponseCode> intPushResponseCodeMap = PushResponseCode.createIntegerPushResponseCodeMapping();
    public static PushResponseCode RSP_OK = PushResponseCode.valueOf("200", "\u6210\u529f(rsp_ok)");
    public static PushResponseCode RSP_NO_AUT = PushResponseCode.valueOf("201", "\u6ca1\u6709\u6743\u9650,\u670d\u52a1\u5668\u4e3b\u52a8\u62d2\u7edd(rsp_no_aut)");
    public static PushResponseCode RSP_DB_ERROR = PushResponseCode.valueOf("501", "\u63a8\u9001\u6d88\u606f\u62a5\u9519\u5931\u8d25(rsp_db_error)");
    public static PushResponseCode RSP_INTERNAL_ERROR = PushResponseCode.valueOf("513", "\u63a8\u9001\u6d88\u606f\u62a5\u9519\u5931\u8d25(rsp_internal_error)");
    public static PushResponseCode RSP_SPEED_LIMIT = PushResponseCode.valueOf("518", "\u63a8\u9001\u8d85\u8fc7\u914d\u7f6e\u7684\u901f\u7387(rsp_speed_limit)");
    public static PushResponseCode RSP_OVERFLOW = PushResponseCode.valueOf("519", "\u670d\u52a1\u8fc7\u8f7d(rsp_overflow)");
    public static PushResponseCode RSP_REPEATED = PushResponseCode.valueOf("520", "\u6d88\u606f\u6298\u53e0,\u77ed\u65f6\u95f4\u5185\u540c\u4e00\u8bbe\u5907\u540c\u4e00\u6d88\u606f\u6536\u5230\u591a\u6b21(rsp_repeated)");
    public static PushResponseCode RSP_UNSUBSCRIBE_PUSHID = PushResponseCode.valueOf("110002", "pushId\u672a\u8ba2\u9605(un subscribe pushId)");
    public static PushResponseCode RSP_INVALID_PUSHID = PushResponseCode.valueOf("110003", "pushId\u975e\u6cd5(invalid pushId)");
    public static PushResponseCode RSP_UNSUBSCRIBE_ALIAS = PushResponseCode.valueOf("110005", "\u522b\u540d\u672a\u8ba2\u9605(un subscribe alias)");
    public static PushResponseCode RSP_OFF_PUSHID = PushResponseCode.valueOf("110010", "pushId\u5931\u6548(\u6d88\u606f\u5f00\u5173\u5173\u95ed)");

    private static HashMap<String, PushResponseCode> createIntegerPushResponseCodeMapping() {
        HashMap<String, PushResponseCode> result = new HashMap<String, PushResponseCode>();
        return result;
    }

    public static Collection<PushResponseCode> getAllPushResponseCodes() {
        return intPushResponseCodeMap.values();
    }

    private PushResponseCode(String value) {
        this.value = value;
    }

    private PushResponseCode(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String toString() {
        return "PushResponseCode{value=" + this.value + ", description='" + this.description + '\'' + '}';
    }

    public String getFullDescription() {
        return this.getName() + "," + this.value + "," + this.description;
    }

    public String getName() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static PushResponseCode valueOf(String value) {
        return intPushResponseCodeMap.get(Integer.valueOf(value));
    }

    public static PushResponseCode valueOf(String value, PushResponseCode defaultIfMissing) {
        PushResponseCode code = intPushResponseCodeMap.get(value);
        return code == null ? defaultIfMissing : code;
    }

    public static PushResponseCode valueOf(String code, String reason) {
        PushResponseCode result = intPushResponseCodeMap.get(code);
        if (result == null) {
            result = new PushResponseCode(code, reason);
            intPushResponseCodeMap.put(code, result);
        }
        return result;
    }
}

