/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.push.sdk.server;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.meizu.push.sdk.constant.PushType;
import com.meizu.push.sdk.constant.ScopeType;
import com.meizu.push.sdk.server.constant.ResultPack;
import com.meizu.push.sdk.server.model.HttpResult;
import com.meizu.push.sdk.server.model.push.Message;
import com.meizu.push.sdk.server.model.push.PushResult;
import com.meizu.push.sdk.server.model.push.UnVarnishedMessage;
import com.meizu.push.sdk.server.model.push.VarnishedMessage;
import com.meizu.push.sdk.server.model.statistics.DailyPushStatics;
import com.meizu.push.sdk.server.model.statistics.TaskStatistics;
import com.meizu.push.sdk.utils.CollectionUtils;
import com.meizu.push.sdk.utils.DateUtils;
import com.meizu.push.sdk.utils.HttpClient;
import com.meizu.push.sdk.utils.StringUtils;
import com.meizu.push.sdk.vo.AdvanceInfo;
import com.meizu.push.sdk.vo.ClickTypeInfo;
import com.meizu.push.sdk.vo.NoticeBarInfo;
import com.meizu.push.sdk.vo.NoticeExpandInfo;
import com.meizu.push.sdk.vo.NotificationType;
import com.meizu.push.sdk.vo.PushTimeInfo;
import com.meizu.push.sdk.vo.UnVarnishedMessageJson;
import com.meizu.push.sdk.vo.VarnishedMessageJson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IFlymePush
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(IFlymePush.class);
    private static final String SUCCESS_CODE = "200";

    public IFlymePush(String appSecret) {
        super(appSecret);
    }

    public IFlymePush(String appSecret, boolean useSSL) {
        super(appSecret, useSSL);
    }

    public ResultPack<PushResult> pushMessage(VarnishedMessage message, List<String> pushIds) throws IOException {
        return this.pushMessage(message, pushIds, 0);
    }

    public ResultPack<PushResult> pushMessage(VarnishedMessage message, List<String> pushIds, int retries) throws IOException {
        if (CollectionUtils.isEmpty(pushIds)) {
            return ResultPack.failed("pushIds is empty");
        }
        if (message == null) {
            return ResultPack.failed("message is null");
        }
        String pushIdStr = CollectionUtils.list2Str(pushIds);
        return this.pushMessage(UserType.PUSHID, PushType.STATUSBAR, message, pushIdStr, retries);
    }

    public ResultPack<PushResult> pushMessageByAlias(VarnishedMessage message, List<String> alias) throws IOException {
        return this.pushMessageByAlias(message, alias, 0);
    }

    public ResultPack<PushResult> pushMessageByAlias(VarnishedMessage message, List<String> alias, int retries) throws IOException {
        if (CollectionUtils.isEmpty(alias)) {
            return ResultPack.failed("alias is empty");
        }
        if (message == null) {
            return ResultPack.failed("message is null");
        }
        String aliasStr = CollectionUtils.list2Str(alias);
        return this.pushMessage(UserType.ALIAS, PushType.STATUSBAR, message, aliasStr, retries);
    }

    public ResultPack<PushResult> pushMessage(UnVarnishedMessage message, List<String> pushIds) throws IOException {
        return this.pushMessage(message, pushIds, 0);
    }

    public ResultPack<PushResult> pushMessage(UnVarnishedMessage message, List<String> pushIds, int retries) throws IOException {
        if (CollectionUtils.isEmpty(pushIds)) {
            return ResultPack.failed("pushIds is empty");
        }
        if (message == null) {
            return ResultPack.failed("message is null");
        }
        String pushIdStr = CollectionUtils.list2Str(pushIds);
        return this.pushMessage(UserType.PUSHID, PushType.DIRECT, message, pushIdStr, retries);
    }

    public ResultPack<PushResult> pushMessageByAlias(UnVarnishedMessage message, List<String> alias) throws IOException {
        return this.pushMessageByALias(message, alias, 0);
    }

    public ResultPack<PushResult> pushMessageByALias(UnVarnishedMessage message, List<String> alias, int retries) throws IOException {
        if (CollectionUtils.isEmpty(alias)) {
            return ResultPack.failed("alias is empty");
        }
        if (message == null) {
            return ResultPack.failed("message is null");
        }
        String aliasStr = CollectionUtils.list2Str(alias);
        return this.pushMessage(UserType.ALIAS, PushType.DIRECT, message, aliasStr, retries);
    }

    public ResultPack<Long> getTaskId(PushType pushType, Message message) throws IOException {
        Message msgInfo;
        if (pushType == null) {
            return ResultPack.failed("pushType is null");
        }
        if (message == null) {
            return ResultPack.failed("message is null");
        }
        String _url = "http://server-api-push.meizu.com/garcia/api/server/push/pushTask/getTaskId";
        StringBuilder body = IFlymePush.newBody("pushType", String.valueOf(pushType.getDesc()));
        Long appId = message.getAppId();
        if (appId == null) {
            return ResultPack.failed("appId is null");
        }
        IFlymePush.addParameter(body, "appId", String.valueOf(appId));
        if (PushType.DIRECT == pushType) {
            if (!(message instanceof UnVarnishedMessage)) {
                return ResultPack.failed("message must be instanceof UnVarnishedMessage");
            }
            msgInfo = (UnVarnishedMessage)message;
            PushTimeInfo pushTimeInfo = new PushTimeInfo(((UnVarnishedMessage)msgInfo).isOffLine(), ((UnVarnishedMessage)msgInfo).getValidTime());
            AdvanceInfo advanceInfo = new AdvanceInfo(((UnVarnishedMessage)msgInfo).isFixSpeed(), ((UnVarnishedMessage)msgInfo).getFixSpeedRate());
            UnVarnishedMessageJson messageJson = new UnVarnishedMessageJson(((UnVarnishedMessage)msgInfo).getTitle(), ((UnVarnishedMessage)msgInfo).getContent(), pushTimeInfo, advanceInfo);
            IFlymePush.addParameter(body, "messageJson", JSON.toJSONString((Object)messageJson));
        } else if (PushType.STATUSBAR == pushType) {
            if (!(message instanceof VarnishedMessage)) {
                return ResultPack.failed("message must be instanceof VarnishedMessage");
            }
            msgInfo = (VarnishedMessage)message;
            NoticeBarInfo noticeBarInfo = new NoticeBarInfo(((VarnishedMessage)msgInfo).getNoticeBarType(), ((VarnishedMessage)msgInfo).getTitle(), ((VarnishedMessage)msgInfo).getContent());
            NoticeExpandInfo noticeExpandInfo = new NoticeExpandInfo(((VarnishedMessage)msgInfo).getNoticeExpandType(), ((VarnishedMessage)msgInfo).getNoticeExpandContent());
            ClickTypeInfo clickTypeInfo = new ClickTypeInfo(((VarnishedMessage)msgInfo).getClickType(), ((VarnishedMessage)msgInfo).getUrl(), ((VarnishedMessage)msgInfo).getParameters(), ((VarnishedMessage)msgInfo).getActivity(), ((VarnishedMessage)msgInfo).getCustomAttribute());
            PushTimeInfo pushTimeInfo = new PushTimeInfo(((VarnishedMessage)msgInfo).isOffLine(), ((VarnishedMessage)msgInfo).getValidTime());
            NotificationType notificationType = new NotificationType(((VarnishedMessage)msgInfo).isVibrate(), ((VarnishedMessage)msgInfo).isLights(), ((VarnishedMessage)msgInfo).isSound());
            AdvanceInfo advanceInfo = new AdvanceInfo(((VarnishedMessage)msgInfo).isFixSpeed(), ((VarnishedMessage)msgInfo).getFixSpeedRate(), ((VarnishedMessage)msgInfo).isSuspend(), ((VarnishedMessage)msgInfo).isClearNoticeBar(), notificationType, ((VarnishedMessage)msgInfo).isFixDisplay(), ((VarnishedMessage)msgInfo).getFixStartDisplayDate(), ((VarnishedMessage)msgInfo).getFixEndDisplayDate(), ((VarnishedMessage)msgInfo).getNotifyKey());
            VarnishedMessageJson messageJson = new VarnishedMessageJson(noticeBarInfo, noticeExpandInfo, clickTypeInfo, pushTimeInfo, advanceInfo);
            IFlymePush.addParameter(body, "messageJson", JSON.toJSONString((Object)messageJson));
            if (message.getRestrictedPackageNames() != null) {
                IFlymePush.addParameter(body, "restrictedPackageNames", this.array2Str(message.getRestrictedPackageNames()));
            }
        }
        HttpResult httpResult = super.post(this.useSSL, _url, body.toString());
        String code = httpResult.getCode();
        String msg = httpResult.getMessage();
        String value = httpResult.getValue();
        if (SUCCESS_CODE.equals(code)) {
            JSONObject objValue = JSON.parseObject((String)value);
            if (objValue.containsKey((Object)"taskId")) {
                Long taskId = objValue.getLong("taskId");
                return ResultPack.succeed(code, msg, taskId);
            }
            return ResultPack.failed("error return value");
        }
        return ResultPack.failed(code, msg);
    }

    public ResultPack<PushResult> pushMessageByTaskId(PushType pushType, long appId, long taskId, List<String> pushIds) throws IOException {
        return this.pushMessageByTaskId(pushType, appId, taskId, pushIds, 0);
    }

    public ResultPack<PushResult> pushMessageByTaskId(PushType pushType, long appId, long taskId, List<String> pushIds, int retries) throws IOException {
        if (pushType == null) {
            return ResultPack.failed("pushType is null");
        }
        if (CollectionUtils.isEmpty(pushIds)) {
            return ResultPack.failed("pushIds is empty");
        }
        String pushIdStr = CollectionUtils.list2Str(pushIds);
        return this.pushMessageByTaskId(UserType.PUSHID, pushType, appId, taskId, pushIdStr, retries);
    }

    public ResultPack<PushResult> pushAliasMessageByTaskId(PushType pushType, long appId, long taskId, List<String> alias) throws IOException {
        return this.pushAliasMessageByTaskId(pushType, appId, taskId, alias, 0);
    }

    public ResultPack<PushResult> pushAliasMessageByTaskId(PushType pushType, long appId, long taskId, List<String> alias, int retries) throws IOException {
        if (pushType == null) {
            return ResultPack.failed("pushType is null");
        }
        if (CollectionUtils.isEmpty(alias)) {
            return ResultPack.failed("alias is empty");
        }
        String aliasStr = CollectionUtils.list2Str(alias);
        return this.pushMessageByTaskId(UserType.ALIAS, pushType, appId, taskId, aliasStr, retries);
    }

    public ResultPack<Long> pushToApp(PushType pushType, Message message) throws IOException {
        Message msgInfo;
        String _url = "http://server-api-push.meizu.com/garcia/api/server/push/pushTask/pushToApp";
        if (pushType == null) {
            return ResultPack.failed("pushType is null");
        }
        if (message == null) {
            return ResultPack.failed("message is null");
        }
        Long appId = message.getAppId();
        if (appId == null) {
            return ResultPack.failed("appId is null");
        }
        StringBuilder body = IFlymePush.newBody("pushType", String.valueOf(pushType.getDesc()));
        IFlymePush.addParameter(body, "appId", String.valueOf(appId));
        if (PushType.DIRECT == pushType) {
            if (!(message instanceof UnVarnishedMessage)) {
                return ResultPack.failed("message must be instanceof UnVarnishedMessage");
            }
            msgInfo = (UnVarnishedMessage)message;
            String startTime = "";
            if (((UnVarnishedMessage)msgInfo).getStartTime() != null) {
                startTime = DateUtils.date2String(((UnVarnishedMessage)msgInfo).getStartTime());
            }
            PushTimeInfo pushTimeInfo = new PushTimeInfo(((UnVarnishedMessage)msgInfo).isOffLine(), ((UnVarnishedMessage)msgInfo).getValidTime(), ((UnVarnishedMessage)msgInfo).getPushTimeType(), startTime);
            AdvanceInfo advanceInfo = new AdvanceInfo(((UnVarnishedMessage)msgInfo).isFixSpeed(), ((UnVarnishedMessage)msgInfo).getFixSpeedRate());
            UnVarnishedMessageJson messageJson = new UnVarnishedMessageJson(((UnVarnishedMessage)msgInfo).getTitle(), ((UnVarnishedMessage)msgInfo).getContent(), pushTimeInfo, advanceInfo);
            IFlymePush.addParameter(body, "messageJson", JSON.toJSONString((Object)messageJson));
        } else if (PushType.STATUSBAR == pushType) {
            if (!(message instanceof VarnishedMessage)) {
                return ResultPack.failed("message must be instanceof VarnishedMessage");
            }
            msgInfo = (VarnishedMessage)message;
            NoticeBarInfo noticeBarInfo = new NoticeBarInfo(((VarnishedMessage)msgInfo).getNoticeBarType(), ((VarnishedMessage)msgInfo).getTitle(), ((VarnishedMessage)msgInfo).getContent());
            NoticeExpandInfo noticeExpandInfo = new NoticeExpandInfo(((VarnishedMessage)msgInfo).getNoticeExpandType(), ((VarnishedMessage)msgInfo).getNoticeExpandContent());
            ClickTypeInfo clickTypeInfo = new ClickTypeInfo(((VarnishedMessage)msgInfo).getClickType(), ((VarnishedMessage)msgInfo).getUrl(), ((VarnishedMessage)msgInfo).getParameters(), ((VarnishedMessage)msgInfo).getActivity(), ((VarnishedMessage)msgInfo).getCustomAttribute());
            String startTime = "";
            if (((VarnishedMessage)msgInfo).getStartTime() != null) {
                startTime = DateUtils.date2String(((VarnishedMessage)msgInfo).getStartTime());
            }
            PushTimeInfo pushTimeInfo = new PushTimeInfo(((VarnishedMessage)msgInfo).isOffLine(), ((VarnishedMessage)msgInfo).getValidTime(), ((VarnishedMessage)msgInfo).getPushTimeType(), startTime);
            NotificationType notificationType = new NotificationType(((VarnishedMessage)msgInfo).isVibrate(), ((VarnishedMessage)msgInfo).isLights(), ((VarnishedMessage)msgInfo).isSound());
            AdvanceInfo advanceInfo = new AdvanceInfo(((VarnishedMessage)msgInfo).isFixSpeed(), ((VarnishedMessage)msgInfo).getFixSpeedRate(), ((VarnishedMessage)msgInfo).isSuspend(), ((VarnishedMessage)msgInfo).isClearNoticeBar(), notificationType, ((VarnishedMessage)msgInfo).isFixDisplay(), ((VarnishedMessage)msgInfo).getFixStartDisplayDate(), ((VarnishedMessage)msgInfo).getFixEndDisplayDate(), ((VarnishedMessage)msgInfo).getNotifyKey());
            VarnishedMessageJson messageJson = new VarnishedMessageJson(noticeBarInfo, noticeExpandInfo, clickTypeInfo, pushTimeInfo, advanceInfo);
            IFlymePush.addParameter(body, "messageJson", JSON.toJSONString((Object)messageJson));
            if (message.getRestrictedPackageNames() != null) {
                IFlymePush.addParameter(body, "restrictedPackageNames", this.array2Str(message.getRestrictedPackageNames()));
            }
        }
        HttpResult httpResult = super.post(this.useSSL, _url, body.toString());
        String code = httpResult.getCode();
        String msg = httpResult.getMessage();
        String value = httpResult.getValue();
        if (SUCCESS_CODE.equals(code)) {
            JSONObject objValue = JSON.parseObject((String)value);
            if (objValue.containsKey((Object)"taskId")) {
                Long taskId = objValue.getLong("taskId");
                return ResultPack.succeed(code, msg, taskId);
            }
            return ResultPack.failed("error return value");
        }
        return ResultPack.failed(code, msg);
    }

    public ResultPack<Long> pushToTag(PushType pushType, Message message, List<String> tagName, ScopeType scopeType) throws IOException {
        Message msgInfo;
        String _url = "http://server-api-push.meizu.com/garcia/api/server/push/pushTask/pushToTag";
        if (pushType == null) {
            return ResultPack.failed("pushType is null");
        }
        if (scopeType == null) {
            return ResultPack.failed("scopeType is null");
        }
        if (message == null) {
            return ResultPack.failed("message is null");
        }
        if (CollectionUtils.isEmpty(tagName)) {
            return ResultPack.failed("tagName is null");
        }
        Long appId = message.getAppId();
        if (appId == null) {
            return ResultPack.failed("appId is null");
        }
        StringBuilder body = IFlymePush.newBody("pushType", String.valueOf(pushType.getDesc()));
        IFlymePush.addParameter(body, "appId", String.valueOf(appId));
        IFlymePush.addParameter(body, "tagNames", CollectionUtils.list2Str(tagName));
        IFlymePush.addParameter(body, "scope", String.valueOf(scopeType.getDesc()));
        if (PushType.DIRECT == pushType) {
            if (!(message instanceof UnVarnishedMessage)) {
                return ResultPack.failed("message must be instanceof UnVarnishedMessage");
            }
            msgInfo = (UnVarnishedMessage)message;
            String startTime = "";
            if (((UnVarnishedMessage)msgInfo).getStartTime() != null) {
                startTime = DateUtils.date2String(((UnVarnishedMessage)msgInfo).getStartTime());
            }
            PushTimeInfo pushTimeInfo = new PushTimeInfo(((UnVarnishedMessage)msgInfo).isOffLine(), ((UnVarnishedMessage)msgInfo).getValidTime(), ((UnVarnishedMessage)msgInfo).getPushTimeType(), startTime);
            AdvanceInfo advanceInfo = new AdvanceInfo(((UnVarnishedMessage)msgInfo).isFixSpeed(), ((UnVarnishedMessage)msgInfo).getFixSpeedRate());
            UnVarnishedMessageJson messageJson = new UnVarnishedMessageJson(((UnVarnishedMessage)msgInfo).getTitle(), ((UnVarnishedMessage)msgInfo).getContent(), pushTimeInfo, advanceInfo);
            IFlymePush.addParameter(body, "messageJson", JSON.toJSONString((Object)messageJson));
        } else if (PushType.STATUSBAR == pushType) {
            if (!(message instanceof VarnishedMessage)) {
                return ResultPack.failed("message must be instanceof VarnishedMessage");
            }
            msgInfo = (VarnishedMessage)message;
            NoticeBarInfo noticeBarInfo = new NoticeBarInfo(((VarnishedMessage)msgInfo).getNoticeBarType(), ((VarnishedMessage)msgInfo).getTitle(), ((VarnishedMessage)msgInfo).getContent());
            NoticeExpandInfo noticeExpandInfo = new NoticeExpandInfo(((VarnishedMessage)msgInfo).getNoticeExpandType(), ((VarnishedMessage)msgInfo).getNoticeExpandContent());
            ClickTypeInfo clickTypeInfo = new ClickTypeInfo(((VarnishedMessage)msgInfo).getClickType(), ((VarnishedMessage)msgInfo).getUrl(), ((VarnishedMessage)msgInfo).getParameters(), ((VarnishedMessage)msgInfo).getActivity(), ((VarnishedMessage)msgInfo).getCustomAttribute());
            String startTime = "";
            if (((VarnishedMessage)msgInfo).getStartTime() != null) {
                startTime = DateUtils.date2String(((VarnishedMessage)msgInfo).getStartTime());
            }
            PushTimeInfo pushTimeInfo = new PushTimeInfo(((VarnishedMessage)msgInfo).isOffLine(), ((VarnishedMessage)msgInfo).getValidTime(), ((VarnishedMessage)msgInfo).getPushTimeType(), startTime);
            NotificationType notificationType = new NotificationType(((VarnishedMessage)msgInfo).isVibrate(), ((VarnishedMessage)msgInfo).isLights(), ((VarnishedMessage)msgInfo).isSound());
            AdvanceInfo advanceInfo = new AdvanceInfo(((VarnishedMessage)msgInfo).isFixSpeed(), ((VarnishedMessage)msgInfo).getFixSpeedRate(), ((VarnishedMessage)msgInfo).isSuspend(), ((VarnishedMessage)msgInfo).isClearNoticeBar(), notificationType, ((VarnishedMessage)msgInfo).isFixDisplay(), ((VarnishedMessage)msgInfo).getFixStartDisplayDate(), ((VarnishedMessage)msgInfo).getFixEndDisplayDate(), ((VarnishedMessage)msgInfo).getNotifyKey());
            VarnishedMessageJson messageJson = new VarnishedMessageJson(noticeBarInfo, noticeExpandInfo, clickTypeInfo, pushTimeInfo, advanceInfo);
            IFlymePush.addParameter(body, "messageJson", JSON.toJSONString((Object)messageJson));
            if (message.getRestrictedPackageNames() != null) {
                IFlymePush.addParameter(body, "restrictedPackageNames", this.array2Str(message.getRestrictedPackageNames()));
            }
        }
        HttpResult httpResult = super.post(this.useSSL, _url, body.toString());
        String code = httpResult.getCode();
        String msg = httpResult.getMessage();
        String value = httpResult.getValue();
        if (SUCCESS_CODE.equals(code)) {
            JSONObject objValue = JSON.parseObject((String)value);
            if (objValue.containsKey((Object)"taskId")) {
                Long taskId = objValue.getLong("taskId");
                return ResultPack.succeed(code, msg, taskId);
            }
            return ResultPack.failed("error return value");
        }
        return ResultPack.failed(code, msg);
    }

    public ResultPack<Boolean> cancelTaskPush(PushType pushType, long appId, long taskId) throws IOException {
        if (pushType == null) {
            return ResultPack.failed("pushType is null");
        }
        String _url = "http://server-api-push.meizu.com/garcia/api/server/push/pushTask/cancel";
        StringBuilder body = IFlymePush.newBody("pushType", String.valueOf(pushType.getDesc()));
        IFlymePush.addParameter(body, "appId", String.valueOf(String.valueOf(appId)));
        IFlymePush.addParameter(body, "taskId", String.valueOf(String.valueOf(taskId)));
        HttpResult httpResult = super.post(this.useSSL, _url, body.toString());
        String code = httpResult.getCode();
        String msg = httpResult.getMessage();
        if (SUCCESS_CODE.equals(code)) {
            return ResultPack.succeed("\u63a8\u9001\u4efb\u52a1\u53d6\u6d88\u6210\u529f");
        }
        return ResultPack.failed(code, msg);
    }

    public ResultPack<TaskStatistics> getTaskStatistics(long appId, long taskId) throws IOException {
        String _url = "http://server-api-push.meizu.com/garcia/api/server/push/statistics/getTaskStatistics";
        StringBuilder body = IFlymePush.newBody("appId", String.valueOf(appId));
        IFlymePush.addParameter(body, "taskId", String.valueOf(String.valueOf(taskId)));
        HttpResult httpResult = super.post(this.useSSL, _url, body.toString());
        String code = httpResult.getCode();
        String msg = httpResult.getMessage();
        String value = httpResult.getValue();
        TaskStatistics taskStatistics = new TaskStatistics();
        if (SUCCESS_CODE.equals(code)) {
            if (StringUtils.isNotBlank(value)) {
                try {
                    JSONObject jsonObject = JSONObject.parseObject((String)value);
                    taskStatistics.setTargetNo(jsonObject.getLong("targetNo"));
                    taskStatistics.setValidNo(jsonObject.getLong("validNo"));
                    taskStatistics.setPushedNo(jsonObject.getLong("pushedNo"));
                    taskStatistics.setAcceptNo(jsonObject.getLong("acceptNo"));
                    taskStatistics.setDisplayNo(jsonObject.getLong("displayNo"));
                    taskStatistics.setClickNo(jsonObject.getLong("clickNo"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return ResultPack.succeed(taskStatistics);
        }
        return ResultPack.failed(code, msg);
    }

    public ResultPack<List<DailyPushStatics>> dailyPushStatics(long appId, Date startTime, Date endTime) throws IOException {
        String _url = "http://server-api-push.meizu.com/garcia/api/server/push/statistics/dailyPushStatics";
        StringBuilder body = IFlymePush.newBody("appId", String.valueOf(appId));
        IFlymePush.addParameter(body, "startTime", DateUtils.date2String(startTime, "yyyyMMdd"));
        IFlymePush.addParameter(body, "endTime", DateUtils.date2String(endTime, "yyyyMMdd"));
        HttpResult httpResult = super.post(this.useSSL, _url, body.toString());
        String code = httpResult.getCode();
        String msg = httpResult.getMessage();
        String value = httpResult.getValue();
        List taskStatistics = new ArrayList();
        if (SUCCESS_CODE.equals(code)) {
            if (StringUtils.isNotBlank(value)) {
                try {
                    taskStatistics = JSONObject.parseArray((String)value, DailyPushStatics.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return ResultPack.succeed(taskStatistics);
        }
        return ResultPack.failed(code, msg);
    }

    private ResultPack<PushResult> pushMessage(UserType userType, PushType pushType, Message message, String targets, int retries) throws IOException {
        ResultPack<PushResult> result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            logger.debug(String.format("attempt [%s] to pushMessage [%s] to %s [%s]", ++attempt, message, userType.getValue(), targets));
            result = this.pushMessageNoRetry(userType, pushType, message, targets);
            tryAgain = result == null && attempt <= retries;
            backoff = this.getBackoffTime(backoff, tryAgain);
        } while (tryAgain);
        if (result == null) {
            throw new IOException(String.format("Could not send message after [%s] attempts", attempt));
        }
        return result;
    }

    private int getBackoffTime(int backoff, boolean tryAgain) {
        if (tryAgain) {
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff < 60000) {
                backoff *= 2;
            }
        }
        return backoff;
    }

    private ResultPack<PushResult> pushMessageNoRetry(UserType userType, PushType pushType, Message message, String targets) throws IOException {
        Message msgInfo;
        String _url = null;
        StringBuilder body = null;
        if (UserType.PUSHID == userType) {
            body = IFlymePush.newBody("pushIds", targets);
        } else if (UserType.ALIAS == userType) {
            body = IFlymePush.newBody("alias", targets);
        }
        Long appId = message.getAppId();
        if (appId == null || appId <= 0L) {
            return ResultPack.failed("appId is empty");
        }
        IFlymePush.addParameter(body, "appId", String.valueOf(appId));
        if (message.getRestrictedPackageNames() != null) {
            IFlymePush.addParameter(body, "restrictedPackageNames", this.array2Str(message.getRestrictedPackageNames()));
        }
        if (PushType.DIRECT == pushType) {
            msgInfo = (UnVarnishedMessage)message;
            PushTimeInfo pushTimeInfo = new PushTimeInfo(((UnVarnishedMessage)msgInfo).isOffLine(), ((UnVarnishedMessage)msgInfo).getValidTime());
            UnVarnishedMessageJson messageJson = new UnVarnishedMessageJson(((UnVarnishedMessage)msgInfo).getTitle(), ((UnVarnishedMessage)msgInfo).getContent(), pushTimeInfo);
            IFlymePush.addParameter(body, "messageJson", JSON.toJSONString((Object)messageJson));
            if (UserType.PUSHID == userType) {
                _url = "http://server-api-push.meizu.com/garcia/api/server/push/unvarnished/pushByPushId";
            } else if (UserType.ALIAS == userType) {
                _url = "http://server-api-push.meizu.com/garcia/api/server/push/unvarnished/pushByAlias";
            }
        } else if (PushType.STATUSBAR == pushType) {
            msgInfo = (VarnishedMessage)message;
            NoticeBarInfo noticeBarInfo = new NoticeBarInfo(((VarnishedMessage)msgInfo).getNoticeBarType(), ((VarnishedMessage)msgInfo).getTitle(), ((VarnishedMessage)msgInfo).getContent());
            NoticeExpandInfo noticeExpandInfo = new NoticeExpandInfo(((VarnishedMessage)msgInfo).getNoticeExpandType(), ((VarnishedMessage)msgInfo).getNoticeExpandContent());
            ClickTypeInfo clickTypeInfo = new ClickTypeInfo(((VarnishedMessage)msgInfo).getClickType(), ((VarnishedMessage)msgInfo).getUrl(), ((VarnishedMessage)msgInfo).getParameters(), ((VarnishedMessage)msgInfo).getActivity(), ((VarnishedMessage)msgInfo).getCustomAttribute());
            PushTimeInfo pushTimeInfo = new PushTimeInfo(((VarnishedMessage)msgInfo).isOffLine(), ((VarnishedMessage)msgInfo).getValidTime());
            NotificationType notificationType = new NotificationType(((VarnishedMessage)msgInfo).isVibrate(), ((VarnishedMessage)msgInfo).isLights(), ((VarnishedMessage)msgInfo).isSound());
            AdvanceInfo advanceInfo = new AdvanceInfo(((VarnishedMessage)msgInfo).isFixSpeed(), ((VarnishedMessage)msgInfo).getFixSpeedRate(), ((VarnishedMessage)msgInfo).isSuspend(), ((VarnishedMessage)msgInfo).isClearNoticeBar(), notificationType, ((VarnishedMessage)msgInfo).isFixDisplay(), ((VarnishedMessage)msgInfo).getFixStartDisplayDate(), ((VarnishedMessage)msgInfo).getFixEndDisplayDate(), ((VarnishedMessage)msgInfo).getNotifyKey());
            VarnishedMessageJson messageJson = new VarnishedMessageJson(noticeBarInfo, noticeExpandInfo, clickTypeInfo, pushTimeInfo, advanceInfo, ((VarnishedMessage)msgInfo).getExtra());
            IFlymePush.addParameter(body, "messageJson", JSON.toJSONString((Object)messageJson));
            if (UserType.PUSHID == userType) {
                _url = "http://server-api-push.meizu.com/garcia/api/server/push/varnished/pushByPushId";
            } else if (UserType.ALIAS == userType) {
                _url = "http://server-api-push.meizu.com/garcia/api/server/push/varnished/pushByAlias";
            }
        }
        HttpResult httpResult = super.post(this.useSSL, _url, body.toString());
        if (httpResult == null) {
            return null;
        }
        String code = httpResult.getCode();
        String msg = httpResult.getMessage();
        String value = httpResult.getValue();
        String msgId = httpResult.getMsgId();
        if (SUCCESS_CODE.equals(code)) {
            Map<String, List<String>> respTarget = new HashMap<String, List<String>>();
            if (StringUtils.isNotBlank(value)) {
                respTarget = (Map)JSONObject.parseObject((String)value, Map.class);
            }
            return ResultPack.succeed(code, msg, PushResult.build(msgId, respTarget));
        }
        return ResultPack.failed(code, msg);
    }

    private ResultPack<PushResult> pushMessageByTaskId(UserType userType, PushType pushType, long appId, long taskId, String targets, int retries) throws IOException {
        ResultPack<PushResult> result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            logger.debug(String.format("attempt [%s] to taskId [%s] to %s [%s]", new Object[]{++attempt, taskId, userType, targets}));
            result = this.pushMessageByTaskIdNoRetry(userType, pushType, appId, taskId, targets);
            tryAgain = result == null && attempt <= retries;
            backoff = this.getBackoffTime(backoff, tryAgain);
        } while (tryAgain);
        if (result == null) {
            throw new IOException(String.format("Could not send message after [%s] attempts", attempt));
        }
        return result;
    }

    private ResultPack<PushResult> pushMessageByTaskIdNoRetry(UserType userType, PushType pushType, long appId, long taskId, String targets) throws IOException {
        String _url = null;
        StringBuilder body = IFlymePush.newBody("appId", String.valueOf(appId));
        IFlymePush.addParameter(body, "taskId", String.valueOf(taskId));
        if (UserType.PUSHID == userType) {
            IFlymePush.addParameter(body, "pushIds", targets);
        } else if (UserType.ALIAS == userType) {
            IFlymePush.addParameter(body, "alias", targets);
        }
        if (PushType.DIRECT == pushType) {
            if (UserType.PUSHID == userType) {
                _url = "http://server-api-push.meizu.com/garcia/api/server/push/task/unvarnished/pushByPushId";
            } else if (UserType.ALIAS == userType) {
                _url = "http://server-api-push.meizu.com/garcia/api/server/push/task/unvarnished/pushByAlias";
            }
        } else if (PushType.STATUSBAR == pushType) {
            if (UserType.PUSHID == userType) {
                _url = "http://server-api-push.meizu.com/garcia/api/server/push/task/varnished/pushByPushId";
            } else if (UserType.ALIAS == userType) {
                _url = "http://server-api-push.meizu.com/garcia/api/server/push/task/varnished/pushByAlias";
            }
        }
        HttpResult httpResult = super.post(this.useSSL, _url, body.toString());
        if (httpResult == null) {
            return null;
        }
        String code = httpResult.getCode();
        String msg = httpResult.getMessage();
        String value = httpResult.getValue();
        String msgId = String.valueOf(taskId);
        if (SUCCESS_CODE.equals(code)) {
            Map<String, List<String>> respTarget = new HashMap<String, List<String>>();
            if (StringUtils.isNotBlank(value)) {
                respTarget = (Map)JSONObject.parseObject((String)value, Map.class);
            }
            return ResultPack.succeed(code, msg, PushResult.build(msgId, respTarget));
        }
        return ResultPack.failed(code, msg);
    }

    private String array2Str(String[] restrictedPackageNames) {
        if (restrictedPackageNames == null || restrictedPackageNames.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(restrictedPackageNames[0]);
        for (int i = 1; i < restrictedPackageNames.length; ++i) {
            sb.append(",").append(restrictedPackageNames[i]);
        }
        return sb.toString();
    }

    static enum UserType {
        PUSHID(0, "pushId"),
        ALIAS(1, "alias");

        private Integer key;
        private String value;

        private UserType(Integer key, String value) {
            this.key = key;
            this.value = value;
        }

        public Integer getKey() {
            return this.key;
        }

        public void setKey(Integer key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

