/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.push.sdk.server;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.meizu.push.sdk.constant.PushType;
import com.meizu.push.sdk.server.constant.ResultPack;
import com.meizu.push.sdk.server.model.HttpResult;
import com.meizu.push.sdk.server.model.sub.AliasInfo;
import com.meizu.push.sdk.server.model.sub.SwitchStatusInfo;
import com.meizu.push.sdk.server.model.sub.TagInfo;
import com.meizu.push.sdk.utils.CollectionUtils;
import com.meizu.push.sdk.utils.HttpClient;
import com.meizu.push.sdk.utils.StringUtils;
import java.io.IOException;
import java.util.List;

public class IFlymePushSub
extends HttpClient {
    private static final String SUCCESS_CODE = "200";

    public IFlymePushSub(long appId, String appSecret) {
        super(appId, appSecret);
    }

    public IFlymePushSub(long appId, String appSecret, boolean useSSL) {
        super(appId, appSecret, useSSL);
    }

    public ResultPack<SwitchStatusInfo> updateStatusbarSwitch(String pushId, Boolean subSwitch) throws IOException {
        return this.updateSwitch(PushType.STATUSBAR, pushId, subSwitch);
    }

    public ResultPack<SwitchStatusInfo> updateDirectSwitch(String pushId, Boolean subSwitch) throws IOException {
        return this.updateSwitch(PushType.DIRECT, pushId, subSwitch);
    }

    public ResultPack<SwitchStatusInfo> updateAllSwitch(String pushId, Boolean subSwitch) throws IOException {
        if (StringUtils.isEmpty(pushId)) {
            return ResultPack.failed("pushId is empty");
        }
        if (subSwitch == null) {
            return ResultPack.failed("subSwitch is null");
        }
        String url = "http://api-push.meizu.com/garcia/api/server/message/changeAllSwitch";
        StringBuilder body = IFlymePushSub.newBody("appId", String.valueOf(this.appId));
        IFlymePushSub.addParameter(body, "pushId", pushId);
        IFlymePushSub.addParameter(body, "subSwitch", subSwitch.toString());
        return this.http2SwitchResultPack(url, body);
    }

    public ResultPack<SwitchStatusInfo> getRegisterSwitch(String pushId) throws IOException {
        if (StringUtils.isEmpty(pushId)) {
            return ResultPack.failed("pushId is empty");
        }
        String url = "http://api-push.meizu.com/garcia/api/server/message/getRegisterSwitch";
        StringBuilder body = IFlymePushSub.newBody("appId", String.valueOf(this.appId));
        IFlymePushSub.addParameter(body, "pushId", pushId);
        return this.http2SwitchResultPack(url, body);
    }

    public ResultPack<AliasInfo> subscribeAlias(String pushId, String alias) throws IOException {
        if (StringUtils.isEmpty(pushId)) {
            return ResultPack.failed("pushId is empty");
        }
        if (StringUtils.isEmpty(alias)) {
            return ResultPack.failed("alias is empty");
        }
        String url = "http://api-push.meizu.com/garcia/api/server/message/subscribeAlias";
        StringBuilder body = IFlymePushSub.newBody("appId", String.valueOf(this.appId));
        IFlymePushSub.addParameter(body, "pushId", pushId);
        IFlymePushSub.addParameter(body, "alias", alias);
        return this.http2AliasResultPack(url, body);
    }

    public ResultPack<AliasInfo> unSubscribeAlias(String pushId) throws IOException {
        if (StringUtils.isEmpty(pushId)) {
            return ResultPack.failed("pushId is empty");
        }
        String url = "http://api-push.meizu.com/garcia/api/server/message/unSubscribeAlias";
        StringBuilder body = IFlymePushSub.newBody("appId", String.valueOf(this.appId));
        IFlymePushSub.addParameter(body, "pushId", pushId);
        return this.http2AliasResultPack(url, body);
    }

    public ResultPack<AliasInfo> getSubAlias(String pushId) throws IOException {
        if (StringUtils.isEmpty(pushId)) {
            return ResultPack.failed("pushId is empty");
        }
        String url = "http://api-push.meizu.com/garcia/api/server/message/getSubAlias";
        StringBuilder body = IFlymePushSub.newBody("appId", String.valueOf(this.appId));
        IFlymePushSub.addParameter(body, "pushId", pushId);
        return this.http2AliasResultPack(url, body);
    }

    public ResultPack<TagInfo> subscribeTags(String pushId, List<String> tags) throws IOException {
        if (StringUtils.isEmpty(pushId)) {
            return ResultPack.failed("pushId is empty");
        }
        if (CollectionUtils.isEmpty(tags)) {
            return ResultPack.failed("tags is empty");
        }
        String url = "http://api-push.meizu.com/garcia/api/server/message/subscribeTags";
        StringBuilder body = IFlymePushSub.newBody("appId", String.valueOf(this.appId));
        IFlymePushSub.addParameter(body, "pushId", pushId);
        IFlymePushSub.addParameter(body, "tags", CollectionUtils.list2Str(tags));
        return this.http2TagResultPack(url, body);
    }

    public ResultPack<TagInfo> unSubscribeTags(String pushId, List<String> tags) throws IOException {
        if (StringUtils.isEmpty(pushId)) {
            return ResultPack.failed("pushId is empty");
        }
        if (CollectionUtils.isEmpty(tags)) {
            return ResultPack.failed("tags is empty");
        }
        String url = "http://api-push.meizu.com/garcia/api/server/message/unSubscribeTags";
        StringBuilder body = IFlymePushSub.newBody("appId", String.valueOf(this.appId));
        IFlymePushSub.addParameter(body, "pushId", pushId);
        IFlymePushSub.addParameter(body, "tags", CollectionUtils.list2Str(tags));
        return this.http2TagResultPack(url, body);
    }

    public ResultPack<TagInfo> getSubTags(String pushId) throws IOException {
        if (StringUtils.isEmpty(pushId)) {
            return ResultPack.failed("pushId is empty");
        }
        String url = "http://api-push.meizu.com/garcia/api/server/message/getSubTags";
        StringBuilder body = IFlymePushSub.newBody("appId", String.valueOf(this.appId));
        IFlymePushSub.addParameter(body, "pushId", pushId);
        return this.http2TagResultPack(url, body);
    }

    public ResultPack<Boolean> unSubAllTags(String pushId) throws IOException {
        if (StringUtils.isEmpty(pushId)) {
            return ResultPack.failed("pushId is empty");
        }
        String url = "http://api-push.meizu.com/garcia/api/server/message/unSubAllTags";
        StringBuilder body = IFlymePushSub.newBody("appId", String.valueOf(this.appId));
        IFlymePushSub.addParameter(body, "pushId", pushId);
        HttpResult httpResult = super.post(this.useSSL, url, body.toString());
        if (httpResult == null) {
            return ResultPack.failed("httpResult is null");
        }
        String code = httpResult.getCode();
        String msg = httpResult.getMessage();
        String value = httpResult.getValue();
        if (SUCCESS_CODE.equals(code)) {
            if (StringUtils.isNotBlank(value)) {
                return ResultPack.succeed(code, msg, Boolean.parseBoolean(value));
            }
            return ResultPack.failed("response value is blank");
        }
        return ResultPack.failed(code, msg);
    }

    private ResultPack<TagInfo> http2TagResultPack(String url, StringBuilder body) throws IOException {
        HttpResult httpResult = super.post(this.useSSL, url, body.toString());
        if (httpResult == null) {
            return ResultPack.failed("httpResult is null");
        }
        String code = httpResult.getCode();
        String msg = httpResult.getMessage();
        String value = httpResult.getValue();
        if (SUCCESS_CODE.equals(code)) {
            if (StringUtils.isNotBlank(value)) {
                TagInfo tagInfo = (TagInfo)JSON.parseObject((String)value, TagInfo.class);
                return ResultPack.succeed(code, msg, tagInfo);
            }
            return ResultPack.failed("response value is blank");
        }
        return ResultPack.failed(code, msg);
    }

    private ResultPack<AliasInfo> http2AliasResultPack(String url, StringBuilder body) throws IOException {
        HttpResult httpResult = super.post(this.useSSL, url, body.toString());
        if (httpResult == null) {
            return ResultPack.failed("httpResult is null");
        }
        String code = httpResult.getCode();
        String msg = httpResult.getMessage();
        String value = httpResult.getValue();
        if (SUCCESS_CODE.equals(code)) {
            if (StringUtils.isNotBlank(value)) {
                JSONObject jsonObject = JSON.parseObject((String)value);
                AliasInfo aliasInfo = new AliasInfo(jsonObject.getString("pushId"), jsonObject.getString("alias"));
                return ResultPack.succeed(code, msg, aliasInfo);
            }
            return ResultPack.failed("response value is blank");
        }
        return ResultPack.failed(code, msg);
    }

    private ResultPack<SwitchStatusInfo> updateSwitch(PushType pushType, String pushId, Boolean subSwitch) throws IOException {
        if (StringUtils.isEmpty(pushId)) {
            return ResultPack.failed("pushId is empty");
        }
        if (subSwitch == null) {
            return ResultPack.failed("subSwitch is null");
        }
        String _url = "http://api-push.meizu.com/garcia/api/server/message/changeRegisterSwitch";
        StringBuilder body = IFlymePushSub.newBody("appId", String.valueOf(this.appId));
        IFlymePushSub.addParameter(body, "pushId", pushId);
        IFlymePushSub.addParameter(body, "msgType", String.valueOf(pushType.getDesc()));
        IFlymePushSub.addParameter(body, "subSwitch", subSwitch.toString());
        return this.http2SwitchResultPack(_url, body);
    }

    private ResultPack<SwitchStatusInfo> http2SwitchResultPack(String url, StringBuilder body) throws IOException {
        HttpResult httpResult = super.post(this.useSSL, url, body.toString());
        if (httpResult == null) {
            return ResultPack.failed("httpResult is null");
        }
        String code = httpResult.getCode();
        String msg = httpResult.getMessage();
        String value = httpResult.getValue();
        if (SUCCESS_CODE.equals(code)) {
            if (StringUtils.isNotBlank(value)) {
                JSONObject jsonObject = JSON.parseObject((String)value);
                SwitchStatusInfo switchStatusInfo = new SwitchStatusInfo(jsonObject.getString("pushId"), jsonObject.getBoolean("barTypeSwitch"), jsonObject.getBoolean("directTypeSwitch"));
                return ResultPack.succeed(code, msg, switchStatusInfo);
            }
            return ResultPack.failed("response value is blank");
        }
        return ResultPack.failed(code, msg);
    }
}

