/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.push.sdk.server.constant;

import com.meizu.push.sdk.server.constant.ErrorCode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class ResultPack<T>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final int VOID = 0;
    public static final int FAILED = -1;
    public static final int SUCCESS = 1;
    private static final String ERROR_CODE = "500";
    private static final String SUCCESS_CODE = "200";
    private int _status = 0;
    private String _code;
    private String _comment = null;
    private T _value = null;
    private Throwable _error = null;
    private ErrorCode _errorCode = null;

    public ResultPack() {
    }

    private ResultPack(int status, T value, String code, String comment, Throwable error, ErrorCode errorCode) {
        this._status = status;
        this._value = value;
        this._comment = comment;
        this._code = code;
        this._error = error;
        this._errorCode = errorCode;
    }

    public ErrorCode getErrorCode() {
        return this._errorCode;
    }

    public int status() {
        return this._status;
    }

    public ResultPack<T> status(int status) {
        this._status = status;
        return this;
    }

    public ResultPack<T> code(String code) {
        this._code = code;
        return this;
    }

    public String comment() {
        return this._comment;
    }

    public ResultPack<T> comment(String comment, Object ... args) {
        this._comment = String.format(comment, args);
        return this;
    }

    public T value() {
        return this._value;
    }

    public String code() {
        return this._code;
    }

    public ResultPack<T> value(T value) {
        this._value = value;
        return this;
    }

    public Throwable error() {
        return this._error;
    }

    public ResultPack<T> error(Throwable error) {
        this._error = error;
        if (error != null) {
            this._status = -1;
            this._comment = error.getMessage();
        }
        return this;
    }

    private ResultPack<T> _errorCode() {
        try {
            int code = Integer.parseInt(this._code);
            String comment = this.comment();
            this._errorCode = ErrorCode.valueOf((Integer)code, comment);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this;
    }

    public boolean isFailed() {
        return this._status == -1;
    }

    public boolean isVoid() {
        return this._status == 0;
    }

    public boolean isSucceed() {
        return this._status == 1;
    }

    public ResultPack<T> reset() {
        this._status = 0;
        this._value = null;
        this._comment = null;
        this._error = null;
        return this;
    }

    public ResultPack<T> reset(boolean keepComment) {
        this._status = 0;
        this._value = null;
        this._error = null;
        if (!keepComment) {
            this._comment = null;
        }
        return this;
    }

    public String toString() {
        return "RESULT:[" + this._status + "] code:[" + this._code + "] comment:[" + this._comment + "] value:[" + String.valueOf(this._value) + "] error:[" + String.valueOf(this._error) + "]" + "] errorCode:[" + this._errorCode + "]";
    }

    public Map<String, Object> toJson() {
        return this.toJson(null);
    }

    public Map<String, Object> toJson(Map<String, Object> jsons) {
        if (jsons == null) {
            jsons = new HashMap<String, Object>();
        }
        jsons.put("status", this._status);
        jsons.put("comment", this._comment);
        jsons.put("value", String.valueOf(this._value));
        jsons.put("error", String.valueOf(this._error));
        return jsons;
    }

    public ResultPack<T> clone() {
        return new ResultPack<T>(this._status, this._value, this._code, this._comment, this._error, this._errorCode);
    }

    public static <R> ResultPack<R> succeed() {
        ResultPack result = new ResultPack();
        return result.status(1).code(SUCCESS_CODE);
    }

    public static <R> ResultPack<R> succeed(R value) {
        ResultPack result = new ResultPack();
        return result.status(1).value(value).code(SUCCESS_CODE);
    }

    public static <R> ResultPack<R> succeed(String code, String comment, R value) {
        ResultPack result = new ResultPack();
        return result.status(1).code(code).comment(comment, new Object[0]).value(value);
    }

    public static <R> ResultPack<R> succeed(String comment) {
        ResultPack result = new ResultPack();
        return result.status(1).comment(comment, new Object[0]).code(SUCCESS_CODE);
    }

    public static <R> ResultPack<R> failed() {
        ResultPack result = new ResultPack();
        return super._errorCode();
    }

    public static <R> ResultPack<R> failed(String comment) {
        ResultPack result = new ResultPack();
        return super._errorCode();
    }

    public static <R> ResultPack<R> failed(String code, String comment) {
        ResultPack result = new ResultPack();
        return super._errorCode();
    }

    public static <R> ResultPack<R> failed(String comment, Throwable e) {
        ResultPack result = new ResultPack();
        return super._errorCode();
    }

    public static <R> ResultPack<R> failed(String comment, R value) {
        ResultPack result = new ResultPack();
        return super._errorCode();
    }

    public static <R> ResultPack<R> failed(Throwable e) {
        ResultPack result = new ResultPack();
        return super._errorCode();
    }

    public static <R> ResultPack<R> none() {
        ResultPack result = new ResultPack();
        return result.status(0);
    }

    public static <R> ResultPack<R> none(String comment) {
        ResultPack result = new ResultPack();
        return result.status(0).comment(comment, new Object[0]);
    }
}

