/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import org.apache.commons.beanutils2.PropertyUtils;

public class BeanComparator<T, V>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String property;
    private final Comparator<V> comparator;

    public BeanComparator() {
        this(null);
    }

    public BeanComparator(String property) {
        this(property, NaturalOrderComparator.INSTANCE);
    }

    public BeanComparator(String property, Comparator<V> comparator) {
        this.setProperty(property);
        this.comparator = comparator != null ? comparator : NaturalOrderComparator.INSTANCE;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getProperty() {
        return this.property;
    }

    public Comparator<V> getComparator() {
        return this.comparator;
    }

    @Override
    public int compare(T o1, T o2) {
        if (this.property == null) {
            return this.internalCompare(o1, o2);
        }
        try {
            Object value1 = PropertyUtils.getProperty(o1, this.property);
            Object value2 = PropertyUtils.getProperty(o2, this.property);
            return this.internalCompare(value1, value2);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e.getClass().getSimpleName() + ": " + e.toString());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BeanComparator)) {
            return false;
        }
        BeanComparator beanComparator = (BeanComparator)o;
        if (!this.comparator.equals(beanComparator.comparator)) {
            return false;
        }
        if (this.property != null) {
            return this.property.equals(beanComparator.property);
        }
        return beanComparator.property == null;
    }

    public int hashCode() {
        return this.comparator.hashCode();
    }

    private int internalCompare(Object val1, Object val2) {
        return this.comparator.compare(val1, val2);
    }

    private static class NaturalOrderComparator<E extends Comparable<? super E>>
    implements Comparator<E>,
    Serializable {
        private static final long serialVersionUID = -291439688585137865L;
        public static final NaturalOrderComparator INSTANCE = new NaturalOrderComparator();

        private NaturalOrderComparator() {
        }

        @Override
        public int compare(E obj1, E obj2) {
            return obj1.compareTo(obj2);
        }

        public int hashCode() {
            return "NaturalOrderComparator".hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return this == object || null != object && object.getClass().equals(this.getClass());
        }
    }
}

