/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.io.File;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.UUID;
import org.apache.commons.beanutils2.BeanUtilsBean;
import org.apache.commons.beanutils2.ConcurrentWeakKeyHashMap;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.ArrayConverter;
import org.apache.commons.beanutils2.converters.BigDecimalConverter;
import org.apache.commons.beanutils2.converters.BigIntegerConverter;
import org.apache.commons.beanutils2.converters.BooleanConverter;
import org.apache.commons.beanutils2.converters.ByteConverter;
import org.apache.commons.beanutils2.converters.CalendarConverter;
import org.apache.commons.beanutils2.converters.CharacterConverter;
import org.apache.commons.beanutils2.converters.ClassConverter;
import org.apache.commons.beanutils2.converters.ConverterFacade;
import org.apache.commons.beanutils2.converters.DateConverter;
import org.apache.commons.beanutils2.converters.DoubleConverter;
import org.apache.commons.beanutils2.converters.DurationConverter;
import org.apache.commons.beanutils2.converters.EnumConverter;
import org.apache.commons.beanutils2.converters.FileConverter;
import org.apache.commons.beanutils2.converters.FloatConverter;
import org.apache.commons.beanutils2.converters.IntegerConverter;
import org.apache.commons.beanutils2.converters.LocalDateConverter;
import org.apache.commons.beanutils2.converters.LocalDateTimeConverter;
import org.apache.commons.beanutils2.converters.LocalTimeConverter;
import org.apache.commons.beanutils2.converters.LongConverter;
import org.apache.commons.beanutils2.converters.MonthDayConverter;
import org.apache.commons.beanutils2.converters.OffsetDateTimeConverter;
import org.apache.commons.beanutils2.converters.OffsetTimeConverter;
import org.apache.commons.beanutils2.converters.PathConverter;
import org.apache.commons.beanutils2.converters.PeriodConverter;
import org.apache.commons.beanutils2.converters.ShortConverter;
import org.apache.commons.beanutils2.converters.SqlDateConverter;
import org.apache.commons.beanutils2.converters.SqlTimeConverter;
import org.apache.commons.beanutils2.converters.SqlTimestampConverter;
import org.apache.commons.beanutils2.converters.StringConverter;
import org.apache.commons.beanutils2.converters.URIConverter;
import org.apache.commons.beanutils2.converters.URLConverter;
import org.apache.commons.beanutils2.converters.UUIDConverter;
import org.apache.commons.beanutils2.converters.YearConverter;
import org.apache.commons.beanutils2.converters.YearMonthConverter;
import org.apache.commons.beanutils2.converters.ZoneIdConverter;
import org.apache.commons.beanutils2.converters.ZoneOffsetConverter;
import org.apache.commons.beanutils2.converters.ZonedDateTimeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConvertUtilsBean {
    private static final Integer ZERO = 0;
    private static final Character SPACE = Character.valueOf(' ');
    private final ConcurrentWeakKeyHashMap<Class<?>, Converter> converters = new ConcurrentWeakKeyHashMap();
    private final Log log = LogFactory.getLog(ConvertUtilsBean.class);

    protected static ConvertUtilsBean getInstance() {
        return BeanUtilsBean.getInstance().getConvertUtils();
    }

    public ConvertUtilsBean() {
        this.deregister();
    }

    public String convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (Array.getLength(value) < 1) {
                return null;
            }
            if ((value = Array.get(value, 0)) == null) {
                return null;
            }
            Converter converter = this.lookup(String.class);
            return converter.convert(String.class, value);
        }
        Converter converter = this.lookup(String.class);
        return converter.convert(String.class, value);
    }

    public Object convert(String value, Class<?> clazz) {
        Converter converter;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Convert string '" + value + "' to class '" + clazz.getName() + "'"));
        }
        if ((converter = this.lookup(clazz)) == null) {
            converter = this.lookup(String.class);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("  Using converter " + converter));
        }
        return converter.convert(clazz, value);
    }

    public Object convert(String[] values, Class<?> clazz) {
        Converter converter;
        Class<?> type = clazz;
        if (clazz.isArray()) {
            type = clazz.getComponentType();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Convert String[" + values.length + "] to class '" + type.getName() + "[]'"));
        }
        if ((converter = this.lookup(type)) == null) {
            converter = this.lookup(String.class);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("  Using converter " + converter));
        }
        Object array = Array.newInstance(type, values.length);
        for (int i = 0; i < values.length; ++i) {
            Array.set(array, i, converter.convert(type, values[i]));
        }
        return array;
    }

    public Object convert(Object value, Class<?> targetType) {
        Class<?> sourceType;
        Class<?> clazz = sourceType = value == null ? null : value.getClass();
        if (this.log.isDebugEnabled()) {
            if (value == null) {
                this.log.debug((Object)("Convert null value to type '" + targetType.getName() + "'"));
            } else {
                this.log.debug((Object)("Convert type '" + sourceType.getName() + "' value '" + value + "' to type '" + targetType.getName() + "'"));
            }
        }
        Object converted = value;
        Converter converter = this.lookup(sourceType, targetType);
        if (converter != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("  Using converter " + converter));
            }
            converted = converter.convert(targetType, value);
        }
        if (String.class.equals(targetType) && converted != null && !(converted instanceof String)) {
            converter = this.lookup(String.class);
            if (converter != null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("  Using converter " + converter));
                }
                converted = converter.convert(String.class, converted);
            }
            if (converted != null && !(converted instanceof String)) {
                converted = converted.toString();
            }
        }
        return converted;
    }

    public void deregister() {
        this.converters.clear();
        this.registerPrimitives(false);
        this.registerStandard(false, false);
        this.registerOther(true);
        this.registerArrays(false, 0);
        this.register(BigDecimal.class, new BigDecimalConverter());
        this.register(BigInteger.class, new BigIntegerConverter());
    }

    public void register(boolean throwException, boolean defaultNull, int defaultArraySize) {
        this.registerPrimitives(throwException);
        this.registerStandard(throwException, defaultNull);
        this.registerOther(throwException);
        this.registerArrays(throwException, defaultArraySize);
    }

    private void registerPrimitives(boolean throwException) {
        this.register(Boolean.TYPE, throwException ? new BooleanConverter() : new BooleanConverter(Boolean.FALSE));
        this.register(Byte.TYPE, throwException ? new ByteConverter() : new ByteConverter(ZERO));
        this.register(Character.TYPE, throwException ? new CharacterConverter() : new CharacterConverter(SPACE));
        this.register(Double.TYPE, throwException ? new DoubleConverter() : new DoubleConverter(ZERO));
        this.register(Float.TYPE, throwException ? new FloatConverter() : new FloatConverter(ZERO));
        this.register(Integer.TYPE, throwException ? new IntegerConverter() : new IntegerConverter(ZERO));
        this.register(Long.TYPE, throwException ? new LongConverter() : new LongConverter(ZERO));
        this.register(Short.TYPE, throwException ? new ShortConverter() : new ShortConverter(ZERO));
    }

    private void registerStandard(boolean throwException, boolean defaultNull) {
        Integer defaultNumber = defaultNull ? null : ZERO;
        BigDecimal bigDecDeflt = defaultNull ? null : new BigDecimal("0.0");
        BigInteger bigIntDeflt = defaultNull ? null : new BigInteger("0");
        Boolean booleanDefault = defaultNull ? null : Boolean.FALSE;
        Character charDefault = defaultNull ? null : SPACE;
        String stringDefault = defaultNull ? null : "";
        this.register(BigDecimal.class, throwException ? new BigDecimalConverter() : new BigDecimalConverter(bigDecDeflt));
        this.register(BigInteger.class, throwException ? new BigIntegerConverter() : new BigIntegerConverter(bigIntDeflt));
        this.register(Boolean.class, throwException ? new BooleanConverter() : new BooleanConverter(booleanDefault));
        this.register(Byte.class, throwException ? new ByteConverter() : new ByteConverter(defaultNumber));
        this.register(Character.class, throwException ? new CharacterConverter() : new CharacterConverter(charDefault));
        this.register(Double.class, throwException ? new DoubleConverter() : new DoubleConverter(defaultNumber));
        this.register(Float.class, throwException ? new FloatConverter() : new FloatConverter(defaultNumber));
        this.register(Integer.class, throwException ? new IntegerConverter() : new IntegerConverter(defaultNumber));
        this.register(Long.class, throwException ? new LongConverter() : new LongConverter(defaultNumber));
        this.register(Short.class, throwException ? new ShortConverter() : new ShortConverter(defaultNumber));
        this.register(String.class, throwException ? new StringConverter() : new StringConverter(stringDefault));
    }

    private void registerOther(boolean throwException) {
        this.register(Class.class, throwException ? new ClassConverter() : new ClassConverter(null));
        this.register(Enum.class, throwException ? new EnumConverter() : new EnumConverter(null));
        this.register(java.util.Date.class, throwException ? new DateConverter() : new DateConverter(null));
        this.register(Calendar.class, throwException ? new CalendarConverter() : new CalendarConverter(null));
        this.register(File.class, throwException ? new FileConverter() : new FileConverter(null));
        this.register(Path.class, throwException ? new PathConverter() : new PathConverter(null));
        this.register(Date.class, throwException ? new SqlDateConverter() : new SqlDateConverter(null));
        this.register(Time.class, throwException ? new SqlTimeConverter() : new SqlTimeConverter(null));
        this.register(Timestamp.class, throwException ? new SqlTimestampConverter() : new SqlTimestampConverter(null));
        this.register(URL.class, throwException ? new URLConverter() : new URLConverter(null));
        this.register(URI.class, throwException ? new URIConverter() : new URIConverter(null));
        this.register(UUID.class, throwException ? new UUIDConverter() : new UUIDConverter(null));
        this.register(LocalDate.class, throwException ? new LocalDateConverter() : new LocalDateConverter(null));
        this.register(LocalDateTime.class, throwException ? new LocalDateTimeConverter() : new LocalDateTimeConverter(null));
        this.register(LocalTime.class, throwException ? new LocalTimeConverter() : new LocalTimeConverter(null));
        this.register(OffsetDateTime.class, throwException ? new OffsetDateTimeConverter() : new OffsetDateTimeConverter(null));
        this.register(OffsetTime.class, throwException ? new OffsetTimeConverter() : new OffsetTimeConverter(null));
        this.register(ZonedDateTime.class, throwException ? new ZonedDateTimeConverter() : new ZonedDateTimeConverter(null));
        this.register(Duration.class, throwException ? new DurationConverter() : new DurationConverter(null));
        this.register(MonthDay.class, throwException ? new MonthDayConverter() : new MonthDayConverter(null));
        this.register(Period.class, throwException ? new PeriodConverter() : new PeriodConverter(null));
        this.register(Year.class, throwException ? new YearConverter() : new YearConverter(null));
        this.register(YearMonth.class, throwException ? new YearMonthConverter() : new YearMonthConverter(null));
        this.register(ZoneId.class, throwException ? new ZoneIdConverter() : new ZoneIdConverter(null));
        this.register(ZoneOffset.class, throwException ? new ZoneOffsetConverter() : new ZoneOffsetConverter(null));
    }

    private void registerArrays(boolean throwException, int defaultArraySize) {
        this.registerArrayConverter(Boolean.TYPE, new BooleanConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Byte.TYPE, new ByteConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Character.TYPE, new CharacterConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Double.TYPE, new DoubleConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Float.TYPE, new FloatConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Integer.TYPE, new IntegerConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Long.TYPE, new LongConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Short.TYPE, new ShortConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(BigDecimal.class, new BigDecimalConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(BigInteger.class, new BigIntegerConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Boolean.class, new BooleanConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Byte.class, new ByteConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Character.class, new CharacterConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Double.class, new DoubleConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Float.class, new FloatConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Integer.class, new IntegerConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Long.class, new LongConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Short.class, new ShortConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(String.class, new StringConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Class.class, new ClassConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Enum.class, new EnumConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(java.util.Date.class, new DateConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Calendar.class, new DateConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(File.class, new FileConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Path.class, new PathConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Date.class, new SqlDateConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Time.class, new SqlTimeConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Timestamp.class, new SqlTimestampConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(URL.class, new URLConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(URI.class, new URIConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(UUID.class, new UUIDConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(LocalDate.class, new LocalDateConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(LocalDateTime.class, new LocalDateTimeConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(LocalTime.class, new LocalTimeConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(OffsetDateTime.class, new OffsetDateTimeConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(OffsetTime.class, new OffsetTimeConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(ZonedDateTime.class, new ZonedDateTimeConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Duration.class, new DurationConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(MonthDay.class, new MonthDayConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Period.class, new PeriodConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Year.class, new YearConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(YearMonth.class, new YearMonthConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(ZoneId.class, new ZoneIdConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(ZoneOffset.class, new ZoneOffsetConverter(), throwException, defaultArraySize);
    }

    private void registerArrayConverter(Class<?> componentType, Converter componentConverter, boolean throwException, int defaultArraySize) {
        Class<?> arrayType = Array.newInstance(componentType, 0).getClass();
        ArrayConverter arrayConverter = null;
        arrayConverter = throwException ? new ArrayConverter(arrayType, componentConverter) : new ArrayConverter(arrayType, componentConverter, defaultArraySize);
        this.register(arrayType, arrayConverter);
    }

    private void register(Class<?> clazz, Converter converter) {
        this.register(new ConverterFacade(converter), clazz);
    }

    public void deregister(Class<?> clazz) {
        this.converters.remove(clazz);
    }

    public Converter lookup(Class<?> clazz) {
        return this.converters.get(clazz);
    }

    public Converter lookup(Class<?> sourceType, Class<?> targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("Target type is missing");
        }
        if (sourceType == null) {
            return this.lookup(targetType);
        }
        Converter converter = null;
        if (targetType == String.class) {
            converter = this.lookup(sourceType);
            if (converter == null && (sourceType.isArray() || Collection.class.isAssignableFrom(sourceType))) {
                converter = this.lookup(String[].class);
            }
            if (converter == null) {
                converter = this.lookup(String.class);
            }
            return converter;
        }
        if (targetType == String[].class) {
            if (sourceType.isArray() || Collection.class.isAssignableFrom(sourceType)) {
                converter = this.lookup(sourceType);
            }
            if (converter == null) {
                converter = this.lookup(String[].class);
            }
            return converter;
        }
        return this.lookup(targetType);
    }

    public void register(Converter converter, Class<?> clazz) {
        this.converters.put(clazz, converter);
    }
}

