/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import org.apache.commons.beanutils2.converters.AbstractConverter;

public final class EnumConverter
extends AbstractConverter {
    public EnumConverter() {
    }

    public EnumConverter(Object defaultValue) {
        super(defaultValue);
    }

    @Override
    protected Class<?> getDefaultType() {
        return Enum.class;
    }

    @Override
    protected <T> T convertToType(Class<T> type, Object value) throws Throwable {
        if (Enum.class.isAssignableFrom(type)) {
            String enumValue = String.valueOf(value);
            T[] constants = type.getEnumConstants();
            if (constants == null) {
                throw this.conversionException(type, value);
            }
            for (T candidate : constants) {
                if (!((Enum)candidate).name().equalsIgnoreCase(enumValue)) continue;
                return candidate;
            }
        }
        throw this.conversionException(type, value);
    }
}

