/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.salt;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.salt.IVGenerator;

public class RandomIVGenerator
implements IVGenerator {
    private static final String GENERATOR_ALGORITHM = "SHA1PRNG";
    private final SecureRandom random;

    public RandomIVGenerator() {
        this(GENERATOR_ALGORITHM);
    }

    public RandomIVGenerator(String secureRandomAlgorithm) {
        try {
            this.random = SecureRandom.getInstance(secureRandomAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionInitializationException(e);
        }
    }

    @Override
    public byte[] generateIV(int length) {
        byte[] iv = new byte[length / 8];
        this.random.nextBytes(iv);
        return iv;
    }

    @Override
    public boolean includePlainIVInEncryptionResults() {
        return true;
    }
}

