/*
 * Decompiled with CFR 0.152.
 */
package com.mengweifeng.util;

import com.mengweifeng.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtil {
    public static Map<String, Field> getDeclaredFieldsMap(Class<?> clazz, Boolean recursion) {
        Field[] fields;
        HashMap<String, Field> fieldsMap = new HashMap<String, Field>();
        for (Field field : fields = ClassUtil.getDeclaredFields(clazz, recursion)) {
            String fieldName = field.getName();
            Field existField = (Field)fieldsMap.get(fieldName);
            if (existField == null) {
                fieldsMap.put(fieldName, field);
                continue;
            }
            Class<?> declaringClass = field.getDeclaringClass();
            Class<?> existDeclaringClass = existField.getDeclaringClass();
            if (!existDeclaringClass.isAssignableFrom(declaringClass)) continue;
            fieldsMap.put(fieldName, field);
        }
        return fieldsMap;
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        return ClassUtil.getDeclaredFields(clazz, false);
    }

    public static Field[] getDeclaredFields(Class<?> clazz, Boolean recursion) {
        if (clazz == null) {
            return new Field[0];
        }
        if (recursion == null) {
            recursion = false;
        }
        Field[] fields = clazz.getDeclaredFields();
        if (recursion.booleanValue()) {
            Class<?> superClass = clazz.getSuperclass();
            Field[] superFields = ClassUtil.getDeclaredFields(superClass, recursion);
            fields = ClassUtil.addAll(fields, superFields);
        }
        return fields;
    }

    public static String getHumpName(Class<?> clazz) {
        String className = clazz.getName();
        int i = className.lastIndexOf(".");
        className = className.substring(i + 1, i + 2).toLowerCase() + className.substring(i + 2);
        return className;
    }

    public static <T> List<Class<T>> getAllClassByInterface(Class<T> c, String packageName) {
        if (!c.isInterface()) {
            return Collections.emptyList();
        }
        ArrayList<Class<T>> returnClassList = new ArrayList<Class<T>>();
        if (StringUtils.isEmpty(packageName)) {
            packageName = c.getPackage().getName();
        }
        try {
            List<Class<?>> allClass = ClassUtil.getClasses(packageName);
            for (int i = 0; i < allClass.size(); ++i) {
                if (!c.isAssignableFrom(allClass.get(i)) || c.equals(allClass.get(i))) continue;
                returnClassList.add(allClass.get(i));
            }
        }
        catch (Exception e) {
            return returnClassList;
        }
        return returnClassList;
    }

    public static List<Class<?>> getAllClassByAnnotation(Class<? extends Annotation> annotationClass, String packageName) {
        ArrayList returnClassList = new ArrayList();
        if (StringUtils.isEmpty(packageName)) {
            packageName = annotationClass.getPackage().getName();
        }
        try {
            List<Class<?>> allClass = ClassUtil.getClasses(packageName);
            for (int i = 0; i < allClass.size(); ++i) {
                if (!allClass.get(i).isAnnotationPresent(annotationClass)) continue;
                returnClassList.add(allClass.get(i));
            }
            return returnClassList;
        }
        catch (Exception e) {
            return returnClassList;
        }
    }

    private static Field[] addAll(Field[] fields, Field[] superFields) {
        int i;
        Field[] newArray = new Field[fields.length + superFields.length];
        for (i = 0; i < fields.length; ++i) {
            newArray[i] = fields[i];
        }
        for (i = 0; i < superFields.length; ++i) {
            newArray[fields.length + i] = superFields[i];
        }
        return newArray;
    }

    private static List<Class<?>> getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace(".", "/");
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String newPath = resource.getFile().replace("%20", " ");
            dirs.add(new File(newPath));
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            classes.addAll(ClassUtil.findClass(directory, packageName));
        }
        return classes;
    }

    private static List<Class<?>> findClass(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(ClassUtil.findClass(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + "." + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }

    public static void main(String[] args) {
        System.out.println(ClassUtil.getHumpName(String.class));
    }
}

