/*
 * Decompiled with CFR 0.152.
 */
package com.mengweifeng.util;

import com.mengweifeng.util.HashWheelTimer;
import com.mengweifeng.util.Timer;
import com.mengweifeng.util.TimerTask;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    private static ThreadLocal<SimpleDateFormat> threadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMdd");
        }
    };
    private static final int TICKMILLIS = 1000;
    private static volatile long time;
    private static volatile String gmt;
    private static volatile String nextHourCookieGmt;
    private static volatile int yyyyMMdd;
    private static volatile int year;
    private static volatile int month;
    private static volatile int date;
    private static volatile int hour;
    private static volatile int minute;
    private static volatile int second;
    private static volatile int dayofyear;
    private static volatile int week;
    private static volatile int hourLeftSeconds;
    private static volatile int dayLeftSeconds;
    private static Timer timer;

    private static void init() {
        final SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        final SimpleDateFormat gmtFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        gmtFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        final SimpleDateFormat cookieGmtFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.ENGLISH);
        cookieGmtFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        time = System.currentTimeMillis();
        long now = Long.parseLong(format.format(time));
        gmt = gmtFormat.format(time);
        nextHourCookieGmt = cookieGmtFormat.format(time + 3600000L);
        yyyyMMdd = (int)(now / 1000000L);
        year = (int)(now / 10000000000L);
        month = (int)(now % 10000000000L / 100000000L);
        date = (int)(now % 100000000L / 1000000L);
        hour = (int)(now % 1000000L / 10000L);
        minute = (int)(now % 10000L / 100L);
        second = (int)(now % 100L);
        hourLeftSeconds = 60 * (59 - minute) + 60 - second;
        dayLeftSeconds = 3600 * (23 - hour) + hourLeftSeconds;
        Calendar c = Calendar.getInstance();
        dayofyear = c.get(6);
        c.setTimeInMillis(time);
        int dayOfWeek = c.get(7);
        week = dayOfWeek - 2;
        if (week < 0) {
            week = 6;
        }
        timer.timing(new TimerTask(){

            public long delayOrIntervalMillis() {
                return 1000L;
            }

            public boolean isTriggerIndependently() {
                return false;
            }

            public TimerTask.Type type() {
                return TimerTask.Type.INTERVAL;
            }

            public void run() {
                time = System.currentTimeMillis();
                long now = Long.parseLong(format.format(time));
                gmt = gmtFormat.format(time);
                nextHourCookieGmt = cookieGmtFormat.format(time + 3600000L);
                yyyyMMdd = (int)(now / 1000000L);
                int t = (int)(now / 10000000000L);
                if (t != year) {
                    dayofyear = 1;
                }
                year = t;
                month = (int)(now % 10000000000L / 100000000L);
                t = (int)(now % 100000000L / 1000000L);
                if (t != date) {
                    week = week == 6 ? 0 : week + 1;
                }
                date = t;
                hour = (int)(now % 1000000L / 10000L);
                minute = (int)(now % 10000L / 100L);
                second = (int)(now % 100L);
                hourLeftSeconds = 60 * (59 - minute) + 60 - second;
                dayLeftSeconds = 3600 * (23 - hour) + hourLeftSeconds;
            }
        });
    }

    public static long getTime() {
        return time;
    }

    public static int getYyyyMMdd() {
        return yyyyMMdd;
    }

    public static int getYear() {
        return year;
    }

    public static int getMonth() {
        return month;
    }

    public static int getDate() {
        return date;
    }

    public static int getHour() {
        return hour;
    }

    public static int getMinute() {
        return minute;
    }

    public static int getSecond() {
        return second;
    }

    public static int getHourLeftSeconds() {
        return hourLeftSeconds;
    }

    public static int getDayLeftSeconds() {
        return dayLeftSeconds;
    }

    public static int getWeek() {
        return week;
    }

    public static String getGmt() {
        return gmt;
    }

    public static int getDayofyear() {
        return dayofyear;
    }

    public static String getNextHourCookieGmt() {
        return nextHourCookieGmt;
    }

    public static String getHhMsSs(Date date) {
        if (null == date) {
            date = new Date();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        String hms = sdf.format(date);
        return hms;
    }

    public static int getDateInt(String dateStr) {
        return Integer.parseInt(dateStr);
    }

    public static int getDateInt(Date date) {
        String dateStr = DateUtil.getDateStr(date);
        return DateUtil.getDateInt(dateStr);
    }

    public static int getDiffDays(String dateStr1, String dateStr2) {
        Date date1 = DateUtil.getDate(dateStr1);
        Date date2 = DateUtil.getDate(dateStr2);
        int diffDays = DateUtil.getDiffDays(date1, date2);
        return diffDays;
    }

    public static int getDiffDays(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new RuntimeException("\u8f93\u5165\u53c2\u6570\u4e3anull");
        }
        Long day = null;
        day = (date2.getTime() - date1.getTime()) / 86400000L;
        return Integer.parseInt(day.toString());
    }

    public static Date getDate(String dateStr) {
        SimpleDateFormat sdf = threadLocal.get();
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            log.warn("\u89e3\u6790\u65f6\u95f4\u5b57\u7b26\u4e32[" + dateStr + "]\u5931\u8d25");
        }
        return date;
    }

    public static String getDateStr(Date date) {
        SimpleDateFormat sdf = threadLocal.get();
        return sdf.format(date);
    }

    public static Date getNextDate(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, days);
        return calendar.getTime();
    }

    public static Date getMonthLastDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int maxDays = calendar.getActualMaximum(5);
        calendar.set(5, maxDays);
        return calendar.getTime();
    }

    public static Date getMonthFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getMonday(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 2);
        return calendar.getTime();
    }

    public static Date getSunday(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 1);
        return calendar.getTime();
    }

    public static int getDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7);
    }

    public static boolean isMonday(Date date) {
        int dayOfWeek = DateUtil.getDayOfWeek(date);
        return dayOfWeek == 2;
    }

    public static boolean isSunday(Date date) {
        int dayOfWeek = DateUtil.getDayOfWeek(date);
        return dayOfWeek == 1;
    }

    public static int getDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getDayOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(6);
    }

    public static Date getPreviousMonthFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = calendar.get(2);
        calendar.set(2, month - 1);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getPreviousMonthLastDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = calendar.get(2);
        calendar.set(2, month - 1);
        int maxDays = calendar.getActualMaximum(5);
        calendar.set(5, maxDays);
        return calendar.getTime();
    }

    public static int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2);
    }

    public static boolean isMonthFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int day = calendar.get(5);
        return day == 1;
    }

    public static boolean isMonthLastDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int day = calendar.get(5);
        int maxDays = calendar.getActualMaximum(5);
        return day == maxDays;
    }

    public static boolean isToday(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar today = Calendar.getInstance();
        return today.get(1) == calendar.get(1) && today.get(2) == calendar.get(2) && today.get(6) == calendar.get(6);
    }

    public static String getTodayStr() {
        return yyyyMMdd + "";
    }

    public static Integer getTodayInt() {
        return yyyyMMdd;
    }

    public static Date getToday() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static int getHourByDay() {
        return hour;
    }

    public static int getWeekDayInt() {
        return week + 1;
    }

    public static int getWeekDayInt(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int index = calendar.get(7);
        if (--index == 0) {
            index = 7;
        }
        return index;
    }

    public static int getMonthDayInt(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int index = calendar.get(5);
        return index;
    }

    public static Date getYestoday() {
        Calendar now = Calendar.getInstance();
        now.add(6, -1);
        return now.getTime();
    }

    public static String getYestodayStr() {
        Calendar now = Calendar.getInstance();
        now.add(6, -1);
        SimpleDateFormat sdf = threadLocal.get();
        return sdf.format(now.getTime());
    }

    public static Integer getTodayRemainingSecond() {
        return dayLeftSeconds;
    }

    static {
        timer = new HashWheelTimer();
        DateUtil.init();
    }
}

