/*
 * Decompiled with CFR 0.152.
 */
package com.mengweifeng.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    public static File getFileByClassPath(String resource) {
        URL url = FileUtil.class.getClassLoader().getResource(resource);
        File file = new File(url.getFile());
        if (!file.exists()) {
            log.warn("\u6587\u4ef6[" + resource + "]\u672a\u627e\u5230");
            return null;
        }
        return file;
    }

    public static InputStream getInputStreamByClassPath(String resource) {
        return FileUtil.class.getClassLoader().getResourceAsStream(resource);
    }

    public static File downloadFromUrl(String fileUrl) {
        String tmpdir = System.getProperty("java.io.tmpdir");
        try {
            int count;
            URL url = new URL(fileUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(3000);
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            InputStream inputStream = conn.getInputStream();
            int i = fileUrl.lastIndexOf("/");
            String fileName = i == fileUrl.length() - 1 ? System.currentTimeMillis() + "" : fileUrl.substring(i + 1);
            File tmpFile = new File(tmpdir + File.separator + fileName);
            FileOutputStream fos = new FileOutputStream(tmpFile);
            byte[] bytes = new byte[1024];
            while ((count = inputStream.read(bytes)) != -1) {
                fos.write(bytes, 0, count);
            }
            fos.flush();
            if (fos != null) {
                fos.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            return tmpFile;
        }
        catch (IOException e) {
            log.debug("\u4e0b\u8f7d\u6587\u4ef6[" + fileUrl + "]\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static String formetFileSize(Long fileSize) {
        if (fileSize == null || fileSize < 0L) {
            return "";
        }
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        fileSizeString = fileSize < 1024L ? df.format((double)fileSize.longValue()) + "B" : (fileSize < 0x100000L ? df.format((double)fileSize.longValue() / 1024.0) + "K" : (fileSize < 0x40000000L ? df.format((double)fileSize.longValue() / 1048576.0) + "M" : df.format((double)fileSize.longValue() / 1.073741824E9) + "G"));
        return fileSizeString;
    }

    public static String getExtendName(String fileName) {
        int l = fileName.lastIndexOf(".");
        if (l == -1) {
            return "";
        }
        return fileName.substring(l + 1, fileName.length());
    }
}

