/*
 * Decompiled with CFR 0.152.
 */
package com.mengweifeng.util;

import com.mengweifeng.util.Timer;
import com.mengweifeng.util.TimerFuture;
import com.mengweifeng.util.TimerTask;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashWheelTimer
implements Timer {
    private static final Logger log = LoggerFactory.getLogger(HashWheelTimer.class);
    private static final AtomicInteger TIMER_ID = new AtomicInteger();
    private static final int MAX_LOCK_SIZE = 16;
    private int id = TIMER_ID.getAndIncrement();
    private Set<HashWheelTimerFuture>[] hashWheels;
    private Lock[] wheelLocks;
    private int lockPointerMask;
    private LinkedBlockingQueue<TimerTask> taskQueue;
    private ExecutorService es;
    private volatile int wheelPointer;
    private int wheelPointerMask;
    private long startTime;
    private int tick;
    private int round;
    private Thread timerThread;
    private Thread execThread;
    private volatile boolean stoped;

    public HashWheelTimer() {
        this(true);
    }

    public HashWheelTimer(boolean daemon) {
        this(daemon, 20);
    }

    public HashWheelTimer(boolean daemon, int tick) {
        this(daemon, tick, 1024);
    }

    public HashWheelTimer(final boolean daemon, int tick, int ticksPerWheel) {
        int normalizedTicksPerWheel = HashWheelTimer.normalizeTicksPerWheel(ticksPerWheel);
        this.tick = tick;
        this.round = tick * normalizedTicksPerWheel;
        this.wheelPointerMask = normalizedTicksPerWheel - 1;
        this.es = Executors.newCachedThreadPool(new ThreadFactory(){
            private AtomicInteger threadId = new AtomicInteger();

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "TimerIndependentExecThread-" + this.threadId.getAndIncrement());
                t.setDaemon(daemon);
                return t;
            }
        });
        this.taskQueue = new LinkedBlockingQueue();
        this.initTaskThread(daemon);
        this.hashWheels = new HashSet[normalizedTicksPerWheel];
        for (int i = 0; i < normalizedTicksPerWheel; ++i) {
            this.hashWheels[i] = new HashSet<HashWheelTimerFuture>();
        }
        int lockSize = normalizedTicksPerWheel > 16 ? 16 : normalizedTicksPerWheel;
        this.lockPointerMask = lockSize - 1;
        this.wheelLocks = new ReentrantLock[lockSize];
        for (int i = 0; i < lockSize; ++i) {
            this.wheelLocks[i] = new ReentrantLock();
        }
        this.initTimerThread(daemon);
    }

    private void initTaskThread(boolean daemon) {
        this.execThread = new Thread("TaskThread[" + this.id + "]"){

            public void run() {
                block4: while (true) {
                    try {
                        while (!Thread.interrupted()) {
                            TimerTask task = (TimerTask)HashWheelTimer.this.taskQueue.take();
                            try {
                                task.run();
                                continue block4;
                            }
                            catch (Throwable e) {
                                log.error("\u6267\u884c\u8ba1\u65f6\u4efb\u52a1\u53d1\u751f\u9519\u8bef", e);
                            }
                        }
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                        break;
                    }
                }
            }
        };
        this.execThread.setDaemon(daemon);
    }

    private void initTimerThread(boolean daemon) {
        this.timerThread = new Thread("TimerThread[" + this.id + "]"){
            long tickedTime;
            {
                this.tickedTime = 0L;
            }

            public void run() {
                HashWheelTimer.this.startTime = System.currentTimeMillis();
                try {
                    while (!Thread.interrupted()) {
                        this.notifyExpiredTasks(this.tick());
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }

            private long tick() throws InterruptedException {
                this.tickedTime += (long)HashWheelTimer.this.tick;
                long nextTickTime = HashWheelTimer.this.startTime + this.tickedTime;
                long sleepMills = nextTickTime - System.currentTimeMillis();
                while (sleepMills > 0L) {
                    Thread.sleep(sleepMills);
                    sleepMills = nextTickTime - System.currentTimeMillis();
                }
                return nextTickTime;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void notifyExpiredTasks(long now) {
                HashWheelTimer.this.wheelPointer = HashWheelTimer.this.wheelPointer + 1 & HashWheelTimer.this.wheelPointerMask;
                Set wheel = HashWheelTimer.this.hashWheels[HashWheelTimer.this.wheelPointer];
                int lockIndex = HashWheelTimer.this.wheelPointer & HashWheelTimer.this.lockPointerMask;
                try {
                    HashWheelTimer.this.wheelLocks[lockIndex].lock();
                    Iterator it = wheel.iterator();
                    while (it.hasNext()) {
                        HashWheelTimerFuture future = (HashWheelTimerFuture)it.next();
                        if (future.cancelled) {
                            it.remove();
                            continue;
                        }
                        if (future.remainingRounds > 0L) {
                            future.remainingRounds--;
                            continue;
                        }
                        it.remove();
                        if (future.deadline <= now) {
                            TimerTask task = future.task;
                            if (task.isTriggerIndependently()) {
                                HashWheelTimer.this.es.submit(task);
                            } else {
                                HashWheelTimer.this.taskQueue.offer(task);
                            }
                            if (task.type() != TimerTask.Type.INTERVAL) continue;
                            HashWheelTimer.this.scheduleTimerFuture(future);
                            continue;
                        }
                        int index = HashWheelTimer.this.wheelPointer + 1 & HashWheelTimer.this.wheelPointerMask;
                        int lIndex = index & HashWheelTimer.this.lockPointerMask;
                        HashWheelTimer.this.wheelLocks[lIndex].lock();
                        HashWheelTimer.this.hashWheels[index].add(future);
                        HashWheelTimer.this.wheelLocks[lIndex].unlock();
                    }
                }
                finally {
                    HashWheelTimer.this.wheelLocks[lockIndex].unlock();
                }
            }
        };
        this.timerThread.setDaemon(daemon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTimerFuture(HashWheelTimerFuture future) {
        if (!this.execThread.isAlive()) {
            this.execThread.start();
        }
        if (!this.timerThread.isAlive()) {
            this.timerThread.start();
        }
        long delay = future.task.delayOrIntervalMillis() < (long)this.tick ? (long)this.tick : future.task.delayOrIntervalMillis();
        future.deadline = System.currentTimeMillis() + delay;
        future.remainingRounds = delay / (long)this.round - (long)(delay % (long)this.round == 0L ? 1 : 0);
        long lastRoundDelay = delay % (long)this.round;
        long lastTickDelay = lastRoundDelay % (long)this.tick;
        int rIndex = (int)lastRoundDelay / this.tick + (lastTickDelay != 0L ? 1 : 0);
        int pointer = this.wheelPointer + rIndex & this.wheelPointerMask;
        int lockIndex = pointer & this.lockPointerMask;
        try {
            this.wheelLocks[lockIndex].lock();
            this.hashWheels[pointer].add(future);
        }
        finally {
            this.wheelLocks[lockIndex].unlock();
        }
    }

    public void startup() {
        if (this.stoped) {
            throw new IllegalStateException("\u8ba1\u65f6\u5668\u505c\u6b62\u540e\u4e0d\u80fd\u518d\u542f\u52a8");
        }
        if (!this.execThread.isAlive()) {
            this.execThread.start();
        }
        if (!this.timerThread.isAlive()) {
            this.timerThread.start();
        }
    }

    public void shutdown() {
        if (this.stoped) {
            return;
        }
        this.stoped = true;
        this.timerThread.interrupt();
        this.execThread.interrupt();
        this.es.shutdown();
        try {
            this.es.awaitTermination(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public TimerFuture timing(TimerTask task) {
        if (this.stoped) {
            throw new IllegalStateException("\u8ba1\u65f6\u5668\u5df2\u505c\u6b62");
        }
        HashWheelTimerFuture future = new HashWheelTimerFuture(task);
        this.scheduleTimerFuture(future);
        return future;
    }

    private static int normalizeTicksPerWheel(int ticksPerWheel) {
        int nTicks = 1;
        nTicks <<= 1;
        while (nTicks < ticksPerWheel) {
            nTicks <<= 1;
        }
        return nTicks;
    }

    private final class HashWheelTimerFuture
    implements TimerFuture {
        private TimerTask task;
        private long deadline;
        private volatile long remainingRounds;
        private volatile boolean cancelled;

        private HashWheelTimerFuture(TimerTask task) {
            this.task = task;
        }

        public void cancel() {
            if (this.cancelled || this.isExpired()) {
                return;
            }
            this.cancelled = true;
        }

        public TimerTask getTimerTask() {
            return this.task;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public boolean isExpired() {
            if (this.task.type() == TimerTask.Type.INTERVAL) {
                return this.cancelled;
            }
            return this.cancelled || System.currentTimeMillis() >= this.deadline;
        }
    }
}

