/*
 * Decompiled with CFR 0.152.
 */
package com.mengweifeng.util;

import com.mengweifeng.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final Map<String, String> CONTENTTYPES = new HashMap<String, String>();
    private static final String DEFAULT_CONTENTTYPE = "text/html;charset=UTF-8";

    public static void downloadFile(HttpServletRequest request, HttpServletResponse response, String fileName, File downLoadFile) throws FileNotFoundException {
        FileInputStream is = new FileInputStream(downLoadFile);
        HttpUtil.downloadFile(request, response, fileName, is);
    }

    public static void downloadFile(HttpServletRequest request, HttpServletResponse response, String fileName, String downLoadPath) throws FileNotFoundException {
        FileInputStream is = new FileInputStream(downLoadPath);
        HttpUtil.downloadFile(request, response, fileName, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(HttpServletRequest request, HttpServletResponse response, String fileName, InputStream is) {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int bytesRead;
            String contentType = HttpUtil.getContentType(fileName);
            String userAgent = request.getHeader("User-Agent");
            userAgent = userAgent.toLowerCase();
            boolean isIe = false;
            if (userAgent.contains("msie") || userAgent.contains("rv:11")) {
                isIe = true;
            }
            fileName = isIe ? URLEncoder.encode(fileName, "utf-8") : new String(fileName.getBytes("utf-8"), "iso8859-1");
            response.setContentType(contentType);
            response.setHeader("Content-disposition", "attachment; filename=" + fileName);
            bis = new BufferedInputStream(is);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
            }
            ((BufferedOutputStream)bos).flush();
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u8bbe\u7f6e\u7f16\u7801\u65f6\u9519\u8bef", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u672a\u627e\u5230", (Throwable)e);
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u65f6\u9519\u8bef", (Throwable)e);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                log.error("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u51fa\u9519", (Throwable)e);
            }
        }
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Real-IP");
        if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip)) {
            return ip;
        }
        ip = request.getHeader("X-Forwarded-For");
        if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip)) {
            int index = ip.indexOf(44);
            if (index != -1) {
                return ip.substring(0, index);
            }
            return ip;
        }
        return request.getRemoteAddr();
    }

    private static String getContentType(String fileName) {
        String extendName = FileUtil.getExtendName(fileName).toLowerCase();
        String contentType = CONTENTTYPES.get(extendName);
        if (contentType == null) {
            contentType = DEFAULT_CONTENTTYPE;
        }
        return contentType;
    }

    public static void setCookie(HttpServletResponse response, String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        if (maxAge > 0) {
            cookie.setMaxAge(maxAge);
        }
        response.addCookie(cookie);
    }

    public static Cookie getCookieByName(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static Map<String, Cookie> getCookieMap(HttpServletRequest request) {
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie);
            }
        }
        return cookieMap;
    }

    static {
        CONTENTTYPES.put("html", DEFAULT_CONTENTTYPE);
        CONTENTTYPES.put("xls", "application/x-msdownload;charset=UTF-8");
        CONTENTTYPES.put("xlsx", "application/x-msdownload;charset=UTF-8");
        CONTENTTYPES.put("csv", "application/csv;charset=UTF-8");
    }
}

