/*
 * Decompiled with CFR 0.152.
 */
package com.merakianalytics.orianna.datastores.mongo;

import com.merakianalytics.datapipelines.iterators.CloseableIterator;
import com.merakianalytics.orianna.types.common.OriannaException;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.client.MongoIterable;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindResultIterator<T>
implements CloseableIterator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FindResultIterator.class);
    private final long count;
    private final AsyncBatchCursor<T> cursor;
    private boolean empty = false;
    private final BlockingQueue<T> queue = new LinkedBlockingQueue<T>();

    public FindResultIterator(MongoIterable<T> result, long count) {
        CompletableFuture future = new CompletableFuture();
        result.batchCursor((cursor, exception) -> {
            if (exception != null) {
                future.completeExceptionally(exception);
            } else {
                future.complete(cursor);
            }
        });
        try {
            this.cursor = (AsyncBatchCursor)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Error on MongoDB query!", (Throwable)e);
            throw new OriannaException("Error on MongoDB query!", (Throwable)e);
        }
        this.count = count;
    }

    public void close() {
        this.cursor.close();
        this.queue.clear();
    }

    public long getCount() {
        return this.count;
    }

    public boolean hasNext() {
        if (this.empty) {
            return false;
        }
        if (!this.queue.isEmpty()) {
            return true;
        }
        CompletableFuture future = new CompletableFuture();
        this.cursor.next((results, exception) -> {
            if (exception != null) {
                future.completeExceptionally(exception);
            } else {
                future.complete(results);
            }
        });
        try {
            List results2 = (List)future.get();
            if (results2 == null || results2.isEmpty()) {
                this.empty = true;
                this.close();
                return false;
            }
            for (Object result : results2) {
                this.queue.add(result);
            }
            return true;
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Error on MongoDB query!", (Throwable)e);
            throw new OriannaException("Error on MongoDB query!", (Throwable)e);
        }
    }

    public T next() {
        if (!this.hasNext()) {
            return null;
        }
        return (T)this.queue.poll();
    }
}

