/*
 * Decompiled with CFR 0.152.
 */
package com.merakianalytics.orianna.datastores.mongo;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.merakianalytics.datapipelines.AbstractDataStore;
import com.merakianalytics.orianna.datastores.mongo.FindResultIterator;
import com.merakianalytics.orianna.types.common.OriannaException;
import com.mongodb.MongoCompressor;
import com.mongodb.MongoCredential;
import com.mongodb.ReadConcern;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.async.client.AggregateIterable;
import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.async.client.MongoClients;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.MongoDatabase;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Field;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNumber;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.AddOriannaIndexFields;
import org.bson.codecs.pojo.Convention;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MongoDBDataStore
extends AbstractDataStore
implements AutoCloseable {
    private static final BulkWriteOptions BULK_WRITE_OPTIONS = new BulkWriteOptions().ordered(false);
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDBDataStore.class);
    private static final UpdateOptions UPDATE_OPTIONS = new UpdateOptions().upsert(true);
    private final Map<Class<?>, String> collectionNames = new ConcurrentHashMap();
    private final MongoDatabase db;
    private final MongoClient mongo;

    protected static Number fromBson(BsonNumber number) {
        if (number instanceof BsonInt32) {
            return number.intValue();
        }
        if (number instanceof BsonInt64) {
            return number.longValue();
        }
        return number.doubleValue();
    }

    private static MongoClientSettings fromConfiguration(Configuration config) {
        Object conf;
        MongoClientSettings.Builder builder = MongoClientSettings.builder();
        CodecRegistry registry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClients.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{PojoCodecProvider.builder().automatic(true).conventions((List)Lists.newArrayList((Object[])new Convention[]{new AddOriannaIndexFields()})).build()})});
        builder.codecRegistry(registry);
        if (config.getCompressor() != null) {
            switch (config.getCompressor()) {
                case SNAPPY: {
                    builder.compressorList((List)ImmutableList.of((Object)MongoCompressor.createSnappyCompressor()));
                    break;
                }
                case ZLIB: {
                    builder.compressorList((List)ImmutableList.of((Object)MongoCompressor.createZlibCompressor()));
                    break;
                }
            }
        }
        builder.clusterSettings(ClusterSettings.builder().hosts((List)Lists.newArrayList((Object[])new ServerAddress[]{new ServerAddress(config.getHost(), config.getPort().intValue())})).mode(ClusterConnectionMode.SINGLE).build());
        if (config.getConnectionPool() != null) {
            conf = config.getConnectionPool();
            ConnectionPoolSettings.Builder connectionPool = ConnectionPoolSettings.builder();
            if (((Configuration.ConnectionPoolConfiguration)conf).getMaintenanceFrequency() != null) {
                connectionPool.maintenanceFrequency(((Configuration.ConnectionPoolConfiguration)conf).getMaintenanceFrequency().longValue(), ((Configuration.ConnectionPoolConfiguration)conf).getMaintenanceFrequencyUnit() == null ? TimeUnit.MILLISECONDS : ((Configuration.ConnectionPoolConfiguration)conf).getMaintenanceFrequencyUnit());
            }
            if (((Configuration.ConnectionPoolConfiguration)conf).getMaintenanceInitialDelay() != null) {
                connectionPool.maintenanceInitialDelay(((Configuration.ConnectionPoolConfiguration)conf).getMaintenanceInitialDelay().longValue(), ((Configuration.ConnectionPoolConfiguration)conf).getMaintenanceInitialDelayUnit() == null ? TimeUnit.MILLISECONDS : ((Configuration.ConnectionPoolConfiguration)conf).getMaintenanceInitialDelayUnit());
            }
            if (((Configuration.ConnectionPoolConfiguration)conf).getMaxConnectionIdleTime() != null) {
                connectionPool.maxConnectionIdleTime(((Configuration.ConnectionPoolConfiguration)conf).getMaxConnectionIdleTime().longValue(), ((Configuration.ConnectionPoolConfiguration)conf).getMaxConnectionIdleTimeUnit() == null ? TimeUnit.MILLISECONDS : ((Configuration.ConnectionPoolConfiguration)conf).getMaxConnectionIdleTimeUnit());
            }
            if (((Configuration.ConnectionPoolConfiguration)conf).getMaxConnectionLifeTime() != null) {
                connectionPool.maxConnectionLifeTime(((Configuration.ConnectionPoolConfiguration)conf).getMaxConnectionLifeTime().longValue(), ((Configuration.ConnectionPoolConfiguration)conf).getMaxConnectionLifeTimeUnit() == null ? TimeUnit.MILLISECONDS : ((Configuration.ConnectionPoolConfiguration)conf).getMaxConnectionLifeTimeUnit());
            }
            if (((Configuration.ConnectionPoolConfiguration)conf).getMaxSize() != null) {
                connectionPool.maxSize(((Configuration.ConnectionPoolConfiguration)conf).getMaxSize().intValue());
            }
            if (((Configuration.ConnectionPoolConfiguration)conf).getMaxWaitQueueSize() != null) {
                connectionPool.maxWaitQueueSize(((Configuration.ConnectionPoolConfiguration)conf).getMaxWaitQueueSize().intValue());
            }
            if (((Configuration.ConnectionPoolConfiguration)conf).getMaxWaitTime() != null) {
                connectionPool.maxWaitTime(((Configuration.ConnectionPoolConfiguration)conf).getMaxWaitTime().longValue(), ((Configuration.ConnectionPoolConfiguration)conf).getMaxWaitTimeUnit() == null ? TimeUnit.MILLISECONDS : ((Configuration.ConnectionPoolConfiguration)conf).getMaxWaitTimeUnit());
            }
            if (((Configuration.ConnectionPoolConfiguration)conf).getMinSize() != null) {
                connectionPool.minSize(((Configuration.ConnectionPoolConfiguration)conf).getMinSize().intValue());
            }
            builder.connectionPoolSettings(connectionPool.build());
        }
        if (config.getPassword() != null) {
            builder.credential(MongoCredential.createCredential((String)config.getUserName(), (String)(config.getAuthenticationDatabase() != null ? config.getAuthenticationDatabase() : config.getDatabase()), (char[])config.getPassword().toCharArray()));
        }
        if (config.getHeartbeatSocket() != null) {
            conf = config.getHeartbeatSocket();
            SocketSettings.Builder heartbeatSocket = SocketSettings.builder();
            if (((Configuration.SocketConfiguration)conf).getConnectTimeout() != null) {
                heartbeatSocket.connectTimeout(((Configuration.SocketConfiguration)conf).getConnectTimeout().intValue(), ((Configuration.SocketConfiguration)conf).getConnectTimeoutUnit() == null ? TimeUnit.MILLISECONDS : ((Configuration.SocketConfiguration)conf).getConnectTimeoutUnit());
            }
            if (((Configuration.SocketConfiguration)conf).getReadTimeout() != null) {
                heartbeatSocket.readTimeout(((Configuration.SocketConfiguration)conf).getReadTimeout().intValue(), ((Configuration.SocketConfiguration)conf).getReadTimeoutUnit() == null ? TimeUnit.MILLISECONDS : ((Configuration.SocketConfiguration)conf).getReadTimeoutUnit());
            }
            if (((Configuration.SocketConfiguration)conf).getReceiveBufferSize() != null) {
                heartbeatSocket.receiveBufferSize(((Configuration.SocketConfiguration)conf).getReceiveBufferSize().intValue());
            }
            if (((Configuration.SocketConfiguration)conf).getSendBufferSize() != null) {
                heartbeatSocket.sendBufferSize(((Configuration.SocketConfiguration)conf).getSendBufferSize().intValue());
            }
            builder.heartbeatSocketSettings(heartbeatSocket.build());
        }
        if (config.getReadConcern() != null) {
            builder.readConcern(config.getReadConcern());
        }
        if (config.getRetryWrites() != null) {
            builder.retryWrites(config.getRetryWrites().booleanValue());
        }
        if (config.getServer() != null) {
            conf = config.getServer();
            ServerSettings.Builder server = ServerSettings.builder();
            if (((Configuration.ServerConfiguration)conf).getHeartbeatFrequency() != null) {
                server.heartbeatFrequency(((Configuration.ServerConfiguration)conf).getHeartbeatFrequency().longValue(), ((Configuration.ServerConfiguration)conf).getHeartbeatFrequencyUnit() == null ? TimeUnit.MILLISECONDS : ((Configuration.ServerConfiguration)conf).getHeartbeatFrequencyUnit());
            }
            if (((Configuration.ServerConfiguration)conf).getMinHeartbeatFrequency() != null) {
                server.minHeartbeatFrequency(((Configuration.ServerConfiguration)conf).getMinHeartbeatFrequency().longValue(), ((Configuration.ServerConfiguration)conf).getMinHeartbeatFrequencyUnit() == null ? TimeUnit.MILLISECONDS : ((Configuration.ServerConfiguration)conf).getMinHeartbeatFrequencyUnit());
            }
            builder.serverSettings(server.build());
        }
        if (config.getSocket() != null) {
            conf = config.getSocket();
            SocketSettings.Builder socket = SocketSettings.builder();
            if (((Configuration.SocketConfiguration)conf).getConnectTimeout() != null) {
                socket.connectTimeout(((Configuration.SocketConfiguration)conf).getConnectTimeout().intValue(), ((Configuration.SocketConfiguration)conf).getConnectTimeoutUnit() == null ? TimeUnit.MILLISECONDS : ((Configuration.SocketConfiguration)conf).getConnectTimeoutUnit());
            }
            if (((Configuration.SocketConfiguration)conf).getReadTimeout() != null) {
                socket.readTimeout(((Configuration.SocketConfiguration)conf).getReadTimeout().intValue(), ((Configuration.SocketConfiguration)conf).getReadTimeoutUnit() == null ? TimeUnit.MILLISECONDS : ((Configuration.SocketConfiguration)conf).getReadTimeoutUnit());
            }
            if (((Configuration.SocketConfiguration)conf).getReceiveBufferSize() != null) {
                socket.receiveBufferSize(((Configuration.SocketConfiguration)conf).getReceiveBufferSize().intValue());
            }
            if (((Configuration.SocketConfiguration)conf).getSendBufferSize() != null) {
                socket.sendBufferSize(((Configuration.SocketConfiguration)conf).getSendBufferSize().intValue());
            }
            builder.socketSettings(socket.build());
        }
        if (config.getSsl() != null) {
            conf = config.getSsl();
            SslSettings.Builder ssl = SslSettings.builder();
            if (((Configuration.SSLConfiguration)conf).getEnabled() != null) {
                ssl.enabled(((Configuration.SSLConfiguration)conf).getEnabled().booleanValue());
            }
            if (((Configuration.SSLConfiguration)conf).getInvalidHostNameallowed() != null) {
                ssl.invalidHostNameAllowed(((Configuration.SSLConfiguration)conf).getInvalidHostNameallowed().booleanValue());
            }
            builder.sslSettings(ssl.build());
        }
        if (config.getWriteConcern() != null) {
            builder.writeConcern(config.getWriteConcern());
        }
        return builder.build();
    }

    protected static BsonNumber toBson(Number number) {
        if (number instanceof Integer) {
            return new BsonInt32(number.intValue());
        }
        if (number instanceof Long) {
            return new BsonInt64(number.longValue());
        }
        return new BsonDouble(number.doubleValue());
    }

    public MongoDBDataStore(Configuration config) {
        this.mongo = MongoClients.create((MongoClientSettings)MongoDBDataStore.fromConfiguration(config));
        this.db = this.mongo.getDatabase(config.getDatabase());
    }

    @Override
    public void close() {
        this.mongo.close();
    }

    protected <T> FindResultIterator<T> find(Class<T> clazz) {
        return this.find(clazz, (Bson)null);
    }

    protected <T> FindResultIterator<T> find(Class<T> clazz, Bson filter) {
        MongoCollection collection = this.getCollection(clazz);
        CompletableFuture future = new CompletableFuture();
        collection.count((count, exception) -> {
            if (exception != null) {
                future.completeExceptionally(exception);
            } else if (0L == count) {
                future.complete(null);
            } else {
                future.complete(new FindResultIterator(filter == null ? collection.find() : collection.find(filter), (long)count));
            }
        });
        try {
            return (FindResultIterator)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Error on MongoDB query!", (Throwable)e);
            throw new OriannaException("Error on MongoDB query!", (Throwable)e);
        }
    }

    protected <T> FindResultIterator<T> find(Class<T> clazz, FindQuery find) {
        MongoCollection collection = this.getCollection(clazz);
        if (find == null) {
            return this.find(clazz, (Bson)null);
        }
        CompletableFuture future = new CompletableFuture();
        collection.count(find.getFilter(), (count, exception) -> {
            if (exception != null) {
                future.completeExceptionally(exception);
            } else if ((long)find.getOrder().size() > count) {
                future.complete(null);
            } else {
                AggregateIterable result = collection.aggregate((List)Lists.newArrayList((Object[])new Bson[]{Aggregates.match((Bson)find.getFilter()), Aggregates.addFields((Field[])new Field[]{new Field("__order", (Object)new BsonDocument("$indexOfArray", (BsonValue)new BsonArray((List)Lists.newArrayList((Object[])new BsonValue[]{new BsonArray(find.getOrder()), new BsonString("$" + find.getOrderingField())}))))}), Aggregates.sort((Bson)Sorts.ascending((String[])new String[]{"__order"}))}));
                future.complete(new FindResultIterator(result, (long)count));
            }
        });
        try {
            return (FindResultIterator)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Error on MongoDB query!", (Throwable)e);
            throw new OriannaException("Error on MongoDB query!", (Throwable)e);
        }
    }

    protected <T> T findFirst(Class<T> clazz) {
        return this.findFirst(clazz, null);
    }

    protected <T> T findFirst(Class<T> clazz, Bson filter) {
        MongoCollection<T> collection = this.getCollection(clazz);
        FindIterable find = filter == null ? collection.find() : collection.find(filter);
        CompletableFuture future = new CompletableFuture();
        find.first((result, exception) -> {
            if (exception != null) {
                future.completeExceptionally(exception);
            } else {
                future.complete(result);
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Error on MongoDB query!", (Throwable)e);
            throw new OriannaException("Error on MongoDB query!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> MongoCollection<T> getCollection(Class<T> clazz) {
        String name = this.collectionNames.get(clazz);
        if (name == null) {
            Map<Class<?>, String> map = this.collectionNames;
            synchronized (map) {
                name = this.collectionNames.get(clazz);
                if (name == null) {
                    String[] parts = clazz.getCanonicalName().split("\\.");
                    name = parts[parts.length - 3] + "." + parts[parts.length - 2] + "." + parts[parts.length - 1];
                    this.collectionNames.put(clazz, name);
                }
            }
        }
        return this.db.getCollection(name, clazz);
    }

    protected List<BsonNumber> numbersToBson(Iterable<Number> numbers) {
        return StreamSupport.stream(numbers.spliterator(), false).map(MongoDBDataStore::toBson).collect(Collectors.toList());
    }

    protected List<BsonString> stringsToBson(Iterable<String> strings) {
        return StreamSupport.stream(strings.spliterator(), false).map(string -> new BsonString(string)).collect(Collectors.toList());
    }

    protected <T> void upsert(Class<T> clazz, Iterable<T> objects, Function<T, Bson> filter) {
        List writes = StreamSupport.stream(objects.spliterator(), false).map(object -> new ReplaceOneModel((Bson)filter.apply(object), object, UPDATE_OPTIONS)).collect(Collectors.toList());
        MongoCollection<T> collection = this.getCollection(clazz);
        collection.bulkWrite(writes, BULK_WRITE_OPTIONS, (result, exception) -> {
            if (exception != null) {
                LOGGER.error("Error bulk upserting to MongoDB!", exception);
                throw new OriannaException("Error bulk upserting to MongoDB!", exception);
            }
        });
    }

    protected <T> void upsert(Class<T> clazz, T object, Bson filter) {
        MongoCollection<T> collection = this.getCollection(clazz);
        collection.replaceOne(filter, object, UPDATE_OPTIONS, (result, exception) -> {
            if (exception != null) {
                LOGGER.error("Error upserting to MongoDB!", exception);
                throw new OriannaException("Error upserting to MongoDB!", exception);
            }
        });
    }

    protected static class FindQuery {
        private Bson filter;
        private List<? extends BsonValue> order;
        private String orderingField;

        public static Builder builder() {
            return new Builder();
        }

        private FindQuery() {
        }

        public Bson getFilter() {
            return this.filter;
        }

        public List<? extends BsonValue> getOrder() {
            return this.order;
        }

        public String getOrderingField() {
            return this.orderingField;
        }

        public static class Builder {
            private Bson filter;
            private List<? extends BsonValue> order;
            private String orderingField;

            private Builder() {
            }

            public FindQuery build() {
                if (this.filter == null || this.order == null || this.orderingField == null) {
                    throw new IllegalStateException("Must set filter, order, and orderingField!");
                }
                FindQuery query = new FindQuery();
                query.filter = this.filter;
                query.order = this.order;
                query.orderingField = this.orderingField;
                return query;
            }

            public Builder filter(Bson filter) {
                this.filter = filter;
                return this;
            }

            public Builder order(List<? extends BsonValue> order) {
                this.order = order;
                return this;
            }

            public Builder orderingField(String orderingField) {
                this.orderingField = orderingField;
                return this;
            }
        }
    }

    public static class Configuration {
        private Compressor compressor;
        private ConnectionPoolConfiguration connectionPool;
        private String database = "orianna";
        private HeartbeatConfiguration heartbeat;
        private String host = "localhost";
        private Integer port = 27017;
        private ReadConcern readConcern;
        private Boolean retryWrites;
        private ServerConfiguration server;
        private SocketConfiguration socket;
        private SocketConfiguration heartbeatSocket;
        private SSLConfiguration ssl;
        private String userName;
        private String password;
        private String authenticationDatabase;
        private WriteConcern writeConcern;

        public String getAuthenticationDatabase() {
            return this.authenticationDatabase;
        }

        public Compressor getCompressor() {
            return this.compressor;
        }

        public ConnectionPoolConfiguration getConnectionPool() {
            return this.connectionPool;
        }

        public String getDatabase() {
            return this.database;
        }

        public HeartbeatConfiguration getHeartbeat() {
            return this.heartbeat;
        }

        public SocketConfiguration getHeartbeatSocket() {
            return this.heartbeatSocket;
        }

        public String getHost() {
            return this.host;
        }

        public String getPassword() {
            return this.password;
        }

        public Integer getPort() {
            return this.port;
        }

        public ReadConcern getReadConcern() {
            return this.readConcern;
        }

        public Boolean getRetryWrites() {
            return this.retryWrites;
        }

        public ServerConfiguration getServer() {
            return this.server;
        }

        public SocketConfiguration getSocket() {
            return this.socket;
        }

        public SSLConfiguration getSsl() {
            return this.ssl;
        }

        public String getUserName() {
            return this.userName;
        }

        public WriteConcern getWriteConcern() {
            return this.writeConcern;
        }

        public void setAuthenticationDatabase(String authenticationDatabase) {
            this.authenticationDatabase = authenticationDatabase;
        }

        public void setCompressor(Compressor compressor) {
            this.compressor = compressor;
        }

        public void setConnectionPool(ConnectionPoolConfiguration connectionPool) {
            this.connectionPool = connectionPool;
        }

        public void setDatabase(String database) {
            this.database = database;
        }

        public void setHeartbeat(HeartbeatConfiguration heartbeat) {
            this.heartbeat = heartbeat;
        }

        public void setHeartbeatSocket(SocketConfiguration heartbeatSocket) {
            this.heartbeatSocket = heartbeatSocket;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public void setReadConcern(ReadConcern readConcern) {
            this.readConcern = readConcern;
        }

        public void setRetryWrites(Boolean retryWrites) {
            this.retryWrites = retryWrites;
        }

        public void setServer(ServerConfiguration server) {
            this.server = server;
        }

        public void setSocket(SocketConfiguration socket) {
            this.socket = socket;
        }

        public void setSsl(SSLConfiguration ssl) {
            this.ssl = ssl;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setWriteConcern(WriteConcern writeConcern) {
            this.writeConcern = writeConcern;
        }

        public static class SSLConfiguration {
            private Boolean enabled;
            private Boolean invalidHostNameallowed;

            public Boolean getEnabled() {
                return this.enabled;
            }

            public Boolean getInvalidHostNameallowed() {
                return this.invalidHostNameallowed;
            }

            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            public void setInvalidHostNameallowed(Boolean invalidHostNameallowed) {
                this.invalidHostNameallowed = invalidHostNameallowed;
            }
        }

        public static class SocketConfiguration {
            private Integer connectTimeout;
            private Integer readTimeout;
            private Integer receiveBufferSize;
            private Integer sendBufferSize;
            private TimeUnit connectTimeoutUnit;
            private TimeUnit readTimeoutUnit;

            public Integer getConnectTimeout() {
                return this.connectTimeout;
            }

            public TimeUnit getConnectTimeoutUnit() {
                return this.connectTimeoutUnit;
            }

            public Integer getReadTimeout() {
                return this.readTimeout;
            }

            public TimeUnit getReadTimeoutUnit() {
                return this.readTimeoutUnit;
            }

            public Integer getReceiveBufferSize() {
                return this.receiveBufferSize;
            }

            public Integer getSendBufferSize() {
                return this.sendBufferSize;
            }

            public void setConnectTimeout(Integer connectTimeout) {
                this.connectTimeout = connectTimeout;
            }

            public void setConnectTimeoutUnit(TimeUnit connectTimeoutUnit) {
                this.connectTimeoutUnit = connectTimeoutUnit;
            }

            public void setReadTimeout(Integer readTimeout) {
                this.readTimeout = readTimeout;
            }

            public void setReadTimeoutUnit(TimeUnit readTimeoutUnit) {
                this.readTimeoutUnit = readTimeoutUnit;
            }

            public void setReceiveBufferSize(Integer receiveBufferSize) {
                this.receiveBufferSize = receiveBufferSize;
            }

            public void setSendBufferSize(Integer sendBufferSize) {
                this.sendBufferSize = sendBufferSize;
            }
        }

        public static class ServerConfiguration {
            private Long heartbeatFrequency;
            private Long minHeartbeatFrequency;
            private TimeUnit heartbeatFrequencyUnit;
            private TimeUnit minHeartbeatFrequencyUnit;

            public Long getHeartbeatFrequency() {
                return this.heartbeatFrequency;
            }

            public TimeUnit getHeartbeatFrequencyUnit() {
                return this.heartbeatFrequencyUnit;
            }

            public Long getMinHeartbeatFrequency() {
                return this.minHeartbeatFrequency;
            }

            public TimeUnit getMinHeartbeatFrequencyUnit() {
                return this.minHeartbeatFrequencyUnit;
            }

            public void setHeartbeatFrequency(Long heartbeatFrequency) {
                this.heartbeatFrequency = heartbeatFrequency;
            }

            public void setHeartbeatFrequencyUnit(TimeUnit heartbeatFrequencyUnit) {
                this.heartbeatFrequencyUnit = heartbeatFrequencyUnit;
            }

            public void setMinHeartbeatFrequency(Long minHeartbeatFrequency) {
                this.minHeartbeatFrequency = minHeartbeatFrequency;
            }

            public void setMinHeartbeatFrequencyUnit(TimeUnit minHeartbeatFrequencyUnit) {
                this.minHeartbeatFrequencyUnit = minHeartbeatFrequencyUnit;
            }
        }

        public static class HeartbeatConfiguration {
            private Long heartbeatFrequency;
            private Long minHeartbeatFrequency;
            private TimeUnit heartbeatFrequencyUnit;
            private TimeUnit minHeartbeatFrequencyUnit;

            public Long getHeartbeatFrequency() {
                return this.heartbeatFrequency;
            }

            public TimeUnit getHeartbeatFrequencyUnit() {
                return this.heartbeatFrequencyUnit;
            }

            public Long getMinHeartbeatFrequency() {
                return this.minHeartbeatFrequency;
            }

            public TimeUnit getMinHeartbeatFrequencyUnit() {
                return this.minHeartbeatFrequencyUnit;
            }

            public void setHeartbeatFrequency(Long heartbeatFrequency) {
                this.heartbeatFrequency = heartbeatFrequency;
            }

            public void setHeartbeatFrequencyUnit(TimeUnit heartbeatFrequencyUnit) {
                this.heartbeatFrequencyUnit = heartbeatFrequencyUnit;
            }

            public void setMinHeartbeatFrequency(Long minHeartbeatFrequency) {
                this.minHeartbeatFrequency = minHeartbeatFrequency;
            }

            public void setMinHeartbeatFrequencyUnit(TimeUnit minHeartbeatFrequencyUnit) {
                this.minHeartbeatFrequencyUnit = minHeartbeatFrequencyUnit;
            }
        }

        public static class ConnectionPoolConfiguration {
            private Long maintenanceFrequency;
            private Long maintenanceInitialDelay;
            private Long maxConnectionIdleTime;
            private Long maxConnectionLifeTime;
            private Long maxWaitTime;
            private TimeUnit maintenanceFrequencyUnit;
            private TimeUnit maintenanceInitialDelayUnit;
            private TimeUnit maxConnectionIdleTimeUnit;
            private TimeUnit maxConnectionLifeTimeUnit;
            private TimeUnit maxWaitTimeUnit;
            private Integer maxSize;
            private Integer maxWaitQueueSize;
            private Integer minSize;

            public Long getMaintenanceFrequency() {
                return this.maintenanceFrequency;
            }

            public TimeUnit getMaintenanceFrequencyUnit() {
                return this.maintenanceFrequencyUnit;
            }

            public Long getMaintenanceInitialDelay() {
                return this.maintenanceInitialDelay;
            }

            public TimeUnit getMaintenanceInitialDelayUnit() {
                return this.maintenanceInitialDelayUnit;
            }

            public Long getMaxConnectionIdleTime() {
                return this.maxConnectionIdleTime;
            }

            public TimeUnit getMaxConnectionIdleTimeUnit() {
                return this.maxConnectionIdleTimeUnit;
            }

            public Long getMaxConnectionLifeTime() {
                return this.maxConnectionLifeTime;
            }

            public TimeUnit getMaxConnectionLifeTimeUnit() {
                return this.maxConnectionLifeTimeUnit;
            }

            public Integer getMaxSize() {
                return this.maxSize;
            }

            public Integer getMaxWaitQueueSize() {
                return this.maxWaitQueueSize;
            }

            public Long getMaxWaitTime() {
                return this.maxWaitTime;
            }

            public TimeUnit getMaxWaitTimeUnit() {
                return this.maxWaitTimeUnit;
            }

            public Integer getMinSize() {
                return this.minSize;
            }

            public void setMaintenanceFrequency(Long maintenanceFrequency) {
                this.maintenanceFrequency = maintenanceFrequency;
            }

            public void setMaintenanceFrequencyUnit(TimeUnit maintenanceFrequencyUnit) {
                this.maintenanceFrequencyUnit = maintenanceFrequencyUnit;
            }

            public void setMaintenanceInitialDelay(Long maintenanceInitialDelay) {
                this.maintenanceInitialDelay = maintenanceInitialDelay;
            }

            public void setMaintenanceInitialDelayUnit(TimeUnit maintenanceInitialDelayUnit) {
                this.maintenanceInitialDelayUnit = maintenanceInitialDelayUnit;
            }

            public void setMaxConnectionIdleTime(Long maxConnectionIdleTime) {
                this.maxConnectionIdleTime = maxConnectionIdleTime;
            }

            public void setMaxConnectionIdleTimeUnit(TimeUnit maxConnectionIdleTimeUnit) {
                this.maxConnectionIdleTimeUnit = maxConnectionIdleTimeUnit;
            }

            public void setMaxConnectionLifeTime(Long maxConnectionLifeTime) {
                this.maxConnectionLifeTime = maxConnectionLifeTime;
            }

            public void setMaxConnectionLifeTimeUnit(TimeUnit maxConnectionLifeTimeUnit) {
                this.maxConnectionLifeTimeUnit = maxConnectionLifeTimeUnit;
            }

            public void setMaxSize(Integer maxSize) {
                this.maxSize = maxSize;
            }

            public void setMaxWaitQueueSize(Integer maxWaitQueueSize) {
                this.maxWaitQueueSize = maxWaitQueueSize;
            }

            public void setMaxWaitTime(Long maxWaitTime) {
                this.maxWaitTime = maxWaitTime;
            }

            public void setMaxWaitTimeUnit(TimeUnit maxWaitTimeUnit) {
                this.maxWaitTimeUnit = maxWaitTimeUnit;
            }

            public void setMinSize(Integer minSize) {
                this.minSize = minSize;
            }
        }
    }

    public static enum Compressor {
        SNAPPY,
        ZLIB;

    }
}

