/*
 * Decompiled with CFR 0.152.
 */
package com.merakianalytics.orianna.datastores.mongo.dto;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.merakianalytics.datapipelines.PipelineContext;
import com.merakianalytics.datapipelines.iterators.CloseableIterator;
import com.merakianalytics.datapipelines.iterators.CloseableIterators;
import com.merakianalytics.datapipelines.sinks.Put;
import com.merakianalytics.datapipelines.sinks.PutMany;
import com.merakianalytics.datapipelines.sources.Get;
import com.merakianalytics.datapipelines.sources.GetMany;
import com.merakianalytics.orianna.datapipeline.common.QueryValidationException;
import com.merakianalytics.orianna.datapipeline.common.Utilities;
import com.merakianalytics.orianna.datapipeline.common.expiration.ExpirationPeriod;
import com.merakianalytics.orianna.datastores.mongo.FindResultIterator;
import com.merakianalytics.orianna.datastores.mongo.MongoDBDataStore;
import com.merakianalytics.orianna.datastores.mongo.proxies.dto.match.TournamentMatches;
import com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ItemList;
import com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.Languages;
import com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.MapData;
import com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.MasteryList;
import com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.SummonerSpellList;
import com.merakianalytics.orianna.types.common.OriannaException;
import com.merakianalytics.orianna.types.common.Platform;
import com.merakianalytics.orianna.types.common.Queue;
import com.merakianalytics.orianna.types.common.Tier;
import com.merakianalytics.orianna.types.dto.champion.Champion;
import com.merakianalytics.orianna.types.dto.championmastery.ChampionMasteries;
import com.merakianalytics.orianna.types.dto.championmastery.ChampionMastery;
import com.merakianalytics.orianna.types.dto.championmastery.ChampionMasteryScore;
import com.merakianalytics.orianna.types.dto.league.LeagueList;
import com.merakianalytics.orianna.types.dto.league.SummonerPositions;
import com.merakianalytics.orianna.types.dto.match.Match;
import com.merakianalytics.orianna.types.dto.match.MatchTimeline;
import com.merakianalytics.orianna.types.dto.spectator.CurrentGameInfo;
import com.merakianalytics.orianna.types.dto.spectator.FeaturedGames;
import com.merakianalytics.orianna.types.dto.staticdata.ChampionList;
import com.merakianalytics.orianna.types.dto.staticdata.Item;
import com.merakianalytics.orianna.types.dto.staticdata.LanguageStrings;
import com.merakianalytics.orianna.types.dto.staticdata.MapDetails;
import com.merakianalytics.orianna.types.dto.staticdata.Mastery;
import com.merakianalytics.orianna.types.dto.staticdata.ProfileIconData;
import com.merakianalytics.orianna.types.dto.staticdata.ProfileIconDetails;
import com.merakianalytics.orianna.types.dto.staticdata.Realm;
import com.merakianalytics.orianna.types.dto.staticdata.ReforgedRune;
import com.merakianalytics.orianna.types.dto.staticdata.ReforgedRunePath;
import com.merakianalytics.orianna.types.dto.staticdata.ReforgedRuneSlot;
import com.merakianalytics.orianna.types.dto.staticdata.ReforgedRuneTree;
import com.merakianalytics.orianna.types.dto.staticdata.Rune;
import com.merakianalytics.orianna.types.dto.staticdata.RuneList;
import com.merakianalytics.orianna.types.dto.staticdata.SummonerSpell;
import com.merakianalytics.orianna.types.dto.staticdata.Versions;
import com.merakianalytics.orianna.types.dto.status.ShardStatus;
import com.merakianalytics.orianna.types.dto.summoner.Summoner;
import com.merakianalytics.orianna.types.dto.thirdpartycode.VerificationString;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bson.BsonNumber;
import org.bson.BsonString;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBDataStore
extends com.merakianalytics.orianna.datastores.mongo.MongoDBDataStore {
    private static final Set<Tier> LEAGUE_LIST_ENDPOINTS = ImmutableSet.of((Object)Tier.MASTER, (Object)Tier.CHALLENGER);
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDBDataStore.class);
    private final Map<String, ExpirationPeriod> expirationPeriods;

    private static String getCurrentVersion(Platform platform, PipelineContext context) {
        Realm realm = (Realm)context.getPipeline().get(Realm.class, (Map)ImmutableMap.of((Object)"platform", (Object)platform));
        return realm.getV();
    }

    public MongoDBDataStore() {
        this(new Configuration());
    }

    public MongoDBDataStore(Configuration config) {
        super(config);
        this.expirationPeriods = config.getExpirationPeriods();
        this.ensureIndexes();
    }

    private void ensureIndexes() {
        ImmutableMap compositeKeys = ImmutableMap.builder().put(Champion.class, (Object)new String[]{"platform", "id"}).put(com.merakianalytics.orianna.types.dto.champion.ChampionList.class, (Object)new String[]{"platform", "freeToPlay"}).put(ChampionMastery.class, (Object)new String[]{"platform", "playerId", "championId"}).put(ChampionMasteries.class, (Object)new String[]{"platform", "summonerId"}).put(ChampionMasteryScore.class, (Object)new String[]{"platform", "summonerId"}).put(LeagueList.class, (Object)new String[]{"platform", "leagueId"}).put(SummonerPositions.class, (Object)new String[]{"platform", "summonerId"}).put(Match.class, (Object)new String[]{"platformId", "gameId"}).put(MatchTimeline.class, (Object)new String[]{"platform", "matchId"}).put(com.merakianalytics.orianna.types.dto.match.TournamentMatches.class, (Object)new String[]{"platform", "tournamentCode"}).put(CurrentGameInfo.class, (Object)new String[]{"platformId", "summonerId"}).put(FeaturedGames.class, (Object)new String[]{"platform"}).put(com.merakianalytics.orianna.types.dto.staticdata.Champion.class, (Object)new String[]{"platform", "id", "version", "locale", "_included_data_hash"}).put(ChampionList.class, (Object)new String[]{"platform", "version", "locale", "_included_data_hash"}).put(Item.class, (Object)new String[]{"platform", "id", "version", "locale", "_included_data_hash"}).put(com.merakianalytics.orianna.types.dto.staticdata.ItemList.class, (Object)new String[]{"platform", "version", "locale", "_included_data_hash"}).put(com.merakianalytics.orianna.types.dto.staticdata.Languages.class, (Object)new String[]{"platform"}).put(LanguageStrings.class, (Object)new String[]{"platform", "version", "locale"}).put(com.merakianalytics.orianna.types.dto.staticdata.MapData.class, (Object)new String[]{"platform", "version", "locale"}).put(MapDetails.class, (Object)new String[]{"platform", "mapId", "version", "locale"}).put(Mastery.class, (Object)new String[]{"platform", "id", "version", "locale", "_included_data_hash"}).put(com.merakianalytics.orianna.types.dto.staticdata.MasteryList.class, (Object)new String[]{"platform", "version", "locale", "_included_data_hash"}).put(ProfileIconData.class, (Object)new String[]{"platform", "version", "locale"}).put(ProfileIconDetails.class, (Object)new String[]{"platform", "id", "version", "locale"}).put(Realm.class, (Object)new String[]{"platform"}).put(ReforgedRune.class, (Object)new String[]{"platform", "id", "version", "locale"}).put(ReforgedRuneTree.class, (Object)new String[]{"platform", "version", "locale"}).put(Rune.class, (Object)new String[]{"platform", "id", "version", "locale", "_included_data_hash"}).put(RuneList.class, (Object)new String[]{"platform", "version", "locale", "_included_data_hash"}).put(SummonerSpell.class, (Object)new String[]{"platform", "id", "version", "locale", "_included_data_hash"}).put(com.merakianalytics.orianna.types.dto.staticdata.SummonerSpellList.class, (Object)new String[]{"platform", "version", "locale", "_included_data_hash"}).put(Versions.class, (Object)new String[]{"platform"}).put(ShardStatus.class, (Object)new String[]{"platform"}).put(Summoner.class, (Object)new String[]{"platform", "id"}).put(VerificationString.class, (Object)new String[]{"platform", "summonerId"}).build();
        for (Class clazz : compositeKeys.keySet()) {
            ArrayList indexes;
            MongoCollection collection = this.getCollection(clazz);
            String[] keys = (String[])compositeKeys.get(clazz);
            Bson composite = Indexes.compoundIndex((Bson[])((Bson[])Arrays.stream(keys).map(key -> Indexes.ascending((String[])new String[]{key})).toArray(Bson[]::new)));
            IndexModel compositeKey = new IndexModel(composite, new IndexOptions().unique(true));
            ExpirationPeriod period = this.expirationPeriods.get(clazz.getCanonicalName());
            if (period != null && period.getPeriod() > 0L) {
                IndexModel expiration = new IndexModel(Indexes.ascending((String[])new String[]{"_updated"}), new IndexOptions().expireAfter(Long.valueOf(period.getPeriod()), period.getUnit()));
                indexes = Lists.newArrayList((Object[])new IndexModel[]{compositeKey, expiration});
            } else {
                indexes = Lists.newArrayList((Object[])new IndexModel[]{compositeKey});
            }
            CompletableFuture future = new CompletableFuture();
            collection.createIndexes((List)indexes, (results, exception) -> {
                if (exception != null) {
                    future.completeExceptionally(exception);
                } else {
                    future.complete(results);
                }
            });
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("Error creating MongoDB indexes!", (Throwable)e);
                throw new OriannaException("Error creating MongoDB indexes!", (Throwable)e);
            }
        }
    }

    @Get(value=com.merakianalytics.orianna.types.dto.staticdata.Champion.class)
    public com.merakianalytics.orianna.types.dto.staticdata.Champion getChampion(Map<String, Object> query, PipelineContext context) {
        Set includedData;
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Number id = (Number)query.get("id");
        String name = (String)query.get("name");
        String key = (String)query.get("key");
        Utilities.checkAtLeastOneNotNull((Object[])new Object[]{id, "id", name, "name", key, "key"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set set = includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        Bson filter = id != null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"id", (Object)id), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)}) : (name != null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"name", (Object)name), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)}) : Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"key", (Object)key), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)}));
        return this.findFirst(com.merakianalytics.orianna.types.dto.staticdata.Champion.class, filter);
    }

    @Get(value=ChampionList.class)
    public ChampionList getChampionList(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        Boolean dataById = query.get("dataById") == null ? Boolean.FALSE : (Boolean)query.get("dataById");
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
        com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ChampionList result = this.findFirst(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ChampionList.class, filter);
        if (result == null) {
            return null;
        }
        try (FindResultIterator<com.merakianalytics.orianna.types.dto.staticdata.Champion> champions = this.find(com.merakianalytics.orianna.types.dto.staticdata.Champion.class, filter);){
            ChampionList list = result.convert((int)champions.getCount(), dataById);
            while (champions.hasNext()) {
                com.merakianalytics.orianna.types.dto.staticdata.Champion champion = champions.next();
                list.getData().put(dataById != false ? Integer.toString(champion.getId()) : champion.getKey(), champion);
            }
            ChampionList championList = list;
            return championList;
        }
    }

    @Get(value=ChampionMasteries.class)
    public ChampionMasteries getChampionMasteries(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Number summonerId = (Number)query.get("summonerId");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", summonerId, "summonerId"});
        com.merakianalytics.orianna.datastores.mongo.proxies.dto.championmastery.ChampionMasteries result = this.findFirst(com.merakianalytics.orianna.datastores.mongo.proxies.dto.championmastery.ChampionMasteries.class, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"summonerId", (Object)summonerId)}));
        if (result == null) {
            return null;
        }
        try (FindResultIterator<ChampionMastery> masteries = this.find(ChampionMastery.class, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"playerId", (Object)summonerId)}));){
            ChampionMasteries list = result.convert((int)masteries.getCount());
            while (masteries.hasNext()) {
                list.add((Object)masteries.next());
            }
            ChampionMasteries championMasteries = list;
            return championMasteries;
        }
    }

    @Get(value=ChampionMastery.class)
    public ChampionMastery getChampionMastery(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Number summonerId = (Number)query.get("summonerId");
        Number championId = (Number)query.get("championId");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", summonerId, "summonerId", championId, "championId"});
        return this.findFirst(ChampionMastery.class, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"playerId", (Object)summonerId), Filters.eq((String)"championId", (Object)championId)}));
    }

    @Get(value=ChampionMasteryScore.class)
    public ChampionMasteryScore getChampionMasteryScore(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Number summonerId = (Number)query.get("summonerId");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", summonerId, "summonerId"});
        return this.findFirst(ChampionMasteryScore.class, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"summonerId", (Object)summonerId)}));
    }

    @Get(value=Champion.class)
    public Champion getChampionStatus(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Number id = (Number)query.get("id");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", id, "id"});
        return this.findFirst(Champion.class, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"id", (Object)id)}));
    }

    @Get(value=com.merakianalytics.orianna.types.dto.champion.ChampionList.class)
    public com.merakianalytics.orianna.types.dto.champion.ChampionList getChampionStatusList(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Boolean freeToPlay = query.get("freeToPlay") == null ? Boolean.FALSE : (Boolean)query.get("freeToPlay");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"freeToPlay", (Object)freeToPlay)});
        com.merakianalytics.orianna.datastores.mongo.proxies.dto.champion.ChampionList result = this.findFirst(com.merakianalytics.orianna.datastores.mongo.proxies.dto.champion.ChampionList.class, filter);
        if (result == null) {
            return null;
        }
        try (FindResultIterator<Champion> statuses = this.find(Champion.class, filter);){
            com.merakianalytics.orianna.types.dto.champion.ChampionList list = result.convert((int)statuses.getCount());
            while (statuses.hasNext()) {
                list.getChampions().add(statuses.next());
            }
            com.merakianalytics.orianna.types.dto.champion.ChampionList championList = list;
            return championList;
        }
    }

    @Get(value=CurrentGameInfo.class)
    public CurrentGameInfo getCurrentGameInfo(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Number summonerId = (Number)query.get("summonerId");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", summonerId, "summonerId"});
        return this.findFirst(CurrentGameInfo.class, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platformId", (Object)platform.getTag()), Filters.eq((String)"summonerId", (Object)summonerId)}));
    }

    @Get(value=FeaturedGames.class)
    public FeaturedGames getFeaturedGames(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        return this.findFirst(FeaturedGames.class, Filters.eq((String)"platform", (Object)platform.getTag()));
    }

    @Get(value=Item.class)
    public Item getItem(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Number id = (Number)query.get("id");
        String name = (String)query.get("name");
        Utilities.checkAtLeastOneNotNull((Object[])new Object[]{id, "id", name, "name"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        Bson filter = id != null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"id", (Object)id), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)}) : Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"name", (Object)name), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
        return this.findFirst(Item.class, filter);
    }

    @Get(value=com.merakianalytics.orianna.types.dto.staticdata.ItemList.class)
    public com.merakianalytics.orianna.types.dto.staticdata.ItemList getItemList(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
        ItemList result = this.findFirst(ItemList.class, filter);
        if (result == null) {
            return null;
        }
        try (FindResultIterator<Item> items = this.find(Item.class, filter);){
            com.merakianalytics.orianna.types.dto.staticdata.ItemList list = result.convert((int)items.getCount());
            while (items.hasNext()) {
                Item item = items.next();
                list.getData().put(Integer.toString(item.getId()), item);
            }
            com.merakianalytics.orianna.types.dto.staticdata.ItemList itemList = list;
            return itemList;
        }
    }

    @Get(value=com.merakianalytics.orianna.types.dto.staticdata.Languages.class)
    public com.merakianalytics.orianna.types.dto.staticdata.Languages getLanguages(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        return Optional.ofNullable(this.findFirst(Languages.class, Filters.eq((String)"platform", (Object)platform.getTag()))).map(Languages::convert).orElse(null);
    }

    @Get(value=LanguageStrings.class)
    public LanguageStrings getLanguageStrings(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        return this.findFirst(LanguageStrings.class, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale)}));
    }

    @Get(value=LeagueList.class)
    public LeagueList getLeagueList(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Tier tier = (Tier)query.get("tier");
        Queue queue = (Queue)query.get("queue");
        String leagueId = (String)query.get("leagueId");
        if (leagueId == null) {
            if (tier == null || queue == null) {
                throw new QueryValidationException("Query was missing required parameters! Either leagueId or tier and queue must be included!");
            }
            if (!LEAGUE_LIST_ENDPOINTS.contains(tier)) {
                StringBuilder sb = new StringBuilder();
                for (Tier t : LEAGUE_LIST_ENDPOINTS) {
                    sb.append(", " + t);
                }
                throw new QueryValidationException("Query contained invalid parameters! tier must be one of [" + sb.substring(2) + "]!");
            }
            if (!Queue.RANKED.contains(queue)) {
                StringBuilder sb = new StringBuilder();
                for (Queue qu : Queue.RANKED) {
                    sb.append(", " + qu);
                }
                throw new QueryValidationException("Query contained invalid parameters! queue must be one of [" + sb.substring(2) + "]!");
            }
        }
        Bson filter = leagueId != null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"leagueId", (Object)leagueId)}) : Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"tier", (Object)tier.name()), Filters.eq((String)"queue", (Object)queue.name())});
        return this.findFirst(LeagueList.class, filter);
    }

    @GetMany(value=com.merakianalytics.orianna.types.dto.staticdata.Champion.class)
    public CloseableIterator<com.merakianalytics.orianna.types.dto.staticdata.Champion> getManyChampion(Map<String, Object> query, PipelineContext context) {
        MongoDBDataStore.FindQuery find;
        Set includedData;
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Iterable ids = (Iterable)query.get("ids");
        Iterable names = (Iterable)query.get("names");
        Iterable keys = (Iterable)query.get("keys");
        Utilities.checkAtLeastOneNotNull((Object[])new Object[]{ids, "ids", names, "names", keys, "keys"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set set = includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        if (ids != null) {
            List order = StreamSupport.stream(ids.spliterator(), false).map(com.merakianalytics.orianna.datastores.mongo.MongoDBDataStore::toBson).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"id", order), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("id").build();
        } else if (names != null) {
            List order = StreamSupport.stream(names.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"name", order), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("name").build();
        } else {
            List order = StreamSupport.stream(keys.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"key", order), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("key").build();
        }
        return this.find(com.merakianalytics.orianna.types.dto.staticdata.Champion.class, find);
    }

    @GetMany(value=ChampionList.class)
    public CloseableIterator<ChampionList> getManyChampionList(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Iterable iter = (Iterable)query.get("versions");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", iter, "versions"});
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        Boolean dataById = query.get("dataById") == null ? Boolean.FALSE : (Boolean)query.get("dataById");
        List versions = StreamSupport.stream(iter.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform), Filters.in((String)"version", versions), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(versions).orderingField("version").build();
        FindResultIterator<com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ChampionList> results = this.find(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ChampionList.class, find);
        if (results == null) {
            return null;
        }
        return CloseableIterators.transform(results, result -> {
            try (FindResultIterator<com.merakianalytics.orianna.types.dto.staticdata.Champion> champions = this.find(com.merakianalytics.orianna.types.dto.staticdata.Champion.class, filter);){
                ChampionList list = result.convert((int)champions.getCount(), dataById);
                while (champions.hasNext()) {
                    com.merakianalytics.orianna.types.dto.staticdata.Champion champion = champions.next();
                    list.getData().put(dataById != false ? Integer.toString(champion.getId()) : champion.getKey(), champion);
                }
                ChampionList championList = list;
                return championList;
            }
        });
    }

    @GetMany(value=ChampionMasteries.class)
    public CloseableIterator<ChampionMasteries> getManyChampionMasteries(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Iterable iter = (Iterable)query.get("summonerIds");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", iter, "summonerIds"});
        List<BsonNumber> summonerIds = this.numbersToBson(iter);
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform), Filters.in((String)"summonerId", summonerIds)})).order(summonerIds).orderingField("summonerId").build();
        FindResultIterator<com.merakianalytics.orianna.datastores.mongo.proxies.dto.championmastery.ChampionMasteries> results = this.find(com.merakianalytics.orianna.datastores.mongo.proxies.dto.championmastery.ChampionMasteries.class, find);
        if (results == null) {
            return null;
        }
        return CloseableIterators.transform(results, result -> {
            try (FindResultIterator<ChampionMastery> masteries = this.find(ChampionMastery.class, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform), Filters.in((String)"summonerId", (Iterable)summonerIds)}));){
                ChampionMasteries list = result.convert((int)masteries.getCount());
                while (masteries.hasNext()) {
                    list.add((Object)masteries.next());
                }
                ChampionMasteries championMasteries = list;
                return championMasteries;
            }
        });
    }

    @GetMany(value=ChampionMastery.class)
    public CloseableIterator<ChampionMastery> getManyChampionMastery(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Number summonerId = (Number)query.get("summonerId");
        Iterable iter = (Iterable)query.get("championIds");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", summonerId, "summonerId", iter, "championIds"});
        List<BsonNumber> championIds = this.numbersToBson(iter);
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform), Filters.eq((String)"playerId", (Object)summonerId), Filters.in((String)"championId", championIds)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(championIds).orderingField("championId").build();
        return this.find(ChampionMastery.class, find);
    }

    @GetMany(value=ChampionMasteryScore.class)
    public CloseableIterator<ChampionMasteryScore> getManyChampionMasteryScore(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Iterable iter = (Iterable)query.get("summonerIds");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", iter, "summonerIds"});
        List<BsonNumber> summonerIds = this.numbersToBson(iter);
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform), Filters.in((String)"summonerId", summonerIds)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(summonerIds).orderingField("summonerId").build();
        return this.find(ChampionMasteryScore.class, find);
    }

    @GetMany(value=Champion.class)
    public CloseableIterator<Champion> getManyChampionStatus(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Iterable iter = (Iterable)query.get("ids");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", iter, "ids"});
        List<BsonNumber> ids = this.numbersToBson(iter);
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"id", ids)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(ids).orderingField("id").build();
        return this.find(Champion.class, find);
    }

    @GetMany(value=com.merakianalytics.orianna.types.dto.champion.ChampionList.class)
    public CloseableIterator<com.merakianalytics.orianna.types.dto.champion.ChampionList> getManyChampionStatusList(Map<String, Object> query, PipelineContext context) {
        Iterable iter = (Iterable)query.get("platforms");
        Boolean freeToPlay = query.get("freeToPlay") == null ? Boolean.FALSE : (Boolean)query.get("freeToPlay");
        Utilities.checkNotNull((Object[])new Object[]{iter, "platforms"});
        List platforms = StreamSupport.stream(iter.spliterator(), false).map(platform -> new BsonString(platform.getTag())).collect(Collectors.toList());
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"freeToPlay", (Object)freeToPlay), Filters.in((String)"platform", platforms)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(platforms).orderingField("platform").build();
        FindResultIterator<com.merakianalytics.orianna.datastores.mongo.proxies.dto.champion.ChampionList> results = this.find(com.merakianalytics.orianna.datastores.mongo.proxies.dto.champion.ChampionList.class, find);
        if (results == null) {
            return null;
        }
        return CloseableIterators.transform(results, result -> {
            try (FindResultIterator<Champion> statuses = this.find(Champion.class, filter);){
                com.merakianalytics.orianna.types.dto.champion.ChampionList list = result.convert((int)statuses.getCount());
                while (statuses.hasNext()) {
                    list.getChampions().add(statuses.next());
                }
                com.merakianalytics.orianna.types.dto.champion.ChampionList championList = list;
                return championList;
            }
        });
    }

    @GetMany(value=CurrentGameInfo.class)
    public CloseableIterator<CurrentGameInfo> getManyCurrentGameInfo(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Iterable iter = (Iterable)query.get("summonerIds");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", iter, "summonerIds"});
        List<BsonNumber> summonerIds = this.numbersToBson(iter);
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platformId", (Object)platform), Filters.in((String)"summonerId", summonerIds)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(summonerIds).orderingField("summonerId").build();
        return this.find(CurrentGameInfo.class, find);
    }

    @GetMany(value=FeaturedGames.class)
    public CloseableIterator<FeaturedGames> getManyFeaturedGames(Map<String, Object> query, PipelineContext context) {
        Iterable iter = (Iterable)query.get("platforms");
        Utilities.checkNotNull((Object[])new Object[]{iter, "platforms"});
        List platforms = StreamSupport.stream(iter.spliterator(), false).map(platform -> new BsonString(platform.getTag())).collect(Collectors.toList());
        Bson filter = Filters.in((String)"platform", platforms);
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(platforms).orderingField("platform").build();
        return this.find(FeaturedGames.class, find);
    }

    @GetMany(value=Item.class)
    public CloseableIterator<Item> getManyItem(Map<String, Object> query, PipelineContext context) {
        MongoDBDataStore.FindQuery find;
        Set includedData;
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Iterable ids = (Iterable)query.get("ids");
        Iterable names = (Iterable)query.get("names");
        Utilities.checkAtLeastOneNotNull((Object[])new Object[]{ids, "ids", names, "names"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set set = includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        if (ids != null) {
            List order = StreamSupport.stream(ids.spliterator(), false).map(com.merakianalytics.orianna.datastores.mongo.MongoDBDataStore::toBson).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"id", order), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("id").build();
        } else {
            List order = StreamSupport.stream(names.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"name", order), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("name").build();
        }
        return this.find(Item.class, find);
    }

    @GetMany(value=com.merakianalytics.orianna.types.dto.staticdata.ItemList.class)
    public CloseableIterator<com.merakianalytics.orianna.types.dto.staticdata.ItemList> getManyItemList(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Iterable iter = (Iterable)query.get("versions");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", iter, "versions"});
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        List versions = StreamSupport.stream(iter.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform), Filters.in((String)"version", versions), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(versions).orderingField("version").build();
        FindResultIterator<ItemList> results = this.find(ItemList.class, find);
        if (results == null) {
            return null;
        }
        return CloseableIterators.transform(results, result -> {
            try (FindResultIterator<Item> items = this.find(Item.class, filter);){
                com.merakianalytics.orianna.types.dto.staticdata.ItemList list = result.convert((int)items.getCount());
                while (items.hasNext()) {
                    Item item = items.next();
                    list.getData().put(Integer.toString(item.getId()), item);
                }
                com.merakianalytics.orianna.types.dto.staticdata.ItemList itemList = list;
                return itemList;
            }
        });
    }

    @GetMany(value=com.merakianalytics.orianna.types.dto.staticdata.Languages.class)
    public CloseableIterator<com.merakianalytics.orianna.types.dto.staticdata.Languages> getManyLanguages(Map<String, Object> query, PipelineContext context) {
        Iterable iter = (Iterable)query.get("platforms");
        Utilities.checkNotNull((Object[])new Object[]{iter, "platforms"});
        List platforms = StreamSupport.stream(iter.spliterator(), false).map(platform -> new BsonString(platform.getTag())).collect(Collectors.toList());
        Bson filter = Filters.in((String)"platform", platforms);
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(platforms).orderingField("platform").build();
        FindResultIterator<Languages> results = this.find(Languages.class, find);
        if (results == null) {
            return null;
        }
        return CloseableIterators.transform(results, Languages::convert);
    }

    @GetMany(value=LanguageStrings.class)
    public CloseableIterator<LanguageStrings> getManyLanguageStrings(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Iterable iter = (Iterable)query.get("locales");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", iter, "locales"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        List locales = StreamSupport.stream(iter.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform), Filters.in((String)"locale", locales), Filters.eq((String)"version", (Object)version)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(locales).orderingField("locale").build();
        return this.find(LanguageStrings.class, find);
    }

    @GetMany(value=LeagueList.class)
    public CloseableIterator<LeagueList> getManyLeagueList(Map<String, Object> query, PipelineContext context) {
        MongoDBDataStore.FindQuery find;
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Tier tier = (Tier)query.get("tier");
        Iterable queues = (Iterable)query.get("queues");
        Iterable leagueIds = (Iterable)query.get("leagueIds");
        if (leagueIds == null) {
            if (tier == null || queues == null) {
                throw new QueryValidationException("Query was missing required parameters! Either leagueIds or tier and queues must be included!");
            }
            if (!LEAGUE_LIST_ENDPOINTS.contains(tier)) {
                StringBuilder sb = new StringBuilder();
                for (Tier t : LEAGUE_LIST_ENDPOINTS) {
                    sb.append(", " + t);
                }
                throw new QueryValidationException("Query contained invalid parameters! tier must be one of [" + sb.substring(2) + "]!");
            }
        }
        if (leagueIds != null) {
            List ids = StreamSupport.stream(leagueIds.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform), Filters.in((String)"leagueId", ids)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(ids).orderingField("leagueId").build();
        } else {
            List ids = StreamSupport.stream(queues.spliterator(), false).map(queue -> new BsonString(queue.name())).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform), Filters.eq((String)"tier", (Object)tier.name()), Filters.in((String)"queue", ids)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(ids).orderingField("queue").build();
        }
        return this.find(LeagueList.class, find);
    }

    @GetMany(value=com.merakianalytics.orianna.types.dto.staticdata.MapData.class)
    public CloseableIterator<com.merakianalytics.orianna.types.dto.staticdata.MapData> getManyMapData(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Iterable iter = (Iterable)query.get("versions");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", iter, "versions"});
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        List versions = StreamSupport.stream(iter.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform), Filters.in((String)"version", versions), Filters.eq((String)"locale", (Object)locale)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(versions).orderingField("version").build();
        FindResultIterator<MapData> results = this.find(MapData.class, find);
        if (results == null) {
            return null;
        }
        return CloseableIterators.transform(results, result -> {
            try (FindResultIterator<MapDetails> maps = this.find(MapDetails.class, filter);){
                com.merakianalytics.orianna.types.dto.staticdata.MapData data = result.convert((int)maps.getCount());
                while (maps.hasNext()) {
                    MapDetails map = maps.next();
                    data.getData().put(Long.toString(map.getMapId()), map);
                }
                com.merakianalytics.orianna.types.dto.staticdata.MapData mapData = data;
                return mapData;
            }
        });
    }

    @GetMany(value=MapDetails.class)
    public CloseableIterator<MapDetails> getManyMapDetails(Map<String, Object> query, PipelineContext context) {
        MongoDBDataStore.FindQuery find;
        String locale;
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Iterable ids = (Iterable)query.get("ids");
        Iterable names = (Iterable)query.get("names");
        Utilities.checkAtLeastOneNotNull((Object[])new Object[]{ids, "ids", names, "names"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String string = locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        if (ids != null) {
            List order = StreamSupport.stream(ids.spliterator(), false).map(com.merakianalytics.orianna.datastores.mongo.MongoDBDataStore::toBson).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"mapId", order), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("mapId").build();
        } else {
            List order = StreamSupport.stream(names.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"name", order), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("name").build();
        }
        return this.find(MapDetails.class, find);
    }

    @GetMany(value=Mastery.class)
    public CloseableIterator<Mastery> getManyMastery(Map<String, Object> query, PipelineContext context) {
        MongoDBDataStore.FindQuery find;
        Set includedData;
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Iterable ids = (Iterable)query.get("ids");
        Iterable names = (Iterable)query.get("names");
        Utilities.checkAtLeastOneNotNull((Object[])new Object[]{ids, "ids", names, "names"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set set = includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        if (ids != null) {
            List order = StreamSupport.stream(ids.spliterator(), false).map(com.merakianalytics.orianna.datastores.mongo.MongoDBDataStore::toBson).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"id", order), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("id").build();
        } else {
            List order = StreamSupport.stream(names.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"name", order), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("name").build();
        }
        return this.find(Mastery.class, find);
    }

    @GetMany(value=com.merakianalytics.orianna.types.dto.staticdata.MasteryList.class)
    public CloseableIterator<com.merakianalytics.orianna.types.dto.staticdata.MasteryList> getManyMasteryList(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Iterable iter = (Iterable)query.get("versions");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", iter, "versions"});
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        List versions = StreamSupport.stream(iter.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform), Filters.in((String)"version", versions), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(versions).orderingField("version").build();
        FindResultIterator<MasteryList> results = this.find(MasteryList.class, find);
        if (results == null) {
            return null;
        }
        return CloseableIterators.transform(results, result -> {
            try (FindResultIterator<Mastery> masteries = this.find(Mastery.class, filter);){
                com.merakianalytics.orianna.types.dto.staticdata.MasteryList list = result.convert((int)masteries.getCount());
                while (masteries.hasNext()) {
                    Mastery mastery = masteries.next();
                    list.getData().put(Integer.toString(mastery.getId()), mastery);
                }
                com.merakianalytics.orianna.types.dto.staticdata.MasteryList masteryList = list;
                return masteryList;
            }
        });
    }

    @GetMany(value=Match.class)
    public CloseableIterator<Match> getManyMatch(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Iterable iter = (Iterable)query.get("matchIds");
        String tournamentCode = (String)query.get("tournamentCode");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", iter, "matchIds"});
        List<BsonNumber> matchIds = this.numbersToBson(iter);
        Bson filter = tournamentCode == null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"platformId", (Object)platform), Filters.in((String)"gameId", matchIds)}) : Filters.and((Bson[])new Bson[]{Filters.eq((String)"platformId", (Object)platform), Filters.eq((String)"tournamentCode", (Object)tournamentCode), Filters.in((String)"gameId", matchIds)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(matchIds).orderingField("gameId").build();
        return this.find(Match.class, find);
    }

    @GetMany(value=MatchTimeline.class)
    public CloseableIterator<MatchTimeline> getManyMatchTimeline(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Iterable iter = (Iterable)query.get("matchIds");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", iter, "matchIds"});
        List<BsonNumber> matchIds = this.numbersToBson(iter);
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform), Filters.in((String)"matchId", matchIds)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(matchIds).orderingField("matchId").build();
        return this.find(MatchTimeline.class, find);
    }

    @GetMany(value=ProfileIconData.class)
    public CloseableIterator<ProfileIconData> getManyProfileIconData(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Iterable iter = (Iterable)query.get("versions");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", iter, "versions"});
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        List versions = StreamSupport.stream(iter.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform), Filters.in((String)"version", versions), Filters.eq((String)"locale", (Object)locale)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(versions).orderingField("version").build();
        FindResultIterator<com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ProfileIconData> results = this.find(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ProfileIconData.class, find);
        if (results == null) {
            return null;
        }
        return CloseableIterators.transform(results, result -> {
            try (FindResultIterator<ProfileIconDetails> icons = this.find(ProfileIconDetails.class, filter);){
                ProfileIconData data = result.convert((int)icons.getCount());
                while (icons.hasNext()) {
                    ProfileIconDetails icon = icons.next();
                    data.getData().put(Long.toString(icon.getId()), icon);
                }
                ProfileIconData profileIconData = data;
                return profileIconData;
            }
        });
    }

    @GetMany(value=ProfileIconDetails.class)
    public CloseableIterator<ProfileIconDetails> getManyProfileIconDetails(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Iterable ids = (Iterable)query.get("ids");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", ids, "ids"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        List order = StreamSupport.stream(ids.spliterator(), false).map(com.merakianalytics.orianna.datastores.mongo.MongoDBDataStore::toBson).collect(Collectors.toList());
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"id", order), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("id").build();
        return this.find(ProfileIconDetails.class, find);
    }

    @GetMany(value=Realm.class)
    public CloseableIterator<Realm> getManyRealm(Map<String, Object> query, PipelineContext context) {
        Iterable iter = (Iterable)query.get("platforms");
        Utilities.checkNotNull((Object[])new Object[]{iter, "platforms"});
        List platforms = StreamSupport.stream(iter.spliterator(), false).map(platform -> new BsonString(platform.getTag())).collect(Collectors.toList());
        Bson filter = Filters.in((String)"platform", platforms);
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(platforms).orderingField("platform").build();
        return this.find(Realm.class, find);
    }

    @GetMany(value=ReforgedRune.class)
    public CloseableIterator<ReforgedRune> getManyReforgedRune(Map<String, Object> query, PipelineContext context) {
        MongoDBDataStore.FindQuery find;
        String locale;
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Iterable ids = (Iterable)query.get("ids");
        Iterable names = (Iterable)query.get("names");
        Iterable keys = (Iterable)query.get("keys");
        Utilities.checkAtLeastOneNotNull((Object[])new Object[]{ids, "ids", names, "names", keys, "keys"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String string = locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        if (ids != null) {
            List order = StreamSupport.stream(ids.spliterator(), false).map(com.merakianalytics.orianna.datastores.mongo.MongoDBDataStore::toBson).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"id", order), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("id").build();
        } else if (names != null) {
            List order = StreamSupport.stream(names.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"name", order), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("name").build();
        } else {
            List order = StreamSupport.stream(keys.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"key", order), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("key").build();
        }
        return this.find(ReforgedRune.class, find);
    }

    @GetMany(value=ReforgedRuneTree.class)
    public CloseableIterator<ReforgedRuneTree> getManyReforgedRuneTree(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Iterable iter = (Iterable)query.get("versions");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", iter, "versions"});
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        List versions = StreamSupport.stream(iter.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform), Filters.in((String)"version", versions), Filters.eq((String)"locale", (Object)locale)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(versions).orderingField("version").build();
        FindResultIterator<com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ReforgedRuneTree> results = this.find(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ReforgedRuneTree.class, find);
        if (results == null) {
            return null;
        }
        return CloseableIterators.transform(results, result -> {
            try (FindResultIterator<ReforgedRune> runes = this.find(ReforgedRune.class, filter);){
                ReforgedRuneTree tree = result.convert();
                HashMap slots = new HashMap();
                for (ReforgedRunePath path : tree) {
                    HashMap forPath = (HashMap)slots.get(path.getId());
                    if (forPath == null) {
                        forPath = new HashMap();
                        slots.put(path.getId(), forPath);
                    }
                    for (int i = 0; i < path.getSlots().size(); ++i) {
                        forPath.put(i, path.getSlots().get(i));
                    }
                }
                while (runes.hasNext()) {
                    ReforgedRune rune = runes.next();
                    ReforgedRuneSlot slot = (ReforgedRuneSlot)((Map)slots.get(rune.getPathId())).get(rune.getSlot());
                    slot.getRunes().add(rune);
                }
                Iterator iterator = tree;
                return iterator;
            }
        });
    }

    @GetMany(value=Rune.class)
    public CloseableIterator<Rune> getManyRune(Map<String, Object> query, PipelineContext context) {
        MongoDBDataStore.FindQuery find;
        Set includedData;
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Iterable ids = (Iterable)query.get("ids");
        Iterable names = (Iterable)query.get("names");
        Utilities.checkAtLeastOneNotNull((Object[])new Object[]{ids, "ids", names, "names"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set set = includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        if (ids != null) {
            List order = StreamSupport.stream(ids.spliterator(), false).map(com.merakianalytics.orianna.datastores.mongo.MongoDBDataStore::toBson).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"id", order), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("id").build();
        } else {
            List order = StreamSupport.stream(names.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"name", order), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("name").build();
        }
        return this.find(Rune.class, find);
    }

    @GetMany(value=RuneList.class)
    public CloseableIterator<RuneList> getManyRuneList(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Iterable iter = (Iterable)query.get("versions");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", iter, "versions"});
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        List versions = StreamSupport.stream(iter.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform), Filters.in((String)"version", versions), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(versions).orderingField("version").build();
        FindResultIterator<com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.RuneList> results = this.find(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.RuneList.class, find);
        if (results == null) {
            return null;
        }
        return CloseableIterators.transform(results, result -> {
            try (FindResultIterator<Rune> runes = this.find(Rune.class, filter);){
                RuneList list = result.convert((int)runes.getCount());
                while (runes.hasNext()) {
                    Rune rune = runes.next();
                    list.getData().put(Integer.toString(rune.getId()), rune);
                }
                RuneList runeList = list;
                return runeList;
            }
        });
    }

    @GetMany(value=ShardStatus.class)
    public CloseableIterator<ShardStatus> getManyShardStatus(Map<String, Object> query, PipelineContext context) {
        Iterable iter = (Iterable)query.get("platforms");
        Utilities.checkNotNull((Object[])new Object[]{iter, "platforms"});
        List platforms = StreamSupport.stream(iter.spliterator(), false).map(platform -> new BsonString(platform.getTag().toLowerCase())).collect(Collectors.toList());
        Bson filter = Filters.in((String)"region_tag", platforms);
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(platforms).orderingField("region_tag").build();
        return this.find(ShardStatus.class, find);
    }

    @GetMany(value=Summoner.class)
    public CloseableIterator<Summoner> getManySummoner(Map<String, Object> query, PipelineContext context) {
        MongoDBDataStore.FindQuery find;
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Iterable summonerIds = (Iterable)query.get("ids");
        Iterable accountIds = (Iterable)query.get("accountIds");
        Iterable summonerNames = (Iterable)query.get("names");
        Utilities.checkAtLeastOneNotNull((Object[])new Object[]{summonerIds, "ids", accountIds, "accountIds", summonerNames, "names"});
        if (summonerIds != null) {
            List order = StreamSupport.stream(summonerIds.spliterator(), false).map(com.merakianalytics.orianna.datastores.mongo.MongoDBDataStore::toBson).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"id", order)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("id").build();
        } else if (summonerNames != null) {
            List order = StreamSupport.stream(summonerNames.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"name", order)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("name").build();
        } else {
            List order = StreamSupport.stream(accountIds.spliterator(), false).map(com.merakianalytics.orianna.datastores.mongo.MongoDBDataStore::toBson).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"accountId", order)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("accountId").build();
        }
        return this.find(Summoner.class, find);
    }

    @GetMany(value=SummonerPositions.class)
    public CloseableIterator<SummonerPositions> getManySummonerPositions(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Iterable iter = (Iterable)query.get("summonerIds");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", iter, "summonerIds"});
        List<BsonNumber> summonerIds = this.numbersToBson(iter);
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform), Filters.in((String)"summonerId", summonerIds)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(summonerIds).orderingField("summonerId").build();
        FindResultIterator<com.merakianalytics.orianna.datastores.mongo.proxies.dto.league.SummonerPositions> results = this.find(com.merakianalytics.orianna.datastores.mongo.proxies.dto.league.SummonerPositions.class, find);
        if (results == null) {
            return null;
        }
        return CloseableIterators.transform(results, com.merakianalytics.orianna.datastores.mongo.proxies.dto.league.SummonerPositions::convert);
    }

    @GetMany(value=SummonerSpell.class)
    public CloseableIterator<SummonerSpell> getManySummonerSpell(Map<String, Object> query, PipelineContext context) {
        MongoDBDataStore.FindQuery find;
        Set includedData;
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Iterable ids = (Iterable)query.get("ids");
        Iterable names = (Iterable)query.get("names");
        Utilities.checkAtLeastOneNotNull((Object[])new Object[]{ids, "ids", names, "names"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set set = includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        if (ids != null) {
            List order = StreamSupport.stream(ids.spliterator(), false).map(com.merakianalytics.orianna.datastores.mongo.MongoDBDataStore::toBson).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"id", order), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("id").build();
        } else {
            List order = StreamSupport.stream(names.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.in((String)"name", order), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
            find = MongoDBDataStore.FindQuery.builder().filter(filter).order(order).orderingField("name").build();
        }
        return this.find(SummonerSpell.class, find);
    }

    @GetMany(value=com.merakianalytics.orianna.types.dto.staticdata.SummonerSpellList.class)
    public CloseableIterator<com.merakianalytics.orianna.types.dto.staticdata.SummonerSpellList> getManySummonerSpellList(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Iterable iter = (Iterable)query.get("versions");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", iter, "versions"});
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        List versions = StreamSupport.stream(iter.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform), Filters.in((String)"version", versions), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(versions).orderingField("version").build();
        FindResultIterator<SummonerSpellList> results = this.find(SummonerSpellList.class, find);
        if (results == null) {
            return null;
        }
        return CloseableIterators.transform(results, result -> {
            try (FindResultIterator<SummonerSpell> spells = this.find(SummonerSpell.class, filter);){
                com.merakianalytics.orianna.types.dto.staticdata.SummonerSpellList list = result.convert((int)spells.getCount());
                while (spells.hasNext()) {
                    SummonerSpell spell = spells.next();
                    list.getData().put(Integer.toString(spell.getId()), spell);
                }
                com.merakianalytics.orianna.types.dto.staticdata.SummonerSpellList summonerSpellList = list;
                return summonerSpellList;
            }
        });
    }

    @GetMany(value=com.merakianalytics.orianna.types.dto.match.TournamentMatches.class)
    public CloseableIterator<com.merakianalytics.orianna.types.dto.match.TournamentMatches> getManyTournamentMatches(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Iterable iter = (Iterable)query.get("tournamentCodes");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", iter, "tournamentCodes"});
        List tournamentCodes = StreamSupport.stream(iter.spliterator(), false).map(BsonString::new).collect(Collectors.toList());
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform), Filters.in((String)"tournamentCode", tournamentCodes)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(tournamentCodes).orderingField("tournamentCode").build();
        FindResultIterator<TournamentMatches> results = this.find(TournamentMatches.class, find);
        if (results == null) {
            return null;
        }
        return CloseableIterators.transform(results, TournamentMatches::convert);
    }

    @GetMany(value=VerificationString.class)
    public CloseableIterator<VerificationString> getManyVerificationString(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Iterable iter = (Iterable)query.get("summonerIds");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", iter, "summonerIds"});
        List<BsonNumber> summonerIds = this.numbersToBson(iter);
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform), Filters.in((String)"summonerId", summonerIds)});
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(summonerIds).orderingField("summonerId").build();
        return this.find(VerificationString.class, find);
    }

    @GetMany(value=Versions.class)
    public CloseableIterator<Versions> getManyVersions(Map<String, Object> query, PipelineContext context) {
        Iterable iter = (Iterable)query.get("platforms");
        Utilities.checkNotNull((Object[])new Object[]{iter, "platforms"});
        List platforms = StreamSupport.stream(iter.spliterator(), false).map(platform -> new BsonString(platform.getTag())).collect(Collectors.toList());
        Bson filter = Filters.in((String)"platform", platforms);
        MongoDBDataStore.FindQuery find = MongoDBDataStore.FindQuery.builder().filter(filter).order(platforms).orderingField("platform").build();
        FindResultIterator<com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.Versions> results = this.find(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.Versions.class, find);
        if (results == null) {
            return null;
        }
        return CloseableIterators.transform(results, com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.Versions::convert);
    }

    @Get(value=com.merakianalytics.orianna.types.dto.staticdata.MapData.class)
    public com.merakianalytics.orianna.types.dto.staticdata.MapData getMapData(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale)});
        MapData result = this.findFirst(MapData.class, filter);
        if (result == null) {
            return null;
        }
        try (FindResultIterator<MapDetails> maps = this.find(MapDetails.class, filter);){
            com.merakianalytics.orianna.types.dto.staticdata.MapData data = result.convert((int)maps.getCount());
            while (maps.hasNext()) {
                MapDetails map = maps.next();
                data.getData().put(Long.toString(map.getMapId()), map);
            }
            com.merakianalytics.orianna.types.dto.staticdata.MapData mapData = data;
            return mapData;
        }
    }

    @Get(value=MapDetails.class)
    public MapDetails getMapDetails(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Number id = (Number)query.get("id");
        String name = (String)query.get("name");
        Utilities.checkAtLeastOneNotNull((Object[])new Object[]{id, "id", name, "name"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Bson filter = id != null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"mapId", (Object)id), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale)}) : Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"name", (Object)name), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale)});
        return this.findFirst(MapDetails.class, filter);
    }

    @Get(value=Mastery.class)
    public Mastery getMastery(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Number id = (Number)query.get("id");
        String name = (String)query.get("name");
        Utilities.checkAtLeastOneNotNull((Object[])new Object[]{id, "id", name, "name"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        Bson filter = id != null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"id", (Object)id), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)}) : Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"name", (Object)name), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
        return this.findFirst(Mastery.class, filter);
    }

    @Get(value=com.merakianalytics.orianna.types.dto.staticdata.MasteryList.class)
    public com.merakianalytics.orianna.types.dto.staticdata.MasteryList getMasteryList(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
        MasteryList result = this.findFirst(MasteryList.class, filter);
        if (result == null) {
            return null;
        }
        try (FindResultIterator<Mastery> masteries = this.find(Mastery.class, filter);){
            com.merakianalytics.orianna.types.dto.staticdata.MasteryList list = result.convert((int)masteries.getCount());
            while (masteries.hasNext()) {
                Mastery mastery = masteries.next();
                list.getData().put(Integer.toString(mastery.getId()), mastery);
            }
            com.merakianalytics.orianna.types.dto.staticdata.MasteryList masteryList = list;
            return masteryList;
        }
    }

    @Get(value=Match.class)
    public Match getMatch(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Number matchId = (Number)query.get("matchId");
        String tournamentCode = (String)query.get("tournamentCode");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", matchId, "matchId"});
        Bson filter = tournamentCode == null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"platformId", (Object)platform.getTag()), Filters.eq((String)"gameId", (Object)matchId)}) : Filters.and((Bson[])new Bson[]{Filters.eq((String)"platformId", (Object)platform.getTag()), Filters.eq((String)"gameId", (Object)matchId), Filters.eq((String)"tournamentCode", (Object)tournamentCode)});
        return this.findFirst(Match.class, filter);
    }

    @Get(value=MatchTimeline.class)
    public MatchTimeline getMatchTimeline(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Number matchId = (Number)query.get("matchId");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", matchId, "matchId"});
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"matchId", (Object)matchId)});
        return this.findFirst(MatchTimeline.class, filter);
    }

    @Get(value=ProfileIconData.class)
    public ProfileIconData getProfileIconData(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale)});
        com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ProfileIconData result = this.findFirst(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ProfileIconData.class, filter);
        if (result == null) {
            return null;
        }
        try (FindResultIterator<ProfileIconDetails> icons = this.find(ProfileIconDetails.class, filter);){
            ProfileIconData data = result.convert((int)icons.getCount());
            while (icons.hasNext()) {
                ProfileIconDetails icon = icons.next();
                data.getData().put(Long.toString(icon.getId()), icon);
            }
            ProfileIconData profileIconData = data;
            return profileIconData;
        }
    }

    @Get(value=ProfileIconDetails.class)
    public ProfileIconDetails getProfileIconDetails(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Number id = (Number)query.get("id");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", id, "id"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"id", (Object)id), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale)});
        return this.findFirst(ProfileIconDetails.class, filter);
    }

    @Get(value=Realm.class)
    public Realm getRealm(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Bson filter = Filters.eq((String)"platform", (Object)platform.getTag());
        return this.findFirst(Realm.class, filter);
    }

    @Get(value=ReforgedRune.class)
    public ReforgedRune getReforgedRune(Map<String, Object> query, PipelineContext context) {
        String locale;
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Number id = (Number)query.get("id");
        String name = (String)query.get("name");
        String key = (String)query.get("key");
        Utilities.checkAtLeastOneNotNull((Object[])new Object[]{id, "id", name, "name", key, "key"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String string = locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Bson filter = id != null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"id", (Object)id), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale)}) : (name != null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"name", (Object)name), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale)}) : Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"key", (Object)key), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale)}));
        return this.findFirst(ReforgedRune.class, filter);
    }

    @Get(value=ReforgedRuneTree.class)
    public ReforgedRuneTree getReforgedRuneTree(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale)});
        com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ReforgedRuneTree result = this.findFirst(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ReforgedRuneTree.class, filter);
        if (result == null) {
            return null;
        }
        try (FindResultIterator<ReforgedRune> runes = this.find(ReforgedRune.class, filter);){
            ReforgedRuneTree tree = result.convert();
            HashMap slots = new HashMap();
            for (ReforgedRunePath path : tree) {
                HashMap forPath = (HashMap)slots.get(path.getId());
                if (forPath == null) {
                    forPath = new HashMap();
                    slots.put(path.getId(), forPath);
                }
                for (int i = 0; i < path.getSlots().size(); ++i) {
                    forPath.put(i, path.getSlots().get(i));
                }
            }
            while (runes.hasNext()) {
                ReforgedRune rune = runes.next();
                ReforgedRuneSlot slot = (ReforgedRuneSlot)((Map)slots.get(rune.getPathId())).get(rune.getSlot());
                slot.getRunes().add(rune);
            }
            Iterator iterator = tree;
            return iterator;
        }
    }

    @Get(value=Rune.class)
    public Rune getRune(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Number id = (Number)query.get("id");
        String name = (String)query.get("name");
        Utilities.checkAtLeastOneNotNull((Object[])new Object[]{id, "id", name, "name"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        Bson filter = id != null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"id", (Object)id), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)}) : Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"name", (Object)name), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
        return this.findFirst(Rune.class, filter);
    }

    @Get(value=RuneList.class)
    public RuneList getRuneList(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
        com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.RuneList result = this.findFirst(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.RuneList.class, filter);
        if (result == null) {
            return null;
        }
        try (FindResultIterator<Rune> runes = this.find(Rune.class, filter);){
            RuneList list = result.convert((int)runes.getCount());
            while (runes.hasNext()) {
                Rune rune = runes.next();
                list.getData().put(Integer.toString(rune.getId()), rune);
            }
            RuneList runeList = list;
            return runeList;
        }
    }

    @Get(value=ShardStatus.class)
    public ShardStatus getShardStatus(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Bson filter = Filters.eq((String)"region_tag", (Object)platform.getTag().toLowerCase());
        return this.findFirst(ShardStatus.class, filter);
    }

    @Get(value=Summoner.class)
    public Summoner getSummoner(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Number summonerId = (Number)query.get("id");
        Number accountId = (Number)query.get("accountId");
        String summonerName = (String)query.get("name");
        Utilities.checkAtLeastOneNotNull((Object[])new Object[]{summonerId, "id", accountId, "accountId", summonerName, "name"});
        Bson filter = summonerId != null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"id", (Object)summonerId)}) : (summonerName != null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"name", (Object)summonerName)}) : Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"accountId", (Object)accountId)}));
        return this.findFirst(Summoner.class, filter);
    }

    @Get(value=SummonerPositions.class)
    public SummonerPositions getSummonerPositions(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Number summonerId = (Number)query.get("summonerId");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", summonerId, "summonerId"});
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"summonerId", (Object)summonerId)});
        return Optional.ofNullable(this.findFirst(com.merakianalytics.orianna.datastores.mongo.proxies.dto.league.SummonerPositions.class, filter)).map(com.merakianalytics.orianna.datastores.mongo.proxies.dto.league.SummonerPositions::convert).orElse(null);
    }

    @Get(value=SummonerSpell.class)
    public SummonerSpell getSummonerSpell(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Number id = (Number)query.get("id");
        String name = (String)query.get("name");
        Utilities.checkAtLeastOneNotNull((Object[])new Object[]{id, "id", name, "name"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        Bson filter = id != null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"id", (Object)id), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)}) : Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"name", (Object)name), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
        return this.findFirst(SummonerSpell.class, filter);
    }

    @Get(value=com.merakianalytics.orianna.types.dto.staticdata.SummonerSpellList.class)
    public com.merakianalytics.orianna.types.dto.staticdata.SummonerSpellList getSummonerSpellList(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        String version = query.get("version") == null ? MongoDBDataStore.getCurrentVersion(platform, context) : (String)query.get("version");
        String locale = query.get("locale") == null ? platform.getDefaultLocale() : (String)query.get("locale");
        Set includedData = query.get("includedData") == null ? Collections.emptySet() : (Set)query.get("includedData");
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"version", (Object)version), Filters.eq((String)"locale", (Object)locale), Filters.eq((String)"includedData", (Object)includedData)});
        SummonerSpellList result = this.findFirst(SummonerSpellList.class, filter);
        if (result == null) {
            return null;
        }
        try (FindResultIterator<SummonerSpell> spells = this.find(SummonerSpell.class, filter);){
            com.merakianalytics.orianna.types.dto.staticdata.SummonerSpellList list = result.convert((int)spells.getCount());
            while (spells.hasNext()) {
                SummonerSpell spell = spells.next();
                list.getData().put(Integer.toString(spell.getId()), spell);
            }
            com.merakianalytics.orianna.types.dto.staticdata.SummonerSpellList summonerSpellList = list;
            return summonerSpellList;
        }
    }

    @Get(value=com.merakianalytics.orianna.types.dto.match.TournamentMatches.class)
    public com.merakianalytics.orianna.types.dto.match.TournamentMatches getTournamentMatches(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        String tournamentCode = (String)query.get("tournamentCode");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", tournamentCode, "tournamentCode"});
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"tournamentCode", (Object)tournamentCode)});
        return Optional.ofNullable(this.findFirst(TournamentMatches.class, filter)).map(TournamentMatches::convert).orElse(null);
    }

    @Get(value=VerificationString.class)
    public VerificationString getVerificationString(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Number summonerId = (Number)query.get("summonerId");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform", summonerId, "summonerId"});
        return this.findFirst(VerificationString.class, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)platform.getTag()), Filters.eq((String)"summonerId", (Object)summonerId)}));
    }

    @Get(value=Versions.class)
    public Versions getVersions(Map<String, Object> query, PipelineContext context) {
        Platform platform = (Platform)query.get("platform");
        Utilities.checkNotNull((Object[])new Object[]{platform, "platform"});
        Bson filter = Filters.eq((String)"platform", (Object)platform.getTag());
        return Optional.ofNullable(this.findFirst(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.Versions.class, filter)).map(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.Versions::convert).orElse(null);
    }

    protected Set<Class<?>> ignore() {
        HashSet<String> included = new HashSet<String>();
        for (String name : this.expirationPeriods.keySet()) {
            if (this.expirationPeriods.get(name).getPeriod() == 0L) continue;
            included.add(name);
        }
        Sets.SetView names = Sets.difference(Configuration.DEFAULT_EXPIRATION_PERIODS.keySet(), included);
        if (names.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet ignore = new HashSet();
        for (String name : names) {
            try {
                ignore.add(Class.forName(name));
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Failed to find class for name " + name + "!", (Throwable)e);
                throw new OriannaException("Failed to find class for name " + name + "! Report this to the orianna team.", (Throwable)e);
            }
        }
        return ignore;
    }

    @Put(value=com.merakianalytics.orianna.types.dto.staticdata.Champion.class)
    public void putChampion(com.merakianalytics.orianna.types.dto.staticdata.Champion champion, PipelineContext context) {
        this.upsert(com.merakianalytics.orianna.types.dto.staticdata.Champion.class, champion, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)champion.getPlatform()), Filters.eq((String)"id", (Object)champion.getId()), Filters.eq((String)"version", (Object)champion.getVersion()), Filters.eq((String)"locale", (Object)champion.getLocale()), Filters.eq((String)"includedData", (Object)champion.getIncludedData())}));
    }

    @Put(value=ChampionList.class)
    public void putChampionList(ChampionList list, PipelineContext context) {
        this.upsert(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ChampionList.class, com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ChampionList.convert(list), Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)list.getPlatform()), Filters.eq((String)"version", (Object)list.getVersion()), Filters.eq((String)"locale", (Object)list.getLocale()), Filters.eq((String)"includedData", (Object)list.getIncludedData())}));
        this.putManyChampion(list.getData().values(), context);
    }

    @Put(value=ChampionMasteries.class)
    public void putChampionMasteries(ChampionMasteries masteries, PipelineContext context) {
        this.upsert(com.merakianalytics.orianna.datastores.mongo.proxies.dto.championmastery.ChampionMasteries.class, com.merakianalytics.orianna.datastores.mongo.proxies.dto.championmastery.ChampionMasteries.convert(masteries), Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)masteries.getPlatform()), Filters.eq((String)"summonerId", (Object)masteries.getSummonerId())}));
        this.putManyChampionMastery((Iterable<ChampionMastery>)masteries, context);
    }

    @Put(value=ChampionMastery.class)
    public void putChampionMastery(ChampionMastery mastery, PipelineContext context) {
        this.upsert(ChampionMastery.class, mastery, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)mastery.getPlatform()), Filters.eq((String)"playerId", (Object)mastery.getPlayerId()), Filters.eq((String)"championId", (Object)mastery.getChampionId())}));
    }

    @Put(value=ChampionMasteryScore.class)
    public void putChampionMasteryScore(ChampionMasteryScore score, PipelineContext context) {
        this.upsert(ChampionMasteryScore.class, score, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)score.getPlatform()), Filters.eq((String)"summonerId", (Object)score.getSummonerId())}));
    }

    @Put(value=Champion.class)
    public void putChampionStatus(Champion champion, PipelineContext context) {
        this.upsert(Champion.class, champion, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)champion.getPlatform()), Filters.eq((String)"id", (Object)champion.getId())}));
    }

    @Put(value=com.merakianalytics.orianna.types.dto.champion.ChampionList.class)
    public void putChampionStatusList(com.merakianalytics.orianna.types.dto.champion.ChampionList list, PipelineContext context) {
        this.upsert(com.merakianalytics.orianna.datastores.mongo.proxies.dto.champion.ChampionList.class, com.merakianalytics.orianna.datastores.mongo.proxies.dto.champion.ChampionList.convert(list), Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)list.getPlatform()), Filters.eq((String)"freeToPlay", (Object)list.isFreeToPlay())}));
        this.putManyChampionStatus(list.getChampions(), context);
    }

    @Put(value=CurrentGameInfo.class)
    public void putCurrentGameInfo(CurrentGameInfo info, PipelineContext context) {
        this.upsert(CurrentGameInfo.class, info, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platformId", (Object)info.getPlatformId()), Filters.eq((String)"summonerId", (Object)info.getSummonerId())}));
    }

    @Put(value=FeaturedGames.class)
    public void putFeaturedGames(FeaturedGames games, PipelineContext context) {
        this.upsert(FeaturedGames.class, games, Filters.eq((String)"platform", (Object)games.getPlatform()));
    }

    @Put(value=Item.class)
    public void putItem(Item item, PipelineContext context) {
        this.upsert(Item.class, item, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)item.getPlatform()), Filters.eq((String)"id", (Object)item.getId()), Filters.eq((String)"version", (Object)item.getVersion()), Filters.eq((String)"locale", (Object)item.getLocale()), Filters.eq((String)"includedData", (Object)item.getIncludedData())}));
    }

    @Put(value=com.merakianalytics.orianna.types.dto.staticdata.ItemList.class)
    public void putItemList(com.merakianalytics.orianna.types.dto.staticdata.ItemList list, PipelineContext context) {
        this.upsert(ItemList.class, ItemList.convert(list), Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)list.getPlatform()), Filters.eq((String)"version", (Object)list.getVersion()), Filters.eq((String)"locale", (Object)list.getLocale()), Filters.eq((String)"includedData", (Object)list.getIncludedData())}));
        this.putManyItem(list.getData().values(), context);
    }

    @Put(value=com.merakianalytics.orianna.types.dto.staticdata.Languages.class)
    public void putLanguages(com.merakianalytics.orianna.types.dto.staticdata.Languages languages, PipelineContext context) {
        this.upsert(Languages.class, Languages.convert(languages), Filters.eq((String)"platform", (Object)languages.getPlatform()));
    }

    @Put(value=LanguageStrings.class)
    public void putLanguageStrings(LanguageStrings strings, PipelineContext context) {
        this.upsert(LanguageStrings.class, strings, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)strings.getPlatform()), Filters.eq((String)"locale", (Object)strings.getLocale()), Filters.eq((String)"version", (Object)strings.getVersion())}));
    }

    @Put(value=LeagueList.class)
    public void putLeagueList(LeagueList league, PipelineContext context) {
        this.upsert(LeagueList.class, league, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)league.getPlatform()), Filters.eq((String)"leagueId", (Object)league.getLeagueId())}));
    }

    @PutMany(value=com.merakianalytics.orianna.types.dto.staticdata.Champion.class)
    public void putManyChampion(Iterable<com.merakianalytics.orianna.types.dto.staticdata.Champion> c, PipelineContext context) {
        this.upsert(com.merakianalytics.orianna.types.dto.staticdata.Champion.class, c, (T champion) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)champion.getPlatform()), Filters.eq((String)"id", (Object)champion.getId()), Filters.eq((String)"version", (Object)champion.getVersion()), Filters.eq((String)"locale", (Object)champion.getLocale()), Filters.eq((String)"includedData", (Object)champion.getIncludedData())}));
    }

    @PutMany(value=ChampionList.class)
    public void putManyChampionList(Iterable<ChampionList> l, PipelineContext context) {
        this.upsert(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ChampionList.class, Iterables.transform(l, com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ChampionList::convert), (T list) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)list.getPlatform()), Filters.eq((String)"version", (Object)list.getVersion()), Filters.eq((String)"locale", (Object)list.getLocale()), Filters.eq((String)"includedData", list.getIncludedData())}));
        this.putManyChampion(Iterables.concat((Iterable)StreamSupport.stream(l.spliterator(), false).map(champions -> champions.getData().values()).collect(Collectors.toList())), context);
    }

    @PutMany(value=ChampionMasteries.class)
    public void putManyChampionMasteries(Iterable<ChampionMasteries> m, PipelineContext context) {
        this.upsert(com.merakianalytics.orianna.datastores.mongo.proxies.dto.championmastery.ChampionMasteries.class, Iterables.transform(m, com.merakianalytics.orianna.datastores.mongo.proxies.dto.championmastery.ChampionMasteries::convert), (T masteries) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)masteries.getPlatform()), Filters.eq((String)"summonerId", (Object)masteries.getSummonerId())}));
        this.putManyChampionMastery(Iterables.concat(m), context);
    }

    @PutMany(value=ChampionMastery.class)
    public void putManyChampionMastery(Iterable<ChampionMastery> m, PipelineContext context) {
        this.upsert(ChampionMastery.class, m, (T mastery) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)mastery.getPlatform()), Filters.eq((String)"playerId", (Object)mastery.getPlayerId()), Filters.eq((String)"championId", (Object)mastery.getChampionId())}));
    }

    @PutMany(value=ChampionMasteryScore.class)
    public void putManyChampionMasteryScore(Iterable<ChampionMasteryScore> m, PipelineContext context) {
        this.upsert(ChampionMasteryScore.class, m, (T masteries) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)masteries.getPlatform()), Filters.eq((String)"summonerId", (Object)masteries.getSummonerId())}));
    }

    @PutMany(value=Champion.class)
    public void putManyChampionStatus(Iterable<Champion> s, PipelineContext context) {
        this.upsert(Champion.class, s, (T status) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)status.getPlatform()), Filters.eq((String)"id", (Object)status.getId())}));
    }

    @PutMany(value=com.merakianalytics.orianna.types.dto.champion.ChampionList.class)
    public void putManyChampionStatusList(Iterable<com.merakianalytics.orianna.types.dto.champion.ChampionList> s, PipelineContext context) {
        this.upsert(com.merakianalytics.orianna.datastores.mongo.proxies.dto.champion.ChampionList.class, Iterables.transform(s, com.merakianalytics.orianna.datastores.mongo.proxies.dto.champion.ChampionList::convert), (T statuses) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)statuses.getPlatform()), Filters.eq((String)"freeToPlay", (Object)statuses.isFreeToPlay())}));
        this.putManyChampionStatus(Iterables.concat((Iterable)StreamSupport.stream(s.spliterator(), false).map(com.merakianalytics.orianna.types.dto.champion.ChampionList::getChampions).collect(Collectors.toList())), context);
    }

    @PutMany(value=CurrentGameInfo.class)
    public void putManyCurrentGameInfo(Iterable<CurrentGameInfo> i, PipelineContext context) {
        this.upsert(CurrentGameInfo.class, i, (T info) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platformId", (Object)info.getPlatformId()), Filters.eq((String)"summonerId", (Object)info.getSummonerId())}));
    }

    @PutMany(value=FeaturedGames.class)
    public void putManyFeaturedGames(Iterable<FeaturedGames> g, PipelineContext context) {
        this.upsert(FeaturedGames.class, g, (T games) -> Filters.eq((String)"platform", (Object)games.getPlatform()));
    }

    @PutMany(value=Item.class)
    public void putManyItem(Iterable<Item> i, PipelineContext context) {
        this.upsert(Item.class, i, (T item) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)item.getPlatform()), Filters.eq((String)"id", (Object)item.getId()), Filters.eq((String)"version", (Object)item.getVersion()), Filters.eq((String)"locale", (Object)item.getLocale()), Filters.eq((String)"includedData", (Object)item.getIncludedData())}));
    }

    @PutMany(value=com.merakianalytics.orianna.types.dto.staticdata.ItemList.class)
    public void putManyItemList(Iterable<com.merakianalytics.orianna.types.dto.staticdata.ItemList> l, PipelineContext context) {
        this.upsert(ItemList.class, Iterables.transform(l, ItemList::convert), (T list) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)list.getPlatform()), Filters.eq((String)"version", (Object)list.getVersion()), Filters.eq((String)"locale", (Object)list.getLocale()), Filters.eq((String)"includedData", list.getIncludedData())}));
        this.putManyItem(Iterables.concat((Iterable)StreamSupport.stream(l.spliterator(), false).map(items -> items.getData().values()).collect(Collectors.toList())), context);
    }

    @PutMany(value=com.merakianalytics.orianna.types.dto.staticdata.Languages.class)
    public void putManyLanguages(Iterable<com.merakianalytics.orianna.types.dto.staticdata.Languages> l, PipelineContext context) {
        this.upsert(Languages.class, Iterables.transform(l, Languages::convert), (T languages) -> Filters.eq((String)"platform", (Object)languages.getPlatform()));
    }

    @PutMany(value=LanguageStrings.class)
    public void putManyLanguageStrings(Iterable<LanguageStrings> s, PipelineContext context) {
        this.upsert(LanguageStrings.class, s, (T strings) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)strings.getPlatform()), Filters.eq((String)"locale", (Object)strings.getLocale()), Filters.eq((String)"version", (Object)strings.getVersion())}));
    }

    @PutMany(value=LeagueList.class)
    public void putManyLeagueList(Iterable<LeagueList> l, PipelineContext context) {
        this.upsert(LeagueList.class, l, (T list) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)list.getPlatform()), Filters.eq((String)"leagueId", (Object)list.getLeagueId())}));
    }

    @PutMany(value=com.merakianalytics.orianna.types.dto.staticdata.MapData.class)
    public void putManyMapData(Iterable<com.merakianalytics.orianna.types.dto.staticdata.MapData> d, PipelineContext context) {
        this.upsert(MapData.class, Iterables.transform(d, MapData::convert), (T data) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)data.getPlatform()), Filters.eq((String)"version", (Object)data.getVersion()), Filters.eq((String)"locale", (Object)data.getLocale())}));
        this.putManyMapDetails(Iterables.concat((Iterable)StreamSupport.stream(d.spliterator(), false).map(data -> data.getData().values()).collect(Collectors.toList())), context);
    }

    @PutMany(value=MapDetails.class)
    public void putManyMapDetails(Iterable<MapDetails> m, PipelineContext context) {
        this.upsert(MapDetails.class, m, (T map) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)map.getPlatform()), Filters.eq((String)"mapId", (Object)map.getMapId()), Filters.eq((String)"version", (Object)map.getVersion()), Filters.eq((String)"locale", (Object)map.getLocale())}));
    }

    @PutMany(value=Mastery.class)
    public void putManyMastery(Iterable<Mastery> m, PipelineContext context) {
        this.upsert(Mastery.class, m, (T mastery) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)mastery.getPlatform()), Filters.eq((String)"id", (Object)mastery.getId()), Filters.eq((String)"version", (Object)mastery.getVersion()), Filters.eq((String)"locale", (Object)mastery.getLocale()), Filters.eq((String)"includedData", (Object)mastery.getIncludedData())}));
    }

    @PutMany(value=com.merakianalytics.orianna.types.dto.staticdata.MasteryList.class)
    public void putManyMasteryList(Iterable<com.merakianalytics.orianna.types.dto.staticdata.MasteryList> l, PipelineContext context) {
        this.upsert(MasteryList.class, Iterables.transform(l, MasteryList::convert), (T list) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)list.getPlatform()), Filters.eq((String)"version", (Object)list.getVersion()), Filters.eq((String)"locale", (Object)list.getLocale()), Filters.eq((String)"includedData", list.getIncludedData())}));
        this.putManyMastery(Iterables.concat((Iterable)StreamSupport.stream(l.spliterator(), false).map(masteries -> masteries.getData().values()).collect(Collectors.toList())), context);
    }

    @PutMany(value=Match.class)
    public void putManyMatch(Iterable<Match> m, PipelineContext context) {
        this.upsert(Match.class, m, (T match) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platformId", (Object)match.getPlatformId()), Filters.eq((String)"gameId", (Object)match.getGameId())}));
    }

    @PutMany(value=MatchTimeline.class)
    public void putManyMatchTimeline(Iterable<MatchTimeline> t, PipelineContext context) {
        this.upsert(MatchTimeline.class, t, (T timeline) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)timeline.getPlatform()), Filters.eq((String)"matchId", (Object)timeline.getMatchId())}));
    }

    @PutMany(value=ProfileIconData.class)
    public void putManyProfileIconData(Iterable<ProfileIconData> d, PipelineContext context) {
        this.upsert(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ProfileIconData.class, Iterables.transform(d, com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ProfileIconData::convert), (T data) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)data.getPlatform()), Filters.eq((String)"version", (Object)data.getVersion()), Filters.eq((String)"locale", (Object)data.getLocale())}));
        this.putManyProfileIconDetails(Iterables.concat((Iterable)StreamSupport.stream(d.spliterator(), false).map(data -> data.getData().values()).collect(Collectors.toList())), context);
    }

    @PutMany(value=ProfileIconDetails.class)
    public void putManyProfileIconDetails(Iterable<ProfileIconDetails> i, PipelineContext context) {
        this.upsert(ProfileIconDetails.class, i, (T icon) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)icon.getPlatform()), Filters.eq((String)"id", (Object)icon.getId()), Filters.eq((String)"version", (Object)icon.getVersion()), Filters.eq((String)"locale", (Object)icon.getLocale())}));
    }

    @PutMany(value=Realm.class)
    public void putManyRealm(Iterable<Realm> r, PipelineContext context) {
        this.upsert(Realm.class, r, (T realm) -> Filters.eq((String)"platform", (Object)realm.getPlatform()));
    }

    @PutMany(value=ReforgedRune.class)
    public void putManyReforgedRune(Iterable<ReforgedRune> r, PipelineContext context) {
        this.upsert(ReforgedRune.class, r, (T rune) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)rune.getPlatform()), Filters.eq((String)"id", (Object)rune.getId()), Filters.eq((String)"version", (Object)rune.getVersion()), Filters.eq((String)"locale", (Object)rune.getLocale())}));
    }

    @PutMany(value=ReforgedRuneTree.class)
    public void putManyReforgedRuneTree(Iterable<ReforgedRuneTree> t, PipelineContext context) {
        this.upsert(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ReforgedRuneTree.class, Iterables.transform(t, com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ReforgedRuneTree::convert), (T tree) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)tree.getPlatform()), Filters.eq((String)"version", (Object)tree.getVersion()), Filters.eq((String)"locale", (Object)tree.getLocale())}));
        this.putManyReforgedRune(Iterables.concat((Iterable)StreamSupport.stream(t.spliterator(), false).map(tree -> tree.stream().map(ReforgedRunePath::getSlots).flatMap(Collection::stream).map(ReforgedRuneSlot::getRunes).flatMap(Collection::stream).collect(Collectors.toList())).collect(Collectors.toList())), context);
    }

    @PutMany(value=Rune.class)
    public void putManyRune(Iterable<Rune> r, PipelineContext context) {
        this.upsert(Rune.class, r, (T rune) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)rune.getPlatform()), Filters.eq((String)"id", (Object)rune.getId()), Filters.eq((String)"version", (Object)rune.getVersion()), Filters.eq((String)"locale", (Object)rune.getLocale()), Filters.eq((String)"includedData", (Object)rune.getIncludedData())}));
    }

    @PutMany(value=RuneList.class)
    public void putManyRuneList(Iterable<RuneList> l, PipelineContext context) {
        this.upsert(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.RuneList.class, Iterables.transform(l, com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.RuneList::convert), (T list) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)list.getPlatform()), Filters.eq((String)"version", (Object)list.getVersion()), Filters.eq((String)"locale", (Object)list.getLocale()), Filters.eq((String)"includedData", list.getIncludedData())}));
        this.putManyRune(Iterables.concat((Iterable)StreamSupport.stream(l.spliterator(), false).map(runes -> runes.getData().values()).collect(Collectors.toList())), context);
    }

    @PutMany(value=ShardStatus.class)
    public void putManyShardStatus(Iterable<ShardStatus> s, PipelineContext context) {
        this.upsert(ShardStatus.class, s, (T status) -> Filters.eq((String)"region_tag", (Object)status.getRegion_tag()));
    }

    @PutMany(value=Summoner.class)
    public void putManySummoner(Iterable<Summoner> s, PipelineContext context) {
        this.upsert(Summoner.class, s, (T summoner) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)summoner.getPlatform()), Filters.eq((String)"id", (Object)summoner.getId())}));
    }

    @PutMany(value=SummonerPositions.class)
    public void putManySummonerPositions(Iterable<SummonerPositions> p, PipelineContext context) {
        this.upsert(com.merakianalytics.orianna.datastores.mongo.proxies.dto.league.SummonerPositions.class, Iterables.transform(p, com.merakianalytics.orianna.datastores.mongo.proxies.dto.league.SummonerPositions::convert), (T positions) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)positions.getPlatform()), Filters.eq((String)"summonerId", (Object)positions.getSummonerId())}));
    }

    @PutMany(value=SummonerSpell.class)
    public void putManySummonerSpell(Iterable<SummonerSpell> s, PipelineContext context) {
        this.upsert(SummonerSpell.class, s, (T spell) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)spell.getPlatform()), Filters.eq((String)"id", (Object)spell.getId()), Filters.eq((String)"version", (Object)spell.getVersion()), Filters.eq((String)"locale", (Object)spell.getLocale()), Filters.eq((String)"includedData", (Object)spell.getIncludedData())}));
    }

    @PutMany(value=com.merakianalytics.orianna.types.dto.staticdata.SummonerSpellList.class)
    public void putManySummonerSpellList(Iterable<com.merakianalytics.orianna.types.dto.staticdata.SummonerSpellList> l, PipelineContext context) {
        this.upsert(SummonerSpellList.class, Iterables.transform(l, SummonerSpellList::convert), (T list) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)list.getPlatform()), Filters.eq((String)"version", (Object)list.getVersion()), Filters.eq((String)"locale", (Object)list.getLocale()), Filters.eq((String)"includedData", list.getIncludedData())}));
        this.putManySummonerSpell(Iterables.concat((Iterable)StreamSupport.stream(l.spliterator(), false).map(spells -> spells.getData().values()).collect(Collectors.toList())), context);
    }

    @PutMany(value=com.merakianalytics.orianna.types.dto.match.TournamentMatches.class)
    public void putManyTournamentMatches(Iterable<com.merakianalytics.orianna.types.dto.match.TournamentMatches> m, PipelineContext context) {
        this.upsert(TournamentMatches.class, Iterables.transform(m, TournamentMatches::convert), (T matches) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)matches.getPlatform()), Filters.eq((String)"tournamentCode", (Object)matches.getTournamentCode())}));
    }

    @PutMany(value=VerificationString.class)
    public void putManyVerificationString(Iterable<VerificationString> s, PipelineContext context) {
        this.upsert(VerificationString.class, s, (T string) -> Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)string.getPlatform()), Filters.eq((String)"summonerId", (Object)string.getSummonerId())}));
    }

    @PutMany(value=Versions.class)
    public void putManyVersions(Iterable<Versions> v, PipelineContext context) {
        this.upsert(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.Versions.class, Iterables.transform(v, com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.Versions::convert), (T versions) -> Filters.eq((String)"platform", (Object)versions.getPlatform()));
    }

    @Put(value=com.merakianalytics.orianna.types.dto.staticdata.MapData.class)
    public void putMapData(com.merakianalytics.orianna.types.dto.staticdata.MapData data, PipelineContext context) {
        this.upsert(MapData.class, MapData.convert(data), Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)data.getPlatform()), Filters.eq((String)"version", (Object)data.getVersion()), Filters.eq((String)"locale", (Object)data.getLocale())}));
        this.putManyMapDetails(data.getData().values(), context);
    }

    @Put(value=MapDetails.class)
    public void putMapDetails(MapDetails map, PipelineContext context) {
        this.upsert(MapDetails.class, map, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)map.getPlatform()), Filters.eq((String)"mapId", (Object)map.getMapId()), Filters.eq((String)"icon", (Object)map.getVersion()), Filters.eq((String)"locale", (Object)map.getLocale())}));
    }

    @Put(value=Mastery.class)
    public void putMastery(Mastery mastery, PipelineContext context) {
        this.upsert(Mastery.class, mastery, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)mastery.getPlatform()), Filters.eq((String)"id", (Object)mastery.getId()), Filters.eq((String)"version", (Object)mastery.getVersion()), Filters.eq((String)"locale", (Object)mastery.getLocale()), Filters.eq((String)"includedData", (Object)mastery.getIncludedData())}));
    }

    @Put(value=com.merakianalytics.orianna.types.dto.staticdata.MasteryList.class)
    public void putMasteryList(com.merakianalytics.orianna.types.dto.staticdata.MasteryList list, PipelineContext context) {
        this.upsert(MasteryList.class, MasteryList.convert(list), Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)list.getPlatform()), Filters.eq((String)"version", (Object)list.getVersion()), Filters.eq((String)"locale", (Object)list.getLocale()), Filters.eq((String)"includedData", (Object)list.getIncludedData())}));
        this.putManyMastery(list.getData().values(), context);
    }

    @Put(value=Match.class)
    public void putMatch(Match match, PipelineContext context) {
        this.upsert(Match.class, match, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platformId", (Object)match.getPlatformId()), Filters.eq((String)"gameId", (Object)match.getGameId())}));
    }

    @Put(value=MatchTimeline.class)
    public void putMatchTimeline(MatchTimeline timeline, PipelineContext context) {
        this.upsert(MatchTimeline.class, timeline, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)timeline.getPlatform()), Filters.eq((String)"matchId", (Object)timeline.getMatchId())}));
    }

    @Put(value=ProfileIconData.class)
    public void putProfileIconData(ProfileIconData data, PipelineContext context) {
        this.upsert(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ProfileIconData.class, com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ProfileIconData.convert(data), Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)data.getPlatform()), Filters.eq((String)"version", (Object)data.getVersion()), Filters.eq((String)"locale", (Object)data.getLocale())}));
        this.putManyProfileIconDetails(data.getData().values(), context);
    }

    @Put(value=ProfileIconDetails.class)
    public void putProfileIconDetails(ProfileIconDetails icon, PipelineContext context) {
        this.upsert(ProfileIconDetails.class, icon, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)icon.getPlatform()), Filters.eq((String)"id", (Object)icon.getId()), Filters.eq((String)"icon", (Object)icon.getVersion()), Filters.eq((String)"locale", (Object)icon.getLocale())}));
    }

    @Put(value=Realm.class)
    public void putRealm(Realm realm, PipelineContext context) {
        this.upsert(Realm.class, realm, Filters.eq((String)"platform", (Object)realm.getPlatform()));
    }

    @Put(value=ReforgedRune.class)
    public void putReforgedRune(ReforgedRune rune, PipelineContext context) {
        this.upsert(ReforgedRune.class, rune, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)rune.getPlatform()), Filters.eq((String)"id", (Object)rune.getId()), Filters.eq((String)"version", (Object)rune.getVersion()), Filters.eq((String)"locale", (Object)rune.getLocale())}));
    }

    @Put(value=ReforgedRuneTree.class)
    public void putReforgedRuneTree(ReforgedRuneTree tree, PipelineContext context) {
        this.upsert(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ReforgedRuneTree.class, com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.ReforgedRuneTree.convert(tree), Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)tree.getPlatform()), Filters.eq((String)"version", (Object)tree.getVersion()), Filters.eq((String)"locale", (Object)tree.getLocale())}));
        List<ReforgedRune> runes = tree.stream().map(ReforgedRunePath::getSlots).flatMap(Collection::stream).map(ReforgedRuneSlot::getRunes).flatMap(Collection::stream).collect(Collectors.toList());
        this.putManyReforgedRune(runes, context);
    }

    @Put(value=Rune.class)
    public void putRune(Rune rune, PipelineContext context) {
        this.upsert(Rune.class, rune, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)rune.getPlatform()), Filters.eq((String)"id", (Object)rune.getId()), Filters.eq((String)"version", (Object)rune.getVersion()), Filters.eq((String)"locale", (Object)rune.getLocale()), Filters.eq((String)"includedData", (Object)rune.getIncludedData())}));
    }

    @Put(value=RuneList.class)
    public void putRuneList(RuneList list, PipelineContext context) {
        this.upsert(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.RuneList.class, com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.RuneList.convert(list), Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)list.getPlatform()), Filters.eq((String)"version", (Object)list.getVersion()), Filters.eq((String)"locale", (Object)list.getLocale()), Filters.eq((String)"includedData", (Object)list.getIncludedData())}));
        this.putManyRune(list.getData().values(), context);
    }

    @Put(value=ShardStatus.class)
    public void putShardStatus(ShardStatus status, PipelineContext context) {
        this.upsert(ShardStatus.class, status, Filters.eq((String)"region_tag", (Object)status.getRegion_tag()));
    }

    @Put(value=Summoner.class)
    public void putSummoner(Summoner summoner, PipelineContext context) {
        this.upsert(Summoner.class, summoner, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)summoner.getPlatform()), Filters.eq((String)"id", (Object)summoner.getId())}));
    }

    @Put(value=SummonerPositions.class)
    public void putSummonerPositions(SummonerPositions positions, PipelineContext context) {
        this.upsert(com.merakianalytics.orianna.datastores.mongo.proxies.dto.league.SummonerPositions.class, com.merakianalytics.orianna.datastores.mongo.proxies.dto.league.SummonerPositions.convert(positions), Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)positions.getPlatform()), Filters.eq((String)"summonerId", (Object)positions.getSummonerId())}));
    }

    @Put(value=SummonerSpell.class)
    public void putSummonerSpell(SummonerSpell spell, PipelineContext context) {
        this.upsert(SummonerSpell.class, spell, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)spell.getPlatform()), Filters.eq((String)"id", (Object)spell.getId()), Filters.eq((String)"version", (Object)spell.getVersion()), Filters.eq((String)"locale", (Object)spell.getLocale()), Filters.eq((String)"includedData", (Object)spell.getIncludedData())}));
    }

    @Put(value=com.merakianalytics.orianna.types.dto.staticdata.SummonerSpellList.class)
    public void putSummonerSpellList(com.merakianalytics.orianna.types.dto.staticdata.SummonerSpellList list, PipelineContext context) {
        this.upsert(SummonerSpellList.class, SummonerSpellList.convert(list), Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)list.getPlatform()), Filters.eq((String)"version", (Object)list.getVersion()), Filters.eq((String)"locale", (Object)list.getLocale()), Filters.eq((String)"includedData", (Object)list.getIncludedData())}));
        this.putManySummonerSpell(list.getData().values(), context);
    }

    @Put(value=com.merakianalytics.orianna.types.dto.match.TournamentMatches.class)
    public void putTournamentMatches(com.merakianalytics.orianna.types.dto.match.TournamentMatches matches, PipelineContext context) {
        this.upsert(TournamentMatches.class, TournamentMatches.convert(matches), Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)matches.getPlatform()), Filters.eq((String)"tournamentCode", (Object)matches.getTournamentCode())}));
    }

    @Put(value=VerificationString.class)
    public void putVerificationString(VerificationString string, PipelineContext context) {
        this.upsert(VerificationString.class, string, Filters.and((Bson[])new Bson[]{Filters.eq((String)"platform", (Object)string.getPlatform()), Filters.eq((String)"summonerId", (Object)string.getSummonerId())}));
    }

    @Put(value=Versions.class)
    public void putVersions(Versions versions, PipelineContext context) {
        this.upsert(com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.Versions.class, com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata.Versions.convert(versions), Filters.eq((String)"platform", (Object)versions.getPlatform()));
    }

    public static class Configuration
    extends MongoDBDataStore.Configuration {
        private static final Long DEFAULT_ETERNAL_PERIOD = -1L;
        private static final TimeUnit DEFAULT_ETERNAL_UNIT = TimeUnit.DAYS;
        private static final Map<String, ExpirationPeriod> DEFAULT_EXPIRATION_PERIODS = ImmutableMap.builder().put((Object)Champion.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)6L, (TimeUnit)TimeUnit.HOURS)).put((Object)com.merakianalytics.orianna.types.dto.champion.ChampionList.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)6L, (TimeUnit)TimeUnit.HOURS)).put((Object)ChampionMastery.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)2L, (TimeUnit)TimeUnit.HOURS)).put((Object)ChampionMasteries.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)2L, (TimeUnit)TimeUnit.HOURS)).put((Object)ChampionMasteryScore.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)2L, (TimeUnit)TimeUnit.HOURS)).put((Object)LeagueList.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)30L, (TimeUnit)TimeUnit.MINUTES)).put((Object)SummonerPositions.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)2L, (TimeUnit)TimeUnit.HOURS)).put((Object)Match.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)MatchTimeline.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)com.merakianalytics.orianna.types.dto.match.TournamentMatches.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)CurrentGameInfo.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)5L, (TimeUnit)TimeUnit.MINUTES)).put((Object)FeaturedGames.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)5L, (TimeUnit)TimeUnit.MINUTES)).put((Object)com.merakianalytics.orianna.types.dto.staticdata.Champion.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)ChampionList.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)Item.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)com.merakianalytics.orianna.types.dto.staticdata.ItemList.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)com.merakianalytics.orianna.types.dto.staticdata.Languages.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)6L, (TimeUnit)TimeUnit.HOURS)).put((Object)LanguageStrings.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)com.merakianalytics.orianna.types.dto.staticdata.MapData.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)MapDetails.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)Mastery.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)com.merakianalytics.orianna.types.dto.staticdata.MasteryList.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)ProfileIconData.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)ProfileIconDetails.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)ReforgedRune.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)ReforgedRuneTree.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)Realm.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)6L, (TimeUnit)TimeUnit.HOURS)).put((Object)Rune.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)RuneList.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)SummonerSpell.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)com.merakianalytics.orianna.types.dto.staticdata.SummonerSpellList.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)DEFAULT_ETERNAL_PERIOD, (TimeUnit)DEFAULT_ETERNAL_UNIT)).put((Object)Versions.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)6L, (TimeUnit)TimeUnit.HOURS)).put((Object)ShardStatus.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)15L, (TimeUnit)TimeUnit.MINUTES)).put((Object)Summoner.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)1L, (TimeUnit)TimeUnit.DAYS)).put((Object)VerificationString.class.getCanonicalName(), (Object)ExpirationPeriod.create((long)5L, (TimeUnit)TimeUnit.MINUTES)).build();
        private Map<String, ExpirationPeriod> expirationPeriods = DEFAULT_EXPIRATION_PERIODS;

        public Map<String, ExpirationPeriod> getExpirationPeriods() {
            return this.expirationPeriods;
        }

        public void setExpirationPeriods(Map<String, ExpirationPeriod> expirationPeriods) {
            this.expirationPeriods = expirationPeriods;
        }
    }
}

