/*
 * Decompiled with CFR 0.152.
 */
package com.merakianalytics.orianna.datastores.mongo.proxies.dto.league;

import com.merakianalytics.orianna.types.common.OriannaException;
import com.merakianalytics.orianna.types.dto.DataObject;
import com.merakianalytics.orianna.types.dto.league.LeaguePosition;
import java.lang.reflect.Field;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummonerPositions {
    private static final Field DATA = SummonerPositions.getDataField();
    private static Logger LOGGER = LoggerFactory.getLogger(SummonerPositions.class);
    private Set<LeaguePosition> data;
    private String platform;
    private long summonerId;

    public static SummonerPositions convert(com.merakianalytics.orianna.types.dto.league.SummonerPositions positions) {
        SummonerPositions proxy = new SummonerPositions();
        proxy.setPlatform(positions.getPlatform());
        proxy.setSummonerId(positions.getSummonerId());
        try {
            proxy.setData((Set)DATA.get(positions));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOGGER.error("Failed to get data from SummonerPositions! Report this to the orianna team!", (Throwable)e);
            throw new OriannaException("Failed to get data from SummonerPositions! Report this to the orianna team!", (Throwable)e);
        }
        return proxy;
    }

    private static Field getDataField() {
        try {
            Field data = DataObject.SetProxy.class.getDeclaredField("data");
            data.setAccessible(true);
            return data;
        }
        catch (NoSuchFieldException | SecurityException e) {
            LOGGER.error("Couldn't get SetProxy data field! Report this to the orianna team!", (Throwable)e);
            throw new OriannaException("Couldn't get SetProxy data field! Report this to the orianna team!", (Throwable)e);
        }
    }

    public com.merakianalytics.orianna.types.dto.league.SummonerPositions convert() {
        com.merakianalytics.orianna.types.dto.league.SummonerPositions positions = new com.merakianalytics.orianna.types.dto.league.SummonerPositions();
        positions.setPlatform(this.platform);
        positions.setSummonerId(this.summonerId);
        try {
            DATA.set(positions, this.data);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOGGER.error("Failed to set data on SummonerPositions! Report this to the orianna team!", (Throwable)e);
            throw new OriannaException("Failed to set data on SummonerPositions! Report this to the orianna team!", (Throwable)e);
        }
        return positions;
    }

    public Set<LeaguePosition> getData() {
        return this.data;
    }

    public String getPlatform() {
        return this.platform;
    }

    public long getSummonerId() {
        return this.summonerId;
    }

    public void setData(Set<LeaguePosition> data) {
        this.data = data;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setSummonerId(long summonerId) {
        this.summonerId = summonerId;
    }
}

