/*
 * Decompiled with CFR 0.152.
 */
package com.merakianalytics.orianna.datastores.mongo.proxies.dto.staticdata;

import com.merakianalytics.orianna.types.common.OriannaException;
import com.merakianalytics.orianna.types.dto.DataObject;
import com.merakianalytics.orianna.types.dto.staticdata.ReforgedRunePath;
import com.merakianalytics.orianna.types.dto.staticdata.ReforgedRuneSlot;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReforgedRuneTree {
    private static final Field DATA = ReforgedRuneTree.getDataField();
    private static Logger LOGGER = LoggerFactory.getLogger(ReforgedRuneTree.class);
    private List<ReforgedRunePath> data;
    private String platform;
    private String version;
    private String locale;

    public static ReforgedRuneTree convert(com.merakianalytics.orianna.types.dto.staticdata.ReforgedRuneTree tree) {
        ReforgedRuneTree proxy = new ReforgedRuneTree();
        try {
            proxy.setData(new ArrayList<ReforgedRunePath>((List)DATA.get(tree)));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOGGER.error("Failed to get data from ReforgedRuneTree! Report this to the orianna team!", (Throwable)e);
            throw new OriannaException("Failed to get data from ReforgedRuneTree! Report this to the orianna team!", (Throwable)e);
        }
        for (int i = 0; i < proxy.getData().size(); ++i) {
            ReforgedRunePath path = proxy.getData().get(i);
            ReforgedRunePath newPath = new ReforgedRunePath();
            proxy.getData().set(i, newPath);
            newPath.setIcon(path.getIcon());
            newPath.setId(path.getId());
            newPath.setKey(path.getKey());
            newPath.setName(path.getName());
            newPath.setSlots(new ArrayList(path.getSlots()));
            for (int j = 0; j < newPath.getSlots().size(); ++j) {
                ReforgedRuneSlot newSlot = new ReforgedRuneSlot();
                newPath.getSlots().set(j, newSlot);
                newSlot.setRunes(new ArrayList(0));
            }
        }
        proxy.setPlatform(tree.getPlatform());
        proxy.setLocale(tree.getLocale());
        proxy.setVersion(tree.getVersion());
        return proxy;
    }

    private static Field getDataField() {
        try {
            Field data = DataObject.ListProxy.class.getDeclaredField("data");
            data.setAccessible(true);
            return data;
        }
        catch (NoSuchFieldException | SecurityException e) {
            LOGGER.error("Couldn't get ListProxy data field! Report this to the orianna team!", (Throwable)e);
            throw new OriannaException("Couldn't get ListProxy data field! Report this to the orianna team!", (Throwable)e);
        }
    }

    public com.merakianalytics.orianna.types.dto.staticdata.ReforgedRuneTree convert() {
        com.merakianalytics.orianna.types.dto.staticdata.ReforgedRuneTree tree = new com.merakianalytics.orianna.types.dto.staticdata.ReforgedRuneTree(0);
        try {
            DATA.set(tree, this.data);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOGGER.error("Failed to set data on ReforgedRuneTree! Report this to the orianna team!", (Throwable)e);
            throw new OriannaException("Failed to set data on ReforgedRuneTree! Report this to the orianna team!", (Throwable)e);
        }
        tree.setPlatform(this.platform);
        tree.setLocale(this.locale);
        tree.setVersion(this.version);
        return tree;
    }

    public List<ReforgedRunePath> getData() {
        return this.data;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getVersion() {
        return this.version;
    }

    public void setData(List<ReforgedRunePath> data) {
        this.data = data;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

