/*
 * Decompiled with CFR 0.152.
 */
package com.mercateo.test.clock;

import java.time.Clock;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAmount;
import lombok.NonNull;

public class TestClock
extends Clock {
    private Instant instant;
    private final ZoneId zone;

    @Override
    public ZoneId getZone() {
        return this.zone;
    }

    @Override
    public Clock withZone(@NonNull ZoneId zone) {
        if (zone == null) {
            throw new NullPointerException("zone is marked non-null but is null");
        }
        return new TestClock(this.instant, zone);
    }

    @Override
    public Instant instant() {
        return this.instant;
    }

    public void fastForward(@NonNull TemporalAmount temporalAmount) {
        if (temporalAmount == null) {
            throw new NullPointerException("temporalAmount is marked non-null but is null");
        }
        this.set(this.instant().plus(temporalAmount));
    }

    public void rewind(@NonNull TemporalAmount temporalAmount) {
        if (temporalAmount == null) {
            throw new NullPointerException("temporalAmount is marked non-null but is null");
        }
        this.set(this.instant().minus(temporalAmount));
    }

    public void set(@NonNull Instant instant) {
        if (instant == null) {
            throw new NullPointerException("instant is marked non-null but is null");
        }
        this.instant = instant;
    }

    public static TestClock fixed(@NonNull Instant instant, @NonNull ZoneId zone) {
        if (instant == null) {
            throw new NullPointerException("instant is marked non-null but is null");
        }
        if (zone == null) {
            throw new NullPointerException("zone is marked non-null but is null");
        }
        return new TestClock(instant, zone);
    }

    public static TestClock fixed(@NonNull OffsetDateTime odt) {
        if (odt == null) {
            throw new NullPointerException("odt is marked non-null but is null");
        }
        return TestClock.fixed(odt.toInstant(), odt.getOffset());
    }

    private TestClock(Instant instant, ZoneId zone) {
        this.instant = instant;
        this.zone = zone;
    }
}

