package com.mercury.sqkon.db

import app.cash.sqldelight.SuspendingTransacter
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlDriver
import app.cash.sqldelight.db.SqlSchema
import com.mercury.sqkon.db.library.newInstance
import com.mercury.sqkon.db.library.schema
import kotlin.Unit

public interface SqkonDatabase : SuspendingTransacter {
  public companion object {
    public val Schema: SqlSchema<QueryResult.AsyncValue<Unit>>
      get() = SqkonDatabase::class.schema

    public operator fun invoke(driver: SqlDriver): SqkonDatabase =
        SqkonDatabase::class.newInstance(driver)
  }
}
