package com.mercury.sqkon.db.library

import app.cash.sqldelight.SuspendingTransacterImpl
import app.cash.sqldelight.db.AfterVersion
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlDriver
import app.cash.sqldelight.db.SqlSchema
import com.mercury.sqkon.db.SqkonDatabase
import kotlin.Long
import kotlin.Unit
import kotlin.reflect.KClass

internal val KClass<SqkonDatabase>.schema: SqlSchema<QueryResult.AsyncValue<Unit>>
  get() = SqkonDatabaseImpl.Schema

internal fun KClass<SqkonDatabase>.newInstance(driver: SqlDriver): SqkonDatabase =
    SqkonDatabaseImpl(driver)

private class SqkonDatabaseImpl(
  driver: SqlDriver,
) : SuspendingTransacterImpl(driver), SqkonDatabase {
  public object Schema : SqlSchema<QueryResult.AsyncValue<Unit>> {
    override val version: Long
      get() = 1

    override fun create(driver: SqlDriver): QueryResult.AsyncValue<Unit> = QueryResult.AsyncValue {
      driver.execute(null, """
          |CREATE TABLE entity (
          |    entity_name TEXT NOT NULL,
          |    entity_key TEXT NOT NULL,
          |    -- UTC timestamp in milliseconds
          |    added_at INTEGER NOT NULL DEFAULT CURRENT_TIMESTAMP,
          |    -- UTC timestamp in milliseconds
          |    updated_at INTEGER NOT NULL DEFAULT CURRENT_TIMESTAMP,
          |    -- UTC timestamp in milliseconds
          |    expires_at INTEGER,
          |    -- JSONB Blob use jsonb_ operators
          |    value BLOB NOT NULL,
          |    PRIMARY KEY (entity_name, entity_key)
          |)
          """.trimMargin(), 0).await()
    }

    override fun migrate(
      driver: SqlDriver,
      oldVersion: Long,
      newVersion: Long,
      vararg callbacks: AfterVersion,
    ): QueryResult.AsyncValue<Unit> = QueryResult.AsyncValue {
    }
  }
}
