package com.mercury.sqkon.db

import app.cash.sqldelight.Transacter
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlDriver
import app.cash.sqldelight.db.SqlSchema
import com.mercury.sqkon.db.library.newInstance
import com.mercury.sqkon.db.library.schema
import kotlin.Unit

public interface SqkonDatabase : Transacter {
  public val metadataQueries: MetadataQueries

  public companion object {
    public val Schema: SqlSchema<QueryResult.Value<Unit>>
      get() = SqkonDatabase::class.schema

    public operator fun invoke(driver: SqlDriver, metadataAdapter: Metadata.Adapter): SqkonDatabase
        = SqkonDatabase::class.newInstance(driver, metadataAdapter)
  }
}
