/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.datavisualization.chart.options;

import com.google.gson.JsonElement;
import com.grapecity.datavisualization.chart.common.deserialization.IJsonDeserializerContext;
import com.grapecity.datavisualization.chart.common.deserialization.c;
import com.grapecity.datavisualization.chart.common.errors.ErrorCode;
import com.grapecity.datavisualization.chart.component.core.utilities.h;
import com.grapecity.datavisualization.chart.core.drawing.colors.utilities.a;
import com.grapecity.datavisualization.chart.enums.ColorOptionType;
import com.grapecity.datavisualization.chart.enums.GradientExtentKeyword;
import com.grapecity.datavisualization.chart.enums.GradientPositionKeyword;
import com.grapecity.datavisualization.chart.enums.GradientSideOrCorner;
import com.grapecity.datavisualization.chart.options.ColorOptionFactory;
import com.grapecity.datavisualization.chart.options.ColorStopOption;
import com.grapecity.datavisualization.chart.options.CssColorOption;
import com.grapecity.datavisualization.chart.options.GradientPositionOption;
import com.grapecity.datavisualization.chart.options.IColorOption;
import com.grapecity.datavisualization.chart.options.IColorStopOption;
import com.grapecity.datavisualization.chart.options.ICssColorOption;
import com.grapecity.datavisualization.chart.options.IGradientPositionOption;
import com.grapecity.datavisualization.chart.options.ILinearGradientOption;
import com.grapecity.datavisualization.chart.options.IRadialGradientOption;
import com.grapecity.datavisualization.chart.options.LinearGradientOption;
import com.grapecity.datavisualization.chart.options.OptionError;
import com.grapecity.datavisualization.chart.options.PatternOption;
import com.grapecity.datavisualization.chart.options.RadialGradientOption;
import com.grapecity.datavisualization.chart.options.deserialization.LinearGradientAngleOptionConverter;
import com.grapecity.datavisualization.chart.typescript.b;
import com.grapecity.datavisualization.chart.typescript.f;
import com.grapecity.datavisualization.chart.typescript.k;
import com.grapecity.datavisualization.chart.typescript.l;
import com.grapecity.datavisualization.chart.typescript.m;
import com.grapecity.datavisualization.chart.typescript.n;
import java.util.ArrayList;

public class ColorOptionConverterUtility {
    public static IColorOption _toColorOptionFromString(String string) {
        return ColorOptionConverterUtility._toColorOptionFromString(string, null);
    }

    public static IColorOption _toColorOptionFromString(String string, IJsonDeserializerContext iJsonDeserializerContext) {
        ICssColorOption iCssColorOption;
        if (iJsonDeserializerContext == null) {
            iJsonDeserializerContext = new com.grapecity.datavisualization.chart.common.deserialization.a();
        }
        if ((iCssColorOption = ColorOptionConverterUtility.a(string = string.trim(), iJsonDeserializerContext)) != null) {
            return iCssColorOption;
        }
        ILinearGradientOption iLinearGradientOption = ColorOptionConverterUtility.b(string, iJsonDeserializerContext);
        if (iLinearGradientOption != null) {
            return iLinearGradientOption;
        }
        IRadialGradientOption iRadialGradientOption = ColorOptionConverterUtility.c(string, iJsonDeserializerContext);
        if (iRadialGradientOption != null) {
            return iRadialGradientOption;
        }
        return null;
    }

    public static IColorOption _toColorOptionFromObject(JsonElement jsonElement, IJsonDeserializerContext iJsonDeserializerContext) {
        if (c.b(jsonElement, "type")) {
            JsonElement jsonElement2 = c.a(jsonElement, "type");
            if (c.g(jsonElement2)) {
                return null;
            }
            Integer n2 = com.grapecity.datavisualization.chart.common.extensions.a.a(jsonElement2, ColorOptionType.class);
            if (n2 != null) {
                ColorOptionType colorOptionType = com.grapecity.datavisualization.chart.common.extensions.b.b(n2, ColorOptionType.class);
                if (colorOptionType == ColorOptionType.Linear) {
                    return com.grapecity.datavisualization.chart.component.options.utilities.a.a(new LinearGradientOption(null, iJsonDeserializerContext.get_strictMode()), jsonElement, iJsonDeserializerContext);
                }
                if (colorOptionType == ColorOptionType.Radial) {
                    return com.grapecity.datavisualization.chart.component.options.utilities.a.a(new RadialGradientOption(null, iJsonDeserializerContext.get_strictMode()), jsonElement, iJsonDeserializerContext);
                }
                if (colorOptionType == ColorOptionType.Pattern) {
                    return com.grapecity.datavisualization.chart.component.options.utilities.a.a(new PatternOption(null, iJsonDeserializerContext.get_strictMode()), jsonElement, iJsonDeserializerContext);
                }
                if (colorOptionType == ColorOptionType.CssColor) {
                    return com.grapecity.datavisualization.chart.component.options.utilities.a.a(new CssColorOption(null, iJsonDeserializerContext.get_strictMode()), jsonElement, iJsonDeserializerContext);
                }
            }
            if (iJsonDeserializerContext.get_strictMode() != null && iJsonDeserializerContext.get_strictMode().booleanValue()) {
                throw new OptionError(ErrorCode.UnexpectedValue, jsonElement2);
            }
            return null;
        }
        if (c.b(jsonElement, "pattern")) {
            return com.grapecity.datavisualization.chart.component.options.utilities.a.a(new PatternOption(null, iJsonDeserializerContext.get_strictMode()), jsonElement, iJsonDeserializerContext);
        }
        if (c.b(jsonElement, "color")) {
            return com.grapecity.datavisualization.chart.component.options.utilities.a.a(new CssColorOption(null, iJsonDeserializerContext.get_strictMode()), jsonElement, iJsonDeserializerContext);
        }
        return null;
    }

    public static IColorStopOption _toColorStopOptionFromString(String string, IJsonDeserializerContext iJsonDeserializerContext) {
        double d2 = (string = string.trim()).lastIndexOf(" ");
        if (d2 == -1.0) {
            String string2 = a.a(string);
            if (string2 != null) {
                ColorStopOption colorStopOption = new ColorStopOption(null, iJsonDeserializerContext.get_strictMode());
                colorStopOption.setColor(string2);
                colorStopOption.setStop(null);
                return colorStopOption;
            }
        } else {
            String string3 = a.a(m.c(string, 0.0, d2).trim());
            if (string3 != null) {
                String string4 = m.e(string, d2 + 1.0);
                if (n.a(string4, "===", "%")) {
                    ColorStopOption colorStopOption = new ColorStopOption(null, iJsonDeserializerContext.get_strictMode());
                    colorStopOption.setColor(string3);
                    colorStopOption.setStop(null);
                    return colorStopOption;
                }
                if (n.a(m.a(string4, (double)(string4.length() - 1)), "==", "%")) {
                    String string5 = m.c(string4, 0.0, string4.length() - 1);
                    double d3 = f.b(string5);
                    if (!f.b(d3)) {
                        ColorStopOption colorStopOption = new ColorStopOption(null, iJsonDeserializerContext.get_strictMode());
                        colorStopOption.setColor(string3);
                        colorStopOption.setStop(d3 / 100.0);
                        return colorStopOption;
                    }
                } else {
                    double d4 = f.b(string4);
                    if (!f.b(d4)) {
                        ColorStopOption colorStopOption = new ColorStopOption(null, iJsonDeserializerContext.get_strictMode());
                        colorStopOption.setColor(string3);
                        colorStopOption.setStop(d4);
                        return colorStopOption;
                    }
                }
            }
        }
        return null;
    }

    private static ICssColorOption a(String string, IJsonDeserializerContext iJsonDeserializerContext) {
        if (string == null) {
            return null;
        }
        String string2 = h.a(string);
        if (string2 == null) {
            return null;
        }
        return ColorOptionFactory._buildCssColorOptionFromCss(string2);
    }

    private static ILinearGradientOption b(String string, IJsonDeserializerContext iJsonDeserializerContext) {
        l l2 = m.a(string, new k("^\\s*(\\w*-\\w*)\\((.*)\\)"));
        if (l2 == null) {
            return null;
        }
        if (n.a((String)l2.get(1), "!=", "linear-gradient")) {
            return null;
        }
        return ColorOptionConverterUtility.f((String)l2.get(2), iJsonDeserializerContext);
    }

    private static IRadialGradientOption c(String string, IJsonDeserializerContext iJsonDeserializerContext) {
        l l2 = m.a(string, new k("^\\s*(\\w*-\\w*)\\((.*)\\)"));
        if (l2 == null) {
            return null;
        }
        if (n.a((String)l2.get(1), "!=", "radial-gradient")) {
            return null;
        }
        return ColorOptionConverterUtility.d((String)l2.get(2), iJsonDeserializerContext);
    }

    private static IRadialGradientOption d(String string, IJsonDeserializerContext iJsonDeserializerContext) {
        RadialGradientOption radialGradientOption = new RadialGradientOption(null, iJsonDeserializerContext.get_strictMode());
        ArrayList<String> arrayList = m.b(string, new k(",(?![^()]*\\))"));
        String string2 = "\\s*((closest-side|closest-corner|farthest-side|farthest-corner)\\s+)?";
        String string3 = "(at(((\\s+([\\d.]+%|center|((left|right)(?!\\s+(left|right)))|((top|bottom)(?!\\s+(top|bottom))))){1,2})|((\\s+(((left|right)(?!\\s+[\\d.]+%\\s+(left|right))\\s+[\\d.]+%)|((top|bottom)(?!\\s+[\\d.]+%\\s+(top|bottom))\\s+[\\d.]+%))){2}))(?=\\s*\\,))?";
        l l2 = m.a(string, new k("\\s*((closest-side|closest-corner|farthest-side|farthest-corner)\\s+)?(at(((\\s+([\\d.]+%|center|((left|right)(?!\\s+(left|right)))|((top|bottom)(?!\\s+(top|bottom))))){1,2})|((\\s+(((left|right)(?!\\s+[\\d.]+%\\s+(left|right))\\s+[\\d.]+%)|((top|bottom)(?!\\s+[\\d.]+%\\s+(top|bottom))\\s+[\\d.]+%))){2}))(?=\\s*\\,))?"));
        if (l2 != null && (l2.get(2) != null || l2.get(4) != null)) {
            b.c(arrayList);
        }
        ArrayList<IColorStopOption> arrayList2 = new ArrayList<IColorStopOption>();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            IColorStopOption iColorStopOption = ColorOptionConverterUtility._toColorStopOptionFromString(arrayList.get(i2), iJsonDeserializerContext);
            if (iColorStopOption == null) continue;
            b.b(arrayList2, iColorStopOption);
        }
        radialGradientOption.setColorStops(arrayList2);
        if (l2 != null && l2.get(2) != null) {
            if (n.a((String)l2.get(2), "==", "closest-side")) {
                radialGradientOption.setExtentKeyword(GradientExtentKeyword.ClosestSide);
            } else if (n.a((String)l2.get(2), "==", "closest-corner")) {
                radialGradientOption.setExtentKeyword(GradientExtentKeyword.ClosestCorner);
            } else if (n.a((String)l2.get(2), "==", "farthest-side")) {
                radialGradientOption.setExtentKeyword(GradientExtentKeyword.FarthestSide);
            } else if (n.a((String)l2.get(2), "==", "farthest-corner")) {
                radialGradientOption.setExtentKeyword(GradientExtentKeyword.FarthestCorner);
            }
        }
        if (l2 != null && l2.get(4) != null) {
            radialGradientOption.setPosition(ColorOptionConverterUtility.e(((String)l2.get(4)).trim(), iJsonDeserializerContext));
        }
        return radialGradientOption;
    }

    private static ArrayList<IGradientPositionOption> e(String string, IJsonDeserializerContext iJsonDeserializerContext) {
        GradientPositionOption gradientPositionOption = new GradientPositionOption(null, iJsonDeserializerContext.get_strictMode());
        gradientPositionOption.setKeyword(GradientPositionKeyword.Left);
        gradientPositionOption.setOffset(0.5);
        GradientPositionOption gradientPositionOption2 = new GradientPositionOption(null, iJsonDeserializerContext.get_strictMode());
        gradientPositionOption2.setKeyword(GradientPositionKeyword.Top);
        gradientPositionOption2.setOffset(0.5);
        ArrayList<String> arrayList = m.b(string, new k("\\s+"));
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            double d2;
            String string2 = arrayList.get(i2);
            if (m.c(string2, "%") == (double)(string2.length() - 1) && !f.b(d2 = f.a((Object)(string2 = m.c(string2, 0.0, string2.length() - 1))) / 100.0)) {
                if (n2 == 1 || i2 == 0) {
                    gradientPositionOption.setKeyword(GradientPositionKeyword.Left);
                    gradientPositionOption.setOffset(d2);
                } else if (n2 == 2 && i2 == 1) {
                    if (n.a(arrayList.get(i2 - 1), "==", "top") || n.a(arrayList.get(i2 - 1), "==", "bottom")) {
                        gradientPositionOption.setOffset(d2);
                    } else {
                        gradientPositionOption2.setOffset(d2);
                    }
                } else if (n2 == 4) {
                    if (n.a(arrayList.get(i2 - 1), "==", "left") || n.a(arrayList.get(i2 - 1), "==", "right")) {
                        gradientPositionOption.setOffset(d2);
                    }
                    if (n.a(arrayList.get(i2 - 1), "==", "top") || n.a(arrayList.get(i2 - 1), "==", "bottom")) {
                        gradientPositionOption2.setOffset(d2);
                    }
                }
            }
            if (n.a(string2, "==", "top")) {
                gradientPositionOption2.setKeyword(GradientPositionKeyword.Top);
                gradientPositionOption2.setOffset(0.0);
                continue;
            }
            if (n.a(string2, "==", "bottom")) {
                gradientPositionOption2.setKeyword(GradientPositionKeyword.Bottom);
                gradientPositionOption2.setOffset(0.0);
                continue;
            }
            if (n.a(string2, "==", "left")) {
                gradientPositionOption.setKeyword(GradientPositionKeyword.Left);
                gradientPositionOption.setOffset(0.0);
                continue;
            }
            if (!n.a(string2, "==", "right")) continue;
            gradientPositionOption.setKeyword(GradientPositionKeyword.Right);
            gradientPositionOption.setOffset(0.0);
        }
        return new ArrayList<IGradientPositionOption>(com.grapecity.datavisualization.chart.typescript.a.a(gradientPositionOption, gradientPositionOption2));
    }

    private static ILinearGradientOption f(String string, IJsonDeserializerContext iJsonDeserializerContext) {
        Object object;
        ArrayList<String> arrayList;
        LinearGradientOption linearGradientOption = new LinearGradientOption(null, iJsonDeserializerContext.get_strictMode());
        ArrayList<String> arrayList2 = arrayList = m.b(string, new k(",(?![^()]*\\))"));
        if (n.a(m.c(arrayList.get(0), 0.0, 2.0), "==", "to")) {
            object = arrayList.get(0).toLowerCase();
            ArrayList<String> arrayList3 = m.b((String)object, " ");
            String string2 = "";
            for (int i2 = 0; i2 < arrayList3.size(); ++i2) {
                string2 = string2 + m.b(arrayList3.get(i2), 0.0, 1.0).toUpperCase() + m.d(arrayList3.get(i2), 1.0);
            }
            arrayList.set(0, string2);
        }
        if (n.a(m.c(arrayList.get(0), 0.0, 2.0), "==", "To")) {
            object = com.grapecity.datavisualization.chart.common.extensions.a.a(arrayList.get(0), GradientSideOrCorner.class);
            if (object == null) {
                linearGradientOption.setAngle(0.0);
            } else {
                linearGradientOption.setAngle(LinearGradientAngleOptionConverter._toAngleFromGradientSideOrCorner(com.grapecity.datavisualization.chart.common.extensions.b.b((Integer)object, GradientSideOrCorner.class)));
            }
            arrayList2 = b.b(arrayList, 1.0);
        }
        if (m.c(arrayList.get(0), "deg") == (double)(arrayList.get(0).length() - 3)) {
            double d2 = f.a((Object)m.c(arrayList.get(0), 0.0, arrayList.get(0).length() - 3));
            if (!f.b(d2)) {
                linearGradientOption.setAngle(d2);
            }
            arrayList2 = b.b(arrayList, 1.0);
        }
        ArrayList<IColorStopOption> arrayList4 = new ArrayList<IColorStopOption>();
        for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
            b.b(arrayList4, ColorOptionConverterUtility._toColorStopOptionFromString(arrayList2.get(i3), iJsonDeserializerContext));
        }
        linearGradientOption.setColorStops(arrayList4);
        return linearGradientOption;
    }
}

