/*
 * Decompiled with CFR 0.152.
 */
package com.mesosphere.mesos.rx.java.util;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    @NotNull
    public static <T, R> List<R> listMap(@NotNull List<T> input, @NotNull Function<T, R> mapper) {
        return input.stream().map(mapper).collect(Collectors.toList());
    }

    public static boolean deepEquals(@NotNull List<byte[]> a, @NotNull List<byte[]> b) {
        if (a == b) {
            return true;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (Arrays.equals(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }
}

