/*
 * Decompiled with CFR 0.152.
 */
package com.mesosphere.mesos.rx.java.util;

import com.mesosphere.mesos.rx.java.util.UserAgentEntry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class UserAgent {
    @NotNull
    private final List<UserAgentEntry> entries;
    @NotNull
    private final String toStringValue;

    @SafeVarargs
    public UserAgent(Function<Class<?>, UserAgentEntry> ... entries) {
        this.entries = Collections.unmodifiableList(Arrays.asList(entries).stream().map(f -> (UserAgentEntry)f.apply(this.getClass())).collect(Collectors.toList()));
        this.toStringValue = this.entries.stream().map(UserAgentEntry::toString).collect(Collectors.joining(" "));
    }

    @NotNull
    public List<UserAgentEntry> getEntries() {
        return this.entries;
    }

    public String toString() {
        return this.toStringValue;
    }
}

