/*
 * Decompiled with CFR 0.152.
 */
package com.mesosphere.mesos.rx.java.util;

import com.mesosphere.mesos.rx.java.util.UserAgentEntry;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UserAgentEntries {
    private UserAgentEntries() {
    }

    @NotNull
    public static Function<Class<?>, UserAgentEntry> literal(@NotNull String name, @NotNull String version) {
        return c -> new UserAgentEntry(name, version);
    }

    @NotNull
    public static Function<Class<?>, UserAgentEntry> literal(@NotNull String name, @NotNull String version, @Nullable String details) {
        return c -> new UserAgentEntry(name, version, details);
    }

    @NotNull
    public static Function<Class<?>, UserAgentEntry> userAgentEntryForGradleArtifact(@NotNull String artifactId) {
        return c -> {
            Properties props = UserAgentEntries.loadProperties(c, String.format("/META-INF/%s.properties", artifactId));
            return new UserAgentEntry(props.getProperty("artifactId", artifactId), props.getProperty("Implementation-Version", "unknown-version"));
        };
    }

    @NotNull
    public static Function<Class<?>, UserAgentEntry> userAgentEntryForMavenArtifact(@NotNull String groupId, @NotNull String artifactId) {
        return c -> {
            Properties props = UserAgentEntries.loadProperties(c, String.format("/META-INF/maven/%s/%s/pom.properties", groupId, artifactId));
            return new UserAgentEntry(props.getProperty("artifactId", artifactId), props.getProperty("version", "unknown-version"));
        };
    }

    @NotNull
    private static Properties loadProperties(@NotNull Class c, @NotNull String resourcePath) {
        Properties props = new Properties();
        try {
            InputStream resourceAsStream = c.getResourceAsStream(resourcePath);
            if (resourceAsStream != null) {
                props.load(resourceAsStream);
                resourceAsStream.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load classpath resource " + resourcePath, e);
        }
        return props;
    }
}

