/*
 * Decompiled with CFR 0.152.
 */
package com.mesosphere.mesos.rx.java.util;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UserAgentEntry {
    @NotNull
    private final String name;
    @NotNull
    private final String version;
    @Nullable
    private final String details;

    public UserAgentEntry(@NotNull String name, @NotNull String version) {
        this(name, version, null);
    }

    public UserAgentEntry(@NotNull String name, @NotNull String version, @Nullable String details) {
        this.name = name;
        this.version = version;
        this.details = details;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getDetails() {
        return this.details;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAgentEntry that = (UserAgentEntry)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.details, that.details);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.details);
    }

    public String toString() {
        if (this.details != null) {
            return String.format("%s/%s (%s)", this.name, this.version, this.details);
        }
        return String.format("%s/%s", this.name, this.version);
    }
}

