/*
 * Decompiled with CFR 0.152.
 */
package com.messagebird;

public class APIResponse {
    private static final int STATUS_OK = 200;
    private static final int STATUS_NO_CONTENT = 204;
    private static final int STATUS_RANGE_SUCCESS_START = 200;
    private static final int STATUS_RANGE_SUCCESS_END = 299;
    private final String body;
    private final int status;

    APIResponse(String body, int status) {
        this.body = body;
        this.status = status;
    }

    APIResponse(String body) {
        this(body, 200);
    }

    static boolean isSuccessStatus(int status) {
        return status >= 200 && status <= 299;
    }

    public boolean isSuccess() {
        return APIResponse.isSuccessStatus(this.status);
    }

    public boolean hasContent() {
        return this.status == 204 || this.body == null || this.body.isEmpty();
    }

    public String getBody() {
        return this.body;
    }

    public int getStatus() {
        return this.status;
    }
}

