/*
 * Decompiled with CFR 0.152.
 */
package com.messagebird;

import com.messagebird.MessageBirdService;
import com.messagebird.exceptions.GeneralException;
import com.messagebird.exceptions.NotFoundException;
import com.messagebird.exceptions.UnauthorizedException;
import com.messagebird.objects.Balance;
import com.messagebird.objects.ChildAccountCreateResponse;
import com.messagebird.objects.ChildAccountDetailedResponse;
import com.messagebird.objects.ChildAccountRequest;
import com.messagebird.objects.ChildAccountResponse;
import com.messagebird.objects.Contact;
import com.messagebird.objects.ContactList;
import com.messagebird.objects.ContactRequest;
import com.messagebird.objects.ErrorReport;
import com.messagebird.objects.FileUploadResponse;
import com.messagebird.objects.Group;
import com.messagebird.objects.GroupList;
import com.messagebird.objects.GroupRequest;
import com.messagebird.objects.Hlr;
import com.messagebird.objects.Lookup;
import com.messagebird.objects.LookupHlr;
import com.messagebird.objects.Message;
import com.messagebird.objects.MessageList;
import com.messagebird.objects.MessageResponse;
import com.messagebird.objects.MsgType;
import com.messagebird.objects.PagedPaging;
import com.messagebird.objects.PhoneNumbersLookup;
import com.messagebird.objects.PhoneNumbersResponse;
import com.messagebird.objects.PurchasedNumber;
import com.messagebird.objects.PurchasedNumberCreatedResponse;
import com.messagebird.objects.PurchasedNumbersFilter;
import com.messagebird.objects.PurchasedNumbersResponse;
import com.messagebird.objects.Verify;
import com.messagebird.objects.VerifyMessage;
import com.messagebird.objects.VerifyRequest;
import com.messagebird.objects.VoiceMessage;
import com.messagebird.objects.VoiceMessageList;
import com.messagebird.objects.VoiceMessageResponse;
import com.messagebird.objects.conversations.Conversation;
import com.messagebird.objects.conversations.ConversationList;
import com.messagebird.objects.conversations.ConversationMessage;
import com.messagebird.objects.conversations.ConversationMessageList;
import com.messagebird.objects.conversations.ConversationMessageRequest;
import com.messagebird.objects.conversations.ConversationSendRequest;
import com.messagebird.objects.conversations.ConversationSendResponse;
import com.messagebird.objects.conversations.ConversationStartRequest;
import com.messagebird.objects.conversations.ConversationStatus;
import com.messagebird.objects.conversations.ConversationUpdateRequest;
import com.messagebird.objects.conversations.ConversationWebhook;
import com.messagebird.objects.conversations.ConversationWebhookCreateRequest;
import com.messagebird.objects.conversations.ConversationWebhookList;
import com.messagebird.objects.conversations.ConversationWebhookUpdateRequest;
import com.messagebird.objects.integrations.Template;
import com.messagebird.objects.integrations.TemplateList;
import com.messagebird.objects.integrations.TemplateResponse;
import com.messagebird.objects.voicecalls.RecordingResponse;
import com.messagebird.objects.voicecalls.TranscriptionResponse;
import com.messagebird.objects.voicecalls.VoiceCall;
import com.messagebird.objects.voicecalls.VoiceCallFlowList;
import com.messagebird.objects.voicecalls.VoiceCallFlowRequest;
import com.messagebird.objects.voicecalls.VoiceCallFlowResponse;
import com.messagebird.objects.voicecalls.VoiceCallLeg;
import com.messagebird.objects.voicecalls.VoiceCallLegResponse;
import com.messagebird.objects.voicecalls.VoiceCallResponse;
import com.messagebird.objects.voicecalls.VoiceCallResponseList;
import com.messagebird.objects.voicecalls.Webhook;
import com.messagebird.objects.voicecalls.WebhookList;
import com.messagebird.objects.voicecalls.WebhookResponseData;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class MessageBirdClient {
    static final String CONVERSATIONS_BASE_URL = "https://conversations.messagebird.com/v1";
    static final String VOICE_CALLS_BASE_URL = "https://voice.messagebird.com";
    static final String NUMBERS_CALLS_BASE_URL = "https://numbers.messagebird.com/v1";
    static final String MESSAGING_BASE_URL = "https://messaging.messagebird.com/v1";
    static final String INTEGRATIONS_BASE_URL_V2 = "https://integrations.messagebird.com/v2";
    static final String INTEGRATIONS_BASE_URL_V3 = "https://integrations.messagebird.com/v3";
    private static String[] supportedLanguages = new String[]{"de-DE", "en-AU", "en-UK", "en-US", "es-ES", "es-LA", "fr-FR", "it-IT", "nl-NL", "pt-BR"};
    static final String PARTNER_ACCOUNTS_BASE_URL = "https://partner-accounts.messagebird.com";
    private static final String BALANCEPATH = "/balance";
    private static final String CONTACTPATH = "/contacts";
    private static final String GROUPPATH = "/groups";
    private static final String HLRPATH = "/hlr";
    private static final String LOOKUPHLRPATH = "/lookup/%s/hlr";
    private static final String LOOKUPPATH = "/lookup";
    private static final String MESSAGESPATH = "/messages";
    private static final String VERIFYPATH = "/verify";
    private static final String VERIFYEMAILPATH = "/verify/messages/email";
    private static final String VOICEMESSAGESPATH = "/voicemessages";
    static final String CONVERSATION_PATH = "/conversations";
    static final String CONVERSATION_SEND_PATH = "/send";
    static final String CONVERSATION_MESSAGE_PATH = "/messages";
    static final String CONVERSATION_WEBHOOK_PATH = "/webhooks";
    static final String INTEGRATIONS_WHATSAPP_PATH = "/platforms/whatsapp";
    static final String VOICECALLSPATH = "/calls";
    static final String LEGSPATH = "/legs";
    static final String RECORDINGPATH = "/recordings";
    static final String TRANSCRIPTIONPATH = "/transcriptions";
    static final String WEBHOOKS = "/webhooks";
    static final String VOICECALLFLOWPATH = "/call-flows";
    private static final String VOICELEGS_SUFFIX_PATH = "/legs";
    static final String FILES_PATH = "/files";
    static final String TEMPLATES_PATH = "/templates";
    static final String RECORDING_DOWNLOAD_FORMAT = ".wav";
    static final String TRANSCRIPTION_DOWNLOAD_FORMAT = ".txt";
    private static final int DEFAULT_MACHINE_TIMEOUT_VALUE = 7000;
    private static final int MIN_MACHINE_TIMEOUT_VALUE = 400;
    private static final int MAX_MACHINE_TIMEOUT_VALUE = 10000;
    private static final String[] MESSAGE_LIST_FILTERS_VALS = new String[]{"originator", "recipient", "direction", "searchterm", "type", "contact_id", "status", "from", "until"};
    private static final Set<String> MESSAGE_LIST_FILTERS = new HashSet<String>(Arrays.asList(MESSAGE_LIST_FILTERS_VALS));
    private static final String[] CONVERSATION_MESSAGE_LIST_FILTERS_VALS = new String[]{"ids", "from"};
    private static final Set<String> CONVERSATION_MESSAGE_LIST_FILTERS = new HashSet<String>(Arrays.asList(CONVERSATION_MESSAGE_LIST_FILTERS_VALS));
    private final String DOWNLOADS = "Downloads";
    private MessageBirdService messageBirdService;

    public MessageBirdClient(MessageBirdService messageBirdService) {
        this.messageBirdService = messageBirdService;
    }

    public Balance getBalance() throws GeneralException, UnauthorizedException, NotFoundException {
        return this.messageBirdService.requestByID(BALANCEPATH, "", Balance.class);
    }

    public Hlr getRequestHlr(BigInteger msisdn, String reference) throws GeneralException, UnauthorizedException {
        if (msisdn == null) {
            throw new IllegalArgumentException("msisdn must be specified.");
        }
        if (reference == null) {
            throw new IllegalArgumentException("Reference must be specified.");
        }
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("msisdn", msisdn);
        payload.put("reference", reference);
        return this.messageBirdService.sendPayLoad(HLRPATH, payload, Hlr.class);
    }

    public Hlr getViewHlr(String hlrId) throws GeneralException, UnauthorizedException, NotFoundException {
        if (hlrId == null) {
            throw new IllegalArgumentException("Hrl ID must be specified.");
        }
        return this.messageBirdService.requestByID(HLRPATH, hlrId, Hlr.class);
    }

    public MessageResponse sendMessage(Message message) throws UnauthorizedException, GeneralException {
        return this.messageBirdService.sendPayLoad("/messages", message, MessageResponse.class);
    }

    public MessageResponse sendMessage(String originator, String body, List<BigInteger> recipients) throws UnauthorizedException, GeneralException {
        return this.messageBirdService.sendPayLoad("/messages", new Message(originator, body, recipients), MessageResponse.class);
    }

    public MessageResponse sendMessage(String originator, String body, List<BigInteger> recipients, String reference) throws UnauthorizedException, GeneralException {
        Message message = new Message(originator, body, recipients);
        message.setReference(reference);
        return this.messageBirdService.sendPayLoad("/messages", message, MessageResponse.class);
    }

    public MessageResponse sendFlashMessage(String originator, String body, List<BigInteger> recipients) throws UnauthorizedException, GeneralException {
        Message message = new Message(originator, body, recipients);
        message.setType(MsgType.flash);
        return this.messageBirdService.sendPayLoad("/messages", message, MessageResponse.class);
    }

    public MessageResponse sendFlashMessage(String originator, String body, List<BigInteger> recipients, String reference) throws UnauthorizedException, GeneralException {
        Message message = new Message(originator, body, recipients);
        message.setType(MsgType.flash);
        message.setReference(reference);
        return this.messageBirdService.sendPayLoad("/messages", message, MessageResponse.class);
    }

    public MessageList listMessages(Integer offset, Integer limit) throws UnauthorizedException, GeneralException {
        this.verifyOffsetAndLimit(offset, limit);
        return this.messageBirdService.requestList("/messages", offset, limit, MessageList.class);
    }

    public MessageList listMessagesFiltered(Integer offset, Integer limit, Map<String, Object> filters) throws UnauthorizedException, GeneralException {
        this.verifyOffsetAndLimit(offset, limit);
        for (String filter : filters.keySet()) {
            if (MESSAGE_LIST_FILTERS.contains(filter)) continue;
            throw new IllegalArgumentException("Invalid filter name: " + filter);
        }
        return this.messageBirdService.requestList("/messages", filters, offset, limit, MessageList.class);
    }

    public void deleteMessage(String id) throws UnauthorizedException, GeneralException, NotFoundException {
        if (id == null) {
            throw new IllegalArgumentException("Message ID must be specified.");
        }
        this.messageBirdService.deleteByID("/messages", id);
    }

    public MessageResponse viewMessage(String id) throws UnauthorizedException, GeneralException, NotFoundException {
        if (id == null) {
            throw new IllegalArgumentException("Message ID must be specified.");
        }
        return this.messageBirdService.requestByID("/messages", id, MessageResponse.class);
    }

    public VoiceMessageResponse sendVoiceMessage(VoiceMessage voiceMessage) throws UnauthorizedException, GeneralException {
        this.addDefaultMachineTimeoutValueIfNotExists(voiceMessage);
        this.checkMachineTimeoutValueIsInRange(voiceMessage);
        return this.messageBirdService.sendPayLoad(VOICEMESSAGESPATH, voiceMessage, VoiceMessageResponse.class);
    }

    public VoiceMessageResponse sendVoiceMessage(String body, List<BigInteger> recipients) throws UnauthorizedException, GeneralException {
        VoiceMessage message = new VoiceMessage(body, recipients);
        this.addDefaultMachineTimeoutValueIfNotExists(message);
        this.checkMachineTimeoutValueIsInRange(message);
        return this.messageBirdService.sendPayLoad(VOICEMESSAGESPATH, message, VoiceMessageResponse.class);
    }

    public VoiceMessageResponse sendVoiceMessage(String body, List<BigInteger> recipients, String reference) throws UnauthorizedException, GeneralException {
        VoiceMessage message = new VoiceMessage(body, recipients);
        message.setReference(reference);
        this.addDefaultMachineTimeoutValueIfNotExists(message);
        this.checkMachineTimeoutValueIsInRange(message);
        return this.messageBirdService.sendPayLoad(VOICEMESSAGESPATH, message, VoiceMessageResponse.class);
    }

    private void addDefaultMachineTimeoutValueIfNotExists(VoiceMessage voiceMessage) {
        if (voiceMessage.getMachineTimeout() == 0) {
            voiceMessage.setMachineTimeout(7000);
        }
    }

    private void checkMachineTimeoutValueIsInRange(VoiceMessage voiceMessage) {
        if (voiceMessage.getMachineTimeout() < 400 || voiceMessage.getMachineTimeout() > 10000) {
            throw new IllegalArgumentException("Please define machine timeout value between 400 and 10000");
        }
    }

    public void deleteVoiceMessage(String id) throws UnauthorizedException, GeneralException, NotFoundException {
        if (id == null) {
            throw new IllegalArgumentException("Message ID must be specified.");
        }
        this.messageBirdService.deleteByID(VOICEMESSAGESPATH, id);
    }

    public VoiceMessageResponse viewVoiceMessage(String id) throws UnauthorizedException, GeneralException, NotFoundException {
        if (id == null) {
            throw new IllegalArgumentException("Voice Message ID must be specified.");
        }
        return this.messageBirdService.requestByID(VOICEMESSAGESPATH, id, VoiceMessageResponse.class);
    }

    public VoiceMessageList listVoiceMessages(Integer offset, Integer limit) throws UnauthorizedException, GeneralException {
        this.verifyOffsetAndLimit(offset, limit);
        return this.messageBirdService.requestList(VOICEMESSAGESPATH, offset, limit, VoiceMessageList.class);
    }

    public Verify sendVerifyToken(VerifyRequest verifyRequest) throws UnauthorizedException, GeneralException {
        if (verifyRequest == null) {
            throw new IllegalArgumentException("Verify request cannot be null");
        }
        if (verifyRequest.getRecipient() == null || verifyRequest.getRecipient().isEmpty()) {
            throw new IllegalArgumentException("Recipient cannot be empty for verify");
        }
        return this.messageBirdService.sendPayLoad(VERIFYPATH, verifyRequest, Verify.class);
    }

    public Verify sendVerifyToken(String recipient) throws UnauthorizedException, GeneralException {
        if (recipient == null || recipient.isEmpty()) {
            throw new IllegalArgumentException("Recipient cannot be empty for verify");
        }
        VerifyRequest verifyRequest = new VerifyRequest(recipient);
        return this.sendVerifyToken(verifyRequest);
    }

    public Verify verifyToken(String id, String token) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("ID cannot be empty for verify");
        }
        if (token == null || token.isEmpty()) {
            throw new IllegalArgumentException("ID cannot be empty for verify");
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("token", token);
        return this.messageBirdService.requestByID(VERIFYPATH, id, params, Verify.class);
    }

    Verify getVerifyObject(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("ID cannot be empty for verify");
        }
        return this.messageBirdService.requestByID(VERIFYPATH, id, Verify.class);
    }

    public VerifyMessage getVerifyEmailMessage(String messageId) throws UnauthorizedException, GeneralException, NotFoundException {
        if (messageId == null || messageId.isEmpty()) {
            throw new IllegalArgumentException("ID cannot be empty for verify email message");
        }
        return this.messageBirdService.requestByID(VERIFYEMAILPATH, messageId, VerifyMessage.class);
    }

    public void deleteVerifyObject(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("ID cannot be empty for verify");
        }
        this.messageBirdService.deleteByID(VERIFYPATH, id);
    }

    public Lookup viewLookup(Lookup lookup) throws UnauthorizedException, GeneralException, NotFoundException {
        if (lookup.getPhoneNumber() == null) {
            throw new IllegalArgumentException("PhoneNumber must be specified.");
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        if (lookup.getCountryCode() != null) {
            params.put("countryCode", lookup.getCountryCode());
        }
        return this.messageBirdService.requestByID(LOOKUPPATH, String.valueOf(lookup.getPhoneNumber()), params, Lookup.class);
    }

    public Lookup viewLookup(BigInteger phoneNumber) throws UnauthorizedException, GeneralException, NotFoundException {
        if (phoneNumber == null) {
            throw new IllegalArgumentException("PhoneNumber must be specified.");
        }
        Lookup lookup = new Lookup(phoneNumber);
        return this.viewLookup(lookup);
    }

    public LookupHlr requestLookupHlr(LookupHlr lookupHlr) throws UnauthorizedException, GeneralException {
        if (lookupHlr.getPhoneNumber() == null) {
            throw new IllegalArgumentException("PhoneNumber must be specified.");
        }
        if (lookupHlr.getReference() == null) {
            throw new IllegalArgumentException("Reference must be specified.");
        }
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("phoneNumber", lookupHlr.getPhoneNumber());
        payload.put("reference", lookupHlr.getReference());
        if (lookupHlr.getCountryCode() != null) {
            payload.put("countryCode", lookupHlr.getCountryCode());
        }
        return this.messageBirdService.sendPayLoad(String.format(LOOKUPHLRPATH, lookupHlr.getPhoneNumber()), payload, LookupHlr.class);
    }

    public LookupHlr requestLookupHlr(BigInteger phoneNumber, String reference) throws UnauthorizedException, GeneralException {
        if (phoneNumber == null) {
            throw new IllegalArgumentException("Phonenumber must be specified.");
        }
        if (reference == null) {
            throw new IllegalArgumentException("Reference must be specified.");
        }
        LookupHlr lookupHlr = new LookupHlr();
        lookupHlr.setPhoneNumber(phoneNumber);
        lookupHlr.setReference(reference);
        return this.requestLookupHlr(lookupHlr);
    }

    public LookupHlr viewLookupHlr(LookupHlr lookupHlr) throws UnauthorizedException, GeneralException, NotFoundException {
        if (lookupHlr.getPhoneNumber() == null) {
            throw new IllegalArgumentException("Phonenumber must be specified");
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        if (lookupHlr.getCountryCode() != null) {
            params.put("countryCode", lookupHlr.getCountryCode());
        }
        return this.messageBirdService.requestByID(String.format(LOOKUPHLRPATH, lookupHlr.getPhoneNumber()), "", params, LookupHlr.class);
    }

    public LookupHlr viewLookupHlr(BigInteger phoneNumber) throws UnauthorizedException, GeneralException, NotFoundException {
        if (phoneNumber == null) {
            throw new IllegalArgumentException("phoneNumber must be specified");
        }
        LookupHlr lookupHlr = new LookupHlr();
        lookupHlr.setPhoneNumber(phoneNumber);
        return this.viewLookupHlr(lookupHlr);
    }

    public VoiceCallFlowList listVoiceCallFlows(Integer offset, Integer limit) throws UnauthorizedException, GeneralException {
        this.verifyOffsetAndLimit(offset, limit);
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, VOICECALLFLOWPATH);
        return this.messageBirdService.requestList(url, offset, limit, VoiceCallFlowList.class);
    }

    public VoiceCallFlowResponse viewVoiceCallFlow(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null) {
            throw new IllegalArgumentException("Call Flow ID must be specified.");
        }
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, VOICECALLFLOWPATH);
        return this.messageBirdService.requestByID(url, id, VoiceCallFlowResponse.class);
    }

    public VoiceCallFlowResponse sendVoiceCallFlow(VoiceCallFlowRequest voiceCallFlowRequest) throws UnauthorizedException, GeneralException {
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, VOICECALLFLOWPATH);
        return this.messageBirdService.sendPayLoad(url, voiceCallFlowRequest, VoiceCallFlowResponse.class);
    }

    public VoiceCallFlowResponse updateVoiceCallFlow(String id, VoiceCallFlowRequest voiceCallFlowRequest) throws UnauthorizedException, GeneralException {
        if (id == null) {
            throw new IllegalArgumentException("Call Flow ID must be specified.");
        }
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, VOICECALLFLOWPATH);
        String request = url + "/" + id;
        return this.messageBirdService.sendPayLoad("PUT", request, voiceCallFlowRequest, VoiceCallFlowResponse.class);
    }

    public void deleteVoiceCallFlow(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null) {
            throw new IllegalArgumentException("Voice Call Flow ID must be specified.");
        }
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, VOICECALLFLOWPATH);
        this.messageBirdService.deleteByID(url, id);
    }

    void deleteContact(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null) {
            throw new IllegalArgumentException("Contact ID must be specified.");
        }
        this.messageBirdService.deleteByID(CONTACTPATH, id);
    }

    public ContactList listContacts(int offset, int limit) throws UnauthorizedException, GeneralException {
        return this.messageBirdService.requestList(CONTACTPATH, offset, limit, ContactList.class);
    }

    public ContactList listContacts() throws UnauthorizedException, GeneralException {
        int limit = 20;
        boolean offset = false;
        return this.listContacts(0, 20);
    }

    public Contact sendContact(ContactRequest contactRequest) throws UnauthorizedException, GeneralException {
        return this.messageBirdService.sendPayLoad(CONTACTPATH, contactRequest, Contact.class);
    }

    public Contact updateContact(String id, ContactRequest contactRequest) throws UnauthorizedException, GeneralException {
        if (id == null) {
            throw new IllegalArgumentException("Contact ID must be specified.");
        }
        String request = "/contacts/" + id;
        return this.messageBirdService.sendPayLoad("PATCH", request, contactRequest, Contact.class);
    }

    public Contact viewContact(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null) {
            throw new IllegalArgumentException("Contact ID must be specified.");
        }
        return this.messageBirdService.requestByID(CONTACTPATH, id, Contact.class);
    }

    public void deleteGroup(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null) {
            throw new IllegalArgumentException("Group ID must be specified.");
        }
        this.messageBirdService.deleteByID(GROUPPATH, id);
    }

    public void deleteGroupContact(String groupId, String contactId) throws NotFoundException, GeneralException, UnauthorizedException {
        if (groupId == null) {
            throw new IllegalArgumentException("Group ID must be specified.");
        }
        if (contactId == null) {
            throw new IllegalArgumentException("Contact ID must be specified.");
        }
        String id = String.format("%s%s/%s", groupId, CONTACTPATH, contactId);
        this.messageBirdService.deleteByID(GROUPPATH, id);
    }

    public GroupList listGroups(int offset, int limit) throws UnauthorizedException, GeneralException {
        return this.messageBirdService.requestList(GROUPPATH, offset, limit, GroupList.class);
    }

    public GroupList listGroups() throws UnauthorizedException, GeneralException {
        boolean offset = false;
        int limit = 20;
        return this.listGroups(0, 20);
    }

    public Group sendGroup(GroupRequest groupRequest) throws UnauthorizedException, GeneralException {
        return this.messageBirdService.sendPayLoad(GROUPPATH, groupRequest, Group.class);
    }

    public void sendGroupContact(String groupId, String[] contactIds) throws NotFoundException, GeneralException, UnauthorizedException {
        String path = String.format("%s%s?%s", groupId, CONTACTPATH, this.getQueryString(contactIds));
        this.messageBirdService.requestByID(GROUPPATH, path, null);
    }

    private String getQueryString(String[] contactIds) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("_method=PUT");
        for (String groupId : contactIds) {
            stringBuilder.append("&ids[]=").append(groupId);
        }
        return stringBuilder.toString();
    }

    public Group updateGroup(String id, GroupRequest groupRequest) throws UnauthorizedException, GeneralException {
        if (id == null) {
            throw new IllegalArgumentException("Group ID must be specified.");
        }
        String path = String.format("%s/%s", GROUPPATH, id);
        return this.messageBirdService.sendPayLoad("PATCH", path, groupRequest, Group.class);
    }

    public Group viewGroup(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null) {
            throw new IllegalArgumentException("Group ID must be specified.");
        }
        return this.messageBirdService.requestByID(GROUPPATH, id, Group.class);
    }

    public Conversation viewConversation(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null) {
            throw new IllegalArgumentException("Id must be specified");
        }
        String url = "https://conversations.messagebird.com/v1/conversations";
        return this.messageBirdService.requestByID(url, id, Conversation.class);
    }

    public Conversation updateConversation(String id, ConversationStatus status) throws UnauthorizedException, GeneralException {
        if (id == null) {
            throw new IllegalArgumentException("Id must be specified.");
        }
        if (status == null) {
            throw new IllegalArgumentException("An updated conversation status must be specified");
        }
        ConversationUpdateRequest payload = new ConversationUpdateRequest(status);
        String url = String.format("%s%s/%s", CONVERSATIONS_BASE_URL, CONVERSATION_PATH, id);
        return this.messageBirdService.sendPayLoad("PATCH", url, payload, Conversation.class);
    }

    public ConversationList listConversations(int offset, int limit) throws UnauthorizedException, GeneralException {
        String url = "https://conversations.messagebird.com/v1/conversations";
        return this.messageBirdService.requestList(url, offset, limit, ConversationList.class);
    }

    public ConversationList listConversations() throws UnauthorizedException, GeneralException {
        boolean offset = false;
        int limit = 10;
        return this.listConversations(0, 10);
    }

    public Conversation startConversation(ConversationStartRequest request) throws UnauthorizedException, GeneralException {
        String url = String.format("%s%s/start", CONVERSATIONS_BASE_URL, CONVERSATION_PATH);
        return this.messageBirdService.sendPayLoad(url, request, Conversation.class);
    }

    public ConversationSendResponse sendMessage(ConversationSendRequest request) throws UnauthorizedException, GeneralException {
        String url = String.format("%s%s", CONVERSATIONS_BASE_URL, CONVERSATION_SEND_PATH);
        return this.messageBirdService.sendPayLoad(url, request, ConversationSendResponse.class);
    }

    public ConversationMessageList listConversationMessages(String conversationId, int offset, int limit) throws UnauthorizedException, GeneralException {
        String url = String.format("%s%s/%s%s", CONVERSATIONS_BASE_URL, CONVERSATION_PATH, conversationId, "/messages");
        return this.messageBirdService.requestList(url, offset, limit, ConversationMessageList.class);
    }

    public ConversationMessageList listConversationMessages(String conversationId) throws UnauthorizedException, GeneralException {
        boolean offset = false;
        int limit = 10;
        return this.listConversationMessages(conversationId, 0, 10);
    }

    public ConversationMessage viewConversationMessage(String messageId) throws NotFoundException, GeneralException, UnauthorizedException {
        String url = "https://conversations.messagebird.com/v1/messages";
        return this.messageBirdService.requestByID(url, messageId, ConversationMessage.class);
    }

    public ConversationMessageList listConversationMessagesWithQueryParam(Map<String, Object> queryParams) throws NotFoundException, GeneralException, UnauthorizedException {
        for (String queryParam : queryParams.keySet()) {
            if (CONVERSATION_MESSAGE_LIST_FILTERS.contains(queryParam)) continue;
            throw new IllegalArgumentException("Invalid filter name: " + queryParam);
        }
        String url = "https://conversations.messagebird.com/v1/messages";
        return this.messageBirdService.requestByID(url, null, queryParams, ConversationMessageList.class);
    }

    public ConversationMessage sendConversationMessage(String conversationId, ConversationMessageRequest request) throws UnauthorizedException, GeneralException {
        String url = String.format("%s%s/%s%s", CONVERSATIONS_BASE_URL, CONVERSATION_PATH, conversationId, "/messages");
        return this.messageBirdService.sendPayLoad(url, request, ConversationMessage.class);
    }

    public void deleteConversationWebhook(String webhookId) throws NotFoundException, GeneralException, UnauthorizedException {
        String url = "https://conversations.messagebird.com/v1/webhooks";
        this.messageBirdService.deleteByID(url, webhookId);
    }

    public ConversationWebhook sendConversationWebhook(ConversationWebhookCreateRequest request) throws UnauthorizedException, GeneralException {
        String url = "https://conversations.messagebird.com/v1/webhooks";
        return this.messageBirdService.sendPayLoad(url, request, ConversationWebhook.class);
    }

    public ConversationWebhook updateConversationWebhook(String id, ConversationWebhookUpdateRequest request) throws UnauthorizedException, GeneralException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Conversation webhook ID must be specified.");
        }
        String url = "https://conversations.messagebird.com/v1/webhooks/" + id;
        return this.messageBirdService.sendPayLoad("PATCH", url, request, ConversationWebhook.class);
    }

    public ConversationWebhook viewConversationWebhook(String webhookId) throws NotFoundException, GeneralException, UnauthorizedException {
        String url = "https://conversations.messagebird.com/v1/webhooks";
        return this.messageBirdService.requestByID(url, webhookId, ConversationWebhook.class);
    }

    public ConversationWebhookList listConversationWebhooks(int offset, int limit) throws UnauthorizedException, GeneralException {
        String url = "https://conversations.messagebird.com/v1/webhooks";
        return this.messageBirdService.requestList(url, offset, limit, ConversationWebhookList.class);
    }

    public ConversationWebhookList listConversationWebhooks() throws UnauthorizedException, GeneralException {
        boolean offset = false;
        int limit = 10;
        return this.listConversationWebhooks(0, 10);
    }

    public VoiceCallResponse sendVoiceCall(VoiceCall voiceCall) throws UnauthorizedException, GeneralException {
        if (voiceCall.getSource() == null) {
            throw new IllegalArgumentException("Source of voice call must be specified.");
        }
        if (voiceCall.getDestination() == null) {
            throw new IllegalArgumentException("Destination of voice call must be specified.");
        }
        if (voiceCall.getCallFlow() == null) {
            throw new IllegalArgumentException("Call flow of voice call must be specified.");
        }
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH);
        return this.messageBirdService.sendPayLoad(url, voiceCall, VoiceCallResponse.class);
    }

    public VoiceCallResponseList listAllVoiceCalls(Integer page, Integer pageSize) throws GeneralException, UnauthorizedException {
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH);
        return this.messageBirdService.requestList(url, new PagedPaging(page, pageSize), VoiceCallResponseList.class);
    }

    public VoiceCallResponse viewVoiceCall(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null) {
            throw new IllegalArgumentException("Voice Message ID must be specified.");
        }
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH);
        return this.messageBirdService.requestByID(url, id, VoiceCallResponse.class);
    }

    public void deleteVoiceCall(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null) {
            throw new IllegalArgumentException("Voice Message ID must be specified.");
        }
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH);
        this.messageBirdService.deleteByID(url, id);
    }

    public VoiceCallLegResponse viewCallLegsByCallId(String callId, Integer page, Integer pageSize) throws UnsupportedEncodingException, UnauthorizedException, GeneralException {
        if (callId == null) {
            throw new IllegalArgumentException("Voice call ID must be specified.");
        }
        String url = String.format("%s%s/%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH, this.urlEncode(callId), "/legs");
        return this.messageBirdService.requestList(url, new PagedPaging(page, pageSize), VoiceCallLegResponse.class);
    }

    public VoiceCallLeg viewCallLegByCallIdAndLegId(String callId, String legId) throws UnsupportedEncodingException, NotFoundException, GeneralException, UnauthorizedException {
        if (callId == null) {
            throw new IllegalArgumentException("Voice call ID must be specified.");
        }
        if (legId == null) {
            throw new IllegalArgumentException("Leg ID must be specified.");
        }
        String url = String.format("%s%s/%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH, this.urlEncode(callId), "/legs");
        VoiceCallLegResponse response = this.messageBirdService.requestByID(url, legId, VoiceCallLegResponse.class);
        if (response.getData().size() == 1) {
            return response.getData().get(0);
        }
        throw new NotFoundException("No such leg", new LinkedList<ErrorReport>());
    }

    private String urlEncode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, String.valueOf(StandardCharsets.UTF_8));
    }

    public RecordingResponse viewRecording(String callID, String legId, String recordingId) throws NotFoundException, GeneralException, UnauthorizedException {
        if (callID == null) {
            throw new IllegalArgumentException("Voice call ID must be specified.");
        }
        if (legId == null) {
            throw new IllegalArgumentException("Leg ID must be specified.");
        }
        if (recordingId == null) {
            throw new IllegalArgumentException("Recording ID must be specified.");
        }
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("legs", legId);
        params.put("recordings", recordingId);
        return this.messageBirdService.requestByID(url, callID, params, RecordingResponse.class);
    }

    public String downloadRecording(String callID, String legId, String recordingId, String basePath) throws NotFoundException, GeneralException, UnauthorizedException {
        if (callID == null) {
            throw new IllegalArgumentException("Voice call ID must be specified.");
        }
        if (legId == null) {
            throw new IllegalArgumentException("Leg ID must be specified.");
        }
        if (recordingId == null) {
            throw new IllegalArgumentException("Recording ID must be specified.");
        }
        String url = String.format("%s%s/%s%s/%s%s/%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH, callID, "/legs", legId, RECORDINGPATH, recordingId, RECORDING_DOWNLOAD_FORMAT);
        String fileName = String.format("%s%s", recordingId, RECORDING_DOWNLOAD_FORMAT);
        return this.messageBirdService.getBinaryData(url, basePath, fileName);
    }

    public RecordingResponse listRecordings(String callID, String legId, Integer offset, Integer limit) throws GeneralException, UnauthorizedException {
        this.verifyOffsetAndLimit(offset, limit);
        if (callID == null) {
            throw new IllegalArgumentException("Voice call ID must be specified.");
        }
        if (legId == null) {
            throw new IllegalArgumentException("Leg ID must be specified.");
        }
        String url = String.format("%s%s/%s%s/%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH, callID, "/legs", legId, RECORDINGPATH);
        return this.messageBirdService.requestList(url, offset, limit, RecordingResponse.class);
    }

    public void deleteRecording(String callID, String legID, String recordingID) throws NotFoundException, GeneralException, UnauthorizedException {
        if (callID == null) {
            throw new IllegalArgumentException("Call ID must be specified.");
        }
        if (legID == null) {
            throw new IllegalArgumentException("Leg ID must be specified.");
        }
        if (recordingID == null) {
            throw new IllegalArgumentException("Recording ID must be specified.");
        }
        String url = String.format("%s%s/%s%s/%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH, callID, "/legs", legID, RECORDINGPATH);
        this.messageBirdService.deleteByID(url, recordingID);
    }

    public TranscriptionResponse createTranscription(String callID, String legId, String recordingId, String language) throws UnauthorizedException, GeneralException {
        if (callID == null) {
            throw new IllegalArgumentException("Voice call ID must be specified.");
        }
        if (legId == null) {
            throw new IllegalArgumentException("Leg ID must be specified.");
        }
        if (recordingId == null) {
            throw new IllegalArgumentException("Recording ID must be specified.");
        }
        if (language == null) {
            throw new IllegalArgumentException("Language must be specified.");
        }
        if (!Arrays.asList(supportedLanguages).contains(language)) {
            throw new IllegalArgumentException("Your language is not allowed.");
        }
        String url = String.format("%s%s/%s%s/%s%s/%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH, callID, "/legs", legId, RECORDINGPATH, recordingId, TRANSCRIPTIONPATH);
        return this.messageBirdService.sendPayLoad(url, language, TranscriptionResponse.class);
    }

    public TranscriptionResponse viewTranscription(String callID, String legId, String recordingId, String transcriptionId) throws UnauthorizedException, GeneralException, NotFoundException {
        if (callID == null) {
            throw new IllegalArgumentException("Voice call ID must be specified.");
        }
        if (legId == null) {
            throw new IllegalArgumentException("Leg ID must be specified.");
        }
        if (recordingId == null) {
            throw new IllegalArgumentException("Recording ID must be specified.");
        }
        if (transcriptionId == null) {
            throw new IllegalArgumentException("Transcription ID must be specified.");
        }
        String url = String.format("%s%s/%s%s/%s%s/%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH, callID, "/legs", legId, RECORDINGPATH, recordingId, TRANSCRIPTIONPATH);
        return this.messageBirdService.requestByID(url, transcriptionId, TranscriptionResponse.class);
    }

    public TranscriptionResponse listTranscriptions(String callID, String legId, String recordingId, Integer page, Integer pageSize) throws UnauthorizedException, GeneralException {
        if (callID == null) {
            throw new IllegalArgumentException("Voice call ID must be specified.");
        }
        if (legId == null) {
            throw new IllegalArgumentException("Leg ID must be specified.");
        }
        if (recordingId == null) {
            throw new IllegalArgumentException("Recording ID must be specified.");
        }
        String url = String.format("%s%s/%s%s/%s%s/%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH, callID, "/legs", legId, RECORDINGPATH, recordingId, TRANSCRIPTIONPATH);
        return this.messageBirdService.requestList(url, new PagedPaging(page, pageSize), TranscriptionResponse.class);
    }

    public String downloadTranscription(String callID, String legId, String recordingId, String transcriptionId, String basePath) throws UnauthorizedException, GeneralException, NotFoundException {
        if (callID == null) {
            throw new IllegalArgumentException("Voice call ID must be specified.");
        }
        if (legId == null) {
            throw new IllegalArgumentException("Leg ID must be specified.");
        }
        if (recordingId == null) {
            throw new IllegalArgumentException("Recording ID must be specified.");
        }
        if (transcriptionId == null) {
            throw new IllegalArgumentException("Transcription ID must be specified.");
        }
        String fileName = String.format("%s%s", transcriptionId, TRANSCRIPTION_DOWNLOAD_FORMAT);
        String url = String.format("%s%s/%s%s/%s%s/%s%s/%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH, callID, "/legs", legId, RECORDINGPATH, recordingId, TRANSCRIPTIONPATH, fileName);
        return this.messageBirdService.getBinaryData(url, basePath, fileName);
    }

    public WebhookResponseData createWebhook(Webhook webhook) throws UnauthorizedException, GeneralException {
        if (webhook.getUrl() == null) {
            throw new IllegalArgumentException("URL of webhook must be specified.");
        }
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, "/webhooks");
        return this.messageBirdService.sendPayLoad(url, webhook, WebhookResponseData.class);
    }

    public WebhookResponseData updateWebhook(String id, Webhook webhook) throws UnauthorizedException, GeneralException {
        if (id == null) {
            throw new IllegalArgumentException("Id of webhook must be specified.");
        }
        String url = String.format("%s%s/%s", VOICE_CALLS_BASE_URL, "/webhooks", id);
        return this.messageBirdService.sendPayLoad("PUT", url, webhook, WebhookResponseData.class);
    }

    public WebhookResponseData viewWebhook(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null) {
            throw new IllegalArgumentException("Id of webhook must be specified.");
        }
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, "/webhooks");
        return this.messageBirdService.requestByID(url, id, WebhookResponseData.class);
    }

    public WebhookList listWebhooks(Integer offset, Integer limit) throws UnauthorizedException, GeneralException {
        this.verifyOffsetAndLimit(offset, limit);
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, "/webhooks");
        return this.messageBirdService.requestList(url, offset, limit, WebhookList.class);
    }

    public void deleteWebhook(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null) {
            throw new IllegalArgumentException("Webhook ID must be specified.");
        }
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, "/webhooks");
        this.messageBirdService.deleteByID(url, id);
    }

    private void verifyOffsetAndLimit(Integer offset, Integer limit) {
        if (offset != null && offset < 0) {
            throw new IllegalArgumentException("Offset must be > 0");
        }
        if (limit != null && limit < 0) {
            throw new IllegalArgumentException("Limit must be > 0");
        }
    }

    private void countryCodeIsValid(String countryCode) throws IllegalArgumentException {
        boolean isValid = Arrays.asList(Locale.getISOCountries()).contains(countryCode);
        if (!isValid) {
            throw new IllegalArgumentException("Invalid Country Code Provided.");
        }
    }

    public PhoneNumbersResponse listNumbersForPurchase(String countryCode) throws GeneralException, UnauthorizedException, NotFoundException, IllegalArgumentException {
        this.countryCodeIsValid(countryCode);
        String url = String.format("%s/available-phone-numbers", NUMBERS_CALLS_BASE_URL);
        return this.messageBirdService.requestByID(url, countryCode, PhoneNumbersResponse.class);
    }

    public PhoneNumbersResponse listNumbersForPurchase(String countryCode, PhoneNumbersLookup params) throws GeneralException, UnauthorizedException, NotFoundException, IllegalArgumentException {
        this.countryCodeIsValid(countryCode);
        String url = String.format("%s/available-phone-numbers", NUMBERS_CALLS_BASE_URL);
        return this.messageBirdService.requestByID(url, countryCode, params.toHashMap(), PhoneNumbersResponse.class);
    }

    public PurchasedNumberCreatedResponse purchaseNumber(String number, String countryCode, int billingIntervalMonths) throws UnauthorizedException, GeneralException, IllegalArgumentException {
        this.countryCodeIsValid(countryCode);
        String url = String.format("%s/phone-numbers", NUMBERS_CALLS_BASE_URL);
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("number", number);
        payload.put("countryCode", countryCode);
        if (!Arrays.asList(1, 3, 6, 9).contains(billingIntervalMonths)) {
            throw new IllegalArgumentException("Billing Interval Must Be Either 1, 3, 6, or 9.");
        }
        payload.put("billingIntervalMonths", billingIntervalMonths);
        return this.messageBirdService.sendPayLoad(url, payload, PurchasedNumberCreatedResponse.class);
    }

    public PurchasedNumbersResponse listPurchasedNumbers(PurchasedNumbersFilter filter) throws UnauthorizedException, GeneralException, NotFoundException {
        String url = String.format("%s/phone-numbers", NUMBERS_CALLS_BASE_URL);
        return this.messageBirdService.requestByID(url, null, filter.toHashMap(), PurchasedNumbersResponse.class);
    }

    public PurchasedNumber viewPurchasedNumber(String number) throws UnauthorizedException, GeneralException, NotFoundException {
        String url = String.format("%s/phone-numbers", NUMBERS_CALLS_BASE_URL);
        return this.messageBirdService.requestByID(url, number, PurchasedNumber.class);
    }

    public PurchasedNumber updateNumber(String number, String ... tags) throws UnauthorizedException, GeneralException {
        String url = String.format("%s/phone-numbers/%s", NUMBERS_CALLS_BASE_URL, number);
        HashMap<String, List<String>> payload = new HashMap<String, List<String>>();
        payload.put("tags", Arrays.asList(tags));
        return this.messageBirdService.sendPayLoad("PATCH", url, payload, PurchasedNumber.class);
    }

    public void cancelNumber(String number) throws UnauthorizedException, GeneralException, NotFoundException {
        String url = String.format("%s/phone-numbers", NUMBERS_CALLS_BASE_URL);
        this.messageBirdService.deleteByID(url, number);
    }

    public FileUploadResponse uploadFile(byte[] binary, String contentType, String filename) throws GeneralException, UnauthorizedException {
        if (binary == null) {
            throw new IllegalArgumentException("File binary must be specified.");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Content type must be specified.");
        }
        String url = "https://messaging.messagebird.com/v1/files";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", contentType);
        if (filename != null) {
            headers.put("filename", filename);
        }
        return this.messageBirdService.sendPayLoad("POST", "https://messaging.messagebird.com/v1/files", headers, binary, FileUploadResponse.class);
    }

    public String downloadFile(String id, String filename, String basePath) throws GeneralException, UnauthorizedException, NotFoundException {
        if (id == null) {
            throw new IllegalArgumentException("File ID must be specified.");
        }
        if (filename == null) {
            filename = id;
        }
        String url = String.format("%s%s/%s", MESSAGING_BASE_URL, FILES_PATH, id);
        return this.messageBirdService.getBinaryData(url, basePath, filename);
    }

    public TemplateResponse createWhatsAppTemplate(Template template) throws UnauthorizedException, GeneralException, IllegalArgumentException {
        template.validate();
        String url = String.format("%s%s%s", INTEGRATIONS_BASE_URL_V2, INTEGRATIONS_WHATSAPP_PATH, TEMPLATES_PATH);
        return this.messageBirdService.sendPayLoad(url, template, TemplateResponse.class);
    }

    public TemplateList listWhatsAppTemplates(int offset, int limit) throws UnauthorizedException, GeneralException {
        String url = String.format("%s%s%s", INTEGRATIONS_BASE_URL_V3, INTEGRATIONS_WHATSAPP_PATH, TEMPLATES_PATH);
        return this.messageBirdService.requestList(url, offset, limit, TemplateList.class);
    }

    public TemplateList listWhatsAppTemplates(int offset, int limit, String wabaID, String channelID) throws UnauthorizedException, GeneralException, IllegalArgumentException {
        this.validateWABAIDAndChannelIDArguments(wabaID, channelID);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (wabaID != null) {
            map.put("wabaId", wabaID);
        }
        if (channelID != null) {
            map.put("channelId", channelID);
        }
        String url = String.format("%s%s%s", INTEGRATIONS_BASE_URL_V3, INTEGRATIONS_WHATSAPP_PATH, TEMPLATES_PATH);
        return this.messageBirdService.requestList(url, map, offset, limit, TemplateList.class);
    }

    public TemplateList listWhatsAppTemplates() throws UnauthorizedException, GeneralException {
        boolean offset = false;
        int limit = 10;
        return this.listWhatsAppTemplates(0, 10);
    }

    public List<TemplateResponse> getWhatsAppTemplatesBy(String templateName) throws GeneralException, UnauthorizedException, NotFoundException, IllegalArgumentException {
        if (templateName == null) {
            throw new IllegalArgumentException("Template name must be specified.");
        }
        String url = String.format("%s%s%s", INTEGRATIONS_BASE_URL_V2, INTEGRATIONS_WHATSAPP_PATH, TEMPLATES_PATH);
        return this.messageBirdService.requestByIdAsList(url, templateName, TemplateResponse.class);
    }

    public List<TemplateResponse> getWhatsAppTemplatesBy(String templateName, String wabaID, String channelID) throws GeneralException, UnauthorizedException, NotFoundException, IllegalArgumentException {
        if (templateName == null) {
            throw new IllegalArgumentException("Template name must be specified.");
        }
        String id = String.format("%s%s", templateName, this.getWabaIDOrChannelIDQuery(wabaID, channelID));
        String url = String.format("%s%s%s", INTEGRATIONS_BASE_URL_V2, INTEGRATIONS_WHATSAPP_PATH, TEMPLATES_PATH);
        return this.messageBirdService.requestByIdAsList(url, id, TemplateResponse.class);
    }

    public TemplateResponse fetchWhatsAppTemplateBy(String templateName, String language) throws GeneralException, UnauthorizedException, NotFoundException, IllegalArgumentException {
        if (templateName == null || language == null) {
            throw new IllegalArgumentException("Template name and language must be specified.");
        }
        String url = String.format("%s%s%s/%s/%s", INTEGRATIONS_BASE_URL_V2, INTEGRATIONS_WHATSAPP_PATH, TEMPLATES_PATH, templateName, language);
        return this.messageBirdService.request(url, TemplateResponse.class);
    }

    public TemplateResponse fetchWhatsAppTemplateBy(String templateName, String language, String wabaID, String channelID) throws GeneralException, UnauthorizedException, NotFoundException, IllegalArgumentException {
        if (templateName == null || language == null) {
            throw new IllegalArgumentException("Template name and language must be specified.");
        }
        String url = String.format("%s%s%s/%s/%s%s", INTEGRATIONS_BASE_URL_V2, INTEGRATIONS_WHATSAPP_PATH, TEMPLATES_PATH, templateName, language, this.getWabaIDOrChannelIDQuery(wabaID, channelID));
        return this.messageBirdService.request(url, TemplateResponse.class);
    }

    private void validateWABAIDAndChannelIDArguments(String wabaID, String channelID) throws IllegalArgumentException {
        if (wabaID == null && channelID == null) {
            throw new IllegalArgumentException("wabaID or channelID must be specified");
        }
        if (wabaID != null && channelID != null) {
            throw new IllegalArgumentException("only supply wabaID or channelID - not both");
        }
    }

    private String getWabaIDOrChannelIDQuery(String wabaID, String channelID) throws IllegalArgumentException {
        this.validateWABAIDAndChannelIDArguments(wabaID, channelID);
        String query = "";
        if (wabaID != null) {
            query = String.format("?wabaId=%s", wabaID);
        }
        if (channelID != null) {
            query = String.format("?channelId=%s", channelID);
        }
        return query;
    }

    public void deleteTemplatesBy(String templateName) throws UnauthorizedException, GeneralException, NotFoundException {
        if (templateName == null) {
            throw new IllegalArgumentException("Template name must be specified.");
        }
        String url = String.format("%s%s%s/%s", INTEGRATIONS_BASE_URL_V2, INTEGRATIONS_WHATSAPP_PATH, TEMPLATES_PATH, templateName);
        this.messageBirdService.delete(url, null);
    }

    public ChildAccountCreateResponse createChildAccount(ChildAccountRequest childAccountRequest) throws UnauthorizedException, GeneralException {
        if (childAccountRequest.getName() == null || childAccountRequest.getName().isEmpty()) {
            throw new IllegalArgumentException("Name must be specified.");
        }
        String url = String.format("%s%s", PARTNER_ACCOUNTS_BASE_URL, "/child-accounts");
        return this.messageBirdService.sendPayLoad(url, childAccountRequest, ChildAccountCreateResponse.class);
    }

    public ChildAccountResponse updateChildAccount(String name, String id) throws UnauthorizedException, GeneralException {
        if (name == null) {
            throw new IllegalArgumentException("Name must be specified.");
        }
        if (id == null) {
            throw new IllegalArgumentException("Child account id must be specified.");
        }
        ChildAccountRequest childAccountRequest = new ChildAccountRequest();
        childAccountRequest.setName(name);
        String url = String.format("%s/child-accounts/%s", PARTNER_ACCOUNTS_BASE_URL, id);
        return this.messageBirdService.sendPayLoad("PATCH", url, childAccountRequest, ChildAccountResponse.class);
    }

    public ChildAccountDetailedResponse getChildAccountById(String id) throws UnauthorizedException, GeneralException, NotFoundException {
        if (id == null) {
            throw new IllegalArgumentException("Child account id must be specified.");
        }
        return this.messageBirdService.requestByID("https://partner-accounts.messagebird.com/child-accounts", id, ChildAccountDetailedResponse.class);
    }

    public List<ChildAccountResponse> getChildAccounts(Integer offset, Integer limit) throws UnauthorizedException, GeneralException {
        this.verifyOffsetAndLimit(offset, limit);
        return this.messageBirdService.requestList("https://partner-accounts.messagebird.com/child-accounts", offset, limit, List.class);
    }

    public void deleteChildAccount(String id) throws UnauthorizedException, GeneralException, NotFoundException {
        if (id == null) {
            throw new IllegalArgumentException("Child account id must be specified.");
        }
        String url = String.format("%s/child-accounts", PARTNER_ACCOUNTS_BASE_URL);
        System.out.println("url: " + url);
        this.messageBirdService.deleteByID(url, id);
    }
}

