/*
 * Decompiled with CFR 0.152.
 */
package com.messagebird;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.messagebird.APIResponse;
import com.messagebird.MessageBirdService;
import com.messagebird.exceptions.GeneralException;
import com.messagebird.exceptions.NotFoundException;
import com.messagebird.exceptions.UnauthorizedException;
import com.messagebird.objects.ErrorReport;
import com.messagebird.objects.PagedPaging;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class MessageBirdServiceImpl
implements MessageBirdService {
    private static final String NOT_AUTHORISED_MSG = "You are not authorised for the MessageBird service, please check your access key.";
    private static final String FAILED_DATA_RESPONSE_CODE = "Failed to retrieve data from MessageBird service with response code ";
    private static final String ACCESS_KEY_MUST_BE_SPECIFIED = "Access key must be specified";
    private static final String SERVICE_URL_MUST_BE_SPECIFIED = "Service URL must be specified";
    private static final String REQUEST_VALUE_MUST_BE_SPECIFIED = "Request value must be specified";
    private static final String REQUEST_METHOD_NOT_ALLOWED = "Request method %s is not allowed.";
    private static final String CAN_NOT_ALLOW_PATCH = "Can not set HttpURLConnection.methods field to allow PATCH.";
    private static final String METHOD_DELETE = "DELETE";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_PATCH = "PATCH";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final List<String> REQUEST_METHODS = Arrays.asList("DELETE", "GET", "PATCH", "POST", "PUT");
    private static final List<String> REQUEST_METHODS_WITH_PAYLOAD = Arrays.asList("PATCH", "POST", "PUT");
    private static final String[] PROTOCOL_LISTS = new String[]{"http://", "https://"};
    private static final List<String> PROTOCOLS = Arrays.asList(PROTOCOL_LISTS);
    private static final double DEFAULT_JAVA_VERSION = 0.0;
    private static boolean isPatchRequestAllowed = false;
    private static final int BUFFER_SIZE = 4096;
    private final String accessKey;
    private final String serviceUrl;
    private final String clientVersion = "5.3.0";
    private final String userAgentString;
    private Proxy proxy = null;

    public MessageBirdServiceImpl(String accessKey, String serviceUrl) {
        if (accessKey == null) {
            throw new IllegalArgumentException(ACCESS_KEY_MUST_BE_SPECIFIED);
        }
        if (serviceUrl == null || serviceUrl.length() == 0) {
            throw new IllegalArgumentException(SERVICE_URL_MUST_BE_SPECIFIED);
        }
        this.accessKey = accessKey;
        this.serviceUrl = serviceUrl;
        this.userAgentString = this.determineUserAgentString();
    }

    private String determineUserAgentString() {
        double javaVersion = 0.0;
        try {
            javaVersion = this.getVersion();
        }
        catch (GeneralException generalException) {
            // empty catch block
        }
        return String.format("MessageBird Java/%s ApiClient/%s", javaVersion, "5.3.0");
    }

    public MessageBirdServiceImpl(String accessKey) {
        this(accessKey, "https://rest.messagebird.com");
    }

    @Override
    public <R> R request(String request, Class<R> clazz) throws UnauthorizedException, GeneralException, NotFoundException {
        return this.getJsonData(request, null, METHOD_GET, clazz);
    }

    @Override
    public <R> R requestByID(String request, String id, Class<R> clazz) throws UnauthorizedException, GeneralException, NotFoundException {
        String path = "";
        if (id != null) {
            path = "/" + id;
        }
        return this.getJsonData(request + path, null, METHOD_GET, clazz);
    }

    @Override
    public <R> R requestByID(String request, String id, Map<String, Object> params, Class<R> clazz) throws UnauthorizedException, GeneralException, NotFoundException {
        String path = "";
        if (id != null) {
            path = "/" + id;
        }
        String queryParams = "";
        if (!params.isEmpty()) {
            queryParams = "?" + this.getPathVariables(params);
        }
        return this.getJsonData(request + path + queryParams, null, METHOD_GET, clazz);
    }

    @Override
    public <E> List<E> requestByIdAsList(String request, String id, Class<E> elementClass) throws UnauthorizedException, GeneralException, NotFoundException {
        String path = "";
        if (id != null) {
            path = "/" + id;
        }
        return this.getJsonDataAsList(request + path, null, METHOD_GET, elementClass);
    }

    @Override
    public void deleteByID(String request, String id) throws UnauthorizedException, GeneralException, NotFoundException {
        this.getJsonData(request + "/" + id, null, METHOD_DELETE, null);
    }

    @Override
    public <R> R delete(String request, Class<R> clazz) throws UnauthorizedException, GeneralException, NotFoundException {
        return this.getJsonData(request, null, METHOD_DELETE, clazz);
    }

    @Override
    public <R> R requestList(String request, Integer offset, Integer limit, Class<R> clazz) throws UnauthorizedException, GeneralException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (offset != null) {
            map.put("offset", String.valueOf(offset));
        }
        if (limit != null) {
            map.put("limit", String.valueOf(limit));
        }
        try {
            return this.getJsonData(request + "?" + this.getPathVariables(map), null, METHOD_GET, clazz);
        }
        catch (NotFoundException e) {
            throw new GeneralException(e);
        }
    }

    @Override
    public <R> R requestList(String request, Map<String, Object> params, Integer offset, Integer limit, Class<R> clazz) throws UnauthorizedException, GeneralException {
        if (offset != null) {
            params.put("offset", String.valueOf(offset));
        }
        if (limit != null) {
            params.put("limit", String.valueOf(limit));
        }
        try {
            return this.getJsonData(request + "?" + this.getPathVariables(params), null, METHOD_GET, clazz);
        }
        catch (NotFoundException e) {
            throw new GeneralException(e);
        }
    }

    @Override
    public <R> R requestList(String request, PagedPaging pagedPaging, Class<R> clazz) throws UnauthorizedException, GeneralException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (pagedPaging.getPage() != null) {
            map.put("page", String.valueOf(pagedPaging.getPage()));
        }
        if (pagedPaging.getPageSize() != null) {
            map.put("perPage", String.valueOf(pagedPaging.getPageSize()));
        }
        try {
            return this.getJsonData(request + "?" + this.getPathVariables(map), null, METHOD_GET, clazz);
        }
        catch (NotFoundException e) {
            throw new GeneralException(e);
        }
    }

    @Override
    public <R, P> R sendPayLoad(String request, P payload, Class<R> clazz) throws UnauthorizedException, GeneralException {
        return this.sendPayLoad(METHOD_POST, request, payload, clazz);
    }

    @Override
    public <R, P> R sendPayLoad(String method, String request, P payload, Class<R> clazz) throws UnauthorizedException, GeneralException {
        return this.sendPayLoad(method, request, new HashMap<String, String>(), payload, clazz);
    }

    @Override
    public <R, P> R sendPayLoad(String method, String request, Map<String, String> headers, P payload, Class<R> clazz) throws UnauthorizedException, GeneralException {
        if (!REQUEST_METHODS_WITH_PAYLOAD.contains(method)) {
            throw new IllegalArgumentException(String.format(REQUEST_METHOD_NOT_ALLOWED, method));
        }
        try {
            return this.getJsonData(request, payload, method, headers, clazz);
        }
        catch (NotFoundException e) {
            throw new GeneralException(e);
        }
    }

    @Override
    public String getBinaryData(String request, String basePath, String fileName) throws GeneralException, UnauthorizedException, NotFoundException {
        File file;
        if (basePath == null) {
            String homePath = System.getProperty("user.home");
            if (homePath == null) {
                throw new IllegalArgumentException("BasePath must be specified.");
            }
            basePath = String.format("%s/%s", homePath, "Downloads");
        }
        if (!(file = new File(basePath)).exists()) {
            throw new IllegalArgumentException("basePath must be existed as directory.");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("basePath must be a directory.");
        }
        String filePath = String.format("%s/%s", basePath, fileName);
        return this.doGetRequestForFileAndStore(request, filePath);
    }

    public <T, P> T getJsonData(String request, P payload, String requestType, Class<T> clazz) throws UnauthorizedException, GeneralException, NotFoundException {
        return this.getJsonData(request, payload, requestType, new HashMap<String, String>(), clazz);
    }

    public <P, E> List<E> getJsonDataAsList(String request, P payload, String requestType, Class<E> elementClass) throws UnauthorizedException, GeneralException, NotFoundException {
        return this.getJsonDataAsList(request, payload, requestType, new HashMap<String, String>(), elementClass);
    }

    public <T, P> T getJsonData(String request, P payload, String requestType, Map<String, String> headers, Class<T> clazz) throws UnauthorizedException, GeneralException, NotFoundException {
        if (request == null) {
            throw new IllegalArgumentException(REQUEST_VALUE_MUST_BE_SPECIFIED);
        }
        String url = request;
        if (!this.isURLAbsolute(url)) {
            url = this.serviceUrl + url;
        }
        APIResponse apiResponse = this.doRequest(requestType, url, headers, payload);
        String body = apiResponse.getBody();
        int status = apiResponse.getStatus();
        if (status == 200 || status == 201 || status == 202) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                mapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES});
                mapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
                return clazz == null ? null : (T)this.readValue(mapper, body, clazz);
            }
            catch (IOException ioe) {
                throw new GeneralException(ioe);
            }
        }
        if (status == 204) {
            return null;
        }
        this.handleHttpFailStatuses(status, body);
        return null;
    }

    public <P, E> List<E> getJsonDataAsList(String request, P payload, String requestType, Map<String, String> headers, Class<E> elementClass) throws UnauthorizedException, GeneralException, NotFoundException {
        if (request == null) {
            throw new IllegalArgumentException(REQUEST_VALUE_MUST_BE_SPECIFIED);
        }
        String url = request;
        if (!this.isURLAbsolute(url)) {
            url = this.serviceUrl + url;
        }
        APIResponse apiResponse = this.doRequest(requestType, url, headers, payload);
        String body = apiResponse.getBody();
        int status = apiResponse.getStatus();
        if (status == 200 || status == 201 || status == 202) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                mapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES});
                mapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
                return this.readValueAsList(mapper, body, elementClass);
            }
            catch (IOException ioe) {
                throw new GeneralException(ioe);
            }
        }
        if (status == 204) {
            return Collections.emptyList();
        }
        this.handleHttpFailStatuses(status, body);
        return Collections.emptyList();
    }

    private <T> T readValue(ObjectMapper mapper, String content, Class<T> clazz) throws JsonProcessingException {
        return (T)mapper.readValue(content, clazz);
    }

    private <E> List<E> readValueAsList(ObjectMapper mapper, String content, Class<E> elementClass) throws JsonProcessingException {
        return (List)mapper.readValue(content, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, elementClass));
    }

    private void handleHttpFailStatuses(int status, String body) throws UnauthorizedException, NotFoundException, GeneralException {
        if (status == 401) {
            List<ErrorReport> errorReport = this.getErrorReportOrNull(body);
            throw new UnauthorizedException(NOT_AUTHORISED_MSG, errorReport);
        }
        if (status >= 400 && status < 500) {
            List<ErrorReport> errorReport = this.getErrorReportOrNull(body);
            if (status == 404) {
                throw new NotFoundException(errorReport);
            }
            throw new GeneralException(FAILED_DATA_RESPONSE_CODE + status, status, errorReport);
        }
        throw new GeneralException(FAILED_DATA_RESPONSE_CODE + status, status);
    }

    <P> APIResponse doRequest(String method, String url, Map<String, String> headers, P payload) throws GeneralException {
        HttpURLConnection connection = null;
        InputStream inputStream = null;
        if (METHOD_PATCH.equalsIgnoreCase(method)) {
            MessageBirdServiceImpl.allowPatchRequestsIfNeeded();
        }
        try {
            connection = this.getConnection(url, payload, method, headers);
            int status = connection.getResponseCode();
            inputStream = APIResponse.isSuccessStatus(status) ? connection.getInputStream() : connection.getErrorStream();
            APIResponse aPIResponse = new APIResponse(this.readToEnd(inputStream), status);
            this.saveClose(inputStream);
            if (connection != null) {
                connection.disconnect();
            }
            return aPIResponse;
        }
        catch (IOException ioe) {
            try {
                throw new GeneralException(ioe);
            }
            catch (Throwable throwable) {
                this.saveClose(inputStream);
                if (connection != null) {
                    connection.disconnect();
                }
                throw throwable;
            }
        }
    }

    private String doGetRequestForFileAndStore(String url, String filePath) throws GeneralException, UnauthorizedException, NotFoundException {
        int status;
        InputStream inputStream;
        HttpURLConnection connection;
        block11: {
            connection = null;
            inputStream = null;
            connection = this.getConnection(url, null, METHOD_GET);
            status = connection.getResponseCode();
            if (APIResponse.isSuccessStatus(status)) {
                inputStream = connection.getInputStream();
            } else {
                inputStream = connection.getErrorStream();
                if (inputStream == null) {
                    throw new GeneralException("Error stream was empty");
                }
            }
            if (status != 200) break block11;
            String string = this.writeInputStreamToFile(inputStream, filePath);
            this.saveClose(inputStream);
            if (connection != null) {
                connection.disconnect();
            }
            return string;
        }
        try {
            String body = this.readToEnd(inputStream);
            this.handleHttpFailStatuses(status, body);
            this.saveClose(inputStream);
            if (connection != null) {
                connection.disconnect();
            }
        }
        catch (IOException ioe) {
            try {
                throw new GeneralException(ioe);
            }
            catch (Throwable throwable) {
                this.saveClose(inputStream);
                if (connection != null) {
                    connection.disconnect();
                }
                throw throwable;
            }
        }
        return null;
    }

    private String writeInputStreamToFile(InputStream inputStream, String filepath) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(filepath);
        int bytesRead = -1;
        byte[] buffer = new byte[4096];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        outputStream.close();
        return filepath;
    }

    private static synchronized void allowPatchRequestsIfNeeded() throws GeneralException {
        if (isPatchRequestAllowed) {
            return;
        }
        try {
            Field methodsField = HttpURLConnection.class.getDeclaredField("methods");
            methodsField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(methodsField, methodsField.getModifiers() & 0xFFFFFFEF);
            Object noInstanceBecauseStaticField = null;
            String[] existingMethods = (String[])methodsField.get(noInstanceBecauseStaticField);
            String[] allowedMethods = MessageBirdServiceImpl.getAllowedMethods(existingMethods);
            methodsField.set(noInstanceBecauseStaticField, allowedMethods);
            isPatchRequestAllowed = true;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new GeneralException(CAN_NOT_ALLOW_PATCH);
        }
    }

    private static String[] getAllowedMethods(String[] existingMethods) {
        int listCapacity = existingMethods.length + 1;
        ArrayList<String> allowedMethods = new ArrayList<String>(listCapacity);
        allowedMethods.addAll(Arrays.asList(existingMethods));
        allowedMethods.add(METHOD_PATCH);
        allowedMethods.add(METHOD_PUT);
        return allowedMethods.toArray(new String[0]);
    }

    private String readToEnd(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream).useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }

    private boolean isURLAbsolute(String url) {
        for (String protocol : PROTOCOLS) {
            if (!url.startsWith(protocol)) continue;
            return true;
        }
        return false;
    }

    public <P> HttpURLConnection getConnection(String serviceUrl, P body, String requestType) throws IOException {
        return this.getConnection(serviceUrl, body, requestType, new HashMap<String, String>());
    }

    public <P> HttpURLConnection getConnection(String serviceUrl, P body, String requestType, Map<String, String> headers) throws IOException {
        if (requestType == null || !REQUEST_METHODS.contains(requestType)) {
            throw new IllegalArgumentException(String.format(REQUEST_METHOD_NOT_ALLOWED, requestType));
        }
        if (body == null && (METHOD_POST.equals(requestType) || METHOD_PUT.equals(requestType))) {
            throw new IllegalArgumentException("Empty body is not allowed for POST or PUT requests");
        }
        URL restService = new URL(serviceUrl);
        HttpURLConnection connection = this.proxy != null ? (HttpURLConnection)restService.openConnection(this.proxy) : (HttpURLConnection)restService.openConnection();
        connection.setDoInput(true);
        connection.setRequestProperty("Accept", "application/json");
        connection.setUseCaches(false);
        connection.setRequestProperty("charset", "utf-8");
        connection.setRequestProperty("Connection", "close");
        connection.setRequestProperty("Authorization", "AccessKey " + this.accessKey);
        connection.setRequestProperty("User-agent", this.userAgentString);
        if (METHOD_POST.equals(requestType) || METHOD_PUT.equals(requestType) || METHOD_PATCH.equals(requestType)) {
            byte[] bodyBytes;
            connection.setRequestMethod(requestType);
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            DateFormat df = this.getDateFormat();
            mapper.setDateFormat(df);
            this.setAdditionalHeaders(connection, headers);
            if (body instanceof byte[]) {
                bodyBytes = (byte[])body;
            } else {
                String json = mapper.writeValueAsString(body);
                bodyBytes = json.getBytes(StandardCharsets.UTF_8);
            }
            connection.getOutputStream().write(bodyBytes);
        } else if (METHOD_DELETE.equals(requestType)) {
            connection.setDoOutput(false);
            connection.setRequestMethod(METHOD_DELETE);
            connection.setRequestProperty("Content-Type", "text/plain");
            this.setAdditionalHeaders(connection, headers);
        } else {
            connection.setDoOutput(false);
            connection.setRequestMethod(METHOD_GET);
            connection.setRequestProperty("Content-Type", "text/plain");
            this.setAdditionalHeaders(connection, headers);
        }
        return connection;
    }

    private void setAdditionalHeaders(HttpURLConnection connection, Map<String, String> headers) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
    }

    private DateFormat getDateFormat() {
        double javaVersion = 0.0;
        try {
            javaVersion = this.getVersion();
        }
        catch (GeneralException generalException) {
            // empty catch block
        }
        if (javaVersion > 1.6) {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        }
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZZ");
    }

    private double getVersion() throws GeneralException {
        String version = System.getProperty("java.version");
        try {
            int pos = version.indexOf(46);
            pos = version.indexOf(46, pos + 1);
            return Double.parseDouble(version.substring(0, pos));
        }
        catch (RuntimeException e) {
            throw new GeneralException(e);
        }
    }

    private List<ErrorReport> getErrorReportOrNull(String body) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode jsonNode = (JsonNode)objectMapper.readValue(body, JsonNode.class);
            if (!jsonNode.has("errors")) {
                return null;
            }
            ErrorReport[] errors = (ErrorReport[])objectMapper.readValue(jsonNode.get("errors").toString(), ErrorReport[].class);
            List<ErrorReport> result = Arrays.asList(errors);
            if (result.isEmpty()) {
                return null;
            }
            return result;
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getClientVersion() {
        return "5.3.0";
    }

    public String getUserAgentString() {
        return this.userAgentString;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    private void saveClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String encodeKeyValuePair(String key, Object value) throws UnsupportedEncodingException {
        return URLEncoder.encode(key, String.valueOf(StandardCharsets.UTF_8)) + "=" + URLEncoder.encode(String.valueOf(value), String.valueOf(StandardCharsets.UTF_8));
    }

    private String getPathVariables(Map<String, Object> map) {
        StringBuilder bpath = new StringBuilder();
        for (Map.Entry<String, Object> param : map.entrySet()) {
            if (bpath.length() > 1) {
                bpath.append("&");
            }
            try {
                if (param.getValue() instanceof Collection) {
                    Collection col = (Collection)param.getValue();
                    Iterator iterator = col.iterator();
                    int count = 0;
                    while (iterator.hasNext()) {
                        if (count > 0) {
                            bpath.append("&");
                        }
                        bpath.append(this.encodeKeyValuePair(param.getKey(), iterator.next()));
                        ++count;
                    }
                    continue;
                }
                bpath.append(this.encodeKeyValuePair(param.getKey(), param.getValue()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return bpath.toString();
    }
}

