/*
 * Decompiled with CFR 0.152.
 */
package com.messagebird;

import com.messagebird.Base64;
import com.messagebird.Request;
import com.messagebird.exceptions.RequestSigningException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

@Deprecated
public class RequestSigner {
    private static final String ALGORITHM_SHA256 = "SHA-256";
    private static final String ALGORITHM_HMAC_SHA256 = "HmacSHA256";
    private static final Charset CHARSET_UTF8 = StandardCharsets.UTF_8;
    private SecretKeySpec secret;

    @Deprecated
    public RequestSigner(byte[] key) {
        this.secret = new SecretKeySpec(key, ALGORITHM_HMAC_SHA256);
    }

    @Deprecated
    public boolean isMatch(String expectedSignature, Request request) {
        try {
            return this.isMatch(Base64.decode(expectedSignature), request);
        }
        catch (IOException e) {
            throw new RequestSigningException(e);
        }
    }

    @Deprecated
    public boolean isMatch(byte[] expectedSignature, Request request) {
        return Arrays.equals(this.computeSignature(request), expectedSignature);
    }

    private byte[] computeSignature(Request request) {
        String timestampAndQuery = request.getTimestamp() + '\n' + request.getSortedQueryParameters() + '\n';
        byte[] timestampAndQueryBytes = timestampAndQuery.getBytes(CHARSET_UTF8);
        byte[] bodyHashBytes = this.getSha256Hash(request.getData());
        return this.getHmacSha256Signature(this.appendArrays(timestampAndQueryBytes, bodyHashBytes));
    }

    private byte[] getSha256Hash(byte[] bytes) {
        try {
            return MessageDigest.getInstance(ALGORITHM_SHA256).digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RequestSigningException(e);
        }
    }

    private byte[] appendArrays(byte[] first, byte[] second) {
        byte[] result = new byte[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private byte[] getHmacSha256Signature(byte[] bytes) {
        try {
            Mac mac = Mac.getInstance(ALGORITHM_HMAC_SHA256);
            mac.init(this.secret);
            return mac.doFinal(bytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RequestSigningException(e);
        }
    }
}

