/*
 * Decompiled with CFR 0.152.
 */
package com.messagebird.objects.integrations;

import com.messagebird.objects.integrations.HSMCategory;
import com.messagebird.objects.integrations.HSMComponent;
import java.util.List;

public class Template {
    private String name;
    private String language;
    private String wabaID;
    private List<HSMComponent> components;
    private HSMCategory category;

    public Template() {
    }

    public Template(String name, String language, String wabaID, List<HSMComponent> components, HSMCategory category) {
        this.name = name;
        this.language = language;
        this.wabaID = wabaID;
        this.components = components;
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getWABAID() {
        return this.wabaID;
    }

    public void setWABAID(String wabaID) {
        this.wabaID = wabaID;
    }

    public List<HSMComponent> getComponents() {
        return this.components;
    }

    public void setComponents(List<HSMComponent> components) {
        this.components = components;
    }

    public HSMCategory getCategory() {
        return this.category;
    }

    public void setCategory(HSMCategory category) {
        this.category = category;
    }

    public String toString() {
        return "WhatsAppTemplate{name='" + this.name + '\'' + ", language='" + this.language + '\'' + ", wabaID='" + this.wabaID + '\'' + ", components=" + this.components + ", category='" + (Object)((Object)this.category) + '\'' + '}';
    }

    public void validate() throws IllegalArgumentException {
        this.validateComponents();
        this.validateName();
        this.validateLanguage();
        this.validateWABAID();
        this.validateCategory();
    }

    private void validateComponents() throws IllegalArgumentException {
        boolean componentsNotEmpty;
        boolean bl = componentsNotEmpty = this.components != null && !this.components.isEmpty();
        if (componentsNotEmpty) {
            for (HSMComponent component : this.components) {
                component.validateComponent();
            }
        } else {
            throw new IllegalArgumentException("A \"components\" field is required and should not be empty list.");
        }
    }

    private void validateName() {
        if (this.name == null) {
            throw new IllegalArgumentException("A \"name\" field is required.");
        }
        if (this.name.length() == 0) {
            throw new IllegalArgumentException("A \"name\" field can not be an empty string.");
        }
    }

    private void validateLanguage() {
        if (this.language == null) {
            throw new IllegalArgumentException("A \"language\" field is required.");
        }
        if (this.language.length() == 0) {
            throw new IllegalArgumentException("A \"language\" field can not be an empty string.");
        }
    }

    private void validateWABAID() {
        if (this.wabaID == null) {
            throw new IllegalArgumentException("A \"wabaID\" field is required.");
        }
        if (this.wabaID.length() == 0) {
            throw new IllegalArgumentException("A \"wabaID\" field can not be an empty string.");
        }
    }

    private void validateCategory() {
        if (this.category == null) {
            throw new IllegalArgumentException("A \"category\" field is required.");
        }
    }
}

