/*
 * Decompiled with CFR 0.152.
 */
package com.messagebird.objects.conversations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum MessageComponentType {
    HEADER("header"),
    BODY("body"),
    FOOTER("footer"),
    BUTTON("button");

    private final String type;

    private MessageComponentType(String type) {
        this.type = type;
    }

    @JsonCreator
    public static MessageComponentType forValue(String value) {
        for (MessageComponentType componentType : MessageComponentType.values()) {
            if (!componentType.getType().equals(value)) continue;
            return componentType;
        }
        return null;
    }

    @JsonValue
    public String toJson() {
        return this.getType();
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.getType();
    }
}

