/*
 * Decompiled with CFR 0.152.
 */
package com.messagebird.objects.integrations;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.messagebird.objects.integrations.HSMComponentButton;
import com.messagebird.objects.integrations.HSMComponentFormat;
import com.messagebird.objects.integrations.HSMComponentType;
import com.messagebird.objects.integrations.HSMExample;
import java.util.List;

public class HSMComponent {
    private HSMComponentType type;
    private HSMComponentFormat format;
    private String text;
    @JsonProperty(value="add_security_recommendation")
    private Boolean addSecurityRecommendation;
    @JsonProperty(value="code_expiration_minutes")
    private Integer codeExpirationMinutes;
    private List<HSMComponentButton> buttons;
    private HSMExample example;

    public HSMComponentType getType() {
        return this.type;
    }

    public void setType(HSMComponentType type) {
        this.type = type;
    }

    public HSMComponentFormat getFormat() {
        return this.format;
    }

    public void setFormat(HSMComponentFormat format) {
        this.format = format;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<HSMComponentButton> getButtons() {
        return this.buttons;
    }

    public void setButtons(List<HSMComponentButton> buttons) {
        this.buttons = buttons;
    }

    public HSMExample getExample() {
        return this.example;
    }

    public void setExample(HSMExample example) {
        this.example = example;
    }

    public Boolean getAddSecurityRecommendation() {
        return this.addSecurityRecommendation;
    }

    public void setAddSecurityRecommendation(Boolean addSecurityRecommendation) {
        this.addSecurityRecommendation = addSecurityRecommendation;
    }

    public Integer getCodeExpirationMinutes() {
        return this.codeExpirationMinutes;
    }

    public void setCodeExpirationMinutes(Integer codeExpirationMinutes) {
        this.codeExpirationMinutes = codeExpirationMinutes;
    }

    public String toString() {
        return "HSMComponent{type='" + (Object)((Object)this.type) + '\'' + ", format='" + (Object)((Object)this.format) + '\'' + ", text='" + this.text + '\'' + ", buttons=" + this.buttons + ", example=" + this.example + '}';
    }

    public void validateComponent() throws IllegalArgumentException {
        this.validateButtons();
        this.validateComponentExample();
    }

    private void validateButtons() throws IllegalArgumentException {
        if (this.buttons == null) {
            return;
        }
        for (HSMComponentButton button : this.buttons) {
            button.validateButtonExample();
        }
    }

    private void validateComponentExample() throws IllegalArgumentException {
        boolean isHeaderUrlNotEmpty;
        boolean isExampleNotNull = this.example != null;
        boolean isHeaderTextNotEmpty = isExampleNotNull && this.example.getHeader_text() != null && !this.example.getHeader_text().isEmpty();
        boolean bl = isHeaderUrlNotEmpty = isExampleNotNull && this.example.getHeader_url() != null && !this.example.getHeader_url().isEmpty();
        if (isHeaderTextNotEmpty) {
            this.checkHeaderText();
        }
        if (isHeaderUrlNotEmpty) {
            this.checkHeaderUrl();
        }
    }

    private void checkHeaderText() throws IllegalArgumentException {
        if (!this.type.equals((Object)HSMComponentType.HEADER) || !this.format.equals((Object)HSMComponentFormat.TEXT)) {
            throw new IllegalArgumentException("\"header_text\" is available for only HEADER type and TEXT format.");
        }
    }

    private void checkHeaderUrl() throws IllegalArgumentException {
        if (!this.type.equals((Object)HSMComponentType.HEADER) || !this.format.equals((Object)HSMComponentFormat.IMAGE)) {
            throw new IllegalArgumentException("\"header_url\" is available for only HEADER type and IMAGE format.");
        }
    }
}

