/*
 * Decompiled with CFR 0.152.
 */
package com.messagebird.objects.integrations;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.messagebird.objects.integrations.HSMComponentButton;
import com.messagebird.objects.integrations.HSMComponentCard;
import com.messagebird.objects.integrations.HSMComponentFormat;
import com.messagebird.objects.integrations.HSMComponentType;
import com.messagebird.objects.integrations.HSMExample;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class HSMComponent {
    private HSMComponentType type;
    private HSMComponentFormat format;
    private String text;
    @JsonProperty(value="add_security_recommendation")
    private Boolean addSecurityRecommendation;
    @JsonProperty(value="code_expiration_minutes")
    private Integer codeExpirationMinutes;
    private List<HSMComponentButton> buttons;
    @JsonProperty(value="has_expiration")
    private Boolean hasExpiration;
    private List<HSMComponentCard> cards;
    private HSMExample example;

    public HSMComponentType getType() {
        return this.type;
    }

    public void setType(HSMComponentType type) {
        this.type = type;
    }

    public HSMComponentFormat getFormat() {
        return this.format;
    }

    public void setFormat(HSMComponentFormat format) {
        this.format = format;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            throw new IllegalArgumentException("Text cannot be null or empty");
        }
        this.text = text;
    }

    public List<HSMComponentButton> getButtons() {
        return this.buttons;
    }

    public void setButtons(List<HSMComponentButton> buttons) {
        this.buttons = buttons;
    }

    public List<HSMComponentCard> getCards() {
        return this.cards;
    }

    public void setCards(List<HSMComponentCard> cards) {
        this.cards = cards;
    }

    public HSMExample getExample() {
        return this.example;
    }

    public void setExample(HSMExample example) {
        this.example = example;
    }

    public Boolean getAddSecurityRecommendation() {
        return this.addSecurityRecommendation;
    }

    public void setAddSecurityRecommendation(Boolean addSecurityRecommendation) {
        this.addSecurityRecommendation = addSecurityRecommendation;
    }

    public Integer getCodeExpirationMinutes() {
        return this.codeExpirationMinutes;
    }

    public void setCodeExpirationMinutes(Integer codeExpirationMinutes) {
        this.codeExpirationMinutes = codeExpirationMinutes;
    }

    public Boolean getHasExpiration() {
        return this.hasExpiration;
    }

    public void setHasExpiration(Boolean hasExpiration) {
        this.hasExpiration = hasExpiration;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HSMComponent{");
        sb.append("type=").append((Object)this.type).append(", format=").append((Object)this.format).append(", text='").append(this.text).append('\'').append(", addSecurityRecommendation=").append(this.addSecurityRecommendation).append(", codeExpirationMinutes=").append(this.codeExpirationMinutes).append(", buttons=").append(this.buttons).append(", hasExpiration=").append(this.hasExpiration).append(", cards=").append(this.cards).append(", example=").append(this.example).append('}');
        return sb.toString();
    }

    public void validateComponent() throws IllegalArgumentException {
        try {
            this.validateButtons();
            this.validateComponentExample();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Component validation failed: " + e.getMessage(), e);
        }
    }

    private void validateButtons() throws IllegalArgumentException {
        if (this.buttons == null) {
            return;
        }
        for (HSMComponentButton button : this.buttons) {
            button.validateButtonExample();
        }
    }

    private void validateComponentExample() throws IllegalArgumentException {
        boolean isHeaderUrlNotEmpty;
        boolean isExampleNotNull = this.example != null;
        boolean isHeaderTextNotEmpty = isExampleNotNull && this.example.getHeader_text() != null && !this.example.getHeader_text().isEmpty();
        boolean bl = isHeaderUrlNotEmpty = isExampleNotNull && this.example.getHeader_url() != null && !this.example.getHeader_url().isEmpty();
        if (isHeaderTextNotEmpty) {
            this.checkHeaderText();
        }
        if (isHeaderUrlNotEmpty) {
            this.checkHeaderUrl();
        }
    }

    private void checkHeaderText() throws IllegalArgumentException {
        if (!HSMComponentType.HEADER.equals((Object)this.type) || !HSMComponentFormat.TEXT.equals((Object)this.format)) {
            throw new IllegalArgumentException("\"header_text\" is available for only HEADER type and TEXT format.");
        }
    }

    private void checkHeaderUrl() throws IllegalArgumentException {
        if (!HSMComponentType.HEADER.equals((Object)this.type) || !HSMComponentFormat.IMAGE.equals((Object)this.format) && !HSMComponentFormat.VIDEO.equals((Object)this.format) && !HSMComponentFormat.DOCUMENT.equals((Object)this.format)) {
            throw new IllegalArgumentException("\"header_url\" is available for only HEADER type and IMAGE, VIDEO, or DOCUMENT formats.");
        }
    }
}

