/*
 * Decompiled with CFR 0.152.
 */
package com.messagebird.objects.conversations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum TemplateMediaType {
    IMAGE("image"),
    DOCUMENT("document"),
    VIDEO("video"),
    TEXT("text"),
    CURRENCY("currency"),
    DATETIME("date_time"),
    PAYLOAD("payload"),
    EXPIRATION_TIME("expiration_time"),
    COUPON_CODE("coupon_code");

    private static final Map<String, TemplateMediaType> TYPE_MAP;
    private final String type;

    private TemplateMediaType(String type) {
        this.type = type;
    }

    @JsonCreator
    public static TemplateMediaType forValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        return TYPE_MAP.get(value.toLowerCase());
    }

    @JsonValue
    public String toJson() {
        return this.getType();
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.getType();
    }

    static {
        HashMap<String, TemplateMediaType> map = new HashMap<String, TemplateMediaType>();
        for (TemplateMediaType templateMediaType : TemplateMediaType.values()) {
            map.put(templateMediaType.getType().toLowerCase(), templateMediaType);
        }
        TYPE_MAP = Collections.unmodifiableMap(map);
    }
}

