/*
 * Decompiled with CFR 0.152.
 */
package com.messagegears.sdk;

import com.messagegears.sdk.MessageGearsProperties;
import com.messagegears.sdk.exception.MessageGearsClientException;
import com.messagegears.sdk.exception.MessageGearsServiceException;
import com.messagegears.sdk.model.Attachment;
import com.messagegears.sdk.model.Header;
import com.messagegears.sdk.model.TemplateLibrary;
import com.messagegears.sdk.model.request.AccountActivityRequest;
import com.messagegears.sdk.model.request.AccountSummaryRequest;
import com.messagegears.sdk.model.request.BaseJobRequest;
import com.messagegears.sdk.model.request.BulkCampaignSubmitRequest;
import com.messagegears.sdk.model.request.BulkJobSubmitRequest;
import com.messagegears.sdk.model.request.BulkJobSummaryRequest;
import com.messagegears.sdk.model.request.CreateAccountRequest;
import com.messagegears.sdk.model.request.ForwardToAFriendRequest;
import com.messagegears.sdk.model.request.JobRequest;
import com.messagegears.sdk.model.request.JobStateRequest;
import com.messagegears.sdk.model.request.JobStateRetrievalRequest;
import com.messagegears.sdk.model.request.MessagePreviewRequest;
import com.messagegears.sdk.model.request.RestRequestParam;
import com.messagegears.sdk.model.request.ThumbnailRequest;
import com.messagegears.sdk.model.request.TransactionalCampaignSubmitRequest;
import com.messagegears.sdk.model.request.TransactionalContentRetrievalRequest;
import com.messagegears.sdk.model.request.TransactionalJobSubmitRequest;
import com.messagegears.sdk.model.request.UpdateAccountRequest;
import com.messagegears.sdk.v3_1.AccountSummaryResponse;
import com.messagegears.sdk.v3_1.BulkJobSubmitResponse;
import com.messagegears.sdk.v3_1.BulkJobSummaryResponse;
import com.messagegears.sdk.v3_1.CreateAccountResponse;
import com.messagegears.sdk.v3_1.ForwardToAFriendResponse;
import com.messagegears.sdk.v3_1.JobStateResponse;
import com.messagegears.sdk.v3_1.MessagePreviewResponse;
import com.messagegears.sdk.v3_1.ThumbnailResponse;
import com.messagegears.sdk.v3_1.TransactionalContent;
import com.messagegears.sdk.v3_1.TransactionalJobSubmitResponse;
import com.messagegears.sdk.v3_1.UpdateAccountResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageGearsClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageGearsClient.class);
    private static final SimpleDateFormat activityDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat activityDateMonthlyFormat = new SimpleDateFormat("yyyy-MM");
    private MessageGearsProperties properties;

    public MessageGearsClient(MessageGearsProperties properties) {
        this.properties = properties;
    }

    public CreateAccountResponse createAccount(CreateAccountRequest request) {
        CreateAccountResponse response;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addCredentials(params);
        this.addParam(params, RestRequestParam.ACTION, request.getRequestType().getAction());
        this.addParam(params, RestRequestParam.NAME, request.getName());
        this.addParam(params, RestRequestParam.AUTOTRACK, request.isAutoTrack());
        this.addParam(params, RestRequestParam.URL_APPEND, request.getUrlAppend());
        this.addParam(params, RestRequestParam.CUSTOM_TRACKING_DOMAIN, request.getCustomTrackingDomain());
        String xmlResponse = this.invoke(params);
        StringReader reader = new StringReader(xmlResponse);
        try {
            response = CreateAccountResponse.unmarshal(reader);
        }
        catch (Exception e) {
            throw new MessageGearsClientException(e);
        }
        return response;
    }

    public UpdateAccountResponse updateAccount(UpdateAccountRequest request) {
        UpdateAccountResponse response;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addCredentials(params);
        this.addParam(params, RestRequestParam.ACTION, request.getRequestType().getAction());
        this.addParam(params, RestRequestParam.NAME, request.getName());
        this.addParam(params, RestRequestParam.AUTOTRACK, request.isAutoTrack());
        this.addParam(params, RestRequestParam.URL_APPEND, request.getUrlAppend());
        this.addParam(params, RestRequestParam.CUSTOM_TRACKING_DOMAIN, request.getCustomTrackingDomain());
        String xmlResponse = this.invoke(params);
        StringReader reader = new StringReader(xmlResponse);
        try {
            response = UpdateAccountResponse.unmarshal(reader);
        }
        catch (Exception e) {
            throw new MessageGearsClientException(e);
        }
        return response;
    }

    public ThumbnailResponse thumbnail(ThumbnailRequest request) {
        ThumbnailResponse response;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addCredentials(params);
        this.addParam(params, RestRequestParam.ACTION, request.getRequestType().getAction());
        this.addParam(params, RestRequestParam.CONTENT, request.getContent());
        this.addParam(params, RestRequestParam.IMAGE_ID, request.getImageId());
        this.addParam(params, RestRequestParam.IMAGE_SIZE, request.getThumbnailSize().name());
        String xmlResponse = this.invoke(params);
        StringReader reader = new StringReader(xmlResponse);
        try {
            response = ThumbnailResponse.unmarshal(reader);
        }
        catch (Exception e) {
            throw new MessageGearsClientException(e);
        }
        return response;
    }

    public TransactionalJobSubmitResponse transactionalCampaignSubmit(TransactionalCampaignSubmitRequest request) {
        TransactionalJobSubmitResponse response;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addCredentials(params);
        this.addParam(params, RestRequestParam.ACTION, request.getRequestType().getAction());
        this.addParam(params, RestRequestParam.CONTEXT_DATA_XML, request.getContextDataXml());
        this.addParam(params, RestRequestParam.RECIPIENT_XML, request.getRecipientXml());
        this.addBaseJobRequestParams(params, request);
        this.addParam(params, RestRequestParam.CAMPAIGN_ID, Long.toString(request.getCampaignId()));
        String xmlResponse = this.invoke(params);
        StringReader reader = new StringReader(xmlResponse);
        try {
            response = TransactionalJobSubmitResponse.unmarshal(reader);
        }
        catch (Exception e) {
            throw new MessageGearsClientException(e);
        }
        return response;
    }

    public TransactionalJobSubmitResponse transactionalJobSubmit(TransactionalJobSubmitRequest request) {
        TransactionalJobSubmitResponse response;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addCredentials(params);
        this.addParam(params, RestRequestParam.ACTION, request.getRequestType().getAction());
        this.addParam(params, RestRequestParam.CONTEXT_DATA_XML, request.getContextDataXml());
        this.addParam(params, RestRequestParam.RECIPIENT_XML, request.getRecipientXml());
        this.addJobRequestParams(params, request);
        String xmlResponse = this.invoke(params);
        StringReader reader = new StringReader(xmlResponse);
        try {
            response = TransactionalJobSubmitResponse.unmarshal(reader);
        }
        catch (Exception e) {
            throw new MessageGearsClientException(e);
        }
        return response;
    }

    public BulkJobSubmitResponse bulkJobSubmit(BulkJobSubmitRequest request) {
        BulkJobSubmitResponse response;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addCredentials(params);
        this.addParam(params, RestRequestParam.ACTION, request.getRequestType().getAction());
        this.addParam(params, RestRequestParam.RECIPIENT_LIST_XML_URL, request.getRecipientListXmlUrl());
        this.addParam(params, RestRequestParam.SUPRESSION_LIST_XML_URL, request.getSuppressionXmlUrl());
        this.addParam(params, RestRequestParam.SUPRESSION_LIST_CSV_URL, request.getSuppressionCsvUrl());
        this.addParam(params, RestRequestParam.CONTEXT_DATA_XML, request.getContextDataXml());
        this.addJobRequestParams(params, request);
        String xmlResponse = this.invoke(params);
        StringReader reader = new StringReader(xmlResponse);
        try {
            response = BulkJobSubmitResponse.unmarshal(reader);
        }
        catch (Exception e) {
            throw new MessageGearsClientException(e);
        }
        return response;
    }

    public BulkJobSubmitResponse bulkCampaignSubmit(BulkCampaignSubmitRequest request) {
        BulkJobSubmitResponse response;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addCredentials(params);
        this.addParam(params, RestRequestParam.ACTION, request.getRequestType().getAction());
        this.addParam(params, RestRequestParam.RECIPIENT_LIST_XML_URL, request.getRecipientListXmlUrl());
        this.addParam(params, RestRequestParam.SUPRESSION_LIST_XML_URL, request.getSuppressionXmlUrl());
        this.addParam(params, RestRequestParam.SUPRESSION_LIST_CSV_URL, request.getSuppressionCsvUrl());
        this.addParam(params, RestRequestParam.CONTEXT_DATA_XML, request.getContextDataXml());
        this.addBaseJobRequestParams(params, request);
        this.addParam(params, RestRequestParam.CAMPAIGN_ID, Long.toString(request.getCampaignId()));
        String xmlResponse = this.invoke(params);
        StringReader reader = new StringReader(xmlResponse);
        try {
            response = BulkJobSubmitResponse.unmarshal(reader);
        }
        catch (Exception e) {
            throw new MessageGearsClientException(e);
        }
        return response;
    }

    public MessagePreviewResponse messagePreview(MessagePreviewRequest request) {
        MessagePreviewResponse response;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addCredentials(params);
        this.addParam(params, RestRequestParam.ACTION, request.getRequestType().getAction());
        this.addJobRequestParams(params, request);
        this.addParam(params, RestRequestParam.RECIPIENT_XML, request.getRecipientXml());
        this.addParam(params, RestRequestParam.CONTEXT_DATA_XML, request.getContextDataXml());
        String xmlResponse = this.invoke(params);
        StringReader reader = new StringReader(xmlResponse);
        try {
            response = MessagePreviewResponse.unmarshal(reader);
        }
        catch (Exception e) {
            throw new MessageGearsClientException(e);
        }
        return response;
    }

    public TransactionalContent transactionalContentRetrieval(TransactionalContentRetrievalRequest request) {
        TransactionalContent response;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addCredentials(params);
        this.addParam(params, RestRequestParam.ACTION, request.getRequestType().getAction());
        this.addParam(params, RestRequestParam.ORIGINAL_REQUEST_ID, request.getOriginalRequestId());
        String xmlResponse = this.invoke(params);
        StringReader reader = new StringReader(xmlResponse);
        try {
            response = TransactionalContent.unmarshal(reader);
        }
        catch (Exception e) {
            throw new MessageGearsClientException(e);
        }
        return response;
    }

    public JobStateResponse setJobState(JobStateRequest request) {
        JobStateResponse response;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addCredentials(params);
        this.addParam(params, RestRequestParam.ACTION, request.getRequestType().getAction());
        this.addParam(params, RestRequestParam.JOB_REQUEST_ID, request.getJobRequestId());
        this.addParam(params, RestRequestParam.JOB_STATUS, request.getStatus().toString());
        String xmlResponse = this.invoke(params);
        StringReader reader = new StringReader(xmlResponse);
        try {
            response = JobStateResponse.unmarshal(reader);
        }
        catch (Exception e) {
            throw new MessageGearsClientException(e);
        }
        return response;
    }

    public JobStateResponse retrieveJobState(JobStateRetrievalRequest request) {
        JobStateResponse response;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addCredentials(params);
        this.addParam(params, RestRequestParam.ACTION, request.getRequestType().getAction());
        this.addParam(params, RestRequestParam.JOB_REQUEST_ID, request.getJobRequestId());
        String xmlResponse = this.invoke(params);
        StringReader reader = new StringReader(xmlResponse);
        try {
            response = JobStateResponse.unmarshal(reader);
        }
        catch (Exception e) {
            throw new MessageGearsClientException(e);
        }
        return response;
    }

    public AccountSummaryResponse accountSummary(AccountSummaryRequest request) {
        AccountSummaryResponse response;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addCredentials(params);
        this.addParam(params, RestRequestParam.ACTION, request.getRequestType().getAction());
        if (request.isMonthly()) {
            this.addParam(params, RestRequestParam.ACTIVITY_DATE, activityDateMonthlyFormat.format(request.getDate()));
        } else {
            this.addParam(params, RestRequestParam.ACTIVITY_DATE, activityDateFormat.format(request.getDate()));
        }
        String xmlResponse = this.invoke(params);
        StringReader reader = new StringReader(xmlResponse);
        try {
            response = AccountSummaryResponse.unmarshal(reader);
        }
        catch (Exception e) {
            throw new MessageGearsClientException(e);
        }
        return response;
    }

    public BulkJobSummaryResponse bulkJobSummary(BulkJobSummaryRequest request) {
        BulkJobSummaryResponse response;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addCredentials(params);
        this.addParam(params, RestRequestParam.ACTION, request.getRequestType().getAction());
        this.addParam(params, RestRequestParam.BULK_REQUEST_ID, request.getRequestId());
        this.addParam(params, RestRequestParam.BULK_CORRELATION_ID, request.getCorrelationId());
        String xmlResponse = this.invoke(params);
        StringReader reader = new StringReader(xmlResponse);
        try {
            response = BulkJobSummaryResponse.unmarshal(reader);
        }
        catch (Exception e) {
            throw new MessageGearsClientException(e);
        }
        return response;
    }

    public String accountActivity(AccountActivityRequest request) {
        String fileName = this.properties.getDownloadDirectory() + activityDateFormat.format(request.getDate()) + "_" + (Object)((Object)request.getActivityType()) + ".xml";
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addCredentials(params);
        this.addParam(params, RestRequestParam.ACTION, request.getRequestType().getAction());
        this.addParam(params, RestRequestParam.ACTIVITY_DATE, activityDateFormat.format(request.getDate()));
        this.addParam(params, RestRequestParam.ACTIVITY_TYPE, request.getActivityType().name());
        LOGGER.info("Starting activity file download for date: " + activityDateFormat.format(request.getDate()));
        this.invoke(params, new File(fileName));
        LOGGER.info("Download complete.");
        return fileName;
    }

    public ForwardToAFriendResponse forwardToAFriendSubmit(ForwardToAFriendRequest request) {
        ForwardToAFriendResponse response;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addCredentials(params);
        this.addParam(params, RestRequestParam.ACTION, request.getRequestType().getAction());
        this.addParam(params, RestRequestParam.RECIPIENT_TOKEN, request.getRecipientToken());
        this.addParam(params, RestRequestParam.RECIPIENT_XML, request.getRecipientXml());
        this.addBaseJobRequestParams(params, request);
        this.addParam(params, RestRequestParam.CAMPAIGN_ID, Long.toString(request.getCampaignId()));
        String xmlResponse = this.invoke(params);
        StringReader reader = new StringReader(xmlResponse);
        try {
            response = ForwardToAFriendResponse.unmarshal(reader);
        }
        catch (Exception e) {
            throw new MessageGearsClientException(e);
        }
        return response;
    }

    private void addJobRequestParams(List<NameValuePair> params, JobRequest request) {
        this.addBaseJobRequestParams(params, request);
        this.addParam(params, RestRequestParam.TEXT_TEMPLATE, request.getTextTemplate());
        this.addParam(params, RestRequestParam.FROM_ADDRESS, request.getFromAddress());
        this.addParam(params, RestRequestParam.FROM_NAME, request.getFromName());
        this.addParam(params, RestRequestParam.SUBJECT_LINE, request.getSubjectLine());
        this.addParam(params, RestRequestParam.HTML_TEMPLATE, request.getHtmlTemplate());
        if (request.getTemplateLanguage() != null) {
            this.addParam(params, RestRequestParam.TEMPLATE_LANGUAGE, request.getTemplateLanguage().name());
        }
        if (request.getCharacterSet() != null) {
            this.addParam(params, RestRequestParam.CHARACTER_SET, request.getCharacterSet());
        }
        this.addParam(params, RestRequestParam.REPLY_TO_ADDRESS, request.getReplyToAddress());
        this.addParam(params, RestRequestParam.ON_BEHALF_OF_ADDRESS, request.getOnBehalfOfAddress());
        this.addParam(params, RestRequestParam.ON_BEHALF_OF_NAME, request.getOnBehalfOfName());
        this.addParam(params, RestRequestParam.AUTOTRACK, request.isAutoTrack());
        this.addParam(params, RestRequestParam.URL_APPEND, request.getUrlAppend());
        this.addParam(params, RestRequestParam.CUSTOM_TRACKING_DOMAIN, request.getCustomTrackingDomain());
        this.addParam(params, RestRequestParam.UNSUBSCRIBE_HEADER, request.isUnsubscribeHeader());
        this.addParam(params, RestRequestParam.JOB_CATEGORY, request.getJobCategory());
        this.addParam(params, RestRequestParam.TEMPLATE_LIBRARY, request.getTemplateLibrary());
        this.addAttachments(params, request.getAttachments());
        this.addHeaders(params, request.getHeaders());
        this.addTemplateLibraries(params, request.getTemplateLibraries());
    }

    private void addBaseJobRequestParams(List<NameValuePair> params, BaseJobRequest request) {
        this.addParam(params, RestRequestParam.NOTIFICATION_EMAIL_ADDRESS, request.getNotificationEmailAddress());
        this.addParam(params, RestRequestParam.CORRELATION_ID, request.getCorrelationId());
    }

    private String invoke(List<NameValuePair> params) {
        String xmlResponse;
        HttpResponse httpResponse = this.submitHttpRequest(params);
        try {
            xmlResponse = IOUtils.toString((InputStream)httpResponse.getEntity().getContent());
        }
        catch (IOException e) {
            throw new MessageGearsClientException(e);
        }
        return xmlResponse;
    }

    private void invoke(List<NameValuePair> params, File outputFile) {
        try {
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            HttpResponse httpResponse = this.submitHttpRequest(params);
            IOUtils.copy((InputStream)httpResponse.getEntity().getContent(), (OutputStream)outputStream);
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.debug("Error accessing the download directory specified in your properties file.");
            throw new MessageGearsClientException("Could not write account activity results.");
        }
        catch (IOException ioe) {
            LOGGER.debug(ioe.getMessage(), (Throwable)ioe);
            throw new MessageGearsClientException("Could not write account activity results.");
        }
    }

    private HttpResponse submitHttpRequest(List<NameValuePair> params) {
        UrlEncodedFormEntity entity;
        try {
            entity = new UrlEncodedFormEntity(params, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MessageGearsClientException(e);
        }
        HttpPost httpPost = new HttpPost(this.properties.getMessageGearsEndPoint());
        httpPost.setEntity((HttpEntity)entity);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new MessageGearsServiceException("Http Status Code: " + httpResponse.getStatusLine().getStatusCode() + " " + IOUtils.toString((InputStream)httpResponse.getEntity().getContent()));
            }
        }
        catch (IOException e) {
            throw new MessageGearsClientException(e);
        }
        return httpResponse;
    }

    private void addCredentials(List<NameValuePair> params) {
        this.addParam(params, RestRequestParam.ACCOUNT_ID, this.properties.getMyMessageGearsAccountId());
        this.addParam(params, RestRequestParam.API_KEY, this.properties.getMyMessageGearsApiKey());
    }

    private void addParam(List<NameValuePair> params, RestRequestParam param, String value) {
        this.addParam(params, param.getParamName(), value);
    }

    private void addParam(List<NameValuePair> params, String param, String value) {
        params.add((NameValuePair)new BasicNameValuePair(param, value));
    }

    private void addParam(List<NameValuePair> params, RestRequestParam param, boolean value) {
        if (value) {
            params.add((NameValuePair)new BasicNameValuePair(param.getParamName(), "true"));
        } else {
            params.add((NameValuePair)new BasicNameValuePair(param.getParamName(), "false"));
        }
    }

    private void addAttachments(List<NameValuePair> params, List<Attachment> attachments) {
        for (int i = 0; i < attachments.size(); ++i) {
            this.addParam(params, RestRequestParam.ATTACHMENT_CONTENT.getParamName() + "." + Integer.toString(i + 1), attachments.get(i).getContent());
            this.addParam(params, RestRequestParam.ATTACHMENT_URL.getParamName() + "." + Integer.toString(i + 1), attachments.get(i).getUrl());
            this.addParam(params, RestRequestParam.ATTACHMENT_NAME.getParamName() + "." + Integer.toString(i + 1), attachments.get(i).getName());
            this.addParam(params, RestRequestParam.ATTACHMENT_CONTENT_TYPE.getParamName() + "." + Integer.toString(i + 1), attachments.get(i).getContentType());
        }
    }

    private void addHeaders(List<NameValuePair> params, List<Header> headers) {
        for (int i = 0; i < headers.size(); ++i) {
            this.addParam(params, RestRequestParam.HEADER_NAME.getParamName() + "." + Integer.toString(i + 1), headers.get(i).getName());
            this.addParam(params, RestRequestParam.HEADER_VALUE.getParamName() + "." + Integer.toString(i + 1), headers.get(i).getValue());
        }
    }

    private void addTemplateLibraries(List<NameValuePair> params, List<TemplateLibrary> libraries) {
        if (libraries != null) {
            for (int i = 0; i < libraries.size(); ++i) {
                this.addParam(params, RestRequestParam.TEMPLATE_LIBRARY_NAME.getParamName() + "." + Integer.toString(i + 1), libraries.get(i).getName());
                this.addParam(params, RestRequestParam.TEMPLATE_LIBRARY_CONTENT.getParamName() + "." + Integer.toString(i + 1), libraries.get(i).getContent());
            }
        }
    }
}

