/*
 * Decompiled with CFR 0.152.
 */
package com.messagegears.sdk.activity;

import com.messagegears.sdk.MessageGearsErrorHandler;
import com.messagegears.sdk.MessageGearsListener;
import com.messagegears.sdk.exception.MessageGearsDefaultErrorHandler;
import com.messagegears.sdk.model.ActivityType;
import com.messagegears.sdk.v3_1.BouncedMessageActivity;
import com.messagegears.sdk.v3_1.ClickActivity;
import com.messagegears.sdk.v3_1.DeliveredMessageActivity;
import com.messagegears.sdk.v3_1.InboundEmailActivity;
import com.messagegears.sdk.v3_1.JobErrorActivity;
import com.messagegears.sdk.v3_1.OpenActivity;
import com.messagegears.sdk.v3_1.RenderErrorActivity;
import com.messagegears.sdk.v3_1.RequestActivity;
import com.messagegears.sdk.v3_1.SmsDeliveredActivity;
import com.messagegears.sdk.v3_1.SmsDeliveryFailureActivity;
import com.messagegears.sdk.v3_1.SmsInboundActivity;
import com.messagegears.sdk.v3_1.SmsRenderErrorActivity;
import com.messagegears.sdk.v3_1.SpamComplaintActivity;
import com.messagegears.sdk.v3_1.UnsubActivity;
import java.io.StringReader;
import org.apache.commons.lang.StringEscapeUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ActivityFileSaxHandler
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivityFileSaxHandler.class);
    private MessageGearsListener listener;
    private MessageGearsErrorHandler errorHandler;
    private ActivityType activityType;
    private String activityXml = "";
    private boolean inActivityItems = false;
    private long numItems = 0L;

    public ActivityFileSaxHandler(MessageGearsListener listener, ActivityType activityType) {
        this.listener = listener;
        this.errorHandler = new MessageGearsDefaultErrorHandler();
        this.activityType = activityType;
    }

    public ActivityFileSaxHandler(MessageGearsListener listener, MessageGearsErrorHandler errorHandler, ActivityType activityType) {
        this.listener = listener;
        this.errorHandler = errorHandler;
        this.activityType = activityType;
    }

    public void startDocument() {
        this.numItems = 0L;
    }

    public void endDocument() {
        LOGGER.debug("Parsing Complete. Number of Items Found: " + this.numItems);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (!qName.equals("ActivityItems")) {
            if (this.inActivityItems) {
                this.activityXml = this.activityXml + "<" + qName + ">";
            }
        } else {
            this.inActivityItems = true;
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inActivityItems) {
            String string = new String(ch);
            String substring = string.substring(start, start + length);
            this.activityXml = this.activityXml + StringEscapeUtils.escapeXml((String)substring);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        if (this.inActivityItems) {
            if (!qName.equals("ActivityItems")) {
                this.activityXml = this.activityXml + "</" + qName + ">";
                if (qName.equals(this.activityType.getXmlTag())) {
                    ++this.numItems;
                    this.processElement(this.activityXml);
                    this.activityXml = "";
                }
            } else {
                this.inActivityItems = false;
            }
        }
    }

    public long getNumItems() {
        return this.numItems;
    }

    private void processElement(String xml) {
        try {
            StringReader reader = new StringReader(xml);
            if (this.activityType.equals((Object)ActivityType.BOUNCES)) {
                this.listener.onBounce(BouncedMessageActivity.unmarshal(reader));
            } else if (this.activityType.equals((Object)ActivityType.CLICKS)) {
                this.listener.onClick(ClickActivity.unmarshal(reader));
            } else if (this.activityType.equals((Object)ActivityType.DELIVERIES)) {
                this.listener.onDelivery(DeliveredMessageActivity.unmarshal(reader));
            } else if (this.activityType.equals((Object)ActivityType.JOB_ERRORS)) {
                this.listener.onJobError(JobErrorActivity.unmarshal(reader));
            } else if (this.activityType.equals((Object)ActivityType.OPENS)) {
                this.listener.onOpen(OpenActivity.unmarshal(reader));
            } else if (this.activityType.equals((Object)ActivityType.RENDER_ERRORS)) {
                this.listener.onRenderError(RenderErrorActivity.unmarshal(reader));
            } else if (this.activityType.equals((Object)ActivityType.SPAM_COMPLAINTS)) {
                this.listener.onSpamComplaint(SpamComplaintActivity.unmarshal(reader));
            } else if (this.activityType.equals((Object)ActivityType.UNSUBSCRIBES)) {
                this.listener.onUnsub(UnsubActivity.unmarshal(reader));
            } else if (this.activityType.equals((Object)ActivityType.INBOUND_EMAIL_ACTIVITY)) {
                this.listener.onInboundEmail(InboundEmailActivity.unmarshal(reader));
            } else if (this.activityType.equals((Object)ActivityType.SMS_DELIVERED_ACTIVITY)) {
                this.listener.onSmsDeliveryActivity(SmsDeliveredActivity.unmarshal(reader));
            } else if (this.activityType.equals((Object)ActivityType.SMS_DELIVERY_FAILURE_ACTIVITY)) {
                this.listener.onSmsDeliveryFailureActivity(SmsDeliveryFailureActivity.unmarshal(reader));
            } else if (this.activityType.equals((Object)ActivityType.SMS_INBOUND_ACTIVITY)) {
                this.listener.onSmsInboundActivity(SmsInboundActivity.unmarshal(reader));
            } else if (this.activityType.equals((Object)ActivityType.SMS_RENDER_ERROR_ACTIVITY)) {
                this.listener.onSmsRenderErrorActivity(SmsRenderErrorActivity.unmarshal(reader));
            } else if (this.activityType.equals((Object)ActivityType.REQUEST_ACTIVITY)) {
                this.listener.onRequestActivity(RequestActivity.unmarshal(reader));
            } else {
                LOGGER.warn("Unrecognized ActivityType: " + (Object)((Object)this.activityType));
                this.errorHandler.handleUnprocessedMessage(xml);
            }
        }
        catch (MarshalException me) {
            LOGGER.debug(me.getMessage(), (Throwable)me);
            this.errorHandler.handleUnprocessedMessage(xml, (Exception)((Object)me));
        }
        catch (ValidationException ve) {
            LOGGER.debug(ve.getMessage(), (Throwable)ve);
            this.errorHandler.handleUnprocessedMessage(xml, (Exception)((Object)ve));
        }
    }
}

