/*
 * Decompiled with CFR 0.152.
 */
package com.messagegears.sdk.activity;

import com.messagegears.sdk.MessageGearsErrorHandler;
import com.messagegears.sdk.MessageGearsListener;
import com.messagegears.sdk.activity.ActivityFileSaxHandler;
import com.messagegears.sdk.exception.MessageGearsClientException;
import com.messagegears.sdk.exception.MessageGearsDefaultErrorHandler;
import com.messagegears.sdk.model.ActivityType;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MessageGearsActivityFileProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageGearsActivityFileProcessor.class);
    private MessageGearsListener listener;
    private MessageGearsErrorHandler errorHandler;

    public MessageGearsActivityFileProcessor(MessageGearsListener listener) {
        this.listener = listener;
        this.errorHandler = new MessageGearsDefaultErrorHandler();
    }

    public MessageGearsActivityFileProcessor(MessageGearsListener listener, MessageGearsErrorHandler errorHandler) {
        this.listener = listener;
        this.errorHandler = errorHandler;
    }

    public void process(InputStream inputStream, ActivityType activityType) {
        try {
            ActivityFileSaxHandler saxHandler = new ActivityFileSaxHandler(this.listener, this.errorHandler, activityType);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            SAXParser parser = factory.newSAXParser();
            XMLReader xr = parser.getXMLReader();
            xr.setContentHandler(saxHandler);
            xr.setErrorHandler(saxHandler);
            xr.parse(new InputSource(inputStream));
            LOGGER.debug("Stream contained " + saxHandler.getNumItems() + " activity items.");
        }
        catch (ParserConfigurationException pce) {
            LOGGER.debug(pce.getMessage(), (Throwable)pce);
            throw new MessageGearsClientException("Parser Configuration Error");
        }
        catch (SAXException saxe) {
            LOGGER.debug(saxe.getMessage(), (Throwable)saxe);
            throw new MessageGearsClientException("Error Parsing Input Source");
        }
        catch (IOException ioe) {
            LOGGER.debug(ioe.getMessage(), (Throwable)ioe);
            throw new MessageGearsClientException("Error Parsing Input Source");
        }
    }
}

