/*
 * Decompiled with CFR 0.152.
 */
package com.messagegears.sdk.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.CanonicalGrantee;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.Permission;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.AddPermissionRequest;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import com.messagegears.sdk.aws.MessageGearsAwsProperties;
import com.messagegears.sdk.exception.MessageGearsClientException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageGearsAwsClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageGearsAwsClient.class);
    MessageGearsAwsProperties properties;
    AmazonSQSClient sqs;
    AmazonS3Client s3;

    public MessageGearsAwsClient(MessageGearsAwsProperties properties) {
        this.properties = properties;
        BasicAWSCredentials credentials = new BasicAWSCredentials(properties.getMyAwsAccountKey(), properties.getMyAwsSecretKey());
        this.sqs = new AmazonSQSClient((AWSCredentials)credentials);
        this.s3 = new AmazonS3Client((AWSCredentials)credentials);
    }

    public File compressFile(File file) throws IOException {
        String filename = file.getName();
        String compressedFileName = filename.replace(".xml", ".zip");
        File compressedFile = new File(compressedFileName);
        FileInputStream inputStream = new FileInputStream(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(compressedFile, false));
        zipOutputStream.putNextEntry(new ZipEntry(filename));
        IOUtils.copyLarge((InputStream)inputStream, (OutputStream)zipOutputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)zipOutputStream);
        return compressedFile;
    }

    public void putS3File(InputStream inputStream, String bucketName, String key) {
        ListObjectsRequest listRequest = new ListObjectsRequest().withBucketName(bucketName).withPrefix(key);
        ObjectListing objectListing = this.listObjectsWithRetry(listRequest);
        if (objectListing.getObjectSummaries().size() > 0) {
            String message = "File " + key + " already exists.";
            LOGGER.warn("putS3File failed: " + message);
            throw new MessageGearsClientException(message);
        }
        ObjectMetadata metaData = new ObjectMetadata();
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, inputStream, metaData);
        this.putWithRetry(putObjectRequest);
        this.setS3Permission(bucketName, key);
        LOGGER.info("putS3File successful: " + key);
    }

    public void deleteS3File(String bucketName, String key) {
        DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(bucketName, key);
        try {
            this.deleteWithRetry(deleteObjectRequest);
            LOGGER.info("deleteS3File successful: " + bucketName + "/" + key);
        }
        catch (AmazonClientException ace) {
            LOGGER.warn("Failed to delete file from S3: " + bucketName + "/" + key);
        }
    }

    public String createQueue(String queueName) {
        CreateQueueRequest request = new CreateQueueRequest().withQueueName(queueName).withDefaultVisibilityTimeout(Integer.valueOf(this.properties.getSqsVisibilityTimeoutSecs()));
        CreateQueueResult response = this.sqs.createQueue(request);
        this.addQueuePermission(response.getQueueUrl());
        this.setMaximumMessageSize(response.getQueueUrl());
        LOGGER.info("Create queue successful: " + queueName);
        return response.getQueueUrl();
    }

    public ReceiveMessageResult receiveMessage(ReceiveMessageRequest request) {
        return this.sqs.receiveMessage(request);
    }

    public void deleteSqsMessage(DeleteMessageRequest request) {
        this.sqs.deleteMessage(request);
    }

    private void setS3Permission(String bucketName, String key) {
        AccessControlList acl = new AccessControlList();
        acl.setOwner(this.s3.getS3AccountOwner());
        CanonicalGrantee grantee = new CanonicalGrantee(this.properties.getMessageGearsAwsCanonicalId());
        acl.grantPermission((Grantee)grantee, Permission.Read);
        this.s3.setObjectAcl(bucketName, key, acl);
    }

    private void setMaximumMessageSize(String queueUrl) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("MaximumMessageSize", "65536");
        SetQueueAttributesRequest request = new SetQueueAttributesRequest().withQueueUrl(queueUrl).withAttributes(attributes);
        this.sqs.setQueueAttributes(request);
    }

    private void addQueuePermission(String queueUrl) {
        AddPermissionRequest permissionRequest = new AddPermissionRequest().withActions(new String[]{"SendMessage"}).withAWSAccountIds(new String[]{this.properties.getMessageGearsAwsAccountId()}).withLabel("MessageGears Send Permission").withQueueUrl(queueUrl);
        this.sqs.addPermission(permissionRequest);
    }

    private void putWithRetry(PutObjectRequest request) {
        for (int i = 0; i < 5; ++i) {
            try {
                this.s3.putObject(request);
                LOGGER.info("Successfully uploaded file to S3: " + request.toString());
                return;
            }
            catch (AmazonClientException ace) {
                LOGGER.debug("Failed to upload file to S3: " + ace.getMessage(), (Throwable)ace);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new AmazonClientException("Failed to upload file, thread interrupted during retry.");
                }
            }
            catch (Exception e) {
                LOGGER.debug("Failed to upload file to S3: " + e.getMessage(), (Throwable)e);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new AmazonClientException("Failed to upload file, thread interrupted during retry.");
                }
            }
        }
        throw new AmazonClientException("Failed to upload file to S3.");
    }

    private void deleteWithRetry(DeleteObjectRequest request) {
        for (int i = 0; i < 5; ++i) {
            try {
                this.s3.deleteObject(request);
                LOGGER.info("Successfully deleted file on S3: " + request.toString());
                return;
            }
            catch (AmazonClientException ace) {
                LOGGER.debug("Failed to delete file from S3: " + ace.getMessage(), (Throwable)ace);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new AmazonClientException("Failed to delete file, thread interrupted during retry.");
                }
            }
            catch (Exception e) {
                LOGGER.debug("Failed to delete file from S3: " + e.getMessage(), (Throwable)e);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new AmazonClientException("Failed to delete file, thread interrupted during retry.");
                }
            }
        }
        throw new AmazonClientException("Failed to delete file from S3.");
    }

    private ObjectListing listObjectsWithRetry(ListObjectsRequest request) {
        for (int i = 0; i < 5; ++i) {
            try {
                return this.s3.listObjects(request);
            }
            catch (AmazonClientException ace) {
                LOGGER.debug("Failed to list objects from S3: " + ace.getMessage(), (Throwable)ace);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new AmazonClientException("Failed to list objects, thread interrupted during retry.");
                }
            }
            catch (Exception e) {
                LOGGER.debug("Failed to list objects from S3: " + e.getMessage(), (Throwable)e);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new AmazonClientException("Failed to list objects, thread interrupted during retry.");
                }
            }
        }
        throw new AmazonClientException("Failed to list objects from S3.");
    }
}

