/*
 * Decompiled with CFR 0.152.
 */
package com.messagegears.sdk.aws;

import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.messagegears.sdk.MessageGearsErrorHandler;
import com.messagegears.sdk.MessageGearsListener;
import com.messagegears.sdk.aws.MessageGearsAwsClient;
import com.messagegears.sdk.aws.MessageGearsAwsProperties;
import com.messagegears.sdk.exception.MessageGearsClientException;
import com.messagegears.sdk.exception.MessageGearsDefaultErrorHandler;
import com.messagegears.sdk.v3_1.ActivityItems;
import com.messagegears.sdk.v3_1.BouncedMessageActivity;
import com.messagegears.sdk.v3_1.ClickActivity;
import com.messagegears.sdk.v3_1.DeliveredMessageActivity;
import com.messagegears.sdk.v3_1.InboundEmailActivity;
import com.messagegears.sdk.v3_1.JobErrorActivity;
import com.messagegears.sdk.v3_1.OpenActivity;
import com.messagegears.sdk.v3_1.RenderErrorActivity;
import com.messagegears.sdk.v3_1.RequestActivity;
import com.messagegears.sdk.v3_1.SmsDeliveredActivity;
import com.messagegears.sdk.v3_1.SmsDeliveryFailureActivity;
import com.messagegears.sdk.v3_1.SmsInboundActivity;
import com.messagegears.sdk.v3_1.SmsRenderErrorActivity;
import com.messagegears.sdk.v3_1.SpamComplaintActivity;
import com.messagegears.sdk.v3_1.UnsubActivity;
import java.io.Serializable;
import java.io.StringReader;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageGearsAwsQueuePoller {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageGearsAwsQueuePoller.class);
    private static final int DEFAULT_WAIT_BETWEEN_RECEIVE = 10000;
    private boolean isRunning = false;
    MessageGearsAwsProperties mgAwsProperties;
    MessageGearsAwsClient client;
    MessageGearsListener listener;
    MessageGearsErrorHandler errorHandler;

    public MessageGearsAwsQueuePoller(MessageGearsAwsProperties mgAwsProperties, MessageGearsListener listener) {
        this.mgAwsProperties = mgAwsProperties;
        this.client = new MessageGearsAwsClient(mgAwsProperties);
        this.listener = listener;
        this.errorHandler = new MessageGearsDefaultErrorHandler();
    }

    public MessageGearsAwsQueuePoller(MessageGearsAwsProperties mgAwsProperties, MessageGearsErrorHandler errorHandler, MessageGearsListener listener) {
        this.mgAwsProperties = mgAwsProperties;
        this.client = new MessageGearsAwsClient(mgAwsProperties);
        this.listener = listener;
        this.errorHandler = errorHandler;
    }

    public void stop() {
        this.isRunning = false;
    }

    public boolean isActive() {
        return this.isRunning;
    }

    public void start() {
        this.isRunning = true;
        while (this.isRunning) {
            ReceiveMessageRequest request = new ReceiveMessageRequest();
            request.setQueueUrl(this.mgAwsProperties.getMyAwsEventQueueUrl());
            ReceiveMessageResult receiveMessageResult = this.client.receiveMessage(request);
            List messages = receiveMessageResult.getMessages();
            if (messages != null && messages.size() > 0) {
                for (Message message : messages) {
                    LOGGER.debug("Found item on queue: " + message.getBody());
                    try {
                        ActivityItems items = this.getActivityItems(message);
                        this.dispatchItems(items);
                    }
                    catch (MessageGearsClientException mgce) {
                        LOGGER.warn("Unable to process message: " + mgce.getMessage());
                        LOGGER.debug(mgce.getMessage(), (Throwable)mgce);
                        this.errorHandler.handleUnprocessedMessage(message.getBody(), mgce);
                    }
                    this.deleteMessage(message);
                }
                continue;
            }
            try {
                LOGGER.info("No items found on queue.  Sleeping for 10000 ms...");
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                this.isRunning = false;
            }
        }
    }

    private void deleteMessage(Message message) {
        DeleteMessageRequest request = new DeleteMessageRequest();
        request.setQueueUrl(this.mgAwsProperties.getMyAwsEventQueueUrl());
        request.setReceiptHandle(message.getReceiptHandle());
        this.client.deleteSqsMessage(request);
    }

    private ActivityItems getActivityItems(Message message) {
        StringReader reader = new StringReader(message.getBody());
        try {
            ActivityItems activityItems = ActivityItems.unmarshal(reader);
            return activityItems;
        }
        catch (ValidationException ve) {
            LOGGER.debug(ve.getMessage(), (Throwable)ve);
            throw new MessageGearsClientException("Failed to unmarshal message: " + message.getBody());
        }
        catch (MarshalException me) {
            LOGGER.debug(me.getMessage(), (Throwable)me);
            throw new MessageGearsClientException("Failed to unmarshal message: " + message.getBody());
        }
    }

    private void dispatchItems(ActivityItems items) {
        if (items.getBouncedMessageActivity() != null) {
            for (Serializable serializable : items.getBouncedMessageActivity()) {
                LOGGER.info("Received a bounce message belonging to job: " + ((BouncedMessageActivity)serializable).getRequestId());
                this.listener.onBounce((BouncedMessageActivity)serializable);
            }
        }
        if (items.getClickActivity() != null) {
            for (Serializable serializable : items.getClickActivity()) {
                LOGGER.info("Received a click message belonging to job: " + ((ClickActivity)serializable).getRequestId());
                this.listener.onClick((ClickActivity)serializable);
            }
        }
        if (items.getDeliveredMessageActivity() != null) {
            for (Serializable serializable : items.getDeliveredMessageActivity()) {
                LOGGER.info("Received a delivery message belonging to job: " + ((DeliveredMessageActivity)serializable).getRequestId());
                this.listener.onDelivery((DeliveredMessageActivity)serializable);
            }
        }
        if (items.getJobErrorActivity() != null) {
            for (Serializable serializable : items.getJobErrorActivity()) {
                LOGGER.info("Received a job error message belonging for job: " + ((JobErrorActivity)serializable).getRequestId());
                this.listener.onJobError((JobErrorActivity)serializable);
            }
        }
        if (items.getOpenActivity() != null) {
            for (Serializable serializable : items.getOpenActivity()) {
                LOGGER.info("Received an open message belonging for job: " + ((OpenActivity)serializable).getRequestId());
                this.listener.onOpen((OpenActivity)serializable);
            }
        }
        if (items.getRenderErrorActivity() != null) {
            for (Serializable serializable : items.getRenderErrorActivity()) {
                LOGGER.info("Received a render error message belonging to job: " + ((RenderErrorActivity)serializable).getRequestId());
                this.listener.onRenderError((RenderErrorActivity)serializable);
            }
        }
        if (items.getSpamComplaintActivity() != null) {
            for (Serializable serializable : items.getSpamComplaintActivity()) {
                LOGGER.info("Received a spam complaint message belonging to job: " + ((SpamComplaintActivity)serializable).getRequestId());
                this.listener.onSpamComplaint((SpamComplaintActivity)serializable);
            }
        }
        if (items.getUnsubActivity() != null) {
            for (Serializable serializable : items.getUnsubActivity()) {
                LOGGER.info("Received an unsub message belonging to job: " + ((UnsubActivity)serializable).getRequestId());
                this.listener.onUnsub((UnsubActivity)serializable);
            }
        }
        if (items.getInboundEmailActivity() != null) {
            for (Serializable serializable : items.getInboundEmailActivity()) {
                LOGGER.info("Received an inbound message belonging to job: " + ((InboundEmailActivity)serializable).getRequestId());
                this.listener.onInboundEmail((InboundEmailActivity)serializable);
            }
        }
        if (items.getSmsDeliveredActivity() != null) {
            for (Serializable serializable : items.getSmsDeliveredActivity()) {
                LOGGER.info("Received an smsDeliveredActivity message belonging to job: " + ((SmsDeliveredActivity)serializable).getRequestId());
                this.listener.onSmsDeliveryActivity((SmsDeliveredActivity)serializable);
            }
        }
        if (items.getSmsDeliveryFailureActivity() != null) {
            for (Serializable serializable : items.getSmsDeliveryFailureActivity()) {
                LOGGER.info("Received an smsDeliveryFailureActivity message belonging to job: " + ((SmsDeliveryFailureActivity)serializable).getRequestId());
                this.listener.onSmsDeliveryFailureActivity((SmsDeliveryFailureActivity)serializable);
            }
        }
        if (items.getSmsRenderErrorActivity() != null) {
            for (Serializable serializable : items.getSmsRenderErrorActivity()) {
                LOGGER.info("Received an smsRenderErrorActivity message belonging to job: " + ((SmsRenderErrorActivity)serializable).getRequestId());
                this.listener.onSmsRenderErrorActivity((SmsRenderErrorActivity)serializable);
            }
        }
        if (items.getSmsInboundActivity() != null) {
            for (Serializable serializable : items.getSmsInboundActivity()) {
                LOGGER.info("Received an smsInboundActivity message: " + ((SmsInboundActivity)serializable).getSmsBody());
                this.listener.onSmsInboundActivity((SmsInboundActivity)serializable);
            }
        }
        if (items.getRequestActivity() != null) {
            for (Serializable serializable : items.getRequestActivity()) {
                LOGGER.info("Received an requestActivity message belonging to job: " + ((RequestActivity)serializable).getRequestId());
                this.listener.onRequestActivity((RequestActivity)serializable);
            }
        }
    }
}

