/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.maven;

import com.metaeffekt.artifact.analysis.flow.ng.ContentAlgorithmParam;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.licensetexts.provider.EncryptedLicenseTextProvider;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.param.ProviderParameters;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.tmd.EncryptedTermMetaDataProviderNG;
import com.metaeffekt.artifact.terms.model.LicenseTextProvider;
import com.metaeffekt.artifact.terms.model.LocalTermsMetaDataLicenseTextProvider;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.metaeffekt.core.maven.kernel.AbstractProjectAwareMojo;

public abstract class AbstractTermsMetaDataBasedMojo
extends AbstractProjectAwareMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Parameter
    protected File userKeysFile;
    @Parameter
    protected String userPassword;
    @Parameter
    String tmdGroupId;
    @Parameter
    String tmdArtifactId;
    @Parameter
    String tmdVersion;
    private transient NormalizationMetaData normalizationMetaData;
    private transient LicenseTextProvider licenseTextProvider;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;

    public MavenProject getProject() {
        return this.project;
    }

    protected boolean configureProvider() {
        boolean managingProvider;
        boolean bl = managingProvider = Security.getProvider("BC") == null;
        if (managingProvider) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        return managingProvider;
    }

    protected void removeProviderConfiguration(boolean managingProvider) {
        if (managingProvider) {
            Security.removeProvider("BC");
        }
    }

    protected NormalizationMetaData resolveTermsMetadata() throws MojoFailureException {
        DefaultArtifact toSearchFor = new DefaultArtifact(this.tmdGroupId, this.tmdArtifactId, this.tmdVersion, null, "zip", "package", (ArtifactHandler)new DefaultArtifactHandler(){

            public String getExtension() {
                return "zip";
            }
        });
        try {
            this.artifactResolver.resolve((Artifact)toSearchFor, this.remoteRepositories, this.localRepository);
        }
        catch (ArtifactNotFoundException | ArtifactResolutionException e) {
            throw new MojoFailureException("Could not resolve tmd artifact.", e);
        }
        if (!toSearchFor.isResolved()) {
            throw new MojoFailureException("Tmd artifact could not be resolved.");
        }
        return AbstractTermsMetaDataBasedMojo.decryptTermsMetaData(this.userPassword, this.userKeysFile, toSearchFor.getFile());
    }

    protected LicenseTextProvider resolveLicenseTextProvider() {
        DefaultArtifact toSearchFor = new DefaultArtifact(this.tmdGroupId, this.tmdArtifactId, this.tmdVersion, null, "zip", "licenses", (ArtifactHandler)new DefaultArtifactHandler(){

            public String getExtension() {
                return "zip";
            }
        });
        try {
            this.artifactResolver.resolve((Artifact)toSearchFor, this.remoteRepositories, this.localRepository);
        }
        catch (ArtifactNotFoundException | ArtifactResolutionException e) {
            return null;
        }
        if (!toSearchFor.isResolved()) {
            return null;
        }
        ProviderParameters providerParameters = new ProviderParameters(new ContentAlgorithmParam(), this.userPassword, this.userKeysFile, toSearchFor.getFile());
        return new EncryptedLicenseTextProvider(providerParameters);
    }

    public static NormalizationMetaData decryptTermsMetaData(String userPassword, File userKeysFile, File contentZipFile) throws MojoFailureException {
        try {
            ProviderParameters providerParam = new ProviderParameters(new ContentAlgorithmParam(), userPassword, userKeysFile, contentZipFile);
            EncryptedTermMetaDataProviderNG provider = new EncryptedTermMetaDataProviderNG();
            return provider.process(providerParam);
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("Unable to read encrypted Terms Metadata: " + e.getMessage() + ".", (Throwable)e);
        }
        catch (Exception e) {
            throw new MojoFailureException("Unable to read encrypted Terms Metadata: " + e.getMessage() + ".", (Throwable)e);
        }
    }

    public void execute() throws MojoFailureException {
        boolean managingProvider;
        boolean bl = managingProvider = Security.getProvider("BC") == null;
        if (managingProvider) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try {
            this.initialize();
            this.doRun();
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (managingProvider) {
                Security.removeProvider("BC");
            }
        }
    }

    private void initialize() throws MojoFailureException {
        if (this.tmdArtifactId != null || this.tmdGroupId != null || this.tmdVersion != null) {
            this.reportIfMissing(this.tmdArtifactId, "tmdArtifactId");
            this.reportIfMissing(this.tmdGroupId, "tmdGroupId");
            this.reportIfMissing(this.tmdVersion, "tmdVersion");
            this.reportIfMissing(this.userKeysFile, "userKeysFile");
            this.reportIfMissing(this.userPassword, "userPassword");
            this.normalizationMetaData = this.resolveTermsMetadata();
            this.licenseTextProvider = this.resolveLicenseTextProvider();
        } else {
            this.normalizationMetaData = NormalizationMetaData.EMPTY_NORMALIZATION_METADATA;
            this.licenseTextProvider = new LocalTermsMetaDataLicenseTextProvider(this.getNormalizationMetaData());
        }
    }

    private void reportIfMissing(String attribute, String attributeName) throws MojoFailureException {
        if (attribute == null) {
            this.logMissingOrInvalid(attributeName);
        }
    }

    private void reportIfMissing(File attributeFile, String attributeName) throws MojoFailureException {
        if (attributeFile == null || !attributeFile.exists()) {
            this.logMissingOrInvalid(attributeName);
        }
    }

    private void logMissingOrInvalid(String attributeName) throws MojoFailureException {
        throw new MojoFailureException("The parameters '" + attributeName + "' is missing or invalid.");
    }

    protected abstract void doRun() throws Exception;

    public NormalizationMetaData getNormalizationMetaData() {
        return this.normalizationMetaData;
    }

    public LicenseTextProvider getLicenseTextProvider() {
        return this.licenseTextProvider;
    }
}

