/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.mojo;

import com.metaeffekt.artifact.analysis.report.InventoryReportModel;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.metaeffekt.core.inventory.InventoryUtils;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.maven.kernel.AbstractProjectAwareMojo;

@Mojo(name="report-artifacts", defaultPhase=LifecyclePhase.COMPILE)
public class ReportMojo
extends AbstractProjectAwareMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(required=true)
    private String id;
    @Parameter(required=true)
    private File referenceInventoryDir;
    @Parameter(defaultValue="inventory/*.xls*")
    private String referenceInventoryIncludes;
    @Parameter(defaultValue="${project.basedir}/.analysis")
    private File analysisBaseDir;
    @Parameter(defaultValue="${project.basedir}/.results")
    private File resultTargetDir;

    public MavenProject getProject() {
        return this.project;
    }

    public void execute() throws MojoFailureException {
        try {
            this.report();
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void report() throws IOException, MojoFailureException {
        File reportFile = new File(this.resultTargetDir, this.id + "-report.html");
        Inventory referenceInventory = InventoryUtils.readInventory((File)this.referenceInventoryDir, (String)this.referenceInventoryIncludes);
        InventoryReportModel inventoryReportModel = new InventoryReportModel().from(this.resultTargetDir).withAnalysisPath(this.analysisBaseDir).withReferenceInventory(referenceInventory);
        inventoryReportModel.evaluate();
        inventoryReportModel.createHtmlReport(reportFile);
        if (inventoryReportModel.isReportFailure()) {
            String reportPathUrl = FileUtils.normalizePathToLinux((String)FileUtils.asRelativePath((File)this.project.getBasedir(), (File)reportFile));
            throw new MojoFailureException("A problem was detected. Please check file: [" + reportPathUrl + "]");
        }
    }
}

