/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.mojo;

import com.metaeffekt.artifact.analysis.flow.ObserveFolderFlow;
import com.metaeffekt.artifact.analysis.flow.ObserveFolderFlowParam;
import com.metaeffekt.artifact.analysis.flow.ScanConsumer;
import com.metaeffekt.artifact.analysis.flow.ScanFlowParam;
import com.metaeffekt.artifact.analysis.maven.AbstractTermsMetaDataBasedMojo;
import com.metaeffekt.artifact.analysis.model.DefaultPropertyProvider;
import com.metaeffekt.artifact.analysis.model.PropertyProvider;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.PropertyUtils;
import com.metaeffekt.artifact.terms.model.LicenseTextProvider;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.resource.InventoryDirResource;
import com.metaeffekt.resource.InventoryResource;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="scan-folder", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class ScanFolderMojo
extends AbstractTermsMetaDataBasedMojo {
    @Parameter(defaultValue="${project.basedir}/.input")
    private File inputDir;
    @Parameter(defaultValue="${project.basedir}/.analysis")
    private File analysisDir;
    @Parameter(defaultValue="${project.basedir}/.analysis/tmp")
    private File tmpBaseDir;
    @Parameter(defaultValue="${project.basedir}/.analysis/status")
    private File statusBaseDir;
    @Parameter(defaultValue="${project.basedir}/.output")
    private File outputDir;
    @Parameter(defaultValue="src/analysis/scan-control.properties")
    private File scanControlPropertiesFile;
    @Parameter(defaultValue="10")
    private int delayInSeconds;
    @Parameter(required=true)
    private File referenceInventoryDir;
    @Parameter(defaultValue="inventory/*.xls*")
    private String referenceInventoryIncludes;

    protected void doRun() throws Exception {
        NormalizationMetaData normalizationMetaData = this.getNormalizationMetaData();
        LicenseTextProvider licenseTextProvider = this.getLicenseTextProvider();
        DefaultPropertyProvider propertyProvider = new DefaultPropertyProvider();
        Properties properties = PropertyUtils.loadProperties((File)this.scanControlPropertiesFile);
        propertyProvider.putAll((Map)properties);
        ScanFlowParam scanFlowParamTemplate = (ScanFlowParam)ScanFlowParam.build().using(normalizationMetaData).using(licenseTextProvider).using(this.analysisDir).configuredBy((PropertyProvider)propertyProvider);
        File tmpBaseDir = new File(this.analysisDir, "tmp");
        File statusBaseDir = new File(this.analysisDir, "status");
        InventoryDirResource referenceInventoryResource = InventoryDirResource.attach((File)this.referenceInventoryDir, (String)this.referenceInventoryIncludes);
        ScanConsumer consumer = new ScanConsumer(this.analysisDir, tmpBaseDir, this.outputDir, (InventoryResource)referenceInventoryResource, scanFlowParamTemplate);
        ObserveFolderFlowParam param = new ObserveFolderFlowParam(this.inputDir, statusBaseDir, tmpBaseDir, (Consumer)consumer);
        FileUtils.forceMkdir((File)param.getObservationDir());
        FileUtils.deleteDirectory((File)param.getTmpBaseDir());
        FileUtils.forceMkdir((File)param.getTmpBaseDir());
        new ObserveFolderFlow().process(param);
    }
}

