/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.mojo;

import com.metaeffekt.artifact.extractors.configuration.DirectoryScanExtractorConfiguration;
import com.metaeffekt.artifact.extractors.configuration.ExtractorConfiguration;
import com.metaeffekt.artifact.extractors.flow.ExtractorFlow;
import com.metaeffekt.artifact.extractors.flow.ExtractorParam;
import com.metaeffekt.artifact.extractors.flow.ExtractorResult;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.metaeffekt.core.inventory.InventoryUtils;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.writer.InventoryWriter;
import org.metaeffekt.core.maven.kernel.AbstractProjectAwareMojo;

@Mojo(name="extract-artifacts", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class ExtractMojo
extends AbstractProjectAwareMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(required=true)
    private String id;
    @Parameter(required=true, defaultValue="${project.build.directory}/scan")
    private File scanBaseDir;
    @Parameter(required=true)
    private File referenceInventoryDir;
    @Parameter(defaultValue="inventory/*.xls*")
    private String referenceInventoryIncludes;
    @Parameter(defaultValue="${project.build.directory}/inventory")
    private File targetInventoryDir;
    @Parameter(defaultValue="${project.artifactId}-${project.version}-inventory.xls")
    private String targetInventoryPath;
    @Parameter(defaultValue="${project.basedir}/.archives")
    private File archiveTargetDir;

    public MavenProject getProject() {
        return this.project;
    }

    public void execute() throws MojoFailureException {
        try {
            this.extract();
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void extract() throws IOException {
        Inventory referenceInventory = InventoryUtils.readInventory((File)this.referenceInventoryDir, (String)this.referenceInventoryIncludes);
        File targetInventoryFile = new File(this.targetInventoryDir, this.targetInventoryPath);
        DirectoryScanExtractorConfiguration directoryScanExtractorConfiguration = new DirectoryScanExtractorConfiguration(this.id, referenceInventory, targetInventoryFile, this.scanBaseDir);
        ExtractorParam extractorParam = new ExtractorParam().using((ExtractorConfiguration)directoryScanExtractorConfiguration).extractArchivesTo(this.archiveTargetDir);
        ExtractorFlow extractorFlow = new ExtractorFlow();
        this.getLog().info((CharSequence)("Extracting archives from " + this.scanBaseDir));
        ExtractorResult extractorResult = extractorFlow.extract(extractorParam);
        new InventoryWriter().writeInventory(extractorResult.getAggregatedInventory(), targetInventoryFile);
    }
}

