/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.mojo;

import com.metaeffekt.artifact.analysis.flow.InventoryResult;
import com.metaeffekt.artifact.analysis.flow.ResolverFlow;
import com.metaeffekt.artifact.analysis.flow.ResolverFlowParam;
import com.metaeffekt.artifact.analysis.maven.AbstractTermsMetaDataBasedMojo;
import com.metaeffekt.artifact.analysis.model.DefaultPropertyProvider;
import com.metaeffekt.artifact.analysis.model.PropertyProvider;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.resource.InventoryResource;
import java.io.File;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.reader.InventoryReader;
import org.metaeffekt.core.inventory.processor.writer.InventoryWriter;

@Mojo(name="resolve-artifacts", defaultPhase=LifecyclePhase.COMPILE)
public class ResolverMojo
extends AbstractTermsMetaDataBasedMojo {
    @Parameter(required=true)
    private File inputInventoryFile;
    @Parameter(required=true)
    private File outputInventoryFile;
    @Parameter
    private File downloadBaseDir;
    @Parameter(required=true)
    private File artifactResolverConfig;
    @Parameter(required=true)
    private File proxyConfig;

    protected void doRun() throws Exception {
        ResolverFlowParam resolverFlowParam = new ResolverFlowParam();
        Inventory inputInventory = new InventoryReader().readInventory(this.inputInventoryFile);
        resolverFlowParam.withInventory(InventoryResource.fromInventory((Inventory)inputInventory));
        DefaultPropertyProvider propertyProvider = new DefaultPropertyProvider();
        if (this.downloadBaseDir != null) {
            propertyProvider.setProperty("artifact.resolver.download.dir", this.downloadBaseDir.getPath());
        } else {
            propertyProvider.setProperty("artifact.resolver.download.dir", null);
        }
        propertyProvider.setProperty("artifact.resolver.proxy.config", this.proxyConfig.getPath());
        propertyProvider.setProperty("artifact.resolver.config", this.artifactResolverConfig.getPath());
        resolverFlowParam.configuredBy((PropertyProvider)propertyProvider);
        ResolverFlow resolverFlow = new ResolverFlow();
        InventoryResult result = resolverFlow.process(resolverFlowParam);
        Inventory resolvedInventory = result.getInventoryResource().getInventory();
        InventoryWriter writer = new InventoryWriter();
        if (this.outputInventoryFile.getParentFile() != null) {
            FileUtils.forceMkdir((File)this.outputInventoryFile.getParentFile());
        }
        writer.writeInventory(resolvedInventory, this.outputInventoryFile);
    }
}

