/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.mojo;

import com.metaeffekt.artifact.analysis.flow.ScanFlow;
import com.metaeffekt.artifact.analysis.flow.ScanFlowParam;
import com.metaeffekt.artifact.analysis.flow.ScanFlowResult;
import com.metaeffekt.artifact.analysis.maven.AbstractTermsMetaDataBasedMojo;
import com.metaeffekt.artifact.analysis.model.DefaultPropertyProvider;
import com.metaeffekt.artifact.analysis.model.PropertyProvider;
import com.metaeffekt.artifact.analysis.utils.PropertyUtils;
import com.metaeffekt.artifact.terms.model.LicenseTextProvider;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.resource.InventoryResource;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.writer.InventoryWriter;

@Mojo(name="scan-artifacts", defaultPhase=LifecyclePhase.COMPILE)
public class ScanMojo
extends AbstractTermsMetaDataBasedMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/inventory")
    private File targetInventoryDir;
    @Parameter(defaultValue="${project.artifactId}-${project.version}-inventory.xls")
    private String targetInventoryPath;
    @Parameter(defaultValue="${project.basedir}/.archives")
    private File archiveTargetDir;
    @Parameter(defaultValue="${project.basedir}/.analysis")
    private File analysisBaseDir;
    @Parameter(defaultValue="src/analysis/scan-control.properties")
    private File scanControlPropertiesFile;
    @Parameter(defaultValue="${project.basedir}/.results")
    private File resultTargetDir;

    public MavenProject getProject() {
        return this.project;
    }

    protected void doRun() throws Exception {
        NormalizationMetaData normalizationMetaData = this.getNormalizationMetaData();
        LicenseTextProvider licenseTextProvider = this.getLicenseTextProvider();
        DefaultPropertyProvider propertyProvider = new DefaultPropertyProvider();
        Properties properties = PropertyUtils.loadProperties((File)this.scanControlPropertiesFile);
        propertyProvider.putAll((Map)properties);
        File targetInventoryFile = new File(this.targetInventoryDir, this.targetInventoryPath);
        ScanFlowParam param = ((ScanFlowParam)ScanFlowParam.build().using(normalizationMetaData).using(licenseTextProvider).using(this.analysisBaseDir).configuredBy((PropertyProvider)propertyProvider)).publishResultsTo(this.resultTargetDir).withInventory(InventoryResource.fromFile((File)targetInventoryFile));
        ScanFlow scanFlow = new ScanFlow();
        this.getLog().info((CharSequence)("Scanning archives in " + this.archiveTargetDir));
        ScanFlowResult scanFlowResult = scanFlow.process(param);
        Inventory scanInventory = scanFlowResult.getInventory();
        for (Artifact artifact : scanInventory.getArtifacts()) {
            String derivedLicenses = artifact.get("Derived Licenses");
            String identifiedTerms = artifact.get("Identified Terms");
            if (derivedLicenses == null && identifiedTerms == null) continue;
            this.getLog().info((CharSequence)(artifact.getId() + "<" + artifact.getChecksum() + ">:"));
            this.getLog().info((CharSequence)("  Associated licenses:      " + (artifact.getLicense() == null ? "" : artifact.getLicense())));
            this.getLog().info((CharSequence)("  Identified licenses:      " + (derivedLicenses == null ? "" : derivedLicenses)));
            this.getLog().info((CharSequence)("  Identified terms/markers: " + (identifiedTerms == null ? "" : identifiedTerms)));
        }
        this.getLog().info((CharSequence)("Updating information in " + targetInventoryFile));
        new InventoryWriter().writeInventory(scanInventory, targetInventoryFile);
    }
}

