/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.mojo;

import com.metaeffekt.artifact.analysis.flow.ScanFlow;
import com.metaeffekt.artifact.analysis.flow.ScanFlowParam;
import com.metaeffekt.artifact.analysis.flow.ScanFlowResult;
import com.metaeffekt.artifact.analysis.maven.AbstractTermsMetaDataBasedMojo;
import com.metaeffekt.artifact.analysis.model.DefaultPropertyProvider;
import com.metaeffekt.artifact.analysis.model.PropertyProvider;
import com.metaeffekt.artifact.analysis.utils.PropertyUtils;
import java.io.File;
import java.util.Map;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.reader.InventoryReader;
import org.metaeffekt.core.inventory.processor.writer.InventoryWriter;

@Mojo(name="scan-inventory", defaultPhase=LifecyclePhase.COMPILE)
public class ScanSimpleMojo
extends AbstractTermsMetaDataBasedMojo {
    @Parameter(required=true)
    public File inputInventory;
    @Parameter(required=true)
    public File targetFile;
    @Parameter(required=true)
    public File analysisBaseDir;
    @Parameter(required=true)
    public File propertiesFile;

    protected void doRun() throws Exception {
        File targetDirectory = this.targetFile.getParentFile();
        if (targetDirectory != null && !targetDirectory.exists() && !targetDirectory.mkdirs()) {
            throw new MojoFailureException("Failed to create parent directory for output: " + targetDirectory.getAbsolutePath());
        }
        if (!this.targetFile.createNewFile()) {
            throw new MojoFailureException("Failed to create output file: " + this.targetFile.getAbsolutePath());
        }
        Inventory inventory = new InventoryReader().readInventory(this.inputInventory);
        DefaultPropertyProvider propertyProvider = new DefaultPropertyProvider();
        propertyProvider.putAll((Map)PropertyUtils.loadProperties((File)this.propertiesFile));
        ScanFlowParam scanFlowParam = (ScanFlowParam)ScanFlowParam.build().using(this.analysisBaseDir).using(this.getLicenseTextProvider()).using(this.getNormalizationMetaData()).publishResultsTo(targetDirectory).withInventory(inventory).configuredBy((PropertyProvider)propertyProvider);
        ScanFlow scanFlow = new ScanFlow();
        ScanFlowResult scanFlowResult = scanFlow.process(scanFlowParam);
        inventory = scanFlowResult.getInventory();
        new InventoryWriter().writeInventory(inventory, this.targetFile);
    }
}

