/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.bom.cyclonedx;

import com.metaeffekt.artifact.analysis.bom.PatternHelper;
import com.metaeffekt.artifact.analysis.bom.cyclonedx.CycloneDxUtils;
import com.metaeffekt.artifact.analysis.bom.cyclonedx.InventoryModelBaseMapper;
import com.metaeffekt.artifact.analysis.bom.parameters.ImportParameters;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.regex.Pattern;
import org.cyclonedx.exception.ParseException;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.Property;
import org.cyclonedx.parsers.BomParserFactory;
import org.cyclonedx.parsers.Parser;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.AssetMetaData;
import org.metaeffekt.core.inventory.processor.model.Inventory;

public class CycloneDxImporter {
    private final List<Pattern> includedAttributePatterns;
    private final List<Pattern> excludedAttributePatterns;
    private final ImportParameters importParameters;

    public CycloneDxImporter(ImportParameters importParameters) {
        this.includedAttributePatterns = PatternHelper.readPatternFile(importParameters.getAttributeInclusionFile());
        this.excludedAttributePatterns = PatternHelper.readPatternFile(importParameters.getAttributeExclusionFile());
        this.importParameters = importParameters;
    }

    public Inventory importFromFile(File bomFile) {
        try {
            Parser parser = BomParserFactory.createParser((File)bomFile);
            Bom parsedBom = parser.parse(bomFile);
            return this.importFromBom(parsedBom);
        }
        catch (ParseException e) {
            throw new RuntimeException("CycloneDX built-in parser failed to parse file.", e);
        }
    }

    public Inventory importFromBom(Bom bom) {
        Inventory inventory = new Inventory();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        ArrayList<AssetMetaData> assets = new ArrayList<AssetMetaData>();
        this.importAssetsAndArtifacts(bom, artifacts, assets);
        this.importHierarchy(bom, artifacts, assets);
        if (!artifacts.isEmpty()) {
            inventory.setArtifacts(artifacts);
            inventory.sortArtifacts();
        }
        if (!assets.isEmpty()) {
            inventory.setAssetMetaData(assets);
        }
        return inventory;
    }

    private void importAssetsAndArtifacts(Bom bom, List<Artifact> artifacts, List<AssetMetaData> assets) {
        AbstractModelBase modelBase;
        List<Component> allComponents = CycloneDxUtils.getAllComponents(bom);
        InventoryModelBaseMapper inventoryModelBaseMapper = new InventoryModelBaseMapper(this.includedAttributePatterns, this.excludedAttributePatterns, this.importParameters);
        Metadata metadata = bom.getMetadata();
        Component metadataComponent = null;
        if (metadata != null && this.importParameters.isIncludeMetadataComponent()) {
            metadataComponent = bom.getMetadata().getComponent();
        }
        if (metadataComponent != null) {
            Property property = new Property();
            property.setName("com.metaeffekt.component.class");
            property.setValue("asset");
            Property propertyPrimary = new Property();
            propertyPrimary.setName("Primary");
            propertyPrimary.setValue("x");
            metadataComponent.addProperty(property);
            metadataComponent.addProperty(propertyPrimary);
            modelBase = inventoryModelBaseMapper.map(metadataComponent);
            if (modelBase instanceof Artifact) {
                artifacts.add((Artifact)modelBase);
            } else if (modelBase != null) {
                assets.add((AssetMetaData)modelBase);
            }
        }
        for (Component component : allComponents) {
            modelBase = inventoryModelBaseMapper.map(component);
            if (modelBase instanceof Artifact) {
                artifacts.add((Artifact)modelBase);
                continue;
            }
            if (modelBase == null) continue;
            assets.add((AssetMetaData)modelBase);
        }
    }

    private void importHierarchy(Bom bom, List<Artifact> artifacts, List<AssetMetaData> assets) {
        Stack<Component> componentStack = new Stack<Component>();
        List components = bom.getComponents();
        if (components == null) {
            return;
        }
        for (Component component : components) {
            componentStack.push(component);
        }
        while (!componentStack.isEmpty()) {
            Component currentComponent = (Component)componentStack.pop();
            if (currentComponent.getComponents() == null) continue;
            for (Component childComponent : currentComponent.getComponents()) {
                Optional<Artifact> artifact = artifacts.stream().filter(a -> a.get("Id").equals(childComponent.getName())).findFirst();
                Optional<AssetMetaData> asset = assets.stream().filter(a -> a.get("Asset Id").equals(childComponent.getName())).findFirst();
                artifact.ifPresent(a -> a.set("AID-" + currentComponent.getName(), "c"));
                asset.ifPresent(a -> a.set("AID-" + currentComponent.getName(), "c"));
            }
        }
    }

    public List<Pattern> getIncludedAttributePatterns() {
        return this.includedAttributePatterns;
    }

    public List<Pattern> getExcludedAttributePatterns() {
        return this.excludedAttributePatterns;
    }
}

