/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.bom.spdx;

import com.metaeffekt.artifact.analysis.bom.LicenseProcessor;
import com.metaeffekt.artifact.analysis.bom.PatternHelper;
import com.metaeffekt.artifact.analysis.bom.parameters.ExportParameters;
import com.metaeffekt.artifact.analysis.bom.spdx.DocumentSpec;
import com.metaeffekt.artifact.analysis.bom.spdx.LicenseStringConverter;
import com.metaeffekt.artifact.analysis.bom.spdx.facade.SpdxApiFacade;
import com.metaeffekt.artifact.analysis.bom.spdx.mapper.MappingUtils;
import com.metaeffekt.artifact.analysis.bom.spdx.mapper.SpdxPackageMapper;
import com.metaeffekt.artifact.analysis.bom.spdx.relationship.RelationshipGraph;
import com.metaeffekt.artifact.analysis.bom.spdx.relationship.RelationshipGraphEdge;
import com.metaeffekt.artifact.analysis.bom.spdx.relationship.RelationshipGraphNode;
import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.terms.model.LicenseTextProvider;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.AssetMetaData;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.ListedLicenses;
import org.spdx.library.model.license.SpdxListedLicense;
import org.spdx.storage.IModelStore;
import org.spdx.storage.listedlicense.IListedLicenseStore;
import org.spdx.storage.listedlicense.SpdxListedLicenseLocalStore;
import org.spdx.storage.simple.InMemSpdxStore;

public class SpdxExporter {
    private static final Logger log = LoggerFactory.getLogger(SpdxExporter.class);
    private static final String unspecificIdComment = "This license identifier is marked \"unspecific\" and does not uniquely match a license of a specific version or variant.\nA license text can therefore not be asserted. Further analysis is required to determine the exact license.";
    private final Set<TermsMetaData> referencedLicenses = new HashSet<TermsMetaData>();
    private final NormalizationMetaData normalizationMetaData;
    private final LicenseTextProvider licenseTextProvider;
    private final ExportParameters exportParameters;
    private final List<Pattern> includedAttributePatterns;
    private final List<Pattern> excludedAttributePatterns;

    public SpdxExporter(NormalizationMetaData normalizationMetaData, LicenseTextProvider licenseTextProvider, ExportParameters exportParameters) {
        this.includedAttributePatterns = PatternHelper.readPatternFile(exportParameters.getAttributeInclusionFile());
        this.excludedAttributePatterns = PatternHelper.readPatternFile(exportParameters.getAttributeExclusionFile());
        this.exportParameters = exportParameters;
        this.normalizationMetaData = Objects.requireNonNull(normalizationMetaData);
        this.licenseTextProvider = licenseTextProvider;
    }

    protected void ensureParentDirExists(File someFile) {
        try {
            if (FileUtils.createParentDirectories((File)someFile) == null) {
                throw new IllegalArgumentException("Could not create parent directories for this file.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void exportToSpdxDocument(Inventory inventory, File outFile, DocumentSpec documentSpec, boolean prettyPrint) {
        this.ensureParentDirExists(Objects.requireNonNull(outFile));
        MultiFormatStore.Format spdxFormat = SpdxApiFacade.getSpdxFormat(documentSpec, prettyPrint);
        if (!this.exportParameters.isIncludeAssets()) {
            InventoryUtils.removeAssetsAndReferences(inventory);
        }
        if (spdxFormat == null) {
            throw new RuntimeException("Input format provided is not supported.");
        }
        try (InMemSpdxStore baseStore = new InMemSpdxStore();
             MultiFormatStore modelStore = new MultiFormatStore((IModelStore)baseStore, spdxFormat);){
            this.createDocument(inventory, modelStore, documentSpec);
            try (OutputStream outputStream = Files.newOutputStream(outFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                modelStore.serialize(documentSpec.getDocumentId(), outputStream);
                log.info("Document created at: {}", (Object)outFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createDocument(Inventory inventory, MultiFormatStore modelStore, DocumentSpec documentSpec) {
        try {
            SpdxDocument spdxDocument = new SpdxDocument((IModelStore)modelStore, documentSpec.getDocumentId(), new ModelCopyManager(), true);
            if (this.exportParameters.isUseLocalLicenseStore()) {
                ListedLicenses.initializeListedLicenses((IListedLicenseStore)new SpdxListedLicenseLocalStore());
            }
            this.prepareCreationInformation(spdxDocument, documentSpec);
            this.prepareArtifactsAndAssets(spdxDocument, documentSpec, inventory);
            this.prepareRelationships(spdxDocument, inventory);
            this.addReferencedLicenses(spdxDocument, this.referencedLicenses);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException(e);
        }
    }

    private void prepareCreationInformation(SpdxDocument spdxDocument, DocumentSpec documentSpec) {
        ArrayList<String> creators = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)documentSpec.getOrganization())) {
            creators.add("Organization: " + documentSpec.getOrganization());
        }
        if (StringUtils.isNotBlank((CharSequence)documentSpec.getPerson())) {
            creators.add("Person: " + documentSpec.getPerson());
        }
        if (StringUtils.isNotBlank((CharSequence)documentSpec.getTool())) {
            creators.add("Tool: " + documentSpec.getTool());
        }
        try {
            String licenseListVersion = ListedLicenses.getListedLicenses().getLicenseListVersion();
            String time = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(Calendar.getInstance().getTime());
            spdxDocument.setCreationInfo(spdxDocument.createCreationInfo(creators, time).setLicenseListVersion(licenseListVersion).setComment("Organization URL: " + documentSpec.getOrganizationUrl() + "\nBom iteration: " + documentSpec.getDocumentVersion()));
            spdxDocument.setName(documentSpec.getDocumentName());
            SpdxListedLicense anyLicenseInfo = new SpdxListedLicense(spdxDocument.getModelStore(), documentSpec.getDocumentId(), this.exportParameters.getDocumentLicense(), spdxDocument.getCopyManager(), true);
            spdxDocument.setDataLicense((AnyLicenseInfo)anyLicenseInfo);
            spdxDocument.setSpecVersion("SPDX-2.3");
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException(e);
        }
    }

    private void prepareArtifactsAndAssets(SpdxDocument spdxDocument, DocumentSpec documentSpec, Inventory inventory) {
        LicenseStringConverter licenseStringConverter = new LicenseStringConverter(this.normalizationMetaData, null);
        SpdxPackageMapper spdxPackageMapper = new SpdxPackageMapper(documentSpec, spdxDocument, licenseStringConverter, this.includedAttributePatterns, this.excludedAttributePatterns, this.exportParameters);
        try {
            for (Artifact artifact : inventory.getArtifacts()) {
                spdxPackageMapper.map((AbstractModelBase)artifact);
            }
            List unmappedAssets = inventory.getAssetMetaData();
            unmappedAssets.removeIf(MappingUtils.getAssetToArtifactMap(inventory)::containsKey);
            for (AssetMetaData assetMetaData : unmappedAssets) {
                spdxPackageMapper.map((AbstractModelBase)assetMetaData);
            }
            this.referencedLicenses.addAll(spdxPackageMapper.getReferencedLicenses());
            this.addReferencedLicenses(spdxDocument, this.referencedLicenses);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException("Failed to map assets/artifacts to spdx packages from inventory: " + inventory, e);
        }
    }

    private void prepareRelationships(SpdxDocument spdxDocument, Inventory inventory) {
        RelationshipGraph relationshipGraph = new RelationshipGraph(inventory, MappingUtils.getAssetToArtifactMap(inventory));
        for (RelationshipGraphEdge edge : relationshipGraph.getAllRelationships()) {
            List<String> toNodes = edge.getToNodes().stream().map(RelationshipGraphNode::getId).collect(Collectors.toList());
            SpdxApiFacade.addRelationshipsToDocument(spdxDocument, edge.getFromNode().getId(), toNodes, edge.getRelationshipType());
        }
    }

    protected void addReferencedLicenses(SpdxDocument spdxDocument, Collection<TermsMetaData> referencedLicenses) throws InvalidSPDXAnalysisException {
        Map<String, String> identifierToTextMap = LicenseProcessor.getReferencedLicenseText(referencedLicenses, this.licenseTextProvider, this.normalizationMetaData);
        if (identifierToTextMap != null) {
            for (Map.Entry<String, String> entry : identifierToTextMap.entrySet()) {
                if (entry.getValue() == null) {
                    SpdxApiFacade.createExtractedLicenseInfo(entry.getKey(), null, unspecificIdComment, spdxDocument);
                    continue;
                }
                SpdxApiFacade.createExtractedLicenseInfo(entry.getKey(), entry.getValue(), null, spdxDocument);
            }
        }
    }

    public Set<TermsMetaData> getReferencedLicenses() {
        return this.referencedLicenses;
    }

    public List<Pattern> getIncludedAttributePatterns() {
        return this.includedAttributePatterns;
    }

    public List<Pattern> getExcludedAttributePatterns() {
        return this.excludedAttributePatterns;
    }
}

